/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.VariableDeclarationOrderUnit;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class VariableDeclarationOrderOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(VariableDeclarationOrderOptimizer.class);

    public VariableDeclarationOrderOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof VariableDeclarationOrderOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        GreqlGraph greqlGraph = greqlQuery.getQueryGraph();
        ArrayList<Iterator<VariableDeclarationOrderUnit>> arrayList = new ArrayList<Iterator<VariableDeclarationOrderUnit>>();
        for (Declaration object2 : greqlGraph.getDeclarationVertices()) {
            Iterator<VariableDeclarationOrderUnit> iterator = new ArrayList();
            Set<Variable> set = this.collectVariablesDeclaredBy(object2);
            if (set.size() < 2) continue;
            for (Variable variable : set) {
                iterator.add(new VariableDeclarationOrderUnit(variable, object2, greqlQuery));
            }
            arrayList.add(iterator);
        }
        boolean bl = false;
        HashSet<SimpleDeclaration> hashSet = new HashSet<SimpleDeclaration>();
        for (List list : arrayList) {
            Collections.sort(list);
            Declaration declaration = ((VariableDeclarationOrderUnit)list.get(0)).getDeclaringDeclaration();
            List<Variable> list2 = this.collectVariablesInDeclarationOrder(declaration);
            List<Variable> list3 = this.collectVariablesInProposedDeclarationOrder(list);
            if (list3.equals(list2)) continue;
            bl = true;
            logger.finer(this.optimizerHeaderString() + "New order of declarations in " + declaration);
            int n = 0;
            for (VariableDeclarationOrderUnit variableDeclarationOrderUnit : list) {
                hashSet.add(variableDeclarationOrderUnit.getSimpleDeclarationOfVariable());
                Variable variable = variableDeclarationOrderUnit.getVariable();
                Variable variable2 = list2.get(n);
                logger.finer("  " + variable2 + " (" + variable2.get_name() + ") --> " + variable + " (" + variable.get_name() + "), changeCosts = " + variableDeclarationOrderUnit.getVariableValueChangeCosts() + ", cardinality = " + variableDeclarationOrderUnit.getTypeExpressionCardinality());
                ++n;
                SimpleDeclaration simpleDeclaration = greqlGraph.createSimpleDeclaration();
                greqlGraph.createIsDeclaredVarOf(variable, simpleDeclaration);
                greqlGraph.createIsTypeExprOfDeclaration(variableDeclarationOrderUnit.getTypeExpressionOfVariable(), simpleDeclaration);
                greqlGraph.createIsSimpleDeclOf(simpleDeclaration, variableDeclarationOrderUnit.getDeclaringDeclaration());
            }
        }
        for (SimpleDeclaration simpleDeclaration : hashSet) {
            simpleDeclaration.delete();
        }
        OptimizerUtility.createMissingSourcePositions(greqlGraph);
        return bl;
    }

    private List<Variable> collectVariablesInDeclarationOrder(Declaration declaration) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (IsSimpleDeclOf isSimpleDeclOf : declaration.getIsSimpleDeclOfIncidences()) {
            for (IsDeclaredVarOf isDeclaredVarOf : isSimpleDeclOf.getAlpha().getIsDeclaredVarOfIncidences()) {
                arrayList.add(isDeclaredVarOf.getAlpha());
            }
        }
        return arrayList;
    }

    private List<Variable> collectVariablesInProposedDeclarationOrder(List<VariableDeclarationOrderUnit> list) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (VariableDeclarationOrderUnit variableDeclarationOrderUnit : list) {
            arrayList.add(variableDeclarationOrderUnit.getVariable());
        }
        return arrayList;
    }

    private Set<Variable> collectVariablesDeclaredBy(Declaration declaration) {
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (IsSimpleDeclOf isSimpleDeclOf : declaration.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            hashSet.addAll(OptimizerUtility.collectVariablesDeclaredBy(isSimpleDeclOf.getAlpha()));
        }
        return hashSet;
    }
}

