/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.BinaryOperator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Not;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;

public class And
extends BinaryOperator {
    public And(GreqlQuery greqlQuery, Formula formula, Formula formula2) {
        super(greqlQuery, formula, formula2);
    }

    @Override
    public String toString() {
        return "(" + this.leftHandSide + " & " + this.rightHandSide + ")";
    }

    @Override
    public Expression toExpression() {
        GreqlGraph greqlGraph = this.query.getQueryGraph();
        FunctionApplication functionApplication = greqlGraph.createFunctionApplication();
        FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("and", greqlGraph);
        greqlGraph.createIsFunctionIdOf(functionId, functionApplication);
        greqlGraph.createIsArgumentOf(this.leftHandSide.toExpression(), functionApplication);
        greqlGraph.createIsArgumentOf(this.rightHandSide.toExpression(), functionApplication);
        return functionApplication;
    }

    @Override
    protected Formula calculateReplacementFormula(Expression expression, Literal literal) {
        return new And(this.query, this.leftHandSide.calculateReplacementFormula(expression, literal), this.rightHandSide.calculateReplacementFormula(expression, literal));
    }

    @Override
    public Formula simplify() {
        Formula formula;
        Formula formula2 = this.leftHandSide.simplify();
        if (formula2.equals(new Not(this.query, formula = this.rightHandSide.simplify())) || new Not(this.query, formula2).equals(formula)) {
            return new False(this.query);
        }
        if (formula2 instanceof False) {
            return formula2;
        }
        if (formula instanceof False) {
            return formula;
        }
        if (formula2 instanceof True) {
            return formula;
        }
        if (formula instanceof True) {
            return formula2;
        }
        if (formula2.equals(formula)) {
            return formula2;
        }
        return new And(this.query, formula2, formula);
    }

    @Override
    public double getSelectivity() {
        double d = this.leftHandSide.getSelectivity() * this.rightHandSide.getSelectivity();
        logger.finer("selectivity[" + this + "] = " + d);
        return d;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof And) {
            And and = (And)object;
            return this.leftHandSide.equals(and.leftHandSide) && this.rightHandSide.equals(and.rightHandSide);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode(17);
    }
}

