/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import java.util.ArrayList;

public class NonConstantTerm
extends Formula {
    protected Expression expression;

    public NonConstantTerm(GreqlQuery greqlQuery, Expression expression) {
        super(greqlQuery);
        this.expression = expression;
    }

    @Override
    public String toString() {
        return "v" + this.expression.getId();
    }

    @Override
    public Expression toExpression() {
        return this.expression;
    }

    @Override
    protected ArrayList<Expression> getNonConstantTermExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(this.expression);
        return arrayList;
    }

    @Override
    protected Formula calculateReplacementFormula(Expression expression, Literal literal) {
        if (this.expression == expression) {
            return literal;
        }
        return this;
    }

    @Override
    public Formula simplify() {
        return this;
    }

    @Override
    public double getSelectivity() {
        VertexEvaluator<Expression> vertexEvaluator = ((GreqlQueryImpl)this.query).getVertexEvaluator(this.expression);
        double d = vertexEvaluator.calculateEstimatedSelectivity();
        logger.finer("selectivity[" + this + "] = " + d);
        return d;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof NonConstantTerm) {
            NonConstantTerm nonConstantTerm = (NonConstantTerm)object;
            return this.expression == nonConstantTerm.expression;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.expression.hashCode();
    }
}

