/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.AggregationPathDescription;
import de.uni_koblenz.jgralab.greql.schema.AlternativePathDescription;
import de.uni_koblenz.jgralab.greql.schema.BackwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Definition;
import de.uni_koblenz.jgralab.greql.schema.DefinitionExpression;
import de.uni_koblenz.jgralab.greql.schema.Direction;
import de.uni_koblenz.jgralab.greql.schema.DoubleLiteral;
import de.uni_koblenz.jgralab.greql.schema.EdgePathDescription;
import de.uni_koblenz.jgralab.greql.schema.EdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.EdgeSetExpression;
import de.uni_koblenz.jgralab.greql.schema.EdgeTypeSubgraph;
import de.uni_koblenz.jgralab.greql.schema.ElementSetExpression;
import de.uni_koblenz.jgralab.greql.schema.ExponentiatedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ExpressionDefinedSubgraph;
import de.uni_koblenz.jgralab.greql.schema.ForwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IntLiteral;
import de.uni_koblenz.jgralab.greql.schema.IntermediateVertexPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IsExpressionOnSubgraph;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefiningExpression;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.IsTableHeaderOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfFunction;
import de.uni_koblenz.jgralab.greql.schema.IteratedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IterationType;
import de.uni_koblenz.jgralab.greql.schema.LetExpression;
import de.uni_koblenz.jgralab.greql.schema.ListComprehension;
import de.uni_koblenz.jgralab.greql.schema.ListConstruction;
import de.uni_koblenz.jgralab.greql.schema.ListRangeConstruction;
import de.uni_koblenz.jgralab.greql.schema.Literal;
import de.uni_koblenz.jgralab.greql.schema.LongLiteral;
import de.uni_koblenz.jgralab.greql.schema.MapComprehension;
import de.uni_koblenz.jgralab.greql.schema.MapConstruction;
import de.uni_koblenz.jgralab.greql.schema.OptionalPathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PathExpression;
import de.uni_koblenz.jgralab.greql.schema.PrimaryPathDescription;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.Quantifier;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.SequentialPathDescription;
import de.uni_koblenz.jgralab.greql.schema.SetComprehension;
import de.uni_koblenz.jgralab.greql.schema.SetConstruction;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SimplePathDescription;
import de.uni_koblenz.jgralab.greql.schema.StringLiteral;
import de.uni_koblenz.jgralab.greql.schema.SubgraphDefinition;
import de.uni_koblenz.jgralab.greql.schema.SubgraphRestrictedExpression;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.schema.ThisVertex;
import de.uni_koblenz.jgralab.greql.schema.TransposedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.TupleConstruction;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.schema.TypeOrRoleId;
import de.uni_koblenz.jgralab.greql.schema.UndefinedLiteral;
import de.uni_koblenz.jgralab.greql.schema.ValueConstruction;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.VertexSetExpression;
import de.uni_koblenz.jgralab.greql.schema.VertexTypeSubgraph;
import de.uni_koblenz.jgralab.greql.schema.WhereExpression;
import java.util.Iterator;
import org.pcollections.PSet;

public class GreqlSerializer {
    private StringBuilder sb = null;

    public static String serializeGraph(GreqlGraph greqlGraph) {
        GreqlSerializer greqlSerializer = new GreqlSerializer();
        return greqlSerializer.serializeGreqlVertex(greqlGraph.getFirstGreqlExpression());
    }

    public static String serializeVertex(GreqlVertex greqlVertex) {
        GreqlSerializer greqlSerializer = new GreqlSerializer();
        return greqlSerializer.serializeGreqlVertex(greqlVertex);
    }

    public String serializeGreqlVertex(GreqlVertex greqlVertex) {
        this.sb = new StringBuilder();
        this.serializeGreqlVertex(greqlVertex, false);
        return this.sb.toString();
    }

    private void serializeGreqlVertex(GreqlVertex greqlVertex, boolean bl) {
        if (greqlVertex instanceof Declaration) {
            Declaration declaration = (Declaration)greqlVertex;
            if (declaration.getFirstIsQuantifiedDeclOfIncidence() != null) {
                this.serializeDeclaration((Declaration)greqlVertex, false);
            } else {
                this.serializeDeclaration((Declaration)greqlVertex, true);
            }
        } else if (greqlVertex instanceof Definition) {
            this.serializeDefinition((Definition)greqlVertex);
        } else if (greqlVertex instanceof Direction) {
            this.serializeDirection((Direction)greqlVertex);
        } else if (greqlVertex instanceof EdgeRestriction) {
            this.serializeEdgeRestriction((EdgeRestriction)greqlVertex);
        } else if (greqlVertex instanceof GreqlExpression) {
            this.serializeGreqlExpression((GreqlExpression)greqlVertex);
        } else if (greqlVertex instanceof Quantifier) {
            this.serializeQuantifier((Quantifier)greqlVertex);
        } else if (greqlVertex instanceof RecordElement) {
            this.serializeRecordElement((RecordElement)greqlVertex);
        } else if (greqlVertex instanceof SimpleDeclaration) {
            this.serializeSimpleDeclaration((SimpleDeclaration)greqlVertex);
        } else if (greqlVertex instanceof Expression) {
            this.serializeExpression((Expression)greqlVertex, false);
        } else {
            throw new GreqlException("Unknown GreqlVertex " + greqlVertex + ".");
        }
        if (bl) {
            this.sb.append(' ');
        }
    }

    private void serializeSimpleDeclaration(SimpleDeclaration simpleDeclaration) {
        boolean bl = true;
        for (Variable variable : simpleDeclaration.get_declaredVar()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeVariable(variable);
        }
        this.sb.append(": ");
        this.serializeExpression(simpleDeclaration.get_typeExpr(), false);
    }

    private void serializeRecordElement(RecordElement recordElement) {
        this.serializeIdentifier(recordElement.get_recordId());
        this.sb.append(" : ");
        this.serializeExpression(recordElement.get_recordExpr(), false);
    }

    private void serializeQuantifier(Quantifier quantifier) {
        switch (quantifier.get_type()) {
            case EXISTS: {
                this.sb.append("exists");
                break;
            }
            case EXISTSONE: {
                this.sb.append("exists!");
                break;
            }
            case FORALL: {
                this.sb.append("forall");
                break;
            }
            default: {
                throw new RuntimeException("FIXME: Unhandled QuantificationType: " + (Object)((Object)quantifier.get_type()));
            }
        }
    }

    private void serializeEdgeRestriction(EdgeRestriction edgeRestriction) {
        String string = "";
        for (TypeOrRoleId typeOrRoleId : edgeRestriction.get_typeId()) {
            this.sb.append(string);
            this.serializeIdentifier(typeOrRoleId);
            string = ",";
        }
        for (TypeOrRoleId typeOrRoleId : edgeRestriction.get_roleId()) {
            this.sb.append(string);
            string = ",";
            this.serializeIdentifier(typeOrRoleId);
        }
        Expression expression = edgeRestriction.get_booleanPredicate();
        if (expression != null) {
            this.sb.append(" @ ");
            this.serializeExpression(expression, false);
        }
    }

    private void serializeDirection(Direction direction) {
        this.sb.append((Object)direction.get_dirValue());
    }

    private void serializeDefinition(Definition definition) {
        this.serializeVariable(definition.get_var());
        this.sb.append(" := ");
        this.serializeExpression(definition.get_expr(), false);
    }

    private void serializeDeclaration(Declaration declaration, boolean bl) {
        boolean bl2 = true;
        for (GreqlVertex greqlVertex : declaration.get_simpleDecl()) {
            if (bl2) {
                bl2 = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeSimpleDeclaration((SimpleDeclaration)greqlVertex);
        }
        bl2 = true;
        for (GreqlVertex greqlVertex : declaration.get_constraint()) {
            if (bl) {
                this.sb.append(" with ");
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression((Expression)greqlVertex, false);
        }
    }

    private void serializeGreqlExpression(GreqlExpression greqlExpression) {
        Iterable iterable = greqlExpression.get_boundVar();
        PSet<String> pSet = greqlExpression.get_importedTypes();
        if (pSet != null) {
            for (String object : pSet) {
                this.sb.append("import ").append(object).append(";\n");
            }
        }
        if (iterable.iterator().hasNext()) {
            this.sb.append("using ");
            boolean bl = true;
            for (Variable variable : iterable) {
                if (bl) {
                    bl = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeVariable(variable);
            }
            this.sb.append(':');
        }
        this.serializeExpression(greqlExpression.get_queryExpr(), false);
    }

    private void serializeExpression(Expression expression, boolean bl) {
        if (expression instanceof ConditionalExpression) {
            this.serializeConditionalExpression((ConditionalExpression)expression);
        } else if (expression instanceof FunctionApplication) {
            this.serializeFunctionApplication((FunctionApplication)expression);
        } else if (expression instanceof Literal) {
            this.serializeLiteral((Literal)expression);
        } else if (expression instanceof Variable) {
            this.serializeVariable((Variable)expression);
        } else if (expression instanceof Identifier) {
            this.serializeIdentifier((Identifier)expression);
        } else if (expression instanceof QuantifiedExpression) {
            this.serializeQuantifiedExpression((QuantifiedExpression)expression);
        } else if (expression instanceof Comprehension) {
            this.serializeComprehension((Comprehension)expression);
        } else if (expression instanceof DefinitionExpression) {
            this.serializeDefinitionExpression((DefinitionExpression)expression);
        } else if (expression instanceof ElementSetExpression) {
            this.serializeElementSetExpression((ElementSetExpression)expression);
        } else if (expression instanceof PathDescription) {
            this.serializePathDescription((PathDescription)expression);
        } else if (expression instanceof PathExpression) {
            this.serializePathExpression((PathExpression)expression);
        } else if (expression instanceof SubgraphRestrictedExpression) {
            this.serializeSubgraphRestrictedExpression((SubgraphRestrictedExpression)expression);
        } else if (expression instanceof ValueConstruction) {
            this.serializeValueConstruction((ValueConstruction)expression);
        } else {
            throw new GreqlException("Unknown Expression " + expression + ". Serialization so far: " + this.sb.toString());
        }
        if (bl) {
            this.sb.append(' ');
        }
    }

    private void serializeValueConstruction(ValueConstruction valueConstruction) {
        if (valueConstruction instanceof ListConstruction) {
            this.serializeListConstruction((ListConstruction)valueConstruction);
        } else if (valueConstruction instanceof MapConstruction) {
            this.serializeMapConstruction((MapConstruction)valueConstruction);
        } else if (valueConstruction instanceof RecordConstruction) {
            this.serializeRecordConstruction((RecordConstruction)valueConstruction);
        } else if (valueConstruction instanceof SetConstruction) {
            this.serializeSetConstruction((SetConstruction)valueConstruction);
        } else if (valueConstruction instanceof TupleConstruction) {
            this.serializeTupleConstruction((TupleConstruction)valueConstruction);
        } else {
            throw new GreqlException("Unknown ValueConstruction " + valueConstruction + ".");
        }
    }

    private void serializeTupleConstruction(TupleConstruction tupleConstruction) {
        this.sb.append("tup(");
        boolean bl = true;
        for (Expression expression : tupleConstruction.get_part()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression(expression, false);
        }
        this.sb.append(")");
    }

    private void serializeSetConstruction(SetConstruction setConstruction) {
        this.sb.append("set(");
        boolean bl = true;
        for (Expression expression : setConstruction.get_part()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression(expression, false);
        }
        this.sb.append(")");
    }

    private void serializeRecordConstruction(RecordConstruction recordConstruction) {
        this.sb.append("rec(");
        boolean bl = true;
        for (RecordElement recordElement : recordConstruction.get_recordElement()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeRecordElement(recordElement);
        }
        this.sb.append(')');
    }

    private void serializeMapConstruction(MapConstruction mapConstruction) {
        this.sb.append("map(");
        Iterator iterator = mapConstruction.get_valueExpr().iterator();
        String string = "";
        for (Expression expression : mapConstruction.get_keyExpr()) {
            this.sb.append(string);
            string = ", ";
            this.serializeExpression(expression, true);
            this.sb.append("-> ");
            this.serializeExpression((Expression)iterator.next(), false);
        }
        this.sb.append(")");
    }

    private void serializeListConstruction(ListConstruction listConstruction) {
        this.sb.append("list(");
        if (listConstruction instanceof ListRangeConstruction) {
            ListRangeConstruction listRangeConstruction = (ListRangeConstruction)listConstruction;
            this.serializeExpression(listRangeConstruction.get_firstValue(), false);
            this.sb.append("..");
            this.serializeExpression(listRangeConstruction.get_lastValue(), false);
        } else {
            boolean bl = true;
            for (Expression expression : listConstruction.get_part()) {
                if (bl) {
                    bl = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeExpression(expression, false);
            }
        }
        this.sb.append(")");
    }

    private void serializeSubgraphRestrictedExpression(SubgraphRestrictedExpression subgraphRestrictedExpression) {
        this.sb.append("on ");
        IsSubgraphDefinitionOf isSubgraphDefinitionOf = subgraphRestrictedExpression.getFirstIsSubgraphDefinitionOfIncidence(EdgeDirection.IN);
        this.serializeSubgraphDefinition((SubgraphDefinition)isSubgraphDefinitionOf.getThat());
        this.sb.append(": ");
        IsExpressionOnSubgraph isExpressionOnSubgraph = subgraphRestrictedExpression.getFirstIsExpressionOnSubgraphIncidence(EdgeDirection.IN);
        this.serializeExpression((Expression)isExpressionOnSubgraph.getThat(), true);
    }

    private void serializeSubgraphDefinition(SubgraphDefinition subgraphDefinition) {
        if (subgraphDefinition instanceof EdgeTypeSubgraph || subgraphDefinition instanceof VertexTypeSubgraph) {
            if (subgraphDefinition instanceof EdgeTypeSubgraph) {
                this.sb.append("e");
            } else {
                this.sb.append("v");
            }
            this.sb.append("Subgraph{");
            boolean bl = true;
            for (TypeId typeId : subgraphDefinition.get_typeRestr()) {
                if (bl) {
                    bl = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeIdentifier(typeId);
            }
            this.sb.append('}');
        } else {
            IsSubgraphDefiningExpression isSubgraphDefiningExpression = ((ExpressionDefinedSubgraph)subgraphDefinition).getFirstIsSubgraphDefiningExpressionIncidence(EdgeDirection.IN);
            this.serializeExpression(isSubgraphDefiningExpression.getAlpha(), true);
        }
    }

    private void serializePathExpression(PathExpression pathExpression) {
        if (pathExpression instanceof BackwardVertexSet) {
            this.serializeBackwardVertexSet((BackwardVertexSet)pathExpression);
        } else if (pathExpression instanceof ForwardVertexSet) {
            this.serializeForwardVertexSet((ForwardVertexSet)pathExpression);
        } else if (pathExpression instanceof PathExistence) {
            this.serializePathExistence((PathExistence)pathExpression);
        } else {
            throw new GreqlException("Unknown PathExpression " + pathExpression + ".");
        }
    }

    private void serializePathExistence(PathExistence pathExistence) {
        this.serializeExpression(pathExistence.get_startExpr(), true);
        this.serializeExpression(pathExistence.get_path(), true);
        this.serializeExpression(pathExistence.get_targetExpr(), false);
    }

    private void serializeForwardVertexSet(ForwardVertexSet forwardVertexSet) {
        this.serializeExpression(forwardVertexSet.get_startExpr(), true);
        this.serializeExpression(forwardVertexSet.get_path(), false);
    }

    private void serializeBackwardVertexSet(BackwardVertexSet backwardVertexSet) {
        this.serializeExpression(backwardVertexSet.get_path(), true);
        this.serializeExpression(backwardVertexSet.get_targetExpr(), false);
    }

    private void serializePathDescription(PathDescription pathDescription) {
        if (!(pathDescription instanceof PrimaryPathDescription) && !(pathDescription instanceof OptionalPathDescription)) {
            this.sb.append('(');
        }
        boolean bl = false;
        for (Object object : pathDescription.get_startRestr()) {
            if (!bl) {
                this.sb.append(" {");
            }
            if (!(object instanceof TypeId)) {
                if (bl) {
                    this.sb.append(" ");
                }
                this.sb.append("@ ");
            } else if (bl) {
                this.sb.append(", ");
            }
            this.serializeExpression((Expression)object, false);
            bl = true;
        }
        if (bl) {
            this.sb.append("} & ");
        }
        if (pathDescription instanceof AlternativePathDescription) {
            this.serializeAlternativePathDescription((AlternativePathDescription)pathDescription);
        } else if (pathDescription instanceof ExponentiatedPathDescription) {
            this.serializeExponentiatedPathDescription((ExponentiatedPathDescription)pathDescription);
        } else if (pathDescription instanceof IntermediateVertexPathDescription) {
            this.serializeIntermediateVertexPathDescription((IntermediateVertexPathDescription)pathDescription);
        } else if (pathDescription instanceof IteratedPathDescription) {
            this.serializeIteratedPathDescription((IteratedPathDescription)pathDescription);
        } else if (pathDescription instanceof OptionalPathDescription) {
            this.serializeOptionalPathDescription((OptionalPathDescription)pathDescription);
        } else if (pathDescription instanceof SequentialPathDescription) {
            this.serializeSequentialPathDescription((SequentialPathDescription)pathDescription);
        } else if (pathDescription instanceof TransposedPathDescription) {
            this.serializeTransposedPathDescription((TransposedPathDescription)pathDescription);
        } else if (pathDescription instanceof PrimaryPathDescription) {
            this.serializePrimaryPathDescription((PrimaryPathDescription)pathDescription);
        } else {
            throw new GreqlException("Unknown PathDescription " + pathDescription + ".");
        }
        boolean bl2 = false;
        for (Expression expression : pathDescription.get_goalRestr()) {
            if (!bl2) {
                this.sb.append(" & {");
            }
            if (!(expression instanceof TypeId)) {
                if (bl2) {
                    this.sb.append(" ");
                }
                this.sb.append("@ ");
            } else if (bl2) {
                this.sb.append(", ");
            }
            this.serializeExpression(expression, false);
            bl2 = true;
        }
        if (bl2) {
            this.sb.append("}");
        }
        if (!(pathDescription instanceof PrimaryPathDescription) && !(pathDescription instanceof OptionalPathDescription)) {
            this.sb.append(')');
        }
    }

    private void serializePrimaryPathDescription(PrimaryPathDescription primaryPathDescription) {
        if (primaryPathDescription instanceof EdgePathDescription) {
            this.serializeEdgePathDescription((EdgePathDescription)primaryPathDescription);
        } else if (primaryPathDescription instanceof SimplePathDescription) {
            this.serializeSimplePathDescription((SimplePathDescription)primaryPathDescription);
        } else if (primaryPathDescription instanceof AggregationPathDescription) {
            this.serializeAggregationPathDescription((AggregationPathDescription)primaryPathDescription);
        } else {
            throw new GreqlException("Unknown PrimaryPathDescription " + primaryPathDescription + ".");
        }
        if (primaryPathDescription.get_edgeRestr().iterator().hasNext()) {
            this.sb.append("{");
            boolean bl = true;
            for (EdgeRestriction edgeRestriction : primaryPathDescription.get_edgeRestr()) {
                if (bl) {
                    bl = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeEdgeRestriction(edgeRestriction);
            }
            this.sb.append("}");
        }
    }

    private void serializeAggregationPathDescription(AggregationPathDescription aggregationPathDescription) {
        if (aggregationPathDescription.is_outAggregation()) {
            this.sb.append("<>--");
        } else {
            this.sb.append("--<>");
        }
    }

    private void serializeSimplePathDescription(SimplePathDescription simplePathDescription) {
        GReQLDirection gReQLDirection = simplePathDescription.get_direction().get_dirValue();
        switch (gReQLDirection) {
            case OUT: {
                this.sb.append("-->");
                break;
            }
            case IN: {
                this.sb.append("<--");
                break;
            }
            default: {
                this.sb.append("<->");
            }
        }
    }

    private void serializeEdgePathDescription(EdgePathDescription edgePathDescription) {
        GReQLDirection gReQLDirection = edgePathDescription.get_direction().get_dirValue();
        switch (gReQLDirection) {
            case OUT: {
                this.sb.append("--");
                this.serializeExpression(edgePathDescription.get_edgeExpr(), false);
                this.sb.append("->");
                break;
            }
            case IN: {
                this.sb.append("<-");
                this.serializeExpression(edgePathDescription.get_edgeExpr(), false);
                this.sb.append("--");
                break;
            }
            default: {
                this.sb.append("<-");
                this.serializeExpression(edgePathDescription.get_edgeExpr(), false);
                this.sb.append("->");
            }
        }
    }

    private void serializeTransposedPathDescription(TransposedPathDescription transposedPathDescription) {
        this.serializePathDescription(transposedPathDescription.get_transposedPath());
        this.sb.append("^T");
    }

    private void serializeSequentialPathDescription(SequentialPathDescription sequentialPathDescription) {
        for (PathDescription pathDescription : sequentialPathDescription.get_sequenceElement()) {
            this.serializePathDescription(pathDescription);
            this.sb.append(' ');
        }
    }

    private void serializeOptionalPathDescription(OptionalPathDescription optionalPathDescription) {
        this.sb.append('[');
        this.serializePathDescription(optionalPathDescription.get_optionalPath());
        this.sb.append(']');
    }

    private void serializeIteratedPathDescription(IteratedPathDescription iteratedPathDescription) {
        this.serializePathDescription(iteratedPathDescription.get_iteratedPath());
        this.sb.append(iteratedPathDescription.get_times() == IterationType.STAR ? (char)'*' : '+');
    }

    private void serializeIntermediateVertexPathDescription(IntermediateVertexPathDescription intermediateVertexPathDescription) {
        Iterator iterator = intermediateVertexPathDescription.get_subPath().iterator();
        this.serializePathDescription((PathDescription)iterator.next());
        this.serializeExpression(intermediateVertexPathDescription.get_intermediateVertex(), false);
        this.serializePathDescription((PathDescription)iterator.next());
    }

    private void serializeExponentiatedPathDescription(ExponentiatedPathDescription exponentiatedPathDescription) {
        this.serializePathDescription(exponentiatedPathDescription.get_exponentiatedPath());
        this.sb.append('^');
        this.serializeLiteral(exponentiatedPathDescription.get_exponent());
    }

    private void serializeAlternativePathDescription(AlternativePathDescription alternativePathDescription) {
        boolean bl = true;
        for (PathDescription pathDescription : alternativePathDescription.get_alternatePath()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(" | ");
            }
            this.serializePathDescription(pathDescription);
        }
    }

    private void serializeElementSetExpression(ElementSetExpression elementSetExpression) {
        if (elementSetExpression instanceof VertexSetExpression) {
            this.sb.append("V");
        } else if (elementSetExpression instanceof EdgeSetExpression) {
            this.sb.append("E");
        } else {
            throw new GreqlException("Unknown ElementSetExpression " + elementSetExpression + ".");
        }
        Iterable iterable = elementSetExpression.get_typeRestr();
        if (!iterable.iterator().hasNext()) {
            return;
        }
        this.sb.append("{");
        String string = "";
        for (TypeId typeId : iterable) {
            this.sb.append(string);
            string = ", ";
            this.serializeIdentifier(typeId);
        }
        this.sb.append("}");
    }

    private void serializeDefinitionExpression(DefinitionExpression definitionExpression) {
        if (definitionExpression instanceof LetExpression) {
            this.serializeLetExpression((LetExpression)definitionExpression);
        } else if (definitionExpression instanceof WhereExpression) {
            this.serializeWhereExpression((WhereExpression)definitionExpression);
        } else {
            throw new GreqlException("Unknown DefinitionExpression " + definitionExpression + ".");
        }
    }

    private void serializeWhereExpression(WhereExpression whereExpression) {
        this.serializeExpression(whereExpression.get_boundExprOfDefinition(), true);
        this.sb.append("where ");
        boolean bl = true;
        for (Definition definition : whereExpression.get_definition()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeDefinition(definition);
        }
    }

    private void serializeLetExpression(LetExpression letExpression) {
        this.sb.append("let ");
        boolean bl = true;
        for (Definition definition : letExpression.get_definition()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeDefinition(definition);
        }
        this.sb.append(" in ");
        this.serializeExpression(letExpression.get_boundExprOfDefinition(), true);
    }

    private void serializeComprehension(Comprehension comprehension) {
        this.sb.append("from ");
        this.serializeDeclaration(comprehension.get_compDecl(), true);
        if (comprehension instanceof SetComprehension) {
            this.sb.append(" reportSet");
        } else if (comprehension instanceof ListComprehension) {
            this.sb.append(" report");
        } else {
            if (comprehension instanceof MapComprehension) {
                this.sb.append(" reportMap");
                this.serializeLimitedComprehension(comprehension);
                MapComprehension mapComprehension = (MapComprehension)comprehension;
                this.serializeExpression(mapComprehension.get_keyExpr(), false);
                this.sb.append(", ");
                this.serializeExpression(mapComprehension.get_valueExpr(), true);
                this.sb.append("end");
                return;
            }
            throw new GreqlException("Unknown Comprehension " + comprehension + ".");
        }
        this.serializeLimitedComprehension(comprehension);
        Expression expression = comprehension.get_compResultDef();
        IsTableHeaderOf isTableHeaderOf = comprehension.getFirstIsTableHeaderOfIncidence(EdgeDirection.IN);
        if (expression instanceof TupleConstruction) {
            boolean bl = true;
            for (Expression expression2 : ((TupleConstruction)expression).get_part()) {
                if (bl) {
                    bl = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeExpression(expression2, false);
                if (isTableHeaderOf == null) continue;
                this.sb.append(" as ");
                this.serializeExpression(isTableHeaderOf.getAlpha(), false);
                isTableHeaderOf = isTableHeaderOf.getNextIsTableHeaderOfIncidence(EdgeDirection.IN);
            }
            this.sb.append(' ');
        } else {
            this.serializeExpression(expression, true);
            if (isTableHeaderOf != null) {
                this.sb.append(" as ");
                this.serializeExpression(isTableHeaderOf.getAlpha(), false);
                this.sb.append(" ");
            }
        }
        this.sb.append("end");
    }

    private void serializeLimitedComprehension(Comprehension comprehension) {
        Expression expression = comprehension.get_maxCount();
        if (expression != null) {
            this.sb.append("N ");
            this.serializeExpression(expression, false);
            this.sb.append(":");
        }
        this.sb.append(" ");
    }

    private void serializeQuantifiedExpression(QuantifiedExpression quantifiedExpression) {
        this.sb.append('(');
        this.serializeQuantifier(quantifiedExpression.get_quantifier());
        this.sb.append(' ');
        this.serializeDeclaration(quantifiedExpression.get_quantifiedDecl(), false);
        this.sb.append(" @ ");
        this.serializeExpression(quantifiedExpression.get_boundExprOfQuantifier(), false);
        this.sb.append(')');
    }

    private void serializeLiteral(Literal literal) {
        if (literal instanceof BoolLiteral) {
            this.sb.append(((BoolLiteral)literal).is_boolValue());
        } else if (literal instanceof IntLiteral) {
            this.sb.append(((IntLiteral)literal).get_intValue());
        } else if (literal instanceof LongLiteral) {
            this.sb.append(((LongLiteral)literal).get_longValue());
        } else if (literal instanceof UndefinedLiteral) {
            this.sb.append("undefined");
        } else if (literal instanceof DoubleLiteral) {
            this.sb.append(((DoubleLiteral)literal).get_doubleValue());
        } else if (literal instanceof StringLiteral) {
            this.sb.append(GraphIO.toUtfString(((StringLiteral)literal).get_stringValue()));
        } else if (literal instanceof ThisEdge) {
            this.sb.append("thisEdge");
        } else if (literal instanceof ThisVertex) {
            this.sb.append("thisVertex");
        } else {
            throw new GreqlException("Unknown Literal " + literal + ".");
        }
    }

    private void serializeIdentifier(Identifier identifier) {
        if (identifier instanceof TypeId) {
            TypeId typeId = (TypeId)identifier;
            if (typeId.is_excluded()) {
                this.sb.append("^");
            }
            this.sb.append(typeId.get_name());
            if (typeId.is_type()) {
                this.sb.append("!");
            }
        } else {
            this.sb.append(identifier.get_name());
        }
    }

    private void serializeFunctionApplication(FunctionApplication functionApplication) {
        FunctionId functionId = functionApplication.get_functionId();
        String string = functionId.get_name();
        if (string.equals("add")) {
            this.serializeFunctionApplicationInfix(functionApplication, "+");
            return;
        }
        if (string.equals("sub")) {
            this.serializeFunctionApplicationInfix(functionApplication, "-");
            return;
        }
        if (string.equals("mul")) {
            this.serializeFunctionApplicationInfix(functionApplication, "*");
            return;
        }
        if (string.equals("div")) {
            this.serializeFunctionApplicationInfix(functionApplication, "/");
            return;
        }
        if (string.equals("equals")) {
            this.serializeFunctionApplicationInfix(functionApplication, "=");
            return;
        }
        if (string.equals("nequals")) {
            this.serializeFunctionApplicationInfix(functionApplication, "<>");
            return;
        }
        if (string.equals("grEqual")) {
            this.serializeFunctionApplicationInfix(functionApplication, ">=");
            return;
        }
        if (string.equals("grThan")) {
            this.serializeFunctionApplicationInfix(functionApplication, ">");
            return;
        }
        if (string.equals("leEqual")) {
            this.serializeFunctionApplicationInfix(functionApplication, "<=");
            return;
        }
        if (string.equals("leThan")) {
            this.serializeFunctionApplicationInfix(functionApplication, "<");
            return;
        }
        if (string.equals("reMatch")) {
            this.serializeFunctionApplicationInfix(functionApplication, "=~");
            return;
        }
        if (string.equals("mod")) {
            this.serializeFunctionApplicationInfix(functionApplication, "%");
            return;
        }
        if (string.equals("and")) {
            this.serializeFunctionApplicationInfix(functionApplication, "and");
            return;
        }
        if (string.equals("or")) {
            this.serializeFunctionApplicationInfix(functionApplication, "or");
            return;
        }
        if (string.equals("xor")) {
            this.serializeFunctionApplicationInfix(functionApplication, "xor");
            return;
        }
        if (string.equals("concat")) {
            this.serializeFunctionApplicationInfix(functionApplication, "++");
            return;
        }
        if (string.equals("getValue")) {
            this.serializeFunctionApplicationInfix(functionApplication, ".");
            return;
        }
        this.serializeIdentifier(functionId);
        String string2 = "{";
        for (IsTypeExprOfFunction object : functionApplication.getIsTypeExprOfFunctionIncidences(EdgeDirection.IN)) {
            Expression expression = (Expression)object.getThat();
            this.sb.append(string2);
            string2 = ", ";
            this.serializeExpression(expression, false);
        }
        if (!string2.equals("{")) {
            this.sb.append("}");
        }
        this.sb.append('(');
        boolean bl = true;
        for (Expression expression : functionApplication.get_argument()) {
            if (bl) {
                bl = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression(expression, false);
        }
        this.sb.append(")");
    }

    private void serializeFunctionApplicationInfix(FunctionApplication functionApplication, String string) {
        this.sb.append("(");
        boolean bl = true;
        for (Expression expression : functionApplication.get_argument()) {
            if (bl) {
                bl = false;
            } else if (string.equals(".")) {
                this.sb.append(string);
            } else {
                this.sb.append(' ').append(string).append(' ');
            }
            this.serializeExpression(expression, false);
        }
        this.sb.append(")");
    }

    private void serializeConditionalExpression(ConditionalExpression conditionalExpression) {
        this.serializeExpression(conditionalExpression.get_condition(), true);
        this.sb.append("? ");
        this.serializeExpression(conditionalExpression.get_trueExpr(), true);
        this.sb.append(": ");
        this.serializeExpression(conditionalExpression.get_falseExpr(), true);
    }

    private void serializeVariable(Variable variable) {
        this.sb.append(variable.get_name());
    }
}

