/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.gretl.AddMappings;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateSubgraph;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.InPlaceTransformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.gretl.template.CreateEdge;
import de.uni_koblenz.jgralab.gretl.template.CreateVertex;
import de.uni_koblenz.jgralab.gretl.template.TemplateGraph;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParser;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.pcollections.Empty;
import org.pcollections.PMap;
import org.pcollections.POrderedMap;
import org.pcollections.PSet;

public class MatchReplace
extends InPlaceTransformation {
    private TemplateGraph replaceGraph;
    private String semanticExpression;
    private PSet<Object> matches;
    private Map<CreateVertex, Vertex> createVertices2Vertices = new HashMap<CreateVertex, Vertex>();
    private LinkedHashSet<Vertex> matchedVertices = new LinkedHashSet();
    private LinkedHashSet<Edge> matchedEdges = new LinkedHashSet();
    private Set<GraphElement<?, ?>> preservables = new HashSet();
    private boolean addGlobalMappings = false;
    private HashSet<GraphElement<?, ?>> allModifiedElements = new HashSet();

    public MatchReplace(Context context, TemplateGraph templateGraph, String string) {
        super(context);
        this.replaceGraph = templateGraph;
        this.semanticExpression = string;
    }

    public MatchReplace(Context context, TemplateGraph templateGraph, boolean bl, String string) {
        super(context);
        this.replaceGraph = templateGraph;
        this.semanticExpression = string;
        this.addGlobalMappings = bl;
    }

    public MatchReplace(Context context, String string, String string2) {
        this(context, TemplateGraphParser.parse(string), string2);
    }

    public MatchReplace(Context context, TemplateGraph templateGraph, PSet<Object> pSet) {
        super(context);
        this.replaceGraph = templateGraph;
        this.matches = pSet;
    }

    public static MatchReplace parseAndCreate(ExecuteTransformation executeTransformation) {
        TemplateGraph templateGraph = TemplateGraphParser.parse(executeTransformation.match((TokenTypes)TokenTypes.DOMAIN_SPECIFIC).value);
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new MatchReplace(executeTransformation.context, templateGraph, string);
    }

    @Override
    protected Integer transform() {
        if (this.context.getPhase() == Context.TransformationPhase.SCHEMA) {
            throw new GReTLException("SCHEMA phase in InPlaceTransformatio?!?");
        }
        if (this.matches == null) {
            this.matches = (PSet)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        this.allModifiedElements.clear();
        int n = 0;
        for (Object e : this.matches) {
            this.context.setGReQLVariable("$", e);
            this.matchedVertices.clear();
            this.matchedEdges.clear();
            this.preservables.clear();
            this.createVertices2Vertices.clear();
            this.calculateMatchedElements(e);
            if (!this.isValidMatch()) continue;
            ++n;
            this.apply();
        }
        this.matches = null;
        return n;
    }

    private void apply() {
        this.createAndUpdateVertices();
        this.createAndUpdateEdges();
        this.deleteNonPreservables();
    }

    private void calculateMatchedElements(Object object) {
        if (object instanceof Vertex) {
            this.matchedVertices.add((Vertex)object);
        } else if (object instanceof Edge) {
            this.matchedEdges.add(((Edge)object).getNormalEdge());
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.calculateMatchedElements(e);
            }
        } else if (object instanceof Record) {
            for (Object v : ((Record)object).toPMap().values()) {
                this.calculateMatchedElements(v);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            this.calculateMatchedElements(map.keySet());
            this.calculateMatchedElements(map.values());
        }
    }

    private void deleteNonPreservables() {
        for (Vertex graphElement : this.matchedVertices) {
            if (!graphElement.isValid() || this.preservables.contains(graphElement)) continue;
            this.verifyNoIncidentalDeletion(graphElement);
            graphElement.delete();
        }
        for (Edge edge : this.matchedEdges) {
            if (!edge.isValid() || this.preservables.contains(edge)) continue;
            edge.delete();
        }
    }

    private void verifyNoIncidentalDeletion(Vertex vertex) {
        for (Edge edge : vertex.incidences()) {
            if (!this.preservables.contains(edge.getNormalEdge()) && this.matchedEdges.contains(edge.getNormalEdge())) continue;
            throw new GReTLException(this.context, "Prevervable or non-matched edge " + edge + " from " + edge.getAlpha() + " to " + edge.getOmega() + " would be deleted by deleting " + vertex + "\ndeleted vertex = " + vertex + ",\nmatchedVertices = " + this.matchedVertices + ",\nmatchedEdges = " + this.matchedEdges + ",\npreservables = " + this.preservables + ",\nquery = " + this.semanticExpression);
        }
    }

    private void createAndUpdateEdges() {
        for (CreateEdge createEdge : this.replaceGraph.getCreateEdgeEdges()) {
            Edge edge;
            Vertex vertex = this.createVertices2Vertices.get(createEdge.getAlpha());
            Vertex vertex2 = this.createVertices2Vertices.get(createEdge.getOmega());
            Object k = null;
            if (createEdge.get_archetype() != null) {
                k = this.context.evaluateGReQLQuery(createEdge.get_archetype());
            }
            if (createEdge.get_typeName() == null && k != null && k instanceof Edge) {
                edge = ((Edge)k).getNormalEdge();
                this.preservables.add(edge);
                this.allModifiedElements.add(edge);
                edge.setAlpha(vertex);
                edge.setOmega(vertex2);
                this.setAttributeValues(edge, k, createEdge.get_attributes(), createEdge.is_copyAttributeValues());
                continue;
            }
            edge = this.createEdge(createEdge, vertex, vertex2);
            if (this.addGlobalMappings && k != null) {
                POrderedMap<Object, AttributedElement<?, ?>> pOrderedMap = Empty.orderedMap();
                pOrderedMap = pOrderedMap.plus(k, edge);
                new AddMappings(this.context, pOrderedMap).execute();
                if (k instanceof Edge) {
                    this.allModifiedElements.add((Edge)k);
                }
            }
            this.setAttributeValues(edge, k, createEdge.get_attributes(), createEdge.is_copyAttributeValues());
        }
    }

    private void createAndUpdateVertices() {
        for (CreateVertex createVertex : this.replaceGraph.getCreateVertexVertices()) {
            Vertex vertex;
            Object k = null;
            if (createVertex.get_archetype() != null) {
                k = this.context.evaluateGReQLQuery(createVertex.get_archetype());
            }
            if (createVertex.get_typeName() == null && k != null && k instanceof Vertex) {
                vertex = (Vertex)k;
                this.createVertices2Vertices.put(createVertex, vertex);
                this.preservables.add(vertex);
                this.allModifiedElements.add(vertex);
                this.setAttributeValues(vertex, k, createVertex.get_attributes(), createVertex.is_copyAttributeValues());
                continue;
            }
            vertex = this.createVertex(createVertex);
            this.createVertices2Vertices.put(createVertex, vertex);
            if (k != null) {
                PMap<Object, Vertex> pMap;
                if (this.addGlobalMappings) {
                    pMap = Empty.orderedMap();
                    pMap = pMap.plus(k, vertex);
                    new AddMappings(this.context, pMap).execute();
                }
                if (k instanceof Vertex) {
                    pMap = (Vertex)k;
                    this.allModifiedElements.add((GraphElement<?, ?>)((Object)pMap));
                    this.relinkIncidences((Vertex)((Object)pMap), vertex);
                }
            }
            this.setAttributeValues(vertex, k, createVertex.get_attributes(), createVertex.is_copyAttributeValues());
        }
    }

    private Vertex createVertex(CreateVertex createVertex) {
        VertexClass vertexClass = this.vc(CreateSubgraph.getVertexClassName(createVertex, this.context));
        Object t = this.context.getTargetGraph().createVertex(vertexClass);
        return t;
    }

    private Edge createEdge(CreateEdge createEdge, Vertex vertex, Vertex vertex2) {
        EdgeClass edgeClass = null;
        if (createEdge.get_typeName() != null) {
            String string = createEdge.get_typeName();
            edgeClass = createEdge.is_typeNameIsQuery() ? this.ec(this.context.evaluateGReQLQuery(string).toString()) : this.ec(createEdge.get_typeName());
        } else {
            edgeClass = this.getSingleEdgeClassBetween(vertex.getAttributedElementClass(), vertex2.getAttributedElementClass());
        }
        return this.context.getTargetGraph().createEdge(edgeClass, vertex, vertex2);
    }

    private EdgeClass getSingleEdgeClassBetween(VertexClass vertexClass, VertexClass vertexClass2) {
        LinkedList<EdgeClass> linkedList = new LinkedList<EdgeClass>();
        for (EdgeClass edgeClass : vertexClass.getConnectedEdgeClasses()) {
            if (edgeClass.isAbstract()) continue;
            VertexClass vertexClass3 = edgeClass.getFrom().getVertexClass();
            VertexClass vertexClass4 = edgeClass.getTo().getVertexClass();
            if (!vertexClass3.equals(vertexClass) && !vertexClass3.isSuperClassOf(vertexClass) || !vertexClass4.equals(vertexClass2) && !vertexClass4.isSuperClassOf(vertexClass2)) continue;
            linkedList.add(edgeClass);
        }
        if (linkedList.size() != 1) {
            throw new GReTLException(this.context, "Cannot find exactly one EdgeClass between " + vertexClass.getQualifiedName() + " and " + vertexClass2.getQualifiedName() + ", but there were these possibilities: " + linkedList + ".");
        }
        return (EdgeClass)linkedList.get(0);
    }

    private void setAttributeValues(GraphElement<?, ?> graphElement, Object object, Map<String, String> map, boolean bl) {
        if (map == null) {
            return;
        }
        if (bl && (object == null || !(object instanceof AttributedElement))) {
            throw new GReTLException(this.context, "Should copy attribute values, but the archetype '" + object + "' is no AttributedElement.");
        }
        if (bl) {
            AttributedElement attributedElement = (AttributedElement)object;
            Object object2 = attributedElement.getAttributedElementClass();
            GraphElementClass graphElementClass = (GraphElementClass)graphElement.getAttributedElementClass();
            for (Attribute attribute : graphElementClass.getAttributeList()) {
                String string = attribute.getName();
                if (map.containsKey(string) || !object2.containsAttribute(string) || object2.getAttribute(string).getDomain() != attribute.getDomain()) continue;
                graphElement.setAttribute(string, attributedElement.getAttribute(string));
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            graphElement.setAttribute((String)entry.getKey(), this.context.evaluateGReQLQuery((String)entry.getValue()));
        }
    }

    private boolean isValidMatch() {
        for (Vertex graphElement : this.matchedVertices) {
            if (!this.allModifiedElements.contains(graphElement)) continue;
            return false;
        }
        for (Edge edge : this.matchedEdges) {
            if (!this.allModifiedElements.contains(edge)) continue;
            return false;
        }
        return true;
    }
}

