/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.grumlschema.impl.std.structure;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AttributeImpl
extends VertexImpl
implements Vertex,
Attribute {
    protected String _defaultValue;
    protected String _name;

    public AttributeImpl(int n, Graph graph) {
        super(n, graph);
    }

    @Override
    public final VertexClass getAttributedElementClass() {
        return Attribute.VC;
    }

    @Override
    public final Class<? extends Vertex> getSchemaClass() {
        return Attribute.class;
    }

    @Override
    public <T> T getAttribute(String string) {
        if (string.equals("defaultValue")) {
            return (T)this.get_defaultValue();
        }
        if (string.equals("name")) {
            return (T)this.get_name();
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + string);
    }

    @Override
    public <T> void setAttribute(String string, T t) {
        if (string.equals("defaultValue")) {
            this.set_defaultValue((String)t);
            return;
        }
        if (string.equals("name")) {
            this.set_name((String)t);
            return;
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + string);
    }

    @Override
    public String get_defaultValue() {
        return this._defaultValue;
    }

    @Override
    public void set_defaultValue(String string) {
        this.graph.fireBeforeChangeAttribute(this, "defaultValue", this._defaultValue, string);
        String string2 = this._defaultValue;
        this._defaultValue = string;
        this.internalMarkAttributeAsSet(0, true);
        this.graphModified();
        this.graph.fireAfterChangeAttribute(this, "defaultValue", string2, string);
    }

    @Override
    public String get_name() {
        return this._name;
    }

    @Override
    public void set_name(String string) {
        this.graph.fireBeforeChangeAttribute(this, "name", this._name, string);
        String string2 = this._name;
        this._name = string;
        this.internalMarkAttributeAsSet(1, true);
        this.graphModified();
        this.graph.fireAfterChangeAttribute(this, "name", string2, string);
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        boolean bl = true;
        if (!graphIO.isNextToken(TgLexer.Token.UNSET)) {
            this._defaultValue = graphIO.matchUtfString();
        } else {
            graphIO.match();
            bl = false;
        }
        if (bl) {
            this.set_defaultValue(this._defaultValue);
        }
        bl = true;
        if (!graphIO.isNextToken(TgLexer.Token.UNSET)) {
            this._name = graphIO.matchUtfString();
        } else {
            graphIO.match();
            bl = false;
        }
        if (bl) {
            this.set_name(this._name);
        }
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException {
        if (string.equals("defaultValue")) {
            GraphIO graphIO = GraphIO.createStringReader(string2, this.getSchema());
            boolean bl = true;
            if (!graphIO.isNextToken(TgLexer.Token.UNSET)) {
                this._defaultValue = graphIO.matchUtfString();
            } else {
                graphIO.match();
                bl = false;
            }
            if (bl) {
                this.set_defaultValue(this._defaultValue);
            }
            return;
        }
        if (string.equals("name")) {
            GraphIO graphIO = GraphIO.createStringReader(string2, this.getSchema());
            boolean bl = true;
            if (!graphIO.isNextToken(TgLexer.Token.UNSET)) {
                this._name = graphIO.matchUtfString();
            } else {
                graphIO.match();
                bl = false;
            }
            if (bl) {
                this.set_name(this._name);
            }
            return;
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + string);
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws GraphIOException, IOException {
        if (this.isUnsetAttribute("defaultValue")) {
            graphIO.writeIdentifier(TgLexer.Token.UNSET.toString());
        } else {
            graphIO.writeUtfString(this._defaultValue);
        }
        if (this.isUnsetAttribute("name")) {
            graphIO.writeIdentifier(TgLexer.Token.UNSET.toString());
        } else {
            graphIO.writeUtfString(this._name);
        }
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException {
        if (string.equals("defaultValue")) {
            GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
            if (this.isUnsetAttribute("defaultValue")) {
                graphIO.writeIdentifier(TgLexer.Token.UNSET.toString());
            } else {
                graphIO.writeUtfString(this._defaultValue);
            }
            return graphIO.getStringWriterResult();
        }
        if (string.equals("name")) {
            GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
            if (this.isUnsetAttribute("name")) {
                graphIO.writeIdentifier(TgLexer.Token.UNSET.toString());
            } else {
                graphIO.writeUtfString(this._name);
            }
            return graphIO.getStringWriterResult();
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + string);
    }

    @Override
    public Attribute getNextAttribute() {
        return (Attribute)this.getNextVertex(Attribute.VC);
    }

    @Override
    public HasDomain getFirstHasDomainIncidence() {
        return (HasDomain)this.getFirstIncidence(HasDomain.EC);
    }

    @Override
    public HasDomain getFirstHasDomainIncidence(EdgeDirection edgeDirection) {
        return (HasDomain)this.getFirstIncidence(HasDomain.EC, edgeDirection);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence() {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence(EdgeDirection edgeDirection) {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC, edgeDirection);
    }

    @Override
    public HasDomain add_domain(Domain domain) {
        return (HasDomain)((SchemaGraph)this.getGraph()).createEdge(HasDomain.EC, this, domain);
    }

    @Override
    public List<? extends Domain> remove_domain() {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        HasDomain hasDomain = (HasDomain)this.getFirstIncidence(HasDomain.EC, EdgeDirection.OUT);
        while (hasDomain != null) {
            HasDomain hasDomain2 = (HasDomain)hasDomain.getNextIncidence(HasDomain.EC, EdgeDirection.OUT);
            arrayList.add((Domain)hasDomain.getThat());
            hasDomain.delete();
            hasDomain = hasDomain2;
        }
        return arrayList;
    }

    @Override
    public boolean remove_domain(Domain domain) {
        boolean bl = false;
        HasDomain hasDomain = (HasDomain)this.getFirstIncidence(HasDomain.EC, EdgeDirection.OUT);
        while (hasDomain != null) {
            HasDomain hasDomain2 = (HasDomain)hasDomain.getNextIncidence(HasDomain.EC, EdgeDirection.OUT);
            if (hasDomain.getThat().equals(domain)) {
                hasDomain.delete();
                bl = true;
            }
            hasDomain = hasDomain2;
        }
        return bl;
    }

    @Override
    public Domain get_domain() {
        HasDomain hasDomain = (HasDomain)this.getFirstIncidence(HasDomain.EC, EdgeDirection.OUT);
        if (hasDomain != null) {
            return (Domain)hasDomain.getThat();
        }
        return null;
    }

    @Override
    public HasAttribute add_element(AttributedElementClass attributedElementClass) {
        return (HasAttribute)((SchemaGraph)this.getGraph()).createEdge(HasAttribute.EC, attributedElementClass, this);
    }

    @Override
    public List<? extends AttributedElementClass> remove_element() {
        ArrayList<AttributedElementClass> arrayList = new ArrayList<AttributedElementClass>();
        HasAttribute hasAttribute = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (hasAttribute != null) {
            HasAttribute hasAttribute2 = (HasAttribute)hasAttribute.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            arrayList.add((AttributedElementClass)hasAttribute.getThat());
            hasAttribute.delete();
            hasAttribute = hasAttribute2;
        }
        return arrayList;
    }

    @Override
    public boolean remove_element(AttributedElementClass attributedElementClass) {
        boolean bl = false;
        HasAttribute hasAttribute = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (hasAttribute != null) {
            HasAttribute hasAttribute2 = (HasAttribute)hasAttribute.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            if (hasAttribute.getThat().equals(attributedElementClass)) {
                hasAttribute.delete();
                bl = true;
            }
            hasAttribute = hasAttribute2;
        }
        return bl;
    }

    @Override
    public AttributedElementClass get_element() {
        HasAttribute hasAttribute = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        if (hasAttribute != null) {
            return (AttributedElementClass)hasAttribute.getThat();
        }
        return null;
    }

    @Override
    public Iterable<HasDomain> getHasDomainIncidences() {
        return new IncidenceIterable<HasDomain>((Vertex)this, HasDomain.EC);
    }

    @Override
    public Iterable<HasDomain> getHasDomainIncidences(EdgeDirection edgeDirection) {
        return new IncidenceIterable<HasDomain>(this, HasDomain.EC, edgeDirection);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences() {
        return new IncidenceIterable<HasAttribute>((Vertex)this, HasAttribute.EC);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences(EdgeDirection edgeDirection) {
        return new IncidenceIterable<HasAttribute>(this, HasAttribute.EC, edgeDirection);
    }
}

