/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributeImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PSet;
import org.pcollections.PVector;

public abstract class AttributedElementClassImpl<SC extends AttributedElementClass<SC, IC>, IC extends AttributedElement<SC, IC>>
extends NamedElementImpl
implements AttributedElementClass<SC, IC> {
    protected PVector<Attribute> allAttributes = ArrayPVector.empty();
    protected PSet<Constraint> constraints = ArrayPSet.empty();
    protected HashMap<String, Integer> attributeIndex;
    protected boolean finished;
    private boolean isAbstract;
    private Class<IC> schemaClass;
    private Class<IC> schemaImplementationClass;

    protected AttributedElementClassImpl(String string, PackageImpl packageImpl, SchemaImpl schemaImpl) {
        super(string, packageImpl, schemaImpl);
    }

    protected Attribute createAttribute(Attribute attribute) {
        this.assertNotFinished();
        if (this.containsAttribute(attribute.getName())) {
            throw new SchemaException("Duplicate attribute '" + attribute.getName() + "' in AttributedElementClass '" + this.getQualifiedName() + "'");
        }
        TreeSet<Attribute> treeSet = new TreeSet<Attribute>(this.allAttributes);
        treeSet.add(attribute);
        this.allAttributes = ArrayPVector.empty().plusAll(treeSet);
        return attribute;
    }

    @Override
    public Attribute createAttribute(String string, Domain domain, String string2) {
        return this.createAttribute(new AttributeImpl(string, domain, this, string2));
    }

    @Override
    public Attribute createAttribute(String string, Domain domain) {
        return this.createAttribute(new AttributeImpl(string, domain, this, null));
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.assertNotFinished();
        this.constraints = this.constraints.plus(constraint);
    }

    protected String attributesToString() {
        StringBuilder stringBuilder = new StringBuilder("Attributes:\n");
        for (Attribute attribute : this.getAttributeList()) {
            stringBuilder.append("\t" + attribute.toString() + "\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean containsAttribute(String string) {
        if (this.finished) {
            return this.attributeIndex.containsKey(string);
        }
        return this.getAttribute(string) != null;
    }

    @Override
    public Attribute getAttribute(String string) {
        for (Attribute attribute : this.allAttributes) {
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.allAttributes.size();
    }

    @Override
    public List<Attribute> getAttributeList() {
        return this.allAttributes;
    }

    public PSet<Constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public Class<IC> getSchemaClass() {
        if (this.schemaClass == null) {
            String string = this.schema.getPackagePrefix() + "." + this.getQualifiedName();
            try {
                this.schemaClass = Class.forName(string, true, SchemaClassManager.instance(this.schema.getQualifiedName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SchemaClassAccessException("Can't load (generated) schema class for AttributedElementClass '" + this.getQualifiedName() + "'", classNotFoundException);
            }
        }
        return this.schemaClass;
    }

    @Override
    public Class<IC> getSchemaImplementationClass() {
        if (this.isAbstract()) {
            throw new SchemaClassAccessException("Can't get (generated) schema implementation class. AttributedElementClass '" + this.getQualifiedName() + "' is abstract!");
        }
        if (this.schemaImplementationClass == null) {
            try {
                Field field = this.getSchemaClass().getField("IMPLEMENTATION_CLASS");
                this.schemaImplementationClass = (Class)field.get(this.schemaClass);
            }
            catch (SecurityException securityException) {
                throw new SchemaClassAccessException(securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new SchemaClassAccessException(noSuchFieldException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SchemaClassAccessException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SchemaClassAccessException(illegalAccessException);
            }
        }
        return this.schemaImplementationClass;
    }

    @Override
    public boolean hasAttributes() {
        return !this.getAttributeList().isEmpty();
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    protected void finish() {
        assert (this.allAttributes != null);
        this.attributeIndex = new HashMap();
        int n = 0;
        for (Attribute attribute : this.allAttributes) {
            this.attributeIndex.put(attribute.getName(), n);
            ++n;
        }
        this.finished = true;
    }

    protected boolean isFinished() {
        return this.finished;
    }

    protected void assertNotFinished() {
        if (this.finished) {
            throw new SchemaException("No changes allowed in a finished Schema.");
        }
    }

    @Override
    public int getAttributeIndex(String string) {
        if (this.finished) {
            Integer n = this.attributeIndex.get(string);
            if (n != null) {
                return n;
            }
        } else {
            int n = 0;
            for (Attribute attribute : this.getAttributeList()) {
                if (attribute.getName().equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        throw new NoSuchAttributeException(this.getQualifiedName() + " doesn't contain an attribute '" + string + "'");
    }

    protected void reopen() {
        this.attributeIndex = null;
        this.finished = false;
    }

    protected abstract void deleteAttribute(AttributeImpl var1);
}

