/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;

public class ConstraintImpl
implements Constraint {
    private String message;
    private String predicate;
    private String offendingElements;

    public ConstraintImpl(String string, String string2, String string3) {
        this.message = string;
        this.predicate = string2;
        this.offendingElements = string3;
    }

    public ConstraintImpl(String string, String string2) {
        this(string, string2, null);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getOffendingElementsQuery() {
        return this.offendingElements;
    }

    @Override
    public String getPredicate() {
        return this.predicate;
    }

    public boolean equals(Object object) {
        if (object instanceof Constraint) {
            Constraint constraint = (Constraint)object;
            return this.compareTo(constraint) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.message.hashCode();
        n = 31 * n + this.predicate.hashCode();
        n = 31 * n + (null == this.offendingElements ? 0 : this.offendingElements.hashCode());
        return n;
    }

    @Override
    public int compareTo(Constraint constraint) {
        int n = this.message.compareTo(constraint.getMessage());
        if (n != 0) {
            return n;
        }
        n = this.predicate.compareTo(constraint.getPredicate());
        if (n != 0) {
            return n;
        }
        if (this.offendingElements != null) {
            return this.offendingElements.compareTo(constraint.getOffendingElementsQuery());
        }
        if (constraint.getOffendingElementsQuery() == null) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{Constraint: message = \"");
        stringBuilder.append(CodeGenerator.stringQuote(this.message));
        stringBuilder.append("\", predicate = \"");
        stringBuilder.append(CodeGenerator.stringQuote(this.predicate));
        stringBuilder.append("\", offendingElements = ");
        stringBuilder.append(this.offendingElements == null ? "<no offending elems query>" : this.offendingElements);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

