/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.exception.CycleException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DirectedGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class DirectedAcyclicGraph<T>
extends DirectedGraph<T> {
    private PVector<T> topologicalOrder = ArrayPVector.empty();
    private HashMap<T, PSet<T>> cachedPredecessors;
    private HashMap<T, PSet<T>> cachedSuccessors;
    private boolean transitive;

    public DirectedAcyclicGraph() {
        this(false);
    }

    public DirectedAcyclicGraph(boolean bl) {
        this.transitive = bl;
    }

    protected boolean computeTopologicalOrder() {
        LinkedList<DirectedGraph.Node> linkedList = new LinkedList<DirectedGraph.Node>();
        for (Object object : this.nodes) {
            ((DirectedGraph.Node)object).mark = ((DirectedGraph.Node)object).predecessors.size();
            if (((DirectedGraph.Node)object).mark != 0) continue;
            linkedList.offer((DirectedGraph.Node)object);
        }
        this.topologicalOrder = ArrayPVector.empty();
        while (!linkedList.isEmpty()) {
            DirectedGraph.Node node = (DirectedGraph.Node)linkedList.poll();
            this.topologicalOrder = this.topologicalOrder.plus(node.data);
            for (Object e : node.successors) {
                DirectedGraph.Node node2 = (DirectedGraph.Node)this.entries.get(e);
                --node2.mark;
                if (node2.mark != 0) continue;
                linkedList.offer(node2);
            }
        }
        assert (this.topologicalOrder.size() <= this.nodes.size());
        return this.topologicalOrder.size() == this.nodes.size();
    }

    @Override
    public T createNode(T t) {
        super.createNode(t);
        this.computeTopologicalOrder();
        return t;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.cachedPredecessors = new HashMap();
        this.cachedSuccessors = new HashMap();
        for (DirectedGraph.Node<Object> node : this.nodes) {
            this.cachedPredecessors.put(node.data, this.getAllPredecessorsInTopologicalOrder(node.data));
            this.cachedSuccessors.put(node.data, this.getAllSuccessorsInTopologicalOrder(node.data));
        }
        super.finish();
        if (this.transitive) {
            for (DirectedGraph.Node<Object> node : this.topologicalOrder) {
                DirectedGraph.Node node2 = (DirectedGraph.Node)this.entries.get(node);
                Set<DirectedGraph.Node> set = this.getIndirectSuccessors(node);
                set.retainAll(node2.successors);
                node2.successors = node2.successors.minusAll(set);
                for (DirectedGraph.Node node3 : set) {
                    DirectedGraph.Node node4 = (DirectedGraph.Node)this.entries.get(node3);
                    node4.predecessors = node4.predecessors.minus(node);
                }
            }
        }
    }

    private Set<T> getIndirectSuccessors(T t) {
        if (!this.finished) {
            throw new SchemaException();
        }
        DirectedGraph.Node node = (DirectedGraph.Node)this.entries.get(t);
        HashSet hashSet = new HashSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object e : node.successors) {
            linkedList.addAll(((DirectedGraph.Node)this.entries.get(e)).successors);
        }
        while (!linkedList.isEmpty()) {
            node = (DirectedGraph.Node)this.entries.get(linkedList.poll());
            if (hashSet.contains(node.data)) continue;
            hashSet.add(node.data);
            for (Object e : node.successors) {
                linkedList.offer(e);
            }
        }
        return hashSet;
    }

    public PSet<T> getAllPredecessorsInTopologicalOrder(T t) {
        if (this.finished) {
            return this.cachedPredecessors.get(t);
        }
        DirectedGraph.Node node = (DirectedGraph.Node)this.entries.get(t);
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList(node.predecessors);
        while (!linkedList.isEmpty()) {
            node = (DirectedGraph.Node)this.entries.get(linkedList.poll());
            if (hashSet.contains(node.data)) continue;
            hashSet.add(node.data);
            for (Iterator iterator : node.predecessors) {
                linkedList.offer(iterator);
            }
        }
        Object object = ArrayPSet.empty();
        for (Object e : this.topologicalOrder) {
            if (!hashSet.contains(e)) continue;
            object = object.plus(e);
        }
        return object;
    }

    public PSet<T> getAllSuccessorsInTopologicalOrder(T t) {
        if (this.finished) {
            return this.cachedSuccessors.get(t);
        }
        DirectedGraph.Node node = (DirectedGraph.Node)this.entries.get(t);
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList(node.successors);
        while (!linkedList.isEmpty()) {
            node = (DirectedGraph.Node)this.entries.get(linkedList.poll());
            if (hashSet.contains(node.data)) continue;
            hashSet.add(node.data);
            for (Iterator iterator : node.successors) {
                linkedList.offer(iterator);
            }
        }
        Object object = ArrayPSet.empty();
        for (Object e : this.topologicalOrder) {
            if (!hashSet.contains(e)) continue;
            object = object.plus(e);
        }
        return object;
    }

    @Override
    public void createEdge(T t, T t2) {
        super.createEdge(t, t2);
        if (!this.computeTopologicalOrder()) {
            DirectedGraph.Node node = (DirectedGraph.Node)this.entries.get(t);
            DirectedGraph.Node node2 = (DirectedGraph.Node)this.entries.get(t2);
            node.successors = node.successors.minus(node2);
            node2.predecessors = node2.predecessors.minus(node);
            this.computeTopologicalOrder();
            throw new CycleException(t, t2);
        }
    }

    public PVector<T> getNodesInTopologicalOrder() {
        return this.topologicalOrder;
    }

    public String toString() {
        HashMap hashMap = new HashMap();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph g {\n");
        int n = 0;
        for (Object e : this.topologicalOrder) {
            hashMap.put(e, n);
            stringBuilder.append("\tn").append(n).append(" [ label=\"").append(e.toString()).append("\" ];\n");
            ++n;
        }
        for (Object e : this.topologicalOrder) {
            DirectedGraph.Node node = (DirectedGraph.Node)this.entries.get(e);
            for (Object e2 : node.successors) {
                stringBuilder.append("\tn").append(hashMap.get(e)).append(" -> n").append(hashMap.get(e2)).append(";\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public void reopen() {
        this.cachedPredecessors = null;
        this.cachedSuccessors = null;
        this.finished = false;
    }

    @Override
    public void delete(T t) {
        super.delete(t);
        this.computeTopologicalOrder();
    }
}

