/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;

public final class DoubleDomainImpl
extends BasicDomainImpl
implements DoubleDomain {
    DoubleDomainImpl(Schema schema) {
        super("Double", (PackageImpl)schema.getDefaultPackage());
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return "double";
    }

    @Override
    public String getJavaClassName(String string) {
        return "java.lang.Double";
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3, boolean bl) {
        return this.maybeWrapInUnsetCheck(string3, bl, string2 + " = " + string3 + ".matchDouble();");
    }

    @Override
    public String getTGTypeName(Package package_) {
        return "Double";
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        return new CodeSnippet(string3 + ".writeDouble(" + string2 + ");");
    }

    @Override
    public String getInitialValue() {
        return "0.0";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        if (graphIO.isNextToken(TgLexer.Token.UNSET)) {
            graphIO.match();
            return GraphIO.Unset.UNSET;
        }
        return graphIO.matchDouble();
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        graphIO.writeDouble((Double)object);
    }

    @Override
    public boolean isConformValue(Object object) {
        return Double.class.isInstance(object);
    }
}

