/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;

public final class StringDomainImpl
extends BasicDomainImpl
implements StringDomain {
    StringDomainImpl(Schema schema) {
        super("String", (PackageImpl)schema.getDefaultPackage());
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return "java.lang.String";
    }

    @Override
    public String getJavaClassName(String string) {
        return this.getJavaAttributeImplementationTypeName(string);
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3, boolean bl) {
        return this.maybeWrapInUnsetCheck(string3, bl, string2 + " = " + string3 + ".matchUtfString();");
    }

    @Override
    public String getTGTypeName(Package package_) {
        return "String";
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        return new CodeSnippet(string3 + ".writeUtfString(" + string2 + ");");
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        if (graphIO.isNextToken(TgLexer.Token.UNSET)) {
            graphIO.match();
            return GraphIO.Unset.UNSET;
        }
        return graphIO.matchUtfString();
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        graphIO.writeUtfString((String)object);
    }

    @Override
    public boolean isConformValue(Object object) {
        return object == null || String.class.isInstance(object);
    }
}

