/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.utilities.gui.xdot.TextShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class XDotShape {
    private final Shape shape;
    private Color lineColor;
    private Color fillColor;
    private Color textColor;
    private Stroke stroke;
    private AttributedElement<?, ?> element;

    public XDotShape(Shape shape, Color color, Color color2, Color color3, Stroke stroke) {
        this.shape = shape;
        this.lineColor = color;
        this.fillColor = color2;
        this.textColor = color3;
        this.stroke = stroke;
    }

    public AttributedElement<?, ?> getElement() {
        return this.element;
    }

    public void setElement(AttributedElement<?, ?> attributedElement) {
        this.element = attributedElement;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.stroke != null) {
            graphics2D.setStroke(this.stroke);
        }
        if (this.fillColor != null) {
            graphics2D.setColor(this.fillColor);
            graphics2D.fill(this.shape);
        }
        if (this.shape instanceof TextShape && this.textColor != null) {
            TextShape textShape = (TextShape)this.shape;
            textShape.justify(graphics2D);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(1.0, -1.0);
            graphics2D.setFont(textShape.getFont());
            graphics2D.setColor(this.textColor);
            graphics2D.drawString(textShape.getText(), (float)textShape.x, (float)(-textShape.y));
            graphics2D.setTransform(affineTransform);
        }
        if (this.lineColor != null) {
            graphics2D.setColor(this.lineColor);
            graphics2D.draw(this.shape);
        }
    }
}

