/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

abstract class GraphElementTreeNode
implements TreeNode {
    protected ArrayList<GraphElementTreeNode> incs;
    protected GraphElementTreeNode parent;

    protected abstract void init();

    protected abstract GraphElement<?, ?> get();

    protected GraphElementTreeNode(GraphElementTreeNode graphElementTreeNode) {
        this.parent = graphElementTreeNode;
    }

    public Enumeration<GraphElementTreeNode> children() {
        this.init();
        return Collections.enumeration(this.incs);
    }

    @Override
    public boolean getAllowsChildren() {
        this.init();
        return false;
    }

    @Override
    public TreeNode getChildAt(int n) {
        this.init();
        return this.incs.get(n);
    }

    @Override
    public int getChildCount() {
        this.init();
        return this.incs.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.init();
        return this.incs.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        this.init();
        return this.incs.isEmpty();
    }

    public abstract String getToolTipText();

    public abstract String getClipboardText();

    private static String escapeHTML(Object object) {
        if (object == null) {
            return "null";
        }
        String string = object.toString();
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    public String getAttributeString() {
        if (((GraphElementClass)this.get().getAttributedElementClass()).getAttributeList().isEmpty()) {
            return "$noAttrs$";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Attribute attribute : ((GraphElementClass)this.get().getAttributedElementClass()).getAttributeList()) {
            stringBuilder.append(attribute.getName());
            stringBuilder.append(" = ");
            stringBuilder.append(GraphElementTreeNode.escapeHTML(this.get().getAttribute(attribute.getName())));
            stringBuilder.append("<br>");
        }
        return stringBuilder.toString();
    }
}

