/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.pcollections.PBag;
import org.pcollections.PMap;

public final class MapPBag<E>
extends AbstractCollection<E>
implements PBag<E> {
    private final PMap<E, Integer> map;
    private final int size;

    public static <E> MapPBag<E> empty(PMap<E, Integer> pMap) {
        return new MapPBag<E>(pMap.minusAll(pMap.keySet()), 0);
    }

    private MapPBag(PMap<E, Integer> pMap, int n) {
        this.map = pMap;
        this.size = n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator iterator = this.map.entrySet().iterator();
        return new Iterator<E>(){
            private E e;
            private int n = 0;

            @Override
            public boolean hasNext() {
                return this.n > 0 || iterator.hasNext();
            }

            @Override
            public E next() {
                if (this.n == 0) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    this.e = entry.getKey();
                    this.n = (Integer)entry.getValue();
                }
                --this.n;
                return this.e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (E e : this) {
            n += e.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PBag)) {
            return false;
        }
        if (!(object instanceof MapPBag)) {
            PBag pBag = this.minusAll((Collection)this);
            object = ((MapPBag)pBag).plusAll((Collection)((PBag)object));
        }
        return this.map.equals(((MapPBag)object).map);
    }

    @Override
    public MapPBag<E> plus(E e) {
        return new MapPBag<E>(this.map.plus(e, this.count(e) + 1), this.size + 1);
    }

    @Override
    public MapPBag<E> minus(Object object) {
        int n = this.count(object);
        if (n == 0) {
            return this;
        }
        if (n == 1) {
            return new MapPBag<E>(this.map.minus(object), this.size - 1);
        }
        return new MapPBag<Object>(this.map.plus(object, n - 1), this.size - 1);
    }

    @Override
    public MapPBag<E> plusAll(Collection<? extends E> collection) {
        PBag<E> pBag = this;
        for (E e : collection) {
            pBag = pBag.plus((Object)e);
        }
        return pBag;
    }

    @Override
    public MapPBag<E> minusAll(Collection<?> collection) {
        PMap<E, Integer> pMap = this.map.minusAll(collection);
        return new MapPBag<E>(pMap, MapPBag.size(pMap));
    }

    private int count(Object object) {
        if (!this.contains(object)) {
            return 0;
        }
        return (Integer)this.map.get(object);
    }

    private static int size(PMap<?, Integer> pMap) {
        int n = 0;
        for (Integer n2 : pMap.values()) {
            n += n2.intValue();
        }
        return n;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }
}

