/*
 * JGraLab - The Java Graph Laboratory
 *
 * Copyright (C) 2006-2013 Institute for Software Technology
 *                         University of Koblenz-Landau, Germany
 *                         ist@uni-koblenz.de
 *
 * For bug reports, documentation and further information, visit
 *
 *                         https://github.com/jgralab/jgralab
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, see <http://www.gnu.org/licenses>.
 *
 * Additional permission under GNU GPL version 3 section 7
 *
 * If you modify this Program, or any covered work, by linking or combining
 * it with Eclipse (or a modified version of that program or an Eclipse
 * plugin), containing parts covered by the terms of the Eclipse Public
 * License (EPL), the licensors of this Program grant you additional
 * permission to convey the resulting work.  Corresponding Source for a
 * non-source form of such a combination shall include the source code for
 * the parts of JGraLab used as well as that of the covered work.
 */
package de.uni_koblenz.jgralab.utilities.rsa2tg;

public class XMIConstants {

	public static final String XMI_XMI = "xmi:XMI";

	public static final String UML_ATTRIBUTE_CLASSIFIER = "classifier";

	public static final String UML_ATTRIBUTE_CLIENT = "client";

	public static final String UML_ATTRIBUTE_SUPPLIER = "supplier";

	public static final String UML_ATTRIBUTE_ASSOCIATION = "association";

	public static final String UML_ATTRIBUTE_ISDERIVED = "isDerived";

	public static final String UML_UPPER_VALUE = "upperValue";

	public static final String UML_LOWER_VALUE = "lowerValue";

	public static final String UML_DETAILS = "details";

	public static final String UML_GENERALIZATION = "generalization";

	public static final String UML_E_ANNOTATIONS = "eAnnotations";

	public static final String XMI_EXTENSION = "xmi:Extension";

	public static final String UML_ENUMERATION_LITERAL = "uml:EnumerationLiteral";

	public static final String UML_OWNED_COMMENT = "ownedComment";

	public static final String UML_ANNOTATED_ELEMENT = "annotatedElement";

	public static final String UML_OWNED_LITERAL = "ownedLiteral";

	public static final String UML_OWNED_ATTRIBUTE = "ownedAttribute";

	public static final String UML_PROPERTY = "uml:Property";

	public static final String UML_OWNEDEND = "ownedEnd";

	public static final String UML_LANGUAGE = "language";

	public static final String UML_BODY = "body";

	public static final String UML_SPECIFICATION = "specification";

	public static final String UML_ATTRIBUTE_CONSTRAINED_ELEMENT = "constrainedElement";

	public static final String UML_OWNEDRULE = "ownedRule";

	public static final String UML_REALIZATION = "uml:Realization";

	public static final String UML_PRIMITIVE_TYPE = "uml:PrimitiveType";

	public static final String UML_ENUMERATION = "uml:Enumeration";

	public static final String UML_ASSOCIATION_CLASS = "uml:AssociationClass";

	public static final String UML_ASSOCIATION = "uml:Association";

	public static final String UML_CLASS = "uml:Class";

	public static final String UML_PACKAGED_ELEMENT = "packagedElement";

	public static final String UML_ATTRIBUTE_TYPE = "type";

	public static final String XMI_NAMESPACE_PREFIX = "xmi";

	public static final String UML_ATTRIBUTE_NAME = "name";

	public static final String UML_MODEL = "uml:Model";

	public static final String UML_PACKAGE = "uml:Package";

	public static final String UML_ATTRIBUTE_IS_ABSRACT = "isAbstract";

	public static final String UML_TRUE = "true";

	public static final String UML_MEMBER_END = "memberEnd";

	public static final String UML_ATTRIBUTE_VALUE = "value";

	public static final String UML_ATTRIBUTE_KEY = "key";

	public static final String UML_ATTRIBUTE_GENERAL = "general";

	public static final String UML_ATTRIBUTE_HREF = "href";

	public static final String UML_ATTRIBUTE_AGGREGATION = "aggregation";

	public static final String UML_SHARED = "shared";

	public static final String UML_COMPOSITE = "composite";

	public static final String UML_DEFAULT_VALUE = "defaultValue";

	public static final String UML_INSTANCE_VALUE = "uml:InstanceValue";

	public static final String XMI_TYPE = "type";

	public static final String UML_LITERAL_INTEGER = "uml:LiteralInteger";

	public static final String UML_LITERAL_BOOLEAN = "uml:LiteralBoolean";

	public static final String UML_LITERAL_STRING = "uml:LiteralString";

	public static final String UML_OPAQUE_EXPRESSION = "uml:OpaqueExpression";

	public static final int DEFAULT_MIN_MULTIPLICITY = 1;

	public static final int DEFAULT_MAX_MULTIPLICITY = 1;

}
