/*
 * This code was generated automatically.
 * Do NOT edit this file, changes will be lost.
 * Instead, change and commit the underlying schema.
 */

package de.uni_koblenz.jgralab.greql.schema;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;

import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;

import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;

import java.lang.ref.WeakReference;

/**
 * The schema GreqlSchema is implemented following the singleton pattern.
 * To get the instance, use the static method <code>instance()</code>.
 */
public class GreqlSchema extends SchemaImpl {

	/**
	 * reference to the singleton instance
	 */
	static WeakReference<GreqlSchema> theInstance = new WeakReference<GreqlSchema>(null);
	
	/**
	 * @return the singleton instance of GreqlSchema
	 */
	public static synchronized GreqlSchema instance() {
		GreqlSchema s = theInstance.get();
		if (s != null) {
			return s;
		}
		s = new GreqlSchema();
		theInstance = new WeakReference<GreqlSchema>(s);
		return s;
	}
	
	/**
	 * Creates a GreqlSchema and builds its schema classes.
	 * This constructor is private. Use the <code>instance()</code> method
	 * to access the schema.
	 */
	private GreqlSchema() {
		super("GreqlSchema", "de.uni_koblenz.jgralab.greql.schema");

		{
			EnumDomain dom = createEnumDomain("GReQLDirection");
			dom.addConst("IN");
			dom.addConst("OUT");
			dom.addConst("INOUT");
		}

		{
			EnumDomain dom = createEnumDomain("QuantificationType");
			dom.addConst("FORALL");
			dom.addConst("EXISTS");
			dom.addConst("EXISTSONE");
		}

		{
			EnumDomain dom = createEnumDomain("IterationType");
			dom.addConst("STAR");
			dom.addConst("PLUS");
		}

		{
			RecordDomain dom = createRecordDomain("SourcePosition");
			dom.addComponent("length", getDomain("Integer"));
			dom.addComponent("offset", getDomain("Integer"));
		}

		createSetDomain(getDomain("String"));

		createListDomain(getDomain("SourcePosition"));

		{
			GraphClass gc = createGraphClass("GreqlGraph");

			VertexClass vc_GreqlVertex = gc.createVertexClass("GreqlVertex");
			vc_GreqlVertex.setAbstract(true);

			VertexClass vc_Declaration = gc.createVertexClass("Declaration");
			vc_Declaration.setAbstract(false);
			vc_Declaration.addSuperClass(vc_GreqlVertex);

			VertexClass vc_Definition = gc.createVertexClass("Definition");
			vc_Definition.setAbstract(false);
			vc_Definition.addSuperClass(vc_GreqlVertex);

			VertexClass vc_Direction = gc.createVertexClass("Direction");
			vc_Direction.setAbstract(false);
			vc_Direction.addSuperClass(vc_GreqlVertex);
			vc_Direction.createAttribute("dirValue", getDomain("GReQLDirection"), null);

			VertexClass vc_EdgeRestriction = gc.createVertexClass("EdgeRestriction");
			vc_EdgeRestriction.setAbstract(false);
			vc_EdgeRestriction.addSuperClass(vc_GreqlVertex);

			VertexClass vc_GreqlExpression = gc.createVertexClass("GreqlExpression");
			vc_GreqlExpression.setAbstract(false);
			vc_GreqlExpression.addSuperClass(vc_GreqlVertex);
			vc_GreqlExpression.createAttribute("importedTypes", getDomain("Set<String>"), null);
			vc_GreqlExpression.createAttribute("optimizer", getDomain("String"), null);
			vc_GreqlExpression.createAttribute("queryText", getDomain("String"), null);

			VertexClass vc_Quantifier = gc.createVertexClass("Quantifier");
			vc_Quantifier.setAbstract(false);
			vc_Quantifier.addSuperClass(vc_GreqlVertex);
			vc_Quantifier.createAttribute("type", getDomain("QuantificationType"), null);

			VertexClass vc_RecordElement = gc.createVertexClass("RecordElement");
			vc_RecordElement.setAbstract(false);
			vc_RecordElement.addSuperClass(vc_GreqlVertex);

			VertexClass vc_SimpleDeclaration = gc.createVertexClass("SimpleDeclaration");
			vc_SimpleDeclaration.setAbstract(false);
			vc_SimpleDeclaration.addSuperClass(vc_GreqlVertex);

			VertexClass vc_SubgraphDefinition = gc.createVertexClass("SubgraphDefinition");
			vc_SubgraphDefinition.setAbstract(true);
			vc_SubgraphDefinition.addSuperClass(vc_GreqlVertex);

			VertexClass vc_Expression = gc.createVertexClass("Expression");
			vc_Expression.setAbstract(true);
			vc_Expression.addSuperClass(vc_GreqlVertex);

			VertexClass vc_EdgeTypeSubgraph = gc.createVertexClass("EdgeTypeSubgraph");
			vc_EdgeTypeSubgraph.setAbstract(false);
			vc_EdgeTypeSubgraph.addSuperClass(vc_SubgraphDefinition);

			VertexClass vc_VertexTypeSubgraph = gc.createVertexClass("VertexTypeSubgraph");
			vc_VertexTypeSubgraph.setAbstract(false);
			vc_VertexTypeSubgraph.addSuperClass(vc_SubgraphDefinition);

			VertexClass vc_ExpressionDefinedSubgraph = gc.createVertexClass("ExpressionDefinedSubgraph");
			vc_ExpressionDefinedSubgraph.setAbstract(false);
			vc_ExpressionDefinedSubgraph.addSuperClass(vc_SubgraphDefinition);

			VertexClass vc_PathDescription = gc.createVertexClass("PathDescription");
			vc_PathDescription.setAbstract(true);
			vc_PathDescription.addSuperClass(vc_Expression);

			VertexClass vc_PathExpression = gc.createVertexClass("PathExpression");
			vc_PathExpression.setAbstract(true);
			vc_PathExpression.addSuperClass(vc_Expression);

			VertexClass vc_SubgraphExpression = gc.createVertexClass("SubgraphExpression");
			vc_SubgraphExpression.setAbstract(true);
			vc_SubgraphExpression.addSuperClass(vc_Expression);

			VertexClass vc_ValueConstruction = gc.createVertexClass("ValueConstruction");
			vc_ValueConstruction.setAbstract(true);
			vc_ValueConstruction.addSuperClass(vc_Expression);

			VertexClass vc_ConditionalExpression = gc.createVertexClass("ConditionalExpression");
			vc_ConditionalExpression.setAbstract(false);
			vc_ConditionalExpression.addSuperClass(vc_Expression);

			VertexClass vc_FunctionApplication = gc.createVertexClass("FunctionApplication");
			vc_FunctionApplication.setAbstract(false);
			vc_FunctionApplication.addSuperClass(vc_Expression);

			VertexClass vc_Identifier = gc.createVertexClass("Identifier");
			vc_Identifier.setAbstract(false);
			vc_Identifier.addSuperClass(vc_Expression);
			vc_Identifier.createAttribute("name", getDomain("String"), null);

			VertexClass vc_Literal = gc.createVertexClass("Literal");
			vc_Literal.setAbstract(false);
			vc_Literal.addSuperClass(vc_Expression);

			VertexClass vc_QuantifiedExpression = gc.createVertexClass("QuantifiedExpression");
			vc_QuantifiedExpression.setAbstract(false);
			vc_QuantifiedExpression.addSuperClass(vc_Expression);

			VertexClass vc_SubgraphRestrictedExpression = gc.createVertexClass("SubgraphRestrictedExpression");
			vc_SubgraphRestrictedExpression.setAbstract(false);
			vc_SubgraphRestrictedExpression.addSuperClass(vc_Expression);

			VertexClass vc_Comprehension = gc.createVertexClass("Comprehension");
			vc_Comprehension.setAbstract(true);
			vc_Comprehension.addSuperClass(vc_Expression);

			VertexClass vc_DefinitionExpression = gc.createVertexClass("DefinitionExpression");
			vc_DefinitionExpression.setAbstract(true);
			vc_DefinitionExpression.addSuperClass(vc_Expression);

			VertexClass vc_ElementSetExpression = gc.createVertexClass("ElementSetExpression");
			vc_ElementSetExpression.setAbstract(true);
			vc_ElementSetExpression.addSuperClass(vc_Expression);

			VertexClass vc_PrimaryPathDescription = gc.createVertexClass("PrimaryPathDescription");
			vc_PrimaryPathDescription.setAbstract(true);
			vc_PrimaryPathDescription.addSuperClass(vc_PathDescription);

			VertexClass vc_AlternativePathDescription = gc.createVertexClass("AlternativePathDescription");
			vc_AlternativePathDescription.setAbstract(false);
			vc_AlternativePathDescription.addSuperClass(vc_PathDescription);

			VertexClass vc_ExponentiatedPathDescription = gc.createVertexClass("ExponentiatedPathDescription");
			vc_ExponentiatedPathDescription.setAbstract(false);
			vc_ExponentiatedPathDescription.addSuperClass(vc_PathDescription);

			VertexClass vc_IntermediateVertexPathDescription = gc.createVertexClass("IntermediateVertexPathDescription");
			vc_IntermediateVertexPathDescription.setAbstract(false);
			vc_IntermediateVertexPathDescription.addSuperClass(vc_PathDescription);

			VertexClass vc_IteratedPathDescription = gc.createVertexClass("IteratedPathDescription");
			vc_IteratedPathDescription.setAbstract(false);
			vc_IteratedPathDescription.addSuperClass(vc_PathDescription);
			vc_IteratedPathDescription.createAttribute("times", getDomain("IterationType"), null);

			VertexClass vc_OptionalPathDescription = gc.createVertexClass("OptionalPathDescription");
			vc_OptionalPathDescription.setAbstract(false);
			vc_OptionalPathDescription.addSuperClass(vc_PathDescription);

			VertexClass vc_SequentialPathDescription = gc.createVertexClass("SequentialPathDescription");
			vc_SequentialPathDescription.setAbstract(false);
			vc_SequentialPathDescription.addSuperClass(vc_PathDescription);

			VertexClass vc_TransposedPathDescription = gc.createVertexClass("TransposedPathDescription");
			vc_TransposedPathDescription.setAbstract(false);
			vc_TransposedPathDescription.addSuperClass(vc_PathDescription);

			VertexClass vc_BackwardVertexSet = gc.createVertexClass("BackwardVertexSet");
			vc_BackwardVertexSet.setAbstract(false);
			vc_BackwardVertexSet.addSuperClass(vc_PathExpression);

			VertexClass vc_ForwardVertexSet = gc.createVertexClass("ForwardVertexSet");
			vc_ForwardVertexSet.setAbstract(false);
			vc_ForwardVertexSet.addSuperClass(vc_PathExpression);

			VertexClass vc_PathExistence = gc.createVertexClass("PathExistence");
			vc_PathExistence.setAbstract(false);
			vc_PathExistence.addSuperClass(vc_PathExpression);

			VertexClass vc_ListConstruction = gc.createVertexClass("ListConstruction");
			vc_ListConstruction.setAbstract(false);
			vc_ListConstruction.addSuperClass(vc_ValueConstruction);

			VertexClass vc_MapConstruction = gc.createVertexClass("MapConstruction");
			vc_MapConstruction.setAbstract(false);
			vc_MapConstruction.addSuperClass(vc_ValueConstruction);

			VertexClass vc_RecordConstruction = gc.createVertexClass("RecordConstruction");
			vc_RecordConstruction.setAbstract(false);
			vc_RecordConstruction.addSuperClass(vc_ValueConstruction);

			VertexClass vc_SetConstruction = gc.createVertexClass("SetConstruction");
			vc_SetConstruction.setAbstract(false);
			vc_SetConstruction.addSuperClass(vc_ValueConstruction);

			VertexClass vc_TupleConstruction = gc.createVertexClass("TupleConstruction");
			vc_TupleConstruction.setAbstract(false);
			vc_TupleConstruction.addSuperClass(vc_ValueConstruction);

			VertexClass vc_RecordId = gc.createVertexClass("RecordId");
			vc_RecordId.setAbstract(false);
			vc_RecordId.addSuperClass(vc_Identifier);

			VertexClass vc_TypeOrRoleId = gc.createVertexClass("TypeOrRoleId");
			vc_TypeOrRoleId.setAbstract(true);
			vc_TypeOrRoleId.addSuperClass(vc_Identifier);

			VertexClass vc_Variable = gc.createVertexClass("Variable");
			vc_Variable.setAbstract(false);
			vc_Variable.addSuperClass(vc_Identifier);

			VertexClass vc_FunctionId = gc.createVertexClass("FunctionId");
			vc_FunctionId.setAbstract(false);
			vc_FunctionId.addSuperClass(vc_Identifier);

			VertexClass vc_UndefinedLiteral = gc.createVertexClass("UndefinedLiteral");
			vc_UndefinedLiteral.setAbstract(false);
			vc_UndefinedLiteral.addSuperClass(vc_Literal);

			VertexClass vc_DoubleLiteral = gc.createVertexClass("DoubleLiteral");
			vc_DoubleLiteral.setAbstract(false);
			vc_DoubleLiteral.addSuperClass(vc_Literal);
			vc_DoubleLiteral.createAttribute("doubleValue", getDomain("Double"), null);

			VertexClass vc_StringLiteral = gc.createVertexClass("StringLiteral");
			vc_StringLiteral.setAbstract(false);
			vc_StringLiteral.addSuperClass(vc_Literal);
			vc_StringLiteral.createAttribute("stringValue", getDomain("String"), null);

			VertexClass vc_BoolLiteral = gc.createVertexClass("BoolLiteral");
			vc_BoolLiteral.setAbstract(false);
			vc_BoolLiteral.addSuperClass(vc_Literal);
			vc_BoolLiteral.createAttribute("boolValue", getDomain("Boolean"), null);

			VertexClass vc_IntLiteral = gc.createVertexClass("IntLiteral");
			vc_IntLiteral.setAbstract(false);
			vc_IntLiteral.addSuperClass(vc_Literal);
			vc_IntLiteral.createAttribute("intValue", getDomain("Integer"), null);

			VertexClass vc_LongLiteral = gc.createVertexClass("LongLiteral");
			vc_LongLiteral.setAbstract(false);
			vc_LongLiteral.addSuperClass(vc_Literal);
			vc_LongLiteral.createAttribute("longValue", getDomain("Long"), null);

			VertexClass vc_ComprehensionWithTableHeader = gc.createVertexClass("ComprehensionWithTableHeader");
			vc_ComprehensionWithTableHeader.setAbstract(true);
			vc_ComprehensionWithTableHeader.addSuperClass(vc_Comprehension);

			VertexClass vc_MapComprehension = gc.createVertexClass("MapComprehension");
			vc_MapComprehension.setAbstract(false);
			vc_MapComprehension.addSuperClass(vc_Comprehension);

			VertexClass vc_SetComprehension = gc.createVertexClass("SetComprehension");
			vc_SetComprehension.setAbstract(false);
			vc_SetComprehension.addSuperClass(vc_Comprehension);

			VertexClass vc_LetExpression = gc.createVertexClass("LetExpression");
			vc_LetExpression.setAbstract(false);
			vc_LetExpression.addSuperClass(vc_DefinitionExpression);

			VertexClass vc_WhereExpression = gc.createVertexClass("WhereExpression");
			vc_WhereExpression.setAbstract(false);
			vc_WhereExpression.addSuperClass(vc_DefinitionExpression);

			VertexClass vc_EdgeSetExpression = gc.createVertexClass("EdgeSetExpression");
			vc_EdgeSetExpression.setAbstract(false);
			vc_EdgeSetExpression.addSuperClass(vc_ElementSetExpression);

			VertexClass vc_VertexSetExpression = gc.createVertexClass("VertexSetExpression");
			vc_VertexSetExpression.setAbstract(false);
			vc_VertexSetExpression.addSuperClass(vc_ElementSetExpression);

			VertexClass vc_EdgePathDescription = gc.createVertexClass("EdgePathDescription");
			vc_EdgePathDescription.setAbstract(false);
			vc_EdgePathDescription.addSuperClass(vc_PrimaryPathDescription);

			VertexClass vc_SimplePathDescription = gc.createVertexClass("SimplePathDescription");
			vc_SimplePathDescription.setAbstract(false);
			vc_SimplePathDescription.addSuperClass(vc_PrimaryPathDescription);

			VertexClass vc_AggregationPathDescription = gc.createVertexClass("AggregationPathDescription");
			vc_AggregationPathDescription.setAbstract(false);
			vc_AggregationPathDescription.addSuperClass(vc_PrimaryPathDescription);
			vc_AggregationPathDescription.createAttribute("outAggregation", getDomain("Boolean"), null);

			VertexClass vc_ListRangeConstruction = gc.createVertexClass("ListRangeConstruction");
			vc_ListRangeConstruction.setAbstract(false);
			vc_ListRangeConstruction.addSuperClass(vc_ListConstruction);

			VertexClass vc_RoleId = gc.createVertexClass("RoleId");
			vc_RoleId.setAbstract(false);
			vc_RoleId.addSuperClass(vc_TypeOrRoleId);

			VertexClass vc_TypeId = gc.createVertexClass("TypeId");
			vc_TypeId.setAbstract(false);
			vc_TypeId.addSuperClass(vc_TypeOrRoleId);
			vc_TypeId.createAttribute("excluded", getDomain("Boolean"), null);
			vc_TypeId.createAttribute("type", getDomain("Boolean"), null);

			VertexClass vc_ThisLiteral = gc.createVertexClass("ThisLiteral");
			vc_ThisLiteral.setAbstract(true);
			vc_ThisLiteral.addSuperClass(vc_Literal);
			vc_ThisLiteral.addSuperClass(vc_Variable);

			VertexClass vc_ListComprehension = gc.createVertexClass("ListComprehension");
			vc_ListComprehension.setAbstract(false);
			vc_ListComprehension.addSuperClass(vc_ComprehensionWithTableHeader);

			VertexClass vc_ThisVertex = gc.createVertexClass("ThisVertex");
			vc_ThisVertex.setAbstract(false);
			vc_ThisVertex.addSuperClass(vc_ThisLiteral);

			VertexClass vc_ThisEdge = gc.createVertexClass("ThisEdge");
			vc_ThisEdge.setAbstract(false);
			vc_ThisEdge.addSuperClass(vc_ThisLiteral);

			EdgeClass ec_GreqlAggregation = gc.createEdgeClass("GreqlAggregation",
				vc_GreqlVertex, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_GreqlVertex, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_GreqlAggregation.setAbstract(true);
			ec_GreqlAggregation.createAttribute("sourcePositions", getDomain("List<SourcePosition>"), null);

			EdgeClass ec_IsBoundExprOf = gc.createEdgeClass("IsBoundExprOf",
				vc_Expression, 1, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_GreqlVertex, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsBoundExprOf.setAbstract(true);
			ec_IsBoundExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsTypeExprOf = gc.createEdgeClass("IsTypeExprOf",
				vc_Expression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_GreqlVertex, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTypeExprOf.setAbstract(true);
			ec_IsTypeExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsPathDescriptionOf = gc.createEdgeClass("IsPathDescriptionOf",
				vc_PathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsPathDescriptionOf.setAbstract(true);
			ec_IsPathDescriptionOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsArgumentOf = gc.createEdgeClass("IsArgumentOf",
				vc_Expression, 0, 2147483647, "argument", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_FunctionApplication, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsArgumentOf.setAbstract(false);
			ec_IsArgumentOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsBoundVarOf = gc.createEdgeClass("IsBoundVarOf",
				vc_Variable, 0, 2147483647, "boundVar", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_GreqlExpression, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsBoundVarOf.setAbstract(false);
			ec_IsBoundVarOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsCompDeclOf = gc.createEdgeClass("IsCompDeclOf",
				vc_Declaration, 1, 1, "compDecl", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Comprehension, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsCompDeclOf.setAbstract(false);
			ec_IsCompDeclOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsCompResultDefOf = gc.createEdgeClass("IsCompResultDefOf",
				vc_Expression, 0, 1, "compResultDef", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Comprehension, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsCompResultDefOf.setAbstract(false);
			ec_IsCompResultDefOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsConditionOf = gc.createEdgeClass("IsConditionOf",
				vc_Expression, 1, 1, "condition", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ConditionalExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsConditionOf.setAbstract(false);
			ec_IsConditionOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsConstraintOf = gc.createEdgeClass("IsConstraintOf",
				vc_Expression, 0, 2147483647, "constraint", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Declaration, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsConstraintOf.setAbstract(false);
			ec_IsConstraintOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsDeclaredVarOf = gc.createEdgeClass("IsDeclaredVarOf",
				vc_Variable, 1, 2147483647, "declaredVar", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_SimpleDeclaration, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsDeclaredVarOf.setAbstract(false);
			ec_IsDeclaredVarOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsDefinitionOf = gc.createEdgeClass("IsDefinitionOf",
				vc_Definition, 1, 2147483647, "definition", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_DefinitionExpression, 1, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsDefinitionOf.setAbstract(false);
			ec_IsDefinitionOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsDirectionOf = gc.createEdgeClass("IsDirectionOf",
				vc_Direction, 1, 1, "direction", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PrimaryPathDescription, 1, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsDirectionOf.setAbstract(false);
			ec_IsDirectionOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsEdgeExprOf = gc.createEdgeClass("IsEdgeExprOf",
				vc_Expression, 1, 1, "edgeExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_EdgePathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsEdgeExprOf.setAbstract(false);
			ec_IsEdgeExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsEdgeRestrOf = gc.createEdgeClass("IsEdgeRestrOf",
				vc_EdgeRestriction, 0, 2147483647, "edgeRestr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PrimaryPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsEdgeRestrOf.setAbstract(false);
			ec_IsEdgeRestrOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsExponentOf = gc.createEdgeClass("IsExponentOf",
				vc_IntLiteral, 1, 1, "exponent", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ExponentiatedPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsExponentOf.setAbstract(false);
			ec_IsExponentOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsExprOf = gc.createEdgeClass("IsExprOf",
				vc_Expression, 1, 1, "expr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Definition, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsExprOf.setAbstract(false);
			ec_IsExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsFalseExprOf = gc.createEdgeClass("IsFalseExprOf",
				vc_Expression, 1, 1, "falseExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ConditionalExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsFalseExprOf.setAbstract(false);
			ec_IsFalseExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsFirstValueOf = gc.createEdgeClass("IsFirstValueOf",
				vc_Expression, 1, 1, "firstValue", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ListRangeConstruction, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsFirstValueOf.setAbstract(false);
			ec_IsFirstValueOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsFunctionIdOf = gc.createEdgeClass("IsFunctionIdOf",
				vc_FunctionId, 1, 1, "functionId", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_FunctionApplication, 1, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsFunctionIdOf.setAbstract(false);
			ec_IsFunctionIdOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsGoalRestrOf = gc.createEdgeClass("IsGoalRestrOf",
				vc_Expression, 0, 2147483647, "goalRestr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsGoalRestrOf.setAbstract(false);
			ec_IsGoalRestrOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsIdOfStoreClause = gc.createEdgeClass("IsIdOfStoreClause",
				vc_Identifier, 0, 1, "identifier", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_GreqlExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsIdOfStoreClause.setAbstract(false);
			ec_IsIdOfStoreClause.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsIntermediateVertexOf = gc.createEdgeClass("IsIntermediateVertexOf",
				vc_Expression, 1, 1, "intermediateVertex", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_IntermediateVertexPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsIntermediateVertexOf.setAbstract(false);
			ec_IsIntermediateVertexOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsLastValueOf = gc.createEdgeClass("IsLastValueOf",
				vc_Expression, 1, 1, "lastValue", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ListRangeConstruction, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsLastValueOf.setAbstract(false);
			ec_IsLastValueOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsMaxCountExpressionOf = gc.createEdgeClass("IsMaxCountExpressionOf",
				vc_Expression, 0, 1, "maxCount", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Comprehension, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsMaxCountExpressionOf.setAbstract(false);
			ec_IsMaxCountExpressionOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsPartOf = gc.createEdgeClass("IsPartOf",
				vc_Expression, 0, 2147483647, "part", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ValueConstruction, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsPartOf.setAbstract(false);
			ec_IsPartOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsPathOf = gc.createEdgeClass("IsPathOf",
				vc_Expression, 1, 1, "path", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PathExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsPathOf.setAbstract(false);
			ec_IsPathOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsQuantifiedDeclOf = gc.createEdgeClass("IsQuantifiedDeclOf",
				vc_Declaration, 1, 1, "quantifiedDecl", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_QuantifiedExpression, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsQuantifiedDeclOf.setAbstract(false);
			ec_IsQuantifiedDeclOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsQuantifierOf = gc.createEdgeClass("IsQuantifierOf",
				vc_Quantifier, 1, 1, "quantifier", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_QuantifiedExpression, 1, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsQuantifierOf.setAbstract(false);
			ec_IsQuantifierOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsQueryExprOf = gc.createEdgeClass("IsQueryExprOf",
				vc_Expression, 1, 1, "queryExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_GreqlExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsQueryExprOf.setAbstract(false);
			ec_IsQueryExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsRecordElementOf = gc.createEdgeClass("IsRecordElementOf",
				vc_RecordElement, 1, 2147483647, "recordElement", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_RecordConstruction, 1, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsRecordElementOf.setAbstract(false);
			ec_IsRecordElementOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsRecordExprOf = gc.createEdgeClass("IsRecordExprOf",
				vc_Expression, 1, 1, "recordExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_RecordElement, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsRecordExprOf.setAbstract(false);
			ec_IsRecordExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsRecordIdOf = gc.createEdgeClass("IsRecordIdOf",
				vc_RecordId, 1, 1, "recordId", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_RecordElement, 1, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsRecordIdOf.setAbstract(false);
			ec_IsRecordIdOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsRoleIdOf = gc.createEdgeClass("IsRoleIdOf",
				vc_RoleId, 0, 2147483647, "roleId", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_EdgeRestriction, 1, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsRoleIdOf.setAbstract(false);
			ec_IsRoleIdOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsBooleanPredicateOfEdgeRestriction = gc.createEdgeClass("IsBooleanPredicateOfEdgeRestriction",
				vc_Expression, 0, 1, "booleanPredicate", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_EdgeRestriction, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsBooleanPredicateOfEdgeRestriction.setAbstract(false);
			ec_IsBooleanPredicateOfEdgeRestriction.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsSimpleDeclOf = gc.createEdgeClass("IsSimpleDeclOf",
				vc_SimpleDeclaration, 1, 2147483647, "simpleDecl", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Declaration, 1, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsSimpleDeclOf.setAbstract(false);
			ec_IsSimpleDeclOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsStartExprOf = gc.createEdgeClass("IsStartExprOf",
				vc_Expression, 0, 1, "startExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PathExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsStartExprOf.setAbstract(false);
			ec_IsStartExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsStartRestrOf = gc.createEdgeClass("IsStartRestrOf",
				vc_Expression, 0, 2147483647, "startRestr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsStartRestrOf.setAbstract(false);
			ec_IsStartRestrOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsSubgraphDefinitionOf = gc.createEdgeClass("IsSubgraphDefinitionOf",
				vc_SubgraphDefinition, 0, 1, "subgraphDefinition", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_SubgraphRestrictedExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsSubgraphDefinitionOf.setAbstract(false);
			ec_IsSubgraphDefinitionOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsSubgraphDefiningExpression = gc.createEdgeClass("IsSubgraphDefiningExpression",
				vc_Expression, 0, 1, "definingExpression", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ExpressionDefinedSubgraph, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsSubgraphDefiningExpression.setAbstract(false);
			ec_IsSubgraphDefiningExpression.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsExpressionOnSubgraph = gc.createEdgeClass("IsExpressionOnSubgraph",
				vc_Expression, 0, 1, "restrictedExpression", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_SubgraphRestrictedExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsExpressionOnSubgraph.setAbstract(false);
			ec_IsExpressionOnSubgraph.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsTableHeaderOf = gc.createEdgeClass("IsTableHeaderOf",
				vc_Expression, 0, 2147483647, "tableHeader", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ComprehensionWithTableHeader, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTableHeaderOf.setAbstract(false);
			ec_IsTableHeaderOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsTargetExprOf = gc.createEdgeClass("IsTargetExprOf",
				vc_Expression, 0, 1, "targetExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_PathExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTargetExprOf.setAbstract(false);
			ec_IsTargetExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsKeyExprOfConstruction = gc.createEdgeClass("IsKeyExprOfConstruction",
				vc_Expression, 0, 2147483647, "keyExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_MapConstruction, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsKeyExprOfConstruction.setAbstract(false);
			ec_IsKeyExprOfConstruction.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsValueExprOfConstruction = gc.createEdgeClass("IsValueExprOfConstruction",
				vc_Expression, 0, 2147483647, "valueExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_MapConstruction, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsValueExprOfConstruction.setAbstract(false);
			ec_IsValueExprOfConstruction.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsKeyExprOfComprehension = gc.createEdgeClass("IsKeyExprOfComprehension",
				vc_Expression, 1, 1, "keyExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_MapComprehension, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsKeyExprOfComprehension.setAbstract(false);
			ec_IsKeyExprOfComprehension.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsValueExprOfComprehension = gc.createEdgeClass("IsValueExprOfComprehension",
				vc_Expression, 1, 1, "valueExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_MapComprehension, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsValueExprOfComprehension.setAbstract(false);
			ec_IsValueExprOfComprehension.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsTrueExprOf = gc.createEdgeClass("IsTrueExprOf",
				vc_Expression, 1, 1, "trueExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ConditionalExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTrueExprOf.setAbstract(false);
			ec_IsTrueExprOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsTypeIdOf = gc.createEdgeClass("IsTypeIdOf",
				vc_TypeId, 0, 2147483647, "typeId", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_EdgeRestriction, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTypeIdOf.setAbstract(false);
			ec_IsTypeIdOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsTypeRestrOfExpression = gc.createEdgeClass("IsTypeRestrOfExpression",
				vc_TypeId, 0, 2147483647, "typeRestr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Expression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTypeRestrOfExpression.setAbstract(false);
			ec_IsTypeRestrOfExpression.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsTypeRestrOfSubgraph = gc.createEdgeClass("IsTypeRestrOfSubgraph",
				vc_TypeId, 0, 2147483647, "typeRestr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_SubgraphDefinition, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTypeRestrOfSubgraph.setAbstract(false);
			ec_IsTypeRestrOfSubgraph.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsVarOf = gc.createEdgeClass("IsVarOf",
				vc_Variable, 1, 1, "var", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_Definition, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsVarOf.setAbstract(false);
			ec_IsVarOf.addSuperClass(ec_GreqlAggregation);

			EdgeClass ec_IsBoundExprOfDefinition = gc.createEdgeClass("IsBoundExprOfDefinition",
				vc_Expression, 1, 1, "boundExprOfDefinition", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_DefinitionExpression, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsBoundExprOfDefinition.setAbstract(false);
			ec_IsBoundExprOfDefinition.addSuperClass(ec_IsBoundExprOf);

			EdgeClass ec_IsBoundExprOfQuantifiedExpression = gc.createEdgeClass("IsBoundExprOfQuantifiedExpression",
				vc_Expression, 1, 1, "boundExprOfQuantifier", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_QuantifiedExpression, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsBoundExprOfQuantifiedExpression.setAbstract(false);
			ec_IsBoundExprOfQuantifiedExpression.addSuperClass(ec_IsBoundExprOf);

			EdgeClass ec_IsTypeExprOfDeclaration = gc.createEdgeClass("IsTypeExprOfDeclaration",
				vc_Expression, 0, 1, "typeExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_SimpleDeclaration, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTypeExprOfDeclaration.setAbstract(false);
			ec_IsTypeExprOfDeclaration.addSuperClass(ec_IsTypeExprOf);

			EdgeClass ec_IsTypeExprOfFunction = gc.createEdgeClass("IsTypeExprOfFunction",
				vc_Expression, 0, 1, "typeExpr", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_FunctionApplication, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTypeExprOfFunction.setAbstract(false);
			ec_IsTypeExprOfFunction.addSuperClass(ec_IsTypeExprOf);

			EdgeClass ec_IsAlternativePathOf = gc.createEdgeClass("IsAlternativePathOf",
				vc_PathDescription, 2, 2147483647, "alternatePath", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_AlternativePathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsAlternativePathOf.setAbstract(false);
			ec_IsAlternativePathOf.addSuperClass(ec_IsPathDescriptionOf);

			EdgeClass ec_IsExponentiatedPathOf = gc.createEdgeClass("IsExponentiatedPathOf",
				vc_PathDescription, 1, 1, "exponentiatedPath", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_ExponentiatedPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsExponentiatedPathOf.setAbstract(false);
			ec_IsExponentiatedPathOf.addSuperClass(ec_IsPathDescriptionOf);

			EdgeClass ec_IsIteratedPathOf = gc.createEdgeClass("IsIteratedPathOf",
				vc_PathDescription, 1, 1, "iteratedPath", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_IteratedPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsIteratedPathOf.setAbstract(false);
			ec_IsIteratedPathOf.addSuperClass(ec_IsPathDescriptionOf);

			EdgeClass ec_IsOptionalPathOf = gc.createEdgeClass("IsOptionalPathOf",
				vc_PathDescription, 1, 1, "optionalPath", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_OptionalPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsOptionalPathOf.setAbstract(false);
			ec_IsOptionalPathOf.addSuperClass(ec_IsPathDescriptionOf);

			EdgeClass ec_IsSequenceElementOf = gc.createEdgeClass("IsSequenceElementOf",
				vc_PathDescription, 2, 2147483647, "sequenceElement", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_SequentialPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsSequenceElementOf.setAbstract(false);
			ec_IsSequenceElementOf.addSuperClass(ec_IsPathDescriptionOf);

			EdgeClass ec_IsSubPathOf = gc.createEdgeClass("IsSubPathOf",
				vc_PathDescription, 2, 2, "subPath", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_IntermediateVertexPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsSubPathOf.setAbstract(false);
			ec_IsSubPathOf.addSuperClass(ec_IsPathDescriptionOf);

			EdgeClass ec_IsTransposedPathOf = gc.createEdgeClass("IsTransposedPathOf",
				vc_PathDescription, 1, 1, "transposedPath", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED,
				vc_TransposedPathDescription, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_IsTransposedPathOf.setAbstract(false);
			ec_IsTransposedPathOf.addSuperClass(ec_IsPathDescriptionOf);
		}

		finish();
	}

	@Override
	public de.uni_koblenz.jgralab.GraphFactory createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType implementationType) {
		switch(implementationType) {
			case GENERIC:
				return new de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl(this);
			case STANDARD:
				return new de.uni_koblenz.jgralab.greql.schema.impl.std.GreqlGraphFactoryImpl();
		}
		throw new UnsupportedOperationException("No " + implementationType + " support compiled.");
	}

	/**
	 * Creates a new GreqlGraph graph.
	*/
	public GreqlGraph createGreqlGraph(de.uni_koblenz.jgralab.ImplementationType implType) {
		return createGreqlGraph(implType, null, 100, 100);
	}

	/**
	 * Creates a new GreqlGraph graph with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	*/
	public GreqlGraph createGreqlGraph(de.uni_koblenz.jgralab.ImplementationType implType, String id, int vMax, int eMax) {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	/**
	 * Creates a new GreqlGraph graph.
	*/
	public GreqlGraph createGreqlGraph(de.uni_koblenz.jgralab.GraphFactory factory) {
		return factory.createGraph(getGraphClass(), null, 100, 100);
	}

	/**
	 * Creates a new GreqlGraph graph.
	*/
	public GreqlGraph createGreqlGraph(de.uni_koblenz.jgralab.GraphFactory factory, String id, int vMax, int eMax) {
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	public GreqlGraph loadGreqlGraph(String filename) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadGreqlGraph(filename, factory, null);
	}

	public GreqlGraph loadGreqlGraph(String filename, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadGreqlGraph(filename, factory, pf);
	}

	public GreqlGraph loadGreqlGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadGreqlGraph(filename, factory, null);
	}

	
	public GreqlGraph loadGreqlGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadGreqlGraph(filename, factory, pf);
	}

	public GreqlGraph loadGreqlGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, null);
	}

	public GreqlGraph loadGreqlGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, pf);
	}
	
	@Override
	public boolean reopen() {
		throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
	}
}
