/*
 * This code was generated automatically.
 * Do NOT edit this file, changes will be lost.
 * Instead, change and commit the underlying schema.
 */

package de.uni_koblenz.jgralab.grumlschema;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;

import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;

import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

import java.lang.ref.WeakReference;

/**
 * The schema GrumlSchema is implemented following the singleton pattern.
 * To get the instance, use the static method <code>instance()</code>.
 */
public class GrumlSchema extends SchemaImpl {

	/**
	 * reference to the singleton instance
	 */
	static WeakReference<GrumlSchema> theInstance = new WeakReference<>(null);
	
	/**
	 * @return the singleton instance of GrumlSchema
	 */
	public static synchronized GrumlSchema instance() {
		GrumlSchema s = theInstance.get();
		if (s != null) {
			return s;
		}
		s = new GrumlSchema();
		theInstance = new WeakReference<>(s);
		return s;
	}
	
	/**
	 * Creates a GrumlSchema and builds its schema classes.
	 * This constructor is private. Use the <code>instance()</code> method
	 * to access the schema.
	 */
	private GrumlSchema() {
		super("GrumlSchema", "de.uni_koblenz.jgralab.grumlschema");

		{
			EnumDomain dom = createEnumDomain("structure.AggregationKind");
			dom.addConst("NONE");
			dom.addConst("SHARED");
			dom.addConst("COMPOSITE");
		}

		createListDomain(getDomain("String"));

		{
			GraphClass gc = createGraphClass("SchemaGraph");

			VertexClass vc_NamedElement = gc.createVertexClass("structure.NamedElement");
			vc_NamedElement.setAbstract(true);
			vc_NamedElement.createAttribute("qualifiedName", getDomain("String"), null);

			VertexClass vc_Comment = gc.createVertexClass("structure.Comment");
			vc_Comment.setAbstract(false);
			vc_Comment.createAttribute("text", getDomain("String"), null);

			VertexClass vc_IncidenceClass = gc.createVertexClass("structure.IncidenceClass");
			vc_IncidenceClass.setAbstract(false);
			vc_IncidenceClass.createAttribute("aggregation", getDomain("structure.AggregationKind"), null);
			vc_IncidenceClass.createAttribute("max", getDomain("Integer"), null);
			vc_IncidenceClass.createAttribute("min", getDomain("Integer"), null);
			vc_IncidenceClass.createAttribute("roleName", getDomain("String"), null);
			vc_IncidenceClass.addConstraint(new ConstraintImpl("Each IncidenceClass must either have a ComesFrom or a GoesTo Edge.", "import structure.*; forall ic : V{IncidenceClass} @ count(ic --<>{ComesFrom, GoesTo}) = 1", "import structure.*; from ic : V{IncidenceClass} with count(ic --<>{ComesFrom, GoesTo}) <> 1 reportSet ic end"));
			vc_IncidenceClass.addComment("The implementation in jgralab.schema.impl gets an \"edgeclass\" attribute to ensure two-way navigability of ComesFrom/GoesTo associations.");

			VertexClass vc_Schema = gc.createVertexClass("structure.Schema");
			vc_Schema.setAbstract(false);
			vc_Schema.createAttribute("name", getDomain("String"), null);
			vc_Schema.createAttribute("packagePrefix", getDomain("String"), null);

			VertexClass vc_Constraint = gc.createVertexClass("structure.Constraint");
			vc_Constraint.setAbstract(false);
			vc_Constraint.createAttribute("message", getDomain("String"), null);
			vc_Constraint.createAttribute("offendingElementsQuery", getDomain("String"), null);
			vc_Constraint.createAttribute("predicateQuery", getDomain("String"), null);

			VertexClass vc_Attribute = gc.createVertexClass("structure.Attribute");
			vc_Attribute.setAbstract(false);
			vc_Attribute.createAttribute("defaultValue", getDomain("String"), null);
			vc_Attribute.createAttribute("name", getDomain("String"), null);
			vc_Attribute.addComment("The defaultValue is a string constant in TG syntax, compatible to the Domain of the Attribute.\ndefaultValue may be null (which means no default value is specified).");

			VertexClass vc_Package = gc.createVertexClass("structure.Package");
			vc_Package.setAbstract(false);
			vc_Package.addSuperClass(vc_NamedElement);
			vc_Package.addConstraint(new ConstraintImpl("A Package must either be default or subpackage, but not both", "import structure.*; forall p: V{Package} @ (inDegree{ContainsDefaultPackage}(p) + inDegree{ContainsSubPackage}(p)) = 1", "import structure.*; from p: V{Package} with (inDegree{ContainsDefaultPackage}(p) + inDegree{ContainsSubPackage}(p)) <> 1 reportSet p end"));

			VertexClass vc_AttributedElementClass = gc.createVertexClass("structure.AttributedElementClass");
			vc_AttributedElementClass.setAbstract(true);
			vc_AttributedElementClass.addSuperClass(vc_NamedElement);

			VertexClass vc_Domain = gc.createVertexClass("domains.Domain");
			vc_Domain.setAbstract(true);
			vc_Domain.addSuperClass(vc_NamedElement);

			VertexClass vc_GraphClass = gc.createVertexClass("structure.GraphClass");
			vc_GraphClass.setAbstract(false);
			vc_GraphClass.addSuperClass(vc_AttributedElementClass);
			vc_GraphClass.addConstraint(new ConstraintImpl("There must be exactly one GraphClass.", "count(V{structure.GraphClass}) = 1", "V{structure.GraphClass}"));

			VertexClass vc_GraphElementClass = gc.createVertexClass("structure.GraphElementClass");
			vc_GraphElementClass.setAbstract(true);
			vc_GraphElementClass.addSuperClass(vc_AttributedElementClass);
			vc_GraphElementClass.createAttribute("abstract", getDomain("Boolean"), null);

			VertexClass vc_CollectionDomain = gc.createVertexClass("domains.CollectionDomain");
			vc_CollectionDomain.setAbstract(true);
			vc_CollectionDomain.addSuperClass(vc_Domain);

			VertexClass vc_BasicDomain = gc.createVertexClass("domains.BasicDomain");
			vc_BasicDomain.setAbstract(true);
			vc_BasicDomain.addSuperClass(vc_Domain);

			VertexClass vc_RecordDomain = gc.createVertexClass("domains.RecordDomain");
			vc_RecordDomain.setAbstract(false);
			vc_RecordDomain.addSuperClass(vc_Domain);

			VertexClass vc_MapDomain = gc.createVertexClass("domains.MapDomain");
			vc_MapDomain.setAbstract(false);
			vc_MapDomain.addSuperClass(vc_Domain);

			VertexClass vc_EnumDomain = gc.createVertexClass("domains.EnumDomain");
			vc_EnumDomain.setAbstract(false);
			vc_EnumDomain.addSuperClass(vc_Domain);
			vc_EnumDomain.createAttribute("enumConstants", getDomain("List<String>"), null);

			VertexClass vc_VertexClass = gc.createVertexClass("structure.VertexClass");
			vc_VertexClass.setAbstract(false);
			vc_VertexClass.addSuperClass(vc_GraphElementClass);

			VertexClass vc_EdgeClass = gc.createVertexClass("structure.EdgeClass");
			vc_EdgeClass.setAbstract(false);
			vc_EdgeClass.addSuperClass(vc_GraphElementClass);
			vc_EdgeClass.addConstraint(new ConstraintImpl("An EdgeClass may have at most one shared/composite end.", "import structure.*; forall ec : V{EdgeClass}, degree{ComesFrom}(ec) = 1 and degree{GoesTo}(ec) = 1 @ theElement(ec <>--{ComesFrom}).aggregation = \"NONE\" or theElement(ec <>--{GoesTo}).aggregation = \"NONE\"", "import structure.*; from ec : V{EdgeClass} with degree{ComesFrom}(ec) = 1 and degree{GoesTo}(ec) = 1 ? theElement(ec <>--{ComesFrom}).aggregation <> \"NONE\" and theElement(ec <>--{GoesTo}).aggregation <> \"NONE\" : false reportSet ec end"));

			VertexClass vc_SetDomain = gc.createVertexClass("domains.SetDomain");
			vc_SetDomain.setAbstract(false);
			vc_SetDomain.addSuperClass(vc_CollectionDomain);

			VertexClass vc_ListDomain = gc.createVertexClass("domains.ListDomain");
			vc_ListDomain.setAbstract(false);
			vc_ListDomain.addSuperClass(vc_CollectionDomain);

			VertexClass vc_StringDomain = gc.createVertexClass("domains.StringDomain");
			vc_StringDomain.setAbstract(false);
			vc_StringDomain.addSuperClass(vc_BasicDomain);

			VertexClass vc_IntegerDomain = gc.createVertexClass("domains.IntegerDomain");
			vc_IntegerDomain.setAbstract(false);
			vc_IntegerDomain.addSuperClass(vc_BasicDomain);

			VertexClass vc_LongDomain = gc.createVertexClass("domains.LongDomain");
			vc_LongDomain.setAbstract(false);
			vc_LongDomain.addSuperClass(vc_BasicDomain);

			VertexClass vc_DoubleDomain = gc.createVertexClass("domains.DoubleDomain");
			vc_DoubleDomain.setAbstract(false);
			vc_DoubleDomain.addSuperClass(vc_BasicDomain);

			VertexClass vc_BooleanDomain = gc.createVertexClass("domains.BooleanDomain");
			vc_BooleanDomain.setAbstract(false);
			vc_BooleanDomain.addSuperClass(vc_BasicDomain);

			EdgeClass ec_Annotates = gc.createEdgeClass("structure.Annotates",
				vc_Comment, 0, 2147483647, "comments", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_NamedElement, 1, 1, "annotatedelement", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_Annotates.setAbstract(false);

			EdgeClass ec_EndsAt = gc.createEdgeClass("structure.EndsAt",
				vc_IncidenceClass, 0, 2147483647, "incidences", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_VertexClass, 1, 1, "targetclass", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_EndsAt.setAbstract(false);

			EdgeClass ec_HasDomain = gc.createEdgeClass("structure.HasDomain",
				vc_Attribute, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Domain, 1, 1, "domain", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_HasDomain.setAbstract(false);

			EdgeClass ec_HasConstraint = gc.createEdgeClass("structure.HasConstraint",
				vc_AttributedElementClass, 1, 1, "constrainedelement", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Constraint, 0, 2147483647, "constraints", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_HasConstraint.setAbstract(false);

			EdgeClass ec_HasAttribute = gc.createEdgeClass("structure.HasAttribute",
				vc_AttributedElementClass, 1, 1, "element", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Attribute, 0, 2147483647, "attributes", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_HasAttribute.setAbstract(false);

			EdgeClass ec_SpecializesEdgeClass = gc.createEdgeClass("structure.SpecializesEdgeClass",
				vc_EdgeClass, 0, 2147483647, "subclasses", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_EdgeClass, 0, 2147483647, "superclasses", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_SpecializesEdgeClass.setAbstract(false);

			EdgeClass ec_ContainsSubPackage = gc.createEdgeClass("structure.ContainsSubPackage",
				vc_Package, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Package, 0, 2147483647, "subpackages", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_ContainsSubPackage.setAbstract(false);

			EdgeClass ec_ContainsDomain = gc.createEdgeClass("structure.ContainsDomain",
				vc_Package, 1, 1, "package", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Domain, 0, 2147483647, "domains", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_ContainsDomain.setAbstract(false);

			EdgeClass ec_ContainsGraphElementClass = gc.createEdgeClass("structure.ContainsGraphElementClass",
				vc_Package, 1, 1, "package", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_GraphElementClass, 0, 2147483647, "graphelementclasses", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_ContainsGraphElementClass.setAbstract(false);

			EdgeClass ec_ContainsDefaultPackage = gc.createEdgeClass("structure.ContainsDefaultPackage",
				vc_Schema, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Package, 1, 1, "defaultpackage", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_ContainsDefaultPackage.setAbstract(false);

			EdgeClass ec_DefinesGraphClass = gc.createEdgeClass("structure.DefinesGraphClass",
				vc_Schema, 1, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_GraphClass, 1, 1, "graphclass", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_DefinesGraphClass.setAbstract(false);

			EdgeClass ec_SpecializesVertexClass = gc.createEdgeClass("structure.SpecializesVertexClass",
				vc_VertexClass, 0, 2147483647, "subclasses", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_VertexClass, 0, 2147483647, "superclasses", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_SpecializesVertexClass.setAbstract(false);

			EdgeClass ec_ComesFrom = gc.createEdgeClass("structure.ComesFrom",
				vc_EdgeClass, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_IncidenceClass, 1, 1, "from", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_ComesFrom.setAbstract(false);

			EdgeClass ec_GoesTo = gc.createEdgeClass("structure.GoesTo",
				vc_EdgeClass, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_IncidenceClass, 1, 1, "to", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_GoesTo.setAbstract(false);

			EdgeClass ec_HasBaseDomain = gc.createEdgeClass("domains.HasBaseDomain",
				vc_CollectionDomain, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Domain, 1, 1, "basedomain", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_HasBaseDomain.setAbstract(false);

			EdgeClass ec_HasValueDomain = gc.createEdgeClass("domains.HasValueDomain",
				vc_MapDomain, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Domain, 1, 1, "valuedomain", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_HasValueDomain.setAbstract(false);

			EdgeClass ec_HasKeyDomain = gc.createEdgeClass("domains.HasKeyDomain",
				vc_MapDomain, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Domain, 1, 1, "keydomain", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_HasKeyDomain.setAbstract(false);

			EdgeClass ec_HasRecordDomainComponent = gc.createEdgeClass("domains.HasRecordDomainComponent",
				vc_RecordDomain, 0, 2147483647, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Domain, 1, 2147483647, "componentdomains", de.uni_koblenz.jgralab.schema.AggregationKind.SHARED);
			ec_HasRecordDomainComponent.setAbstract(false);
			ec_HasRecordDomainComponent.createAttribute("name", getDomain("String"), null);
		}

		finish();
	}

	@Override
	public de.uni_koblenz.jgralab.GraphFactory createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType implementationType) {
		switch(implementationType) {
			case GENERIC:
				return new de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl(this);
			case STANDARD:
				return new de.uni_koblenz.jgralab.grumlschema.impl.std.SchemaGraphFactoryImpl();
		}
		throw new UnsupportedOperationException("No " + implementationType + " support compiled.");
	}

	/**
	 * Creates a new SchemaGraph graph.
	*/
	public SchemaGraph createSchemaGraph(de.uni_koblenz.jgralab.ImplementationType implType) {
		return createSchemaGraph(implType, null, 100, 100);
	}

	/**
	 * Creates a new SchemaGraph graph with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	*/
	public SchemaGraph createSchemaGraph(de.uni_koblenz.jgralab.ImplementationType implType, String id, int vMax, int eMax) {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	/**
	 * Creates a new SchemaGraph graph.
	*/
	public SchemaGraph createSchemaGraph(de.uni_koblenz.jgralab.GraphFactory factory) {
		return factory.createGraph(getGraphClass(), null, 100, 100);
	}

	/**
	 * Creates a new SchemaGraph graph.
	*/
	public SchemaGraph createSchemaGraph(de.uni_koblenz.jgralab.GraphFactory factory, String id, int vMax, int eMax) {
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	public SchemaGraph loadSchemaGraph(String filename) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadSchemaGraph(filename, factory, null);
	}

	public SchemaGraph loadSchemaGraph(String filename, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadSchemaGraph(filename, factory, pf);
	}

	public SchemaGraph loadSchemaGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadSchemaGraph(filename, factory, null);
	}

	
	public SchemaGraph loadSchemaGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadSchemaGraph(filename, factory, pf);
	}

	public SchemaGraph loadSchemaGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, null);
	}

	public SchemaGraph loadSchemaGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, pf);
	}
	
	@Override
	public boolean reopen() {
		throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
	}
}
