/*
 * This code was generated automatically.
 * Do NOT edit this file, changes will be lost.
 * Instead, change and commit the underlying schema.
 */

package de.uni_koblenz.jgralab.utilities.xml2tg.schema;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;

import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;

import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

import java.lang.ref.WeakReference;

/**
 * The schema XMLSchema is implemented following the singleton pattern.
 * To get the instance, use the static method <code>instance()</code>.
 */
public class XMLSchema extends SchemaImpl {

	/**
	 * reference to the singleton instance
	 */
	static WeakReference<XMLSchema> theInstance = new WeakReference<>(null);
	
	/**
	 * @return the singleton instance of XMLSchema
	 */
	public static synchronized XMLSchema instance() {
		XMLSchema s = theInstance.get();
		if (s != null) {
			return s;
		}
		s = new XMLSchema();
		theInstance = new WeakReference<>(s);
		return s;
	}
	
	/**
	 * Creates a XMLSchema and builds its schema classes.
	 * This constructor is private. Use the <code>instance()</code> method
	 * to access the schema.
	 */
	private XMLSchema() {
		super("XMLSchema", "de.uni_koblenz.jgralab.utilities.xml2tg.schema");

		{
			GraphClass gc = createGraphClass("XMLGraph");

			VertexClass vc_Attribute = gc.createVertexClass("Attribute");
			vc_Attribute.setAbstract(false);
			vc_Attribute.createAttribute("name", getDomain("String"), null);
			vc_Attribute.createAttribute("value", getDomain("String"), null);

			VertexClass vc_Node = gc.createVertexClass("Node");
			vc_Node.setAbstract(true);

			VertexClass vc_Text = gc.createVertexClass("Text");
			vc_Text.setAbstract(false);
			vc_Text.addSuperClass(vc_Node);
			vc_Text.createAttribute("content", getDomain("String"), null);

			VertexClass vc_Element = gc.createVertexClass("Element");
			vc_Element.setAbstract(false);
			vc_Element.addSuperClass(vc_Node);
			vc_Element.createAttribute("name", getDomain("String"), null);
			vc_Element.addConstraint(new ConstraintImpl("There must be exactly one root element", "exists! e: V{Element} @ inDegree{HasChild}(e) = 0", "from e: V{Element} with inDegree{HasChild}(e) = 0 report e end"));
			vc_Element.addComment("Each element except the root element must have exactly one parent.");

			EdgeClass ec_HasAttribute = gc.createEdgeClass("HasAttribute",
				vc_Element, 1, 1, "element", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Attribute, 0, 2147483647, "attributes", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_HasAttribute.setAbstract(false);

			EdgeClass ec_HasContent = gc.createEdgeClass("HasContent",
				vc_Element, 0, 1, "parent", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Node, 0, 2147483647, "contents", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_HasContent.setAbstract(true);

			EdgeClass ec_References = gc.createEdgeClass("References",
				vc_Attribute, 0, 2147483647, "referent", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Element, 0, 2147483647, "refs", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_References.setAbstract(false);

			EdgeClass ec_HasText = gc.createEdgeClass("HasText",
				vc_Element, 1, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Text, 0, 2147483647, "texts", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_HasText.setAbstract(false);
			ec_HasText.addSuperClass(ec_HasContent);

			EdgeClass ec_HasChild = gc.createEdgeClass("HasChild",
				vc_Element, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_Element, 0, 2147483647, "children", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
			ec_HasChild.setAbstract(false);
			ec_HasChild.addSuperClass(ec_HasContent);
		}

		finish();
	}

	@Override
	public de.uni_koblenz.jgralab.GraphFactory createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType implementationType) {
		switch(implementationType) {
			case GENERIC:
				return new de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl(this);
			case STANDARD:
				return new de.uni_koblenz.jgralab.utilities.xml2tg.schema.impl.std.XMLGraphFactoryImpl();
		}
		throw new UnsupportedOperationException("No " + implementationType + " support compiled.");
	}

	/**
	 * Creates a new XMLGraph graph.
	*/
	public XMLGraph createXMLGraph(de.uni_koblenz.jgralab.ImplementationType implType) {
		return createXMLGraph(implType, null, 100, 100);
	}

	/**
	 * Creates a new XMLGraph graph with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	*/
	public XMLGraph createXMLGraph(de.uni_koblenz.jgralab.ImplementationType implType, String id, int vMax, int eMax) {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	/**
	 * Creates a new XMLGraph graph.
	*/
	public XMLGraph createXMLGraph(de.uni_koblenz.jgralab.GraphFactory factory) {
		return factory.createGraph(getGraphClass(), null, 100, 100);
	}

	/**
	 * Creates a new XMLGraph graph.
	*/
	public XMLGraph createXMLGraph(de.uni_koblenz.jgralab.GraphFactory factory, String id, int vMax, int eMax) {
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	public XMLGraph loadXMLGraph(String filename) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadXMLGraph(filename, factory, null);
	}

	public XMLGraph loadXMLGraph(String filename, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadXMLGraph(filename, factory, pf);
	}

	public XMLGraph loadXMLGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadXMLGraph(filename, factory, null);
	}

	
	public XMLGraph loadXMLGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadXMLGraph(filename, factory, pf);
	}

	public XMLGraph loadXMLGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, null);
	}

	public XMLGraph loadXMLGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, pf);
	}
	
	@Override
	public boolean reopen() {
		throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
	}
}
