/*
 * This code was generated automatically.
 * Do NOT edit this file, changes will be lost.
 * Instead, change and commit the underlying schema.
 */

package de.uni_koblenz.jgralab.gretl.template;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;

import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;

import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

import java.lang.ref.WeakReference;

/**
 * The schema TemplateSchema is implemented following the singleton pattern.
 * To get the instance, use the static method <code>instance()</code>.
 */
public class TemplateSchema extends SchemaImpl {

	/**
	 * reference to the singleton instance
	 */
	static WeakReference<TemplateSchema> theInstance = new WeakReference<>(null);
	
	/**
	 * @return the singleton instance of TemplateSchema
	 */
	public static synchronized TemplateSchema instance() {
		TemplateSchema s = theInstance.get();
		if (s != null) {
			return s;
		}
		s = new TemplateSchema();
		theInstance = new WeakReference<>(s);
		return s;
	}
	
	/**
	 * Creates a TemplateSchema and builds its schema classes.
	 * This constructor is private. Use the <code>instance()</code> method
	 * to access the schema.
	 */
	private TemplateSchema() {
		super("TemplateSchema", "de.uni_koblenz.jgralab.gretl.template");

		createMapDomain(getDomain("String"), getDomain("String"));

		{
			GraphClass gc = createGraphClass("TemplateGraph");

			VertexClass vc_CreateVertex = gc.createVertexClass("CreateVertex");
			vc_CreateVertex.setAbstract(false);
			vc_CreateVertex.createAttribute("archetype", getDomain("String"), null);
			vc_CreateVertex.createAttribute("attributes", getDomain("Map<String, String>"), null);
			vc_CreateVertex.createAttribute("copyAttributeValues", getDomain("Boolean"), null);
			vc_CreateVertex.createAttribute("typeName", getDomain("String"), null);
			vc_CreateVertex.createAttribute("typeNameIsQuery", getDomain("Boolean"), null);

			EdgeClass ec_CreateEdge = gc.createEdgeClass("CreateEdge",
				vc_CreateVertex, 0, 2147483647, "src", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
				vc_CreateVertex, 0, 2147483647, "dst", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
			ec_CreateEdge.setAbstract(false);
			ec_CreateEdge.createAttribute("archetype", getDomain("String"), null);
			ec_CreateEdge.createAttribute("attributes", getDomain("Map<String, String>"), null);
			ec_CreateEdge.createAttribute("copyAttributeValues", getDomain("Boolean"), null);
			ec_CreateEdge.createAttribute("typeName", getDomain("String"), null);
			ec_CreateEdge.createAttribute("typeNameIsQuery", getDomain("Boolean"), null);
		}

		finish();
	}

	@Override
	public de.uni_koblenz.jgralab.GraphFactory createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType implementationType) {
		switch(implementationType) {
			case GENERIC:
				return new de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl(this);
			case STANDARD:
				return new de.uni_koblenz.jgralab.gretl.template.impl.std.TemplateGraphFactoryImpl();
		}
		throw new UnsupportedOperationException("No " + implementationType + " support compiled.");
	}

	/**
	 * Creates a new TemplateGraph graph.
	*/
	public TemplateGraph createTemplateGraph(de.uni_koblenz.jgralab.ImplementationType implType) {
		return createTemplateGraph(implType, null, 100, 100);
	}

	/**
	 * Creates a new TemplateGraph graph with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	*/
	public TemplateGraph createTemplateGraph(de.uni_koblenz.jgralab.ImplementationType implType, String id, int vMax, int eMax) {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	/**
	 * Creates a new TemplateGraph graph.
	*/
	public TemplateGraph createTemplateGraph(de.uni_koblenz.jgralab.GraphFactory factory) {
		return factory.createGraph(getGraphClass(), null, 100, 100);
	}

	/**
	 * Creates a new TemplateGraph graph.
	*/
	public TemplateGraph createTemplateGraph(de.uni_koblenz.jgralab.GraphFactory factory, String id, int vMax, int eMax) {
		return factory.createGraph(getGraphClass(), id, vMax, eMax);
	}

	public TemplateGraph loadTemplateGraph(String filename) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadTemplateGraph(filename, factory, null);
	}

	public TemplateGraph loadTemplateGraph(String filename, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(de.uni_koblenz.jgralab.ImplementationType.STANDARD);
		return loadTemplateGraph(filename, factory, pf);
	}

	public TemplateGraph loadTemplateGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadTemplateGraph(filename, factory, null);
	}

	
	public TemplateGraph loadTemplateGraph(String filename, de.uni_koblenz.jgralab.ImplementationType implType, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		de.uni_koblenz.jgralab.GraphFactory factory = createDefaultGraphFactory(implType);
		return loadTemplateGraph(filename, factory, pf);
	}

	public TemplateGraph loadTemplateGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, null);
	}

	public TemplateGraph loadTemplateGraph(String filename, de.uni_koblenz.jgralab.GraphFactory factory, de.uni_koblenz.jgralab.ProgressFunction pf) throws GraphIOException {
		return GraphIO.loadGraphFromFile(filename, factory, pf);
	}
	
	@Override
	public boolean reopen() {
		throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
	}
}
