(ns lens.mdr.bucket
  (:require
    #?(:clj [clojure.spec :as s]
       :cljs [cljs.spec :as s])
            [lens.mdr.bucket.item :as item]
            [odm.data-formats :as odm]))

;; A globally unique identifier of this bucket
(s/def ::id
  uuid?)

;; A key which can be used in searches
(s/def ::key
  some?)

(s/def ::label
  ::odm/translated-text)

(s/def ::items
  (s/coll-of some?))

(s/def ::item
  (s/keys :req [::item/id ::item/label ::item/count]
          :opt [::item/key]))
