(defproject de.uni-leipzig.life/lens-mdr-spec "0.2.5-SNAPSHOT"
  :description "Specs for the Lens MDR CQI Endpoint."
  :url "http://git.life.uni-leipzig.local/lens/lens-mdr-spec"

  :min-lein-version "2.6.0"
  :pedantic? :abort

  :plugins [[lein-cljsbuild "1.1.5"]
            [lein-doo "0.1.7"]]

  :dependencies [[org.clojars.akiel/odm-spec "0.4-alpha15"]]

  :profiles
  {:dev
   {:dependencies [[criterium "0.4.4"]
                   [juxt/iota "0.2.2"]
                   [org.clojure/clojure "1.9.0-alpha15"]
                   [org.clojure/clojurescript "1.9.494"]
                   [org.clojure/test.check "0.9.0"]]}}

  :source-paths ["src"]
  :test-paths ["test/cljc"]

  :cljsbuild
  {:builds
   {:test
    {:source-paths ["src" "test/cljc" "test/cljs"]
     :compiler
     {:output-to "out/testable.js"
      :main lens.mdr.spec.runner
      :optimizations :simple}}}}

  :deploy-repositories
  [["nexus-snapshots"
    {:url "http://nexus.javadev.life.uni-leipzig.local/content/repositories/snapshots"
     :sign-releases false}]
   ["nexus-releases"
    {:url "http://nexus.javadev.life.uni-leipzig.local/content/repositories/releases"
     :sign-releases false}]]

  :clean-targets ["target" "out"])
