(ns lens.mdr.bucket.item
  (:require
    #?(:clj [clojure.spec :as s]
       :cljs [cljs.spec :as s])
            [odm.data-formats :as odm]))

;; A globally unique identifier of this bucket item
(s/def ::id
  uuid?)

;; A key which can be used in searches together with the bucket key
(s/def ::key
  some?)

(s/def ::label
  ::odm/translated-text)

(s/def ::count
  nat-int?)

(s/def :lens.mdr.bucket/item
  (s/keys :req [::id ::label ::count] :opt [::key]))
