(ns lens.mdr.item
  "An item represents the usage of an item-def in a particular form-def."
  (:require
    #?(:clj [clojure.spec :as s]
       :cljs [cljs.spec :as s])
            [lens.mdr.item-group-ref]
            [lens.mdr.item-ref]))

;; A UUID v5 as combination of item-group-ref-id and item-oid
(s/def ::id
  uuid?)

(s/def ::item-group-ref
  :lens.mdr/item-group-ref)

(s/def ::item-ref
  :lens.mdr/item-ref)

(s/def :lens.mdr/item
  (s/keys :req [::id ::item-group-ref ::item-ref]))
