(ns lens.mdr.item-group-ref
  (:require
    #?(:clj [clojure.spec :as s]
       :cljs [cljs.spec :as s])
            [lens.mdr.form-def]
            [lens.mdr.item-group-def]
            [odm.item-group-ref]))

;; A UUID v5 as combination of form-def-id and item-group-oid
(s/def ::id
  uuid?)

(s/def ::form-def
  :lens.mdr/form-def)

(s/def ::item-group-def
  :lens.mdr/item-group-def)

(s/def :lens.mdr/item-group-ref
  (s/merge
    (s/keys :req [::id ::form-def ::item-group-def])
    :odm/item-group-ref))
