# LIFE CQI

Utilities for LIFE Command Query Interfaces.

## Executing Queries

Query execution follows the [Pedestal Interceptor][1] model. An interceptor is a map like this:

```clojure
{:name :list-something
 :cqi.query/type :join
 :cqi.query/cardinality :many
 :enter
 (fn [{:keys [db] :as context}]
   (cqi/join-many context (all-somethings db)))}
```

The most important keys are `:name` and `:enter` which are the same as in Pedestal. With query interceptors, the name should be the same as the query key. Enter has to be a function from context to context as described in the Pedestal tutorial. The context contains all keys one supplies initially an carries the result.

There are two functions which can be used to put a result into the context.

* `cqi/deliver-result` - just puts a result into the context
* `cqi/join` - executes current query from context as join over roots

Normally it should not be necessary to use `deliver-result` directly. Instead `cqi/prop` should be used to create interceptors for properties and `cqi/join` should be used for joins.

The interceptors are than passed via `:cqi/routes` to `cqi/execute`:

```clojure
(let [context
      {:cqi/routes
       {:list-something [list-something]}}]
  (cqi/execute context [{:list-something [:a]}]))
```

The function `cqi/execute` returns the result directly.

The most simple example is a query which returns the constant value `1`:

```clojure
(let [context {:cqi/routes {:a [{:enter #(cqi/deliver-result % 1)}]}}]
  (cqi/execute context [:a]))
```

This returns `{:a 1}`.

### Union Queries

Union Queries are used to return a list of heterogeneous data were different types require different sub-queries.

Example:

```clojure
[{:shape {:circle [:radius] :triangle [:length-a :length-b :length-c]}}]
```

In this example, we have a join called `:shape` with a union sub-query which is represented by a map. The map keys represent types, were the values represent the actual sub-query for that type.

The interceptor for `:shape` looks the same as every join-many interceptor.

```clojure
{:name :shape
 :cqi.query/type :join
 :cqi.query/cardinality :many
 :enter
 (fn [{:keys [db] :as context}]
   (cqi/join-many context (all-shapes db)))}
```

In order to be able to select the right sub-query for the right shape, shapes have to expose there type somehow. Per default it's expected that data items return the types used as keys in the union map under `:cqi/union-key`. But it's also possible to specify a different keyword or a function under `:cqi/union-key-fn` in the context.

[1]: <http://pedestal.io/reference/interceptors>
