(defproject de.uni-leipzig.life/life-cqi "0.3-2-6-SNAPSHOT"
  :description "Utilities for LIFE Command Query Interfaces."
  :url "http://git.life.uni-leipzig.local/clojure/life-cqi"

  :min-lein-version "2.0.0"
  :pedantic? :abort

  :dependencies [[com.datomic/datomic-free "0.9.5350"
                  :exclusions
                  [com.amazonaws/aws-java-sdk
                   com.h2database/h2
                   org.apache.tomcat/tomcat-jdbc
                   org.codehaus.janino/commons-compiler-jdk
                   org.clojure/tools.cli
                   org.hornetq/hornetq-server
                   org.slf4j/jcl-over-slf4j
                   org.slf4j/jul-to-slf4j
                   org.slf4j/log4j-over-slf4j]]
                 [com.taoensso/timbre "4.8.0"]
                 [commons-codec "1.10"]
                 [io.pedestal/pedestal.interceptor "0.5.2"]
                 [org.clojars.akiel/async-error "0.1"
                  :exclusions [org.clojure/clojurescript]]
                 [org.clojars.akiel/datomic-spec "0.1-alpha2"]
                 [org.clojars.akiel/hap-client-clj "0.4"
                  :exclusions [org.clojure/clojurescript
                               com.cognitect/transit-clj]]
                 [org.clojure/clojure "1.9.0-alpha15"]
                 [org.clojure/core.async "0.3.442"]
                 [org.clojure/core.cache "0.6.5"]
                 [org.clojure/tools.reader "1.0.0-beta4"]
                 [org.omcljs/om "1.0.0-alpha48"
                  :exclusions [cljsjs/react cljsjs/react-dom
                               com.cognitect/transit-cljs
                               org.clojure/clojurescript]]
                 [org.slf4j/slf4j-api "1.7.22"]]

  :profiles {:dev
             {:source-paths ["dev"]
              :dependencies [[criterium "0.4.3"]
                             [juxt/iota "0.2.3"]
                             [org.clojure/test.check "0.9.0"]]
              :jvm-opts ["-Dclojure.spec.compile-asserts=true"]}}

  :deploy-repositories
  [["nexus-snapshots"
    {:url "http://nexus.javadev.life.uni-leipzig.local/content/repositories/snapshots"
     :sign-releases false}]
   ["nexus-releases"
    {:url "http://nexus.javadev.life.uni-leipzig.local/content/repositories/releases"
     :sign-releases false}]])
