(ns life-cqi.interceptor.queries
  (:require [clojure.spec :as s]
            [taoensso.timbre :refer [trace warn]]))

(defn spec [[key interceptors]]
  (or (some :cqi.query/spec interceptors) (s/form key)))

(defn- merge-maps [a b]
  (if (and (map? a) (map? b))
    (merge a b)
    b))

(defn- realize-routes [{:keys [cqi/routes] :as interceptor}]
  (if (delay? routes)
    (update interceptor :cqi/routes deref)
    interceptor))

(defn- query [depth [key interceptors :as route-entry]]
  (let [{:keys [cqi.query/type cqi.query/cardinality cqi/routes]
         :as interceptor}
        (apply merge-with merge-maps (map realize-routes (reverse interceptors)))]
    (cond-> #:cqi.query
                {:key key
                 :type type
                 :cardinality (or cardinality :one)}
            (= :prop type) (assoc :cqi.query/spec (spec route-entry))
            (and (< depth 10) routes) (assoc :cqi/queries (into [] (map #(query (inc depth) %)) (sort-by first routes))))))

(def queries
  {:name :cqi/queries
   :desc "Discover possible queries depending on user permissions."
   :cqi.query/type :join
   :cqi.query/cardinality :many
   :enter
   (fn enter-queries [{:keys [cqi/parent-routes] :as context}]
     (trace {:action :enter-queries :route-keys (keys parent-routes)})
     (assoc context :cqi/result (into [] (map #(query 1 %)) (sort-by first parent-routes))))})

