goog.provide('deercreeklabs.tube.client');
deercreeklabs.tube.client.default_keepalive_secs = (25);

/**
 * @interface
 */
deercreeklabs.tube.client.ITubeClient = function(){};

var deercreeklabs$tube$client$ITubeClient$send$dyn_56759 = (function (this$,data){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (deercreeklabs.tube.client.send[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4429__auto__.call(null,this$,data));
} else {
var m__4426__auto__ = (deercreeklabs.tube.client.send["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4426__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("ITubeClient.send",this$);
}
}
});
/**
 * Send binary bytes over this tube
 */
deercreeklabs.tube.client.send = (function deercreeklabs$tube$client$send(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$send$arity$2 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$send$arity$2(this$,data);
} else {
return deercreeklabs$tube$client$ITubeClient$send$dyn_56759(this$,data);
}
});

var deercreeklabs$tube$client$ITubeClient$close$dyn_56760 = (function() {
var G__56761 = null;
var G__56761__1 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
var G__56761__3 = (function (this$,code,reason){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4429__auto__.call(null,this$,code,reason));
} else {
var m__4426__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4426__auto__.call(null,this$,code,reason));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
G__56761 = function(this$,code,reason){
switch(arguments.length){
case 1:
return G__56761__1.call(this,this$);
case 3:
return G__56761__3.call(this,this$,code,reason);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__56761.cljs$core$IFn$_invoke$arity$1 = G__56761__1;
G__56761.cljs$core$IFn$_invoke$arity$3 = G__56761__3;
return G__56761;
})()
;
/**
 * Close this tube
 */
deercreeklabs.tube.client.close = (function deercreeklabs$tube$client$close(var_args){
var G__56322 = arguments.length;
switch (G__56322) {
case 1:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$1 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$1(this$);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_56760(this$);
}
}));

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3 = (function (this$,code,reason){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$3 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$3(this$,code,reason);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_56760(this$,code,reason);
}
}));

(deercreeklabs.tube.client.close.cljs$lang$maxFixedArity = 3);



/**
* @constructor
 * @implements {deercreeklabs.tube.client.ITubeClient}
*/
deercreeklabs.tube.client.TubeClient = (function (conn,close_client_BANG_,_STAR_shutdown_QMARK_){
this.conn = conn;
this.close_client_BANG_ = close_client_BANG_;
this._STAR_shutdown_QMARK_ = _STAR_shutdown_QMARK_;
});
(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$ = cljs.core.PROTOCOL_SENTINEL);

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$send$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
return deercreeklabs.tube.connection.send(self__.conn,data);
}));

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$close$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var code = (1000);
var reason = "Explicit close";
var ws_already_closed_QMARK_ = false;
return (self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3 ? self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3(code,reason,ws_already_closed_QMARK_) : self__.close_client_BANG_.call(null,code,reason,ws_already_closed_QMARK_));
}));

(deercreeklabs.tube.client.TubeClient.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"close-client!","close-client!",-332645616,null),new cljs.core.Symbol(null,"*shutdown?","*shutdown?",282019102,null)], null);
}));

(deercreeklabs.tube.client.TubeClient.cljs$lang$type = true);

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorStr = "deercreeklabs.tube.client/TubeClient");

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"deercreeklabs.tube.client/TubeClient");
}));

/**
 * Positional factory function for deercreeklabs.tube.client/TubeClient.
 */
deercreeklabs.tube.client.__GT_TubeClient = (function deercreeklabs$tube$client$__GT_TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_){
return (new deercreeklabs.tube.client.TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_));
});

deercreeklabs.tube.client._LT_ws_client_cljs = (function deercreeklabs$tube$client$_LT_ws_client_cljs(logger,url,on_error,on_disconnect,handle_rcv_BANG_,log_conn_failure_QMARK_,_STAR_conn,_STAR_shutdown_QMARK_){
var fragment_size = (31999);
var client = (function (){var G__56329 = deercreeklabs.tube.utils.platform_kw();
var G__56329__$1 = (((G__56329 instanceof cljs.core.Keyword))?G__56329.fqn:null);
switch (G__56329__$1) {
case "node":
var WSC = require("ws");
return (new WSC(url));

break;
case "browser":
return (new WebSocket(url));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56329__$1)].join('')));

}
})();
var _STAR_connected_QMARK_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var msg_handler = (function (msg_obj){
var data = (new Int8Array(msg_obj.data));
return (handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1 ? handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1(data) : handle_rcv_BANG_.call(null,data));
});
var closer = (function (){
return client.close();
});
var sender = (function (data){
if(cljs.core.truth_(cljs.core.deref(_STAR_shutdown_QMARK_))){
return null;
} else {
return client.send(data.buffer);
}
});
var ret_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
(client.binaryType = "arraybuffer");

(client.onopen = (function (event){
cljs.core.reset_BANG_(_STAR_connected_QMARK_,true);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ret_ch,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"sender","sender",1557303285),sender,new cljs.core.Keyword(null,"closer","closer",10992481),closer,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330),fragment_size], null));
}));

(client.onclose = (function (event){
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__56330 = cljs.core.deref(_STAR_conn);
var G__56331 = event.code;
var G__56332 = event.reason;
return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(G__56330,G__56331,G__56332) : on_disconnect.call(null,G__56330,G__56331,G__56332));
} else {
return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onerror = (function (err){
if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__56333 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(err);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__56333) : on_error.call(null,G__56333));
} else {
if(cljs.core.truth_(log_conn_failure_QMARK_)){
var G__56334_56764 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__56335_56765 = ["Websocket failed to connect. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.tube.utils.ex_msg(err))].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__56334_56764,G__56335_56765) : logger.call(null,G__56334_56764,G__56335_56765));
} else {
}

return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onmessage = msg_handler);

return ret_ch;
});
deercreeklabs.tube.client.start_keep_alive_loop = (function deercreeklabs$tube$client$start_keep_alive_loop(conn,keep_alive_secs,_STAR_shutdown_QMARK_){
var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_56380){
var state_val_56381 = (state_56380[(1)]);
if((state_val_56381 === (7))){
var inst_56374 = (state_56380[(2)]);
var _ = (function (){var statearr_56382 = state_56380;
(statearr_56382[(4)] = cljs.core.rest((state_56380[(4)])));

return statearr_56382;
})();
var state_56380__$1 = state_56380;
var statearr_56383_56767 = state_56380__$1;
(statearr_56383_56767[(2)] = inst_56374);

(statearr_56383_56767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (1))){
var state_56380__$1 = state_56380;
var statearr_56384_56769 = state_56380__$1;
(statearr_56384_56769[(2)] = null);

(statearr_56384_56769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (4))){
var inst_56348 = (state_56380[(2)]);
var state_56380__$1 = state_56380;
var statearr_56385_56770 = state_56380__$1;
(statearr_56385_56770[(2)] = inst_56348);

(statearr_56385_56770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (13))){
var inst_56366 = deercreeklabs.tube.connection.send_ping(conn);
var state_56380__$1 = state_56380;
var statearr_56386_56771 = state_56380__$1;
(statearr_56386_56771[(2)] = inst_56366);

(statearr_56386_56771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (6))){
var inst_56355 = cljs.core.deref(_STAR_shutdown_QMARK_);
var inst_56356 = cljs.core.not(inst_56355);
var state_56380__$1 = state_56380;
if(inst_56356){
var statearr_56387_56772 = state_56380__$1;
(statearr_56387_56772[(1)] = (8));

} else {
var statearr_56388_56773 = state_56380__$1;
(statearr_56388_56773[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (3))){
var inst_56377 = (state_56380[(2)]);
var state_56380__$1 = state_56380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56380__$1,inst_56377);
} else {
if((state_val_56381 === (12))){
var state_56380__$1 = state_56380;
var statearr_56390_56780 = state_56380__$1;
(statearr_56390_56780[(2)] = null);

(statearr_56390_56780[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (2))){
var _ = (function (){var statearr_56391 = state_56380;
(statearr_56391[(4)] = cljs.core.cons((5),(state_56380[(4)])));

return statearr_56391;
})();
var state_56380__$1 = state_56380;
var statearr_56392_56783 = state_56380__$1;
(statearr_56392_56783[(2)] = null);

(statearr_56392_56783[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (11))){
var inst_56362 = (state_56380[(2)]);
var inst_56363 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_56380__$1 = (function (){var statearr_56394 = state_56380;
(statearr_56394[(7)] = inst_56362);

return statearr_56394;
})();
if(cljs.core.truth_(inst_56363)){
var statearr_56395_56791 = state_56380__$1;
(statearr_56395_56791[(1)] = (12));

} else {
var statearr_56396_56792 = state_56380__$1;
(statearr_56396_56792[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (9))){
var state_56380__$1 = state_56380;
var statearr_56397_56793 = state_56380__$1;
(statearr_56397_56793[(2)] = null);

(statearr_56397_56793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (5))){
var _ = (function (){var statearr_56398 = state_56380;
(statearr_56398[(4)] = cljs.core.rest((state_56380[(4)])));

return statearr_56398;
})();
var state_56380__$1 = state_56380;
var ex56393 = (state_56380__$1[(2)]);
var statearr_56399_56794 = state_56380__$1;
(statearr_56399_56794[(5)] = ex56393);


var statearr_56400_56795 = state_56380__$1;
(statearr_56400_56795[(1)] = (4));

(statearr_56400_56795[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (14))){
var inst_56368 = (state_56380[(2)]);
var state_56380__$1 = (function (){var statearr_56401 = state_56380;
(statearr_56401[(8)] = inst_56368);

return statearr_56401;
})();
var statearr_56402_56796 = state_56380__$1;
(statearr_56402_56796[(2)] = null);

(statearr_56402_56796[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (10))){
var inst_56372 = (state_56380[(2)]);
var state_56380__$1 = state_56380;
var statearr_56404_56797 = state_56380__$1;
(statearr_56404_56797[(2)] = inst_56372);

(statearr_56404_56797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (8))){
var inst_56358 = (keep_alive_secs | (0));
var inst_56359 = ((1000) * inst_56358);
var inst_56360 = cljs.core.async.timeout(inst_56359);
var state_56380__$1 = state_56380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56380__$1,(11),inst_56360);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto__ = null;
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto____0 = (function (){
var statearr_56405 = [null,null,null,null,null,null,null,null,null];
(statearr_56405[(0)] = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto__);

(statearr_56405[(1)] = (1));

return statearr_56405;
});
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto____1 = (function (state_56380){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_56380);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e56406){var ex__43598__auto__ = e56406;
var statearr_56407_56812 = state_56380;
(statearr_56407_56812[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_56380[(4)]))){
var statearr_56408_56817 = state_56380;
(statearr_56408_56817[(1)] = cljs.core.first((state_56380[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56838 = state_56380;
state_56380 = G__56838;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto__ = function(state_56380){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto____1.call(this,state_56380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto____0;
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto____1;
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_56409 = f__43975__auto__();
(statearr_56409[(6)] = c__43974__auto__);

return statearr_56409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

return c__43974__auto__;
});
deercreeklabs.tube.client._LT_connect = (function deercreeklabs$tube$client$_LT_connect(wsc,url,logger,options,close_client_BANG_,_STAR_conn,_STAR_shutdown_QMARK_){
var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_56533){
var state_val_56534 = (state_56533[(1)]);
if((state_val_56534 === (7))){
var state_56533__$1 = state_56533;
var statearr_56535_56870 = state_56533__$1;
(statearr_56535_56870[(2)] = false);

(statearr_56535_56870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (20))){
var inst_56457 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56536_56873 = state_56533__$1;
(statearr_56536_56873[(2)] = inst_56457);

(statearr_56536_56873[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (27))){
var inst_56472 = (state_56533[(7)]);
var inst_56489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56490 = cljs.core.async.timeout((100));
var inst_56491 = [inst_56472,inst_56490];
var inst_56492 = (new cljs.core.PersistentVector(null,2,(5),inst_56489,inst_56491,null));
var state_56533__$1 = state_56533;
return cljs.core.async.ioc_alts_BANG_(state_56533__$1,(29),inst_56492);
} else {
if((state_val_56534 === (1))){
var state_56533__$1 = state_56533;
var statearr_56537_56874 = state_56533__$1;
(statearr_56537_56874[(2)] = null);

(statearr_56537_56874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (24))){
var inst_56483 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_56533__$1 = state_56533;
if(cljs.core.truth_(inst_56483)){
var statearr_56538_56875 = state_56533__$1;
(statearr_56538_56875[(1)] = (26));

} else {
var statearr_56539_56876 = state_56533__$1;
(statearr_56539_56876[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (39))){
var state_56533__$1 = state_56533;
var statearr_56540_56878 = state_56533__$1;
(statearr_56540_56878[(2)] = null);

(statearr_56540_56878[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (4))){
var inst_56411 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56541_56880 = state_56533__$1;
(statearr_56541_56880[(2)] = inst_56411);

(statearr_56541_56880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (15))){
var inst_56444 = (state_56533[(8)]);
var inst_56449 = inst_56444.cljs$lang$protocol_mask$partition0$;
var inst_56450 = (inst_56449 & (64));
var inst_56451 = inst_56444.cljs$core$ISeq$;
var inst_56452 = (cljs.core.PROTOCOL_SENTINEL === inst_56451);
var inst_56453 = ((inst_56450) || (inst_56452));
var state_56533__$1 = state_56533;
if(cljs.core.truth_(inst_56453)){
var statearr_56542_56883 = state_56533__$1;
(statearr_56542_56883[(1)] = (18));

} else {
var statearr_56543_56885 = state_56533__$1;
(statearr_56543_56885[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (21))){
var inst_56444 = (state_56533[(8)]);
var inst_56462 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_56444);
var state_56533__$1 = state_56533;
var statearr_56544_56887 = state_56533__$1;
(statearr_56544_56887[(2)] = inst_56462);

(statearr_56544_56887[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (31))){
var inst_56481 = (state_56533[(9)]);
var inst_56507 = deercreeklabs.tube.utils.current_time_ms();
var inst_56508 = cljs.core.identity(inst_56507);
var inst_56509 = cljs.core.identity(inst_56481);
var inst_56510 = (inst_56508 > inst_56509);
var state_56533__$1 = state_56533;
if(cljs.core.truth_(inst_56510)){
var statearr_56545_56889 = state_56533__$1;
(statearr_56545_56889[(1)] = (36));

} else {
var statearr_56546_56890 = state_56533__$1;
(statearr_56546_56890[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (32))){
var inst_56524 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56547_56892 = state_56533__$1;
(statearr_56547_56892[(2)] = inst_56524);

(statearr_56547_56892[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (40))){
var state_56533__$1 = state_56533;
var statearr_56548_56893 = state_56533__$1;
(statearr_56548_56893[(2)] = null);

(statearr_56548_56893[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (33))){
var state_56533__$1 = state_56533;
var statearr_56549_56895 = state_56533__$1;
(statearr_56549_56895[(2)] = null);

(statearr_56549_56895[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (13))){
var inst_56419 = (state_56533[(10)]);
var state_56533__$1 = state_56533;
var statearr_56550_56898 = state_56533__$1;
(statearr_56550_56898[(2)] = inst_56419);

(statearr_56550_56898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (22))){
var inst_56444 = (state_56533[(8)]);
var state_56533__$1 = state_56533;
var statearr_56551_56900 = state_56533__$1;
(statearr_56551_56900[(2)] = inst_56444);

(statearr_56551_56900[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (36))){
var inst_56467 = (state_56533[(11)]);
var inst_56474 = (state_56533[(12)]);
var inst_56512 = ["Websocket to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)," connected, but did ","not complete negotiation before timeout (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56467)," ms)"].join('');
var inst_56513 = (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),inst_56512) : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_56512));
var inst_56514 = deercreeklabs.tube.connection.close(inst_56474,(1002),"Protocol negotiation timed out",false);
var state_56533__$1 = (function (){var statearr_56552 = state_56533;
(statearr_56552[(13)] = inst_56513);

(statearr_56552[(14)] = inst_56514);

return statearr_56552;
})();
var statearr_56553_56903 = state_56533__$1;
(statearr_56553_56903[(2)] = null);

(statearr_56553_56903[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (41))){
var inst_56520 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56554_56906 = state_56533__$1;
(statearr_56554_56906[(2)] = inst_56520);

(statearr_56554_56906[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (29))){
var inst_56472 = (state_56533[(7)]);
var inst_56494 = (state_56533[(2)]);
var inst_56495 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56494,(0),null);
var inst_56496 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56494,(1),null);
var inst_56497 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_56472,inst_56496);
var state_56533__$1 = (function (){var statearr_56555 = state_56533;
(statearr_56555[(15)] = inst_56495);

return statearr_56555;
})();
if(inst_56497){
var statearr_56556_56907 = state_56533__$1;
(statearr_56556_56907[(1)] = (30));

} else {
var statearr_56557_56908 = state_56533__$1;
(statearr_56557_56908[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (6))){
var inst_56419 = (state_56533[(10)]);
var inst_56424 = inst_56419.cljs$lang$protocol_mask$partition0$;
var inst_56425 = (inst_56424 & (64));
var inst_56426 = inst_56419.cljs$core$ISeq$;
var inst_56427 = (cljs.core.PROTOCOL_SENTINEL === inst_56426);
var inst_56428 = ((inst_56425) || (inst_56427));
var state_56533__$1 = state_56533;
if(cljs.core.truth_(inst_56428)){
var statearr_56558_56909 = state_56533__$1;
(statearr_56558_56909[(1)] = (9));

} else {
var statearr_56559_56910 = state_56533__$1;
(statearr_56559_56910[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (28))){
var inst_56526 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56560_56912 = state_56533__$1;
(statearr_56560_56912[(2)] = inst_56526);

(statearr_56560_56912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (25))){
var inst_56528 = (state_56533[(2)]);
var _ = (function (){var statearr_56561 = state_56533;
(statearr_56561[(4)] = cljs.core.rest((state_56533[(4)])));

return statearr_56561;
})();
var state_56533__$1 = state_56533;
var statearr_56562_56914 = state_56533__$1;
(statearr_56562_56914[(2)] = inst_56528);

(statearr_56562_56914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (34))){
var inst_56468 = (state_56533[(16)]);
var inst_56474 = (state_56533[(12)]);
var inst_56502 = deercreeklabs.tube.client.start_keep_alive_loop(inst_56474,inst_56468,_STAR_shutdown_QMARK_);
var inst_56503 = deercreeklabs.tube.client.__GT_TubeClient(inst_56474,close_client_BANG_,_STAR_shutdown_QMARK_);
var state_56533__$1 = (function (){var statearr_56563 = state_56533;
(statearr_56563[(17)] = inst_56502);

return statearr_56563;
})();
var statearr_56564_56915 = state_56533__$1;
(statearr_56564_56915[(2)] = inst_56503);

(statearr_56564_56915[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (17))){
var inst_56460 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
if(cljs.core.truth_(inst_56460)){
var statearr_56565_56917 = state_56533__$1;
(statearr_56565_56917[(1)] = (21));

} else {
var statearr_56566_56918 = state_56533__$1;
(statearr_56566_56918[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (3))){
var inst_56531 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56533__$1,inst_56531);
} else {
if((state_val_56534 === (12))){
var inst_56419 = (state_56533[(10)]);
var inst_56437 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_56419);
var state_56533__$1 = state_56533;
var statearr_56567_56920 = state_56533__$1;
(statearr_56567_56920[(2)] = inst_56437);

(statearr_56567_56920[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (2))){
var inst_56419 = (state_56533[(10)]);
var _ = (function (){var statearr_56568 = state_56533;
(statearr_56568[(4)] = cljs.core.cons((5),(state_56533[(4)])));

return statearr_56568;
})();
var inst_56419__$1 = wsc;
var inst_56421 = (inst_56419__$1 == null);
var inst_56422 = cljs.core.not(inst_56421);
var state_56533__$1 = (function (){var statearr_56569 = state_56533;
(statearr_56569[(10)] = inst_56419__$1);

return statearr_56569;
})();
if(inst_56422){
var statearr_56570_56923 = state_56533__$1;
(statearr_56570_56923[(1)] = (6));

} else {
var statearr_56571_56924 = state_56533__$1;
(statearr_56571_56924[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (23))){
var inst_56441 = (state_56533[(18)]);
var inst_56440 = (state_56533[(19)]);
var inst_56443 = (state_56533[(20)]);
var inst_56468 = (state_56533[(16)]);
var inst_56467 = (state_56533[(11)]);
var inst_56472 = (state_56533[(7)]);
var inst_56442 = (state_56533[(21)]);
var inst_56474 = (state_56533[(12)]);
var inst_56465 = (state_56533[(2)]);
var inst_56466 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56465,new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612),new cljs.core.Keyword(null,"smart","smart",-1065238825));
var inst_56467__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56465,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(5000));
var inst_56468__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56465,new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281),deercreeklabs.tube.client.default_keepalive_secs);
var inst_56469 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56465,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_56470 = cljs.core.constantly(null);
var inst_56471 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56465,new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281),inst_56470);
var inst_56472__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_56473 = (function (){var map__56418 = inst_56465;
var keep_alive_secs = inst_56468__$1;
var connect_timeout_ms = inst_56467__$1;
var closer = inst_56442;
var on_rcv = inst_56471;
var compression_type = inst_56466;
var log_conn_failure_QMARK_ = inst_56469;
var ready_ch = inst_56472__$1;
var sender = inst_56441;
var fragment_size = inst_56443;
var map__56417 = inst_56440;
return (function (conn){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ready_ch,true);
});
})();
var inst_56474__$1 = deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$12((0),url,url,inst_56473,null,null,inst_56441,inst_56442,inst_56443,inst_56466,true,inst_56471);
var inst_56475 = cljs.core.reset_BANG_(_STAR_conn,inst_56474__$1);
var inst_56476 = deercreeklabs.baracus.encode_int(inst_56443);
var inst_56477 = (inst_56441.cljs$core$IFn$_invoke$arity$1 ? inst_56441.cljs$core$IFn$_invoke$arity$1(inst_56476) : inst_56441.call(null,inst_56476));
var inst_56478 = deercreeklabs.tube.utils.current_time_ms();
var inst_56479 = cljs.core.identity(inst_56478);
var inst_56480 = cljs.core.identity(inst_56467__$1);
var inst_56481 = (inst_56479 + inst_56480);
var state_56533__$1 = (function (){var statearr_56572 = state_56533;
(statearr_56572[(22)] = inst_56475);

(statearr_56572[(9)] = inst_56481);

(statearr_56572[(23)] = inst_56477);

(statearr_56572[(16)] = inst_56468__$1);

(statearr_56572[(11)] = inst_56467__$1);

(statearr_56572[(7)] = inst_56472__$1);

(statearr_56572[(12)] = inst_56474__$1);

return statearr_56572;
})();
var statearr_56573_56931 = state_56533__$1;
(statearr_56573_56931[(2)] = null);

(statearr_56573_56931[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (35))){
var inst_56505 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56574_56934 = state_56533__$1;
(statearr_56574_56934[(2)] = inst_56505);

(statearr_56574_56934[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (19))){
var state_56533__$1 = state_56533;
var statearr_56575_56935 = state_56533__$1;
(statearr_56575_56935[(2)] = false);

(statearr_56575_56935[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (11))){
var inst_56432 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56577_56937 = state_56533__$1;
(statearr_56577_56937[(2)] = inst_56432);

(statearr_56577_56937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (9))){
var state_56533__$1 = state_56533;
var statearr_56578_56938 = state_56533__$1;
(statearr_56578_56938[(2)] = true);

(statearr_56578_56938[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (5))){
var _ = (function (){var statearr_56579 = state_56533;
(statearr_56579[(4)] = cljs.core.rest((state_56533[(4)])));

return statearr_56579;
})();
var state_56533__$1 = state_56533;
var ex56576 = (state_56533__$1[(2)]);
var statearr_56580_56941 = state_56533__$1;
(statearr_56580_56941[(5)] = ex56576);


var statearr_56581_56942 = state_56533__$1;
(statearr_56581_56942[(1)] = (4));

(statearr_56581_56942[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (14))){
var inst_56444 = (state_56533[(8)]);
var inst_56440 = (state_56533[(19)]);
var inst_56440__$1 = (state_56533[(2)]);
var inst_56441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56440__$1,new cljs.core.Keyword(null,"sender","sender",1557303285));
var inst_56442 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56440__$1,new cljs.core.Keyword(null,"closer","closer",10992481));
var inst_56443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56440__$1,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330));
var inst_56444__$1 = options;
var inst_56446 = (inst_56444__$1 == null);
var inst_56447 = cljs.core.not(inst_56446);
var state_56533__$1 = (function (){var statearr_56582 = state_56533;
(statearr_56582[(8)] = inst_56444__$1);

(statearr_56582[(18)] = inst_56441);

(statearr_56582[(19)] = inst_56440__$1);

(statearr_56582[(20)] = inst_56443);

(statearr_56582[(21)] = inst_56442);

return statearr_56582;
})();
if(inst_56447){
var statearr_56583_56947 = state_56533__$1;
(statearr_56583_56947[(1)] = (15));

} else {
var statearr_56584_56948 = state_56533__$1;
(statearr_56584_56948[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (26))){
var state_56533__$1 = state_56533;
var statearr_56585_56949 = state_56533__$1;
(statearr_56585_56949[(2)] = null);

(statearr_56585_56949[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (16))){
var state_56533__$1 = state_56533;
var statearr_56586_56951 = state_56533__$1;
(statearr_56586_56951[(2)] = false);

(statearr_56586_56951[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (38))){
var inst_56522 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
var statearr_56587_56953 = state_56533__$1;
(statearr_56587_56953[(2)] = inst_56522);

(statearr_56587_56953[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (30))){
var inst_56499 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_56533__$1 = state_56533;
if(cljs.core.truth_(inst_56499)){
var statearr_56588_56956 = state_56533__$1;
(statearr_56588_56956[(1)] = (33));

} else {
var statearr_56589_56957 = state_56533__$1;
(statearr_56589_56957[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (10))){
var state_56533__$1 = state_56533;
var statearr_56590_56958 = state_56533__$1;
(statearr_56590_56958[(2)] = false);

(statearr_56590_56958[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (18))){
var state_56533__$1 = state_56533;
var statearr_56591_56960 = state_56533__$1;
(statearr_56591_56960[(2)] = true);

(statearr_56591_56960[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (37))){
var state_56533__$1 = state_56533;
var statearr_56592_56961 = state_56533__$1;
(statearr_56592_56961[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56534 === (8))){
var inst_56435 = (state_56533[(2)]);
var state_56533__$1 = state_56533;
if(cljs.core.truth_(inst_56435)){
var statearr_56594_56962 = state_56533__$1;
(statearr_56594_56962[(1)] = (12));

} else {
var statearr_56595_56963 = state_56533__$1;
(statearr_56595_56963[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto__ = null;
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto____0 = (function (){
var statearr_56596 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56596[(0)] = deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto__);

(statearr_56596[(1)] = (1));

return statearr_56596;
});
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto____1 = (function (state_56533){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_56533);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e56597){var ex__43598__auto__ = e56597;
var statearr_56598_56964 = state_56533;
(statearr_56598_56964[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_56533[(4)]))){
var statearr_56599_56965 = state_56533;
(statearr_56599_56965[(1)] = cljs.core.first((state_56533[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56966 = state_56533;
state_56533 = G__56966;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto__ = function(state_56533){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto____1.call(this,state_56533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto____0;
deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto____1;
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_56600 = f__43975__auto__();
(statearr_56600[(6)] = c__43974__auto__);

return statearr_56600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
}));

return c__43974__auto__;
});
var ufv___56967 = schema.utils.use_fn_validation;
var output_schema56602_56968 = schema.core.Any;
var input_schema56603_56969 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_schema56607_56970 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)], 0)),schema.core.optional_key(new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"logger","logger",-220675947)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one(schema.core.Str,new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null)], null)),schema.core.optional_key(new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),schema.core.Bool,schema.core.optional_key(new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null)),schema.core.optional_key(new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null))]),cljs.core.with_meta(new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),cljs.core.list(new cljs.core.Symbol("s","enum","s/enum",-975416934,null),new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"logger","logger",-220675947)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)], null)))], null);
var input_checker56604_56971 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema56603_56969);
}),null));
var output_checker56605_56972 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema56602_56968);
}),null));
var input_checker56608_56973 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema56607_56970);
}),null));
var output_checker56609_56974 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema56602_56968);
}),null));
var ret__53619__auto___57036 = (function (){
/**
 * Inputs: ([url :- s/Str] [url :- s/Str options :- {(s/optional-key :compression-type) (s/enum :none :smart :deflate), (s/optional-key :connect-timeout-ms) s/Int, (s/optional-key :keep-alive-secs) s/Int, (s/optional-key :logger) (s/=> s/Any s/Keyword s/Str), (s/optional-key :log-conn-failure?) s/Bool, (s/optional-key :on-disconnect) (s/=> s/Any), (s/optional-key :on-rcv) (s/=> s/Any)}])
 * 
 *   Will return a connected client or a closed channel (nil) on connection
 * failure or timeout.
 */
deercreeklabs.tube.client._LT_tube_client = (function deercreeklabs$tube$client$_LT_tube_client(var_args){
var G__56613 = arguments.length;
switch (G__56613) {
case 1:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1 = (function (G__56606){
var validate__51710__auto__ = cljs.core.deref(ufv___56967);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___57054 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__56606], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56614_57061 = new cljs.core.Keyword(null,"input","input",556931961);
var G__56615_57062 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56616_57063 = input_schema56603_56969;
var G__56617_57064 = cljs.core.deref(input_checker56604_56971);
var G__56618_57065 = args__51711__auto___57054;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56614_57061,G__56615_57062,G__56616_57063,G__56617_57064,G__56618_57065) : schema.core.fn_validator.call(null,G__56614_57061,G__56615_57062,G__56616_57063,G__56617_57064,G__56618_57065));
} else {
var temp__5754__auto___57082 = (function (){var fexpr__56619 = cljs.core.deref(input_checker56604_56971);
return (fexpr__56619.cljs$core$IFn$_invoke$arity$1 ? fexpr__56619.cljs$core$IFn$_invoke$arity$1(args__51711__auto___57054) : fexpr__56619.call(null,args__51711__auto___57054));
})();
if(cljs.core.truth_(temp__5754__auto___57082)){
var error__51712__auto___57093 = temp__5754__auto___57082;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___57093], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema56603_56969,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___57054,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___57093], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var url = G__56606;
while(true){
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2(url,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56620_57123 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__56621_57124 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56622_57125 = output_schema56602_56968;
var G__56623_57126 = cljs.core.deref(output_checker56605_56972);
var G__56624_57127 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56620_57123,G__56621_57124,G__56622_57125,G__56623_57126,G__56624_57127) : schema.core.fn_validator.call(null,G__56620_57123,G__56621_57124,G__56622_57125,G__56623_57126,G__56624_57127));
} else {
var temp__5754__auto___57143 = (function (){var fexpr__56625 = cljs.core.deref(output_checker56605_56972);
return (fexpr__56625.cljs$core$IFn$_invoke$arity$1 ? fexpr__56625.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__56625.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___57143)){
var error__51712__auto___57152 = temp__5754__auto___57143;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___57152], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema56602_56968,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___57152], null));
} else {
}
}
} else {
}

return o__51713__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2 = (function (G__56610,G__56611){
var validate__51710__auto__ = cljs.core.deref(ufv___56967);
if(cljs.core.truth_(validate__51710__auto__)){
var args__51711__auto___57173 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__56610,G__56611], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56626_57174 = new cljs.core.Keyword(null,"input","input",556931961);
var G__56627_57175 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56628_57176 = input_schema56607_56970;
var G__56629_57177 = cljs.core.deref(input_checker56608_56973);
var G__56630_57178 = args__51711__auto___57173;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56626_57174,G__56627_57175,G__56628_57176,G__56629_57177,G__56630_57178) : schema.core.fn_validator.call(null,G__56626_57174,G__56627_57175,G__56628_57176,G__56629_57177,G__56630_57178));
} else {
var temp__5754__auto___57180 = (function (){var fexpr__56631 = cljs.core.deref(input_checker56608_56973);
return (fexpr__56631.cljs$core$IFn$_invoke$arity$1 ? fexpr__56631.cljs$core$IFn$_invoke$arity$1(args__51711__auto___57173) : fexpr__56631.call(null,args__51711__auto___57173));
})();
if(cljs.core.truth_(temp__5754__auto___57180)){
var error__51712__auto___57187 = temp__5754__auto___57180;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___57187], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema56607_56970,new cljs.core.Keyword(null,"value","value",305978217),args__51711__auto___57173,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___57187], null));
} else {
}
}
} else {
}

var o__51713__auto__ = (function (){var url = G__56610;
var options = G__56611;
while(true){
var c__43974__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__43974__auto__,validate__51710__auto__,ufv___56967,output_schema56602_56968,input_schema56603_56969,input_schema56607_56970,input_checker56604_56971,output_checker56605_56972,input_checker56608_56973,output_checker56609_56974){
return (function (){
var f__43975__auto__ = (function (){var switch__43594__auto__ = (function (state_56709){
var state_val_56710 = (state_56709[(1)]);
if((state_val_56710 === (7))){
var state_56709__$1 = state_56709;
var statearr_56711_57223 = state_56709__$1;
(statearr_56711_57223[(2)] = false);

(statearr_56711_57223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (20))){
var state_56709__$1 = state_56709;
var statearr_56712_57226 = state_56709__$1;
(statearr_56712_57226[(2)] = null);

(statearr_56712_57226[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (1))){
var state_56709__$1 = state_56709;
var statearr_56713_57236 = state_56709__$1;
(statearr_56713_57236[(2)] = null);

(statearr_56713_57236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (4))){
var inst_56632 = (state_56709[(2)]);
var state_56709__$1 = state_56709;
var statearr_56714_57243 = state_56709__$1;
(statearr_56714_57243[(2)] = inst_56632);

(statearr_56714_57243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (15))){
var inst_56674 = (state_56709[(7)]);
var inst_56683 = (state_56709[(2)]);
var inst_56684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56683,(0),null);
var inst_56685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56683,(1),null);
var inst_56686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56687 = deercreeklabs.async_utils.check(inst_56684);
var inst_56688 = [inst_56687,inst_56685];
var inst_56689 = (new cljs.core.PersistentVector(null,2,(5),inst_56686,inst_56688,null));
var inst_56690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56689,(0),null);
var inst_56691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56689,(1),null);
var inst_56692 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_56674,inst_56691);
var state_56709__$1 = (function (){var statearr_56715 = state_56709;
(statearr_56715[(8)] = inst_56690);

return statearr_56715;
})();
if(inst_56692){
var statearr_56716_57273 = state_56709__$1;
(statearr_56716_57273[(1)] = (16));

} else {
var statearr_56717_57274 = state_56709__$1;
(statearr_56717_57274[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (21))){
var inst_56704 = (state_56709[(2)]);
var _ = (function (){var statearr_56718 = state_56709;
(statearr_56718[(4)] = cljs.core.rest((state_56709[(4)])));

return statearr_56718;
})();
var state_56709__$1 = state_56709;
var statearr_56719_57276 = state_56709__$1;
(statearr_56719_57276[(2)] = inst_56704);

(statearr_56719_57276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (13))){
var inst_56642 = (state_56709[(9)]);
var state_56709__$1 = state_56709;
var statearr_56720_57278 = state_56709__$1;
(statearr_56720_57278[(2)] = inst_56642);

(statearr_56720_57278[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (22))){
var inst_56700 = (state_56709[(2)]);
var inst_56701 = deercreeklabs.async_utils.check(inst_56700);
var state_56709__$1 = state_56709;
var statearr_56721_57279 = state_56709__$1;
(statearr_56721_57279[(2)] = inst_56701);

(statearr_56721_57279[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (6))){
var inst_56642 = (state_56709[(9)]);
var inst_56647 = inst_56642.cljs$lang$protocol_mask$partition0$;
var inst_56648 = (inst_56647 & (64));
var inst_56649 = inst_56642.cljs$core$ISeq$;
var inst_56650 = (cljs.core.PROTOCOL_SENTINEL === inst_56649);
var inst_56651 = ((inst_56648) || (inst_56650));
var state_56709__$1 = state_56709;
if(cljs.core.truth_(inst_56651)){
var statearr_56722_57280 = state_56709__$1;
(statearr_56722_57280[(1)] = (9));

} else {
var statearr_56723_57281 = state_56709__$1;
(statearr_56723_57281[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (17))){
var state_56709__$1 = state_56709;
var statearr_56724_57282 = state_56709__$1;
(statearr_56724_57282[(2)] = false);

(statearr_56724_57282[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (3))){
var inst_56707 = (state_56709[(2)]);
var state_56709__$1 = state_56709;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56709__$1,inst_56707);
} else {
if((state_val_56710 === (12))){
var inst_56642 = (state_56709[(9)]);
var inst_56660 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_56642);
var state_56709__$1 = state_56709;
var statearr_56725_57284 = state_56709__$1;
(statearr_56725_57284[(2)] = inst_56660);

(statearr_56725_57284[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (2))){
var inst_56642 = (state_56709[(9)]);
var _ = (function (){var statearr_56726 = state_56709;
(statearr_56726[(4)] = cljs.core.cons((5),(state_56709[(4)])));

return statearr_56726;
})();
var inst_56642__$1 = options;
var inst_56644 = (inst_56642__$1 == null);
var inst_56645 = cljs.core.not(inst_56644);
var state_56709__$1 = (function (){var statearr_56727 = state_56709;
(statearr_56727[(9)] = inst_56642__$1);

return statearr_56727;
})();
if(inst_56645){
var statearr_56728_57287 = state_56709__$1;
(statearr_56728_57287[(1)] = (6));

} else {
var statearr_56729_57289 = state_56709__$1;
(statearr_56729_57289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (19))){
var inst_56664 = (state_56709[(10)]);
var inst_56669 = (state_56709[(11)]);
var inst_56690 = (state_56709[(8)]);
var inst_56671 = (state_56709[(12)]);
var inst_56670 = (state_56709[(13)]);
var inst_56698 = deercreeklabs.tube.client._LT_connect(inst_56690,url,inst_56664,options,inst_56671,inst_56670,inst_56669);
var state_56709__$1 = state_56709;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56709__$1,(22),inst_56698);
} else {
if((state_val_56710 === (11))){
var inst_56655 = (state_56709[(2)]);
var state_56709__$1 = state_56709;
var statearr_56731_57290 = state_56709__$1;
(statearr_56731_57290[(2)] = inst_56655);

(statearr_56731_57290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (9))){
var state_56709__$1 = state_56709;
var statearr_56732_57291 = state_56709__$1;
(statearr_56732_57291[(2)] = true);

(statearr_56732_57291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (5))){
var _ = (function (){var statearr_56733 = state_56709;
(statearr_56733[(4)] = cljs.core.rest((state_56709[(4)])));

return statearr_56733;
})();
var state_56709__$1 = state_56709;
var ex56730 = (state_56709__$1[(2)]);
var statearr_56734_57293 = state_56709__$1;
(statearr_56734_57293[(5)] = ex56730);


var statearr_56735_57294 = state_56709__$1;
(statearr_56735_57294[(1)] = (4));

(statearr_56735_57294[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (14))){
var inst_56664 = (state_56709[(10)]);
var inst_56669 = (state_56709[(11)]);
var inst_56674 = (state_56709[(7)]);
var inst_56671 = (state_56709[(12)]);
var inst_56670 = (state_56709[(13)]);
var inst_56663 = (state_56709[(2)]);
var inst_56664__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56663,new cljs.core.Keyword(null,"logger","logger",-220675947),deercreeklabs.tube.utils.println_logger);
var inst_56665 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56663,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_56666 = cljs.core.constantly(null);
var inst_56667 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56663,new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814),inst_56666);
var inst_56668 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56663,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(10000));
var inst_56669__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var inst_56670__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var inst_56671__$1 = (function (){var map__56638 = inst_56663;
var logger = inst_56664__$1;
var log_conn_failure_QMARK_ = inst_56665;
var on_disconnect = inst_56667;
var connect_timeout_ms = inst_56668;
var _STAR_shutdown_QMARK_ = inst_56669__$1;
var _STAR_conn = inst_56670__$1;
return (function (code,reason,ws_already_closed_QMARK_){
var conn = cljs.core.deref(_STAR_conn);
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(conn)){
deercreeklabs.tube.connection.close(conn,code,reason,ws_already_closed_QMARK_);
} else {
}

return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(conn,code,reason) : on_disconnect.call(null,conn,code,reason));
});
})();
var inst_56672 = (function (){var map__56638 = inst_56663;
var logger = inst_56664__$1;
var log_conn_failure_QMARK_ = inst_56665;
var on_disconnect = inst_56667;
var connect_timeout_ms = inst_56668;
var _STAR_shutdown_QMARK_ = inst_56669__$1;
var _STAR_conn = inst_56670__$1;
var close_client_BANG_ = inst_56671__$1;
return (function (msg){
try{var G__56739_57297 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__56740_57298 = ["Error in websocket: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__56739_57297,G__56740_57298) : logger.call(null,G__56739_57297,G__56740_57298));

return close_client_BANG_((1011),msg,true);
}catch (e56736){if((e56736 instanceof Error)){
var e = e56736;
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error.") : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error."));

var G__56737 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__56738 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(e);
return (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__56737,G__56738) : logger.call(null,G__56737,G__56738));
} else {
throw e56736;

}
}});
})();
var inst_56673 = (function (){var on_error = inst_56672;
var connect_timeout_ms = inst_56668;
var close_client_BANG_ = inst_56671__$1;
var on_disconnect = inst_56667;
var _STAR_conn = inst_56670__$1;
var log_conn_failure_QMARK_ = inst_56665;
var logger = inst_56664__$1;
var map__56638 = inst_56663;
var _STAR_shutdown_QMARK_ = inst_56669__$1;
return (function (p1__56601_SHARP_){
var temp__5754__auto__ = cljs.core.deref(_STAR_conn);
if(cljs.core.truth_(temp__5754__auto__)){
var conn = temp__5754__auto__;
return deercreeklabs.tube.connection.handle_data(conn,p1__56601_SHARP_);
} else {
return null;
}
});
})();
var inst_56674__$1 = deercreeklabs.tube.client._LT_ws_client_cljs(inst_56664__$1,url,inst_56672,inst_56667,inst_56673,inst_56665,inst_56670__$1,inst_56669__$1);
var inst_56678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56679 = cljs.core.async.timeout(inst_56668);
var inst_56680 = [inst_56674__$1,inst_56679];
var inst_56681 = (new cljs.core.PersistentVector(null,2,(5),inst_56678,inst_56680,null));
var state_56709__$1 = (function (){var statearr_56741 = state_56709;
(statearr_56741[(10)] = inst_56664__$1);

(statearr_56741[(11)] = inst_56669__$1);

(statearr_56741[(7)] = inst_56674__$1);

(statearr_56741[(12)] = inst_56671__$1);

(statearr_56741[(13)] = inst_56670__$1);

return statearr_56741;
})();
return cljs.core.async.ioc_alts_BANG_(state_56709__$1,(15),inst_56681);
} else {
if((state_val_56710 === (16))){
var inst_56690 = (state_56709[(8)]);
var state_56709__$1 = state_56709;
var statearr_56742_57305 = state_56709__$1;
(statearr_56742_57305[(2)] = inst_56690);

(statearr_56742_57305[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (10))){
var state_56709__$1 = state_56709;
var statearr_56743_57307 = state_56709__$1;
(statearr_56743_57307[(2)] = false);

(statearr_56743_57307[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (18))){
var inst_56696 = (state_56709[(2)]);
var state_56709__$1 = state_56709;
if(cljs.core.truth_(inst_56696)){
var statearr_56744_57310 = state_56709__$1;
(statearr_56744_57310[(1)] = (19));

} else {
var statearr_56745_57311 = state_56709__$1;
(statearr_56745_57311[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56710 === (8))){
var inst_56658 = (state_56709[(2)]);
var state_56709__$1 = state_56709;
if(cljs.core.truth_(inst_56658)){
var statearr_56746_57313 = state_56709__$1;
(statearr_56746_57313[(1)] = (12));

} else {
var statearr_56747_57314 = state_56709__$1;
(statearr_56747_57314[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$state_machine__43595__auto__ = null;
var deercreeklabs$tube$client$state_machine__43595__auto____0 = (function (){
var statearr_56748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56748[(0)] = deercreeklabs$tube$client$state_machine__43595__auto__);

(statearr_56748[(1)] = (1));

return statearr_56748;
});
var deercreeklabs$tube$client$state_machine__43595__auto____1 = (function (state_56709){
while(true){
var ret_value__43596__auto__ = (function (){try{while(true){
var result__43597__auto__ = switch__43594__auto__(state_56709);
if(cljs.core.keyword_identical_QMARK_(result__43597__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43597__auto__;
}
break;
}
}catch (e56749){var ex__43598__auto__ = e56749;
var statearr_56750_57318 = state_56709;
(statearr_56750_57318[(2)] = ex__43598__auto__);


if(cljs.core.seq((state_56709[(4)]))){
var statearr_56751_57319 = state_56709;
(statearr_56751_57319[(1)] = cljs.core.first((state_56709[(4)])));

} else {
throw ex__43598__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43596__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57321 = state_56709;
state_56709 = G__57321;
continue;
} else {
return ret_value__43596__auto__;
}
break;
}
});
deercreeklabs$tube$client$state_machine__43595__auto__ = function(state_56709){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$state_machine__43595__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$state_machine__43595__auto____1.call(this,state_56709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$state_machine__43595__auto____0;
deercreeklabs$tube$client$state_machine__43595__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$state_machine__43595__auto____1;
return deercreeklabs$tube$client$state_machine__43595__auto__;
})()
})();
var state__43976__auto__ = (function (){var statearr_56752 = f__43975__auto__();
(statearr_56752[(6)] = c__43974__auto__);

return statearr_56752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43976__auto__);
});})(c__43974__auto__,validate__51710__auto__,ufv___56967,output_schema56602_56968,input_schema56603_56969,input_schema56607_56970,input_checker56604_56971,output_checker56605_56972,input_checker56608_56973,output_checker56609_56974))
);

return c__43974__auto__;
break;
}
})();
if(cljs.core.truth_(validate__51710__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56753_57324 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__56754_57325 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56755_57326 = output_schema56602_56968;
var G__56756_57327 = cljs.core.deref(output_checker56609_56974);
var G__56757_57328 = o__51713__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56753_57324,G__56754_57325,G__56755_57326,G__56756_57327,G__56757_57328) : schema.core.fn_validator.call(null,G__56753_57324,G__56754_57325,G__56755_57326,G__56756_57327,G__56757_57328));
} else {
var temp__5754__auto___57330 = (function (){var fexpr__56758 = cljs.core.deref(output_checker56609_56974);
return (fexpr__56758.cljs$core$IFn$_invoke$arity$1 ? fexpr__56758.cljs$core$IFn$_invoke$arity$1(o__51713__auto__) : fexpr__56758.call(null,o__51713__auto__));
})();
if(cljs.core.truth_(temp__5754__auto___57330)){
var error__51712__auto___57331 = temp__5754__auto___57330;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51712__auto___57331], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema56602_56968,new cljs.core.Keyword(null,"value","value",305978217),o__51713__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51712__auto___57331], null));
} else {
}
}
} else {
}

return o__51713__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.tube.client._LT_tube_client),schema.core.make_fn_schema(output_schema56602_56968,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema56603_56969,input_schema56607_56970], null)));


//# sourceMappingURL=deercreeklabs.tube.client.js.map
