goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__53660){
var vec__53661 = p__53660;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53661,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53661,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__53666 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__53666__$1 = (((G__53666 instanceof cljs.core.Keyword))?G__53666.fqn:null);
switch (G__53666__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__53668 = (function (){
var seq__53669 = cljs.core.seq(vars__$1);
var chunk__53670 = null;
var count__53671 = (0);
var i__53672 = (0);
while(true){
if((i__53672 < count__53671)){
var v = chunk__53670.cljs$core$IIndexed$_nth$arity$2(null,i__53672);
var temp__5754__auto___53780 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5754__auto___53780)){
var t_53781 = temp__5754__auto___53780;
var G__53675_53783 = ((function (seq__53669,chunk__53670,count__53671,i__53672,t_53781,temp__5754__auto___53780,v,each_fixture_fn,G__53666,G__53666__$1,env,once_fixtures,each_fixtures,vec__53661,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_53781)));
});})(seq__53669,chunk__53670,count__53671,i__53672,t_53781,temp__5754__auto___53780,v,each_fixture_fn,G__53666,G__53666__$1,env,once_fixtures,each_fixtures,vec__53661,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__53675_53783) : each_fixture_fn.call(null,G__53675_53783));
} else {
}


var G__53786 = seq__53669;
var G__53787 = chunk__53670;
var G__53788 = count__53671;
var G__53789 = (i__53672 + (1));
seq__53669 = G__53786;
chunk__53670 = G__53787;
count__53671 = G__53788;
i__53672 = G__53789;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__53669);
if(temp__5754__auto__){
var seq__53669__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53669__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__53669__$1);
var G__53790 = cljs.core.chunk_rest(seq__53669__$1);
var G__53791 = c__4556__auto__;
var G__53792 = cljs.core.count(c__4556__auto__);
var G__53793 = (0);
seq__53669 = G__53790;
chunk__53670 = G__53791;
count__53671 = G__53792;
i__53672 = G__53793;
continue;
} else {
var v = cljs.core.first(seq__53669__$1);
var temp__5754__auto___53794__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5754__auto___53794__$1)){
var t_53795 = temp__5754__auto___53794__$1;
var G__53676_53796 = ((function (seq__53669,chunk__53670,count__53671,i__53672,t_53795,temp__5754__auto___53794__$1,v,seq__53669__$1,temp__5754__auto__,each_fixture_fn,G__53666,G__53666__$1,env,once_fixtures,each_fixtures,vec__53661,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_53795)));
});})(seq__53669,chunk__53670,count__53671,i__53672,t_53795,temp__5754__auto___53794__$1,v,seq__53669__$1,temp__5754__auto__,each_fixture_fn,G__53666,G__53666__$1,env,once_fixtures,each_fixtures,vec__53661,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__53676_53796) : each_fixture_fn.call(null,G__53676_53796));
} else {
}


var G__53798 = cljs.core.next(seq__53669__$1);
var G__53799 = null;
var G__53800 = (0);
var G__53801 = (0);
seq__53669 = G__53798;
chunk__53670 = G__53799;
count__53671 = G__53800;
i__53672 = G__53801;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__53667 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__53667.cljs$core$IFn$_invoke$arity$1 ? fexpr__53667.cljs$core$IFn$_invoke$arity$1(G__53668) : fexpr__53667.call(null,G__53668));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__53666__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__53659_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53659_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__53680 = shadow.test.env.get_test_ns_info(ns);
var map__53680__$1 = (((((!((map__53680 == null))))?(((((map__53680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53680.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53680):map__53680);
var test_ns = map__53680__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53680__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__53690,vars){
var map__53691 = p__53690;
var map__53691__$1 = (((((!((map__53691 == null))))?(((((map__53691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53691.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53691):map__53691);
var env = map__53691__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53691__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__53694_53813 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__53696_53814 = null;
var count__53697_53815 = (0);
var i__53698_53816 = (0);
while(true){
if((i__53698_53816 < count__53697_53815)){
var vec__53718_53820 = chunk__53696_53814.cljs$core$IIndexed$_nth$arity$2(null,i__53698_53816);
var test_ns_53821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53718_53820,(0),null);
var ns_info_53822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53718_53820,(1),null);
var map__53721_53823 = ns_info_53822;
var map__53721_53824__$1 = (((((!((map__53721_53823 == null))))?(((((map__53721_53823.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53721_53823.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53721_53823):map__53721_53823);
var fixtures_53825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53721_53824__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5754__auto___53827 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_53825);
if(cljs.core.truth_(temp__5754__auto___53827)){
var fix_53828 = temp__5754__auto___53827;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53821,fix_53828], 0));
} else {
}

var temp__5754__auto___53829 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_53825);
if(cljs.core.truth_(temp__5754__auto___53829)){
var fix_53830 = temp__5754__auto___53829;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53821,fix_53830], 0));
} else {
}


var G__53832 = seq__53694_53813;
var G__53833 = chunk__53696_53814;
var G__53834 = count__53697_53815;
var G__53835 = (i__53698_53816 + (1));
seq__53694_53813 = G__53832;
chunk__53696_53814 = G__53833;
count__53697_53815 = G__53834;
i__53698_53816 = G__53835;
continue;
} else {
var temp__5754__auto___53837 = cljs.core.seq(seq__53694_53813);
if(temp__5754__auto___53837){
var seq__53694_53838__$1 = temp__5754__auto___53837;
if(cljs.core.chunked_seq_QMARK_(seq__53694_53838__$1)){
var c__4556__auto___53840 = cljs.core.chunk_first(seq__53694_53838__$1);
var G__53841 = cljs.core.chunk_rest(seq__53694_53838__$1);
var G__53842 = c__4556__auto___53840;
var G__53843 = cljs.core.count(c__4556__auto___53840);
var G__53844 = (0);
seq__53694_53813 = G__53841;
chunk__53696_53814 = G__53842;
count__53697_53815 = G__53843;
i__53698_53816 = G__53844;
continue;
} else {
var vec__53723_53848 = cljs.core.first(seq__53694_53838__$1);
var test_ns_53849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53723_53848,(0),null);
var ns_info_53850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53723_53848,(1),null);
var map__53726_53851 = ns_info_53850;
var map__53726_53852__$1 = (((((!((map__53726_53851 == null))))?(((((map__53726_53851.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53726_53851.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53726_53851):map__53726_53851);
var fixtures_53853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53726_53852__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5754__auto___53854__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_53853);
if(cljs.core.truth_(temp__5754__auto___53854__$1)){
var fix_53855 = temp__5754__auto___53854__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53849,fix_53855], 0));
} else {
}

var temp__5754__auto___53856__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_53853);
if(cljs.core.truth_(temp__5754__auto___53856__$1)){
var fix_53857 = temp__5754__auto___53856__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53849,fix_53857], 0));
} else {
}


var G__53858 = cljs.core.next(seq__53694_53838__$1);
var G__53859 = null;
var G__53860 = (0);
var G__53861 = (0);
seq__53694_53813 = G__53858;
chunk__53696_53814 = G__53859;
count__53697_53815 = G__53860;
i__53698_53816 = G__53861;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__53685_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53685_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__53733 = cljs.test.get_current_env();
var map__53733__$1 = (((((!((map__53733 == null))))?(((((map__53733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53733.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53733):map__53733);
var env = map__53733__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53733__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53733__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__53740 = arguments.length;
switch (G__53740) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__53754 = arguments.length;
switch (G__53754) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__53758 = shadow.test.env.get_test_ns_info(ns);
var map__53758__$1 = (((((!((map__53758 == null))))?(((((map__53758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53758.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53758):map__53758);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53758__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__53769 = arguments.length;
switch (G__53769) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__53763_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53763_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__53772 = arguments.length;
switch (G__53772) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__53770_SHARP_){
var or__4126__auto__ = (re == null);
if(or__4126__auto__){
return or__4126__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__53770_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
