goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___53062 = schema.utils.use_fn_validation;
var output_schema52664_53063 = schema.core.Bool;
var input_schema52665_53064 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker52666_53065 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52665_53064);
}),null));
var output_checker52667_53066 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52664_53063);
}),null));
var ret__52081__auto___53067 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__52669){
var validate__49990__auto__ = cljs.core.deref(ufv___53062);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53068 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52669], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52691_53069 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52692_53070 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__52693_53071 = input_schema52665_53064;
var G__52694_53072 = cljs.core.deref(input_checker52666_53065);
var G__52695_53073 = args__49991__auto___53068;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52691_53069,G__52692_53070,G__52693_53071,G__52694_53072,G__52695_53073) : schema.core.fn_validator.call(null,G__52691_53069,G__52692_53070,G__52693_53071,G__52694_53072,G__52695_53073));
} else {
var temp__5753__auto___53074 = (function (){var fexpr__52697 = cljs.core.deref(input_checker52666_53065);
return (fexpr__52697.cljs$core$IFn$_invoke$arity$1 ? fexpr__52697.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53068) : fexpr__52697.call(null,args__49991__auto___53068));
})();
if(cljs.core.truth_(temp__5753__auto___53074)){
var error__49992__auto___53075 = temp__5753__auto___53074;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53075], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52665_53064,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53068,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53075], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var arg = G__52669;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52704_53077 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52705_53078 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__52706_53079 = output_schema52664_53063;
var G__52707_53080 = cljs.core.deref(output_checker52667_53066);
var G__52708_53081 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52704_53077,G__52705_53078,G__52706_53079,G__52707_53080,G__52708_53081) : schema.core.fn_validator.call(null,G__52704_53077,G__52705_53078,G__52706_53079,G__52707_53080,G__52708_53081));
} else {
var temp__5753__auto___53082 = (function (){var fexpr__52710 = cljs.core.deref(output_checker52667_53066);
return (fexpr__52710.cljs$core$IFn$_invoke$arity$1 ? fexpr__52710.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52710.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53082)){
var error__49992__auto___53083 = temp__5753__auto___53082;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53083], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52664_53063,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53083], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema52664_53063,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52665_53064], null)));

var ufv___53084 = schema.utils.use_fn_validation;
var output_schema52711_53085 = deercreeklabs.baracus.ByteArray;
var input_schema52712_53086 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema52716_53087 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker52713_53088 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52712_53086);
}),null));
var output_checker52714_53089 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52711_53085);
}),null));
var input_checker52717_53090 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52716_53087);
}),null));
var output_checker52718_53091 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52711_53085);
}),null));
var ret__52081__auto___53092 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__52722 = arguments.length;
switch (G__52722) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__52715){
var validate__49990__auto__ = cljs.core.deref(ufv___53084);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53094 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52715], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52723_53095 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52724_53096 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__52725_53097 = input_schema52712_53086;
var G__52726_53098 = cljs.core.deref(input_checker52713_53088);
var G__52727_53099 = args__49991__auto___53094;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52723_53095,G__52724_53096,G__52725_53097,G__52726_53098,G__52727_53099) : schema.core.fn_validator.call(null,G__52723_53095,G__52724_53096,G__52725_53097,G__52726_53098,G__52727_53099));
} else {
var temp__5753__auto___53103 = (function (){var fexpr__52728 = cljs.core.deref(input_checker52713_53088);
return (fexpr__52728.cljs$core$IFn$_invoke$arity$1 ? fexpr__52728.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53094) : fexpr__52728.call(null,args__49991__auto___53094));
})();
if(cljs.core.truth_(temp__5753__auto___53103)){
var error__49992__auto___53104 = temp__5753__auto___53103;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53104], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52712_53086,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53094,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53104], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var size_or_seq = G__52715;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52729_53107 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52730_53108 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__52731_53109 = output_schema52711_53085;
var G__52732_53110 = cljs.core.deref(output_checker52714_53089);
var G__52733_53111 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52729_53107,G__52730_53108,G__52731_53109,G__52732_53110,G__52733_53111) : schema.core.fn_validator.call(null,G__52729_53107,G__52730_53108,G__52731_53109,G__52732_53110,G__52733_53111));
} else {
var temp__5753__auto___53112 = (function (){var fexpr__52735 = cljs.core.deref(output_checker52714_53089);
return (fexpr__52735.cljs$core$IFn$_invoke$arity$1 ? fexpr__52735.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52735.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53112)){
var error__49992__auto___53113 = temp__5753__auto___53112;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53113], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52711_53085,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53113], null));
} else {
}
}
} else {
}

return o__49994__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__52719,G__52720){
var validate__49990__auto__ = cljs.core.deref(ufv___53084);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53117 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52719,G__52720], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52736_53119 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52737_53120 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__52738_53121 = input_schema52716_53087;
var G__52739_53122 = cljs.core.deref(input_checker52717_53090);
var G__52740_53123 = args__49991__auto___53117;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52736_53119,G__52737_53120,G__52738_53121,G__52739_53122,G__52740_53123) : schema.core.fn_validator.call(null,G__52736_53119,G__52737_53120,G__52738_53121,G__52739_53122,G__52740_53123));
} else {
var temp__5753__auto___53126 = (function (){var fexpr__52741 = cljs.core.deref(input_checker52717_53090);
return (fexpr__52741.cljs$core$IFn$_invoke$arity$1 ? fexpr__52741.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53117) : fexpr__52741.call(null,args__49991__auto___53117));
})();
if(cljs.core.truth_(temp__5753__auto___53126)){
var error__49992__auto___53128 = temp__5753__auto___53126;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53128], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52716_53087,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53117,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53128], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var size = G__52719;
var init_val_or_seq = G__52720;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52742_53130 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52743_53131 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__52744_53132 = output_schema52711_53085;
var G__52745_53133 = cljs.core.deref(output_checker52718_53091);
var G__52746_53134 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52742_53130,G__52743_53131,G__52744_53132,G__52745_53133,G__52746_53134) : schema.core.fn_validator.call(null,G__52742_53130,G__52743_53131,G__52744_53132,G__52745_53133,G__52746_53134));
} else {
var temp__5753__auto___53135 = (function (){var fexpr__52747 = cljs.core.deref(output_checker52718_53091);
return (fexpr__52747.cljs$core$IFn$_invoke$arity$1 ? fexpr__52747.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52747.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53135)){
var error__49992__auto___53136 = temp__5753__auto___53135;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53136], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52711_53085,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53136], null));
} else {
}
}
} else {
}

return o__49994__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema52711_53085,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52712_53086,input_schema52716_53087], null)));

var ufv___53137 = schema.utils.use_fn_validation;
var output_schema52748_53138 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema52749_53139 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker52750_53140 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52749_53139);
}),null));
var output_checker52751_53141 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52748_53138);
}),null));
var ret__52081__auto___53146 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__52752){
var validate__49990__auto__ = cljs.core.deref(ufv___53137);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53148 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52752], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52753_53149 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52754_53150 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__52755_53151 = input_schema52749_53139;
var G__52756_53152 = cljs.core.deref(input_checker52750_53140);
var G__52757_53153 = args__49991__auto___53148;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52753_53149,G__52754_53150,G__52755_53151,G__52756_53152,G__52757_53153) : schema.core.fn_validator.call(null,G__52753_53149,G__52754_53150,G__52755_53151,G__52756_53152,G__52757_53153));
} else {
var temp__5753__auto___53155 = (function (){var fexpr__52758 = cljs.core.deref(input_checker52750_53140);
return (fexpr__52758.cljs$core$IFn$_invoke$arity$1 ? fexpr__52758.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53148) : fexpr__52758.call(null,args__49991__auto___53148));
})();
if(cljs.core.truth_(temp__5753__auto___53155)){
var error__49992__auto___53158 = temp__5753__auto___53155;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53158], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52749_53139,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53148,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53158], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var arrays = G__52752;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__52759 = cljs.core.count(arrays__$1);
switch (G__52759) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__52759,arrays__$1,validate__49990__auto__,ufv___53137,output_schema52748_53138,input_schema52749_53139,input_checker52750_53140,output_checker52751_53141){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__52759,arrays__$1,validate__49990__auto__,ufv___53137,output_schema52748_53138,input_schema52749_53139,input_checker52750_53140,output_checker52751_53141))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__52759,arrays__$1,validate__49990__auto__,ufv___53137,output_schema52748_53138,input_schema52749_53139,input_checker52750_53140,output_checker52751_53141){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__52759,arrays__$1,validate__49990__auto__,ufv___53137,output_schema52748_53138,input_schema52749_53139,input_checker52750_53140,output_checker52751_53141))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52760_53160 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52761_53161 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__52762_53162 = output_schema52748_53138;
var G__52763_53163 = cljs.core.deref(output_checker52751_53141);
var G__52764_53164 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52760_53160,G__52761_53161,G__52762_53162,G__52763_53163,G__52764_53164) : schema.core.fn_validator.call(null,G__52760_53160,G__52761_53161,G__52762_53162,G__52763_53163,G__52764_53164));
} else {
var temp__5753__auto___53169 = (function (){var fexpr__52766 = cljs.core.deref(output_checker52751_53141);
return (fexpr__52766.cljs$core$IFn$_invoke$arity$1 ? fexpr__52766.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52766.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53169)){
var error__49992__auto___53170 = temp__5753__auto___53169;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53170], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52748_53138,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53170], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema52748_53138,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52749_53139], null)));

var ufv___53179 = schema.utils.use_fn_validation;
var output_schema52767_53180 = schema.core.Bool;
var input_schema52768_53181 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker52769_53182 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52768_53181);
}),null));
var output_checker52770_53183 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52767_53180);
}),null));
var ret__52081__auto___53186 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__52771,G__52772){
var validate__49990__auto__ = cljs.core.deref(ufv___53179);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53188 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52771,G__52772], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52773_53189 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52774_53190 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__52775_53191 = input_schema52768_53181;
var G__52776_53192 = cljs.core.deref(input_checker52769_53182);
var G__52777_53193 = args__49991__auto___53188;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52773_53189,G__52774_53190,G__52775_53191,G__52776_53192,G__52777_53193) : schema.core.fn_validator.call(null,G__52773_53189,G__52774_53190,G__52775_53191,G__52776_53192,G__52777_53193));
} else {
var temp__5753__auto___53197 = (function (){var fexpr__52778 = cljs.core.deref(input_checker52769_53182);
return (fexpr__52778.cljs$core$IFn$_invoke$arity$1 ? fexpr__52778.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53188) : fexpr__52778.call(null,args__49991__auto___53188));
})();
if(cljs.core.truth_(temp__5753__auto___53197)){
var error__49992__auto___53198 = temp__5753__auto___53197;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53198], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52768_53181,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53188,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53198], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var a = G__52771;
var b = G__52772;
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b))){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__53209 = ((i + (1)) | (0));
i = G__53209;
continue;
} else {
return false;
}
}
break;
}
} else {
return false;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52779_53210 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52780_53211 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__52781_53212 = output_schema52767_53180;
var G__52782_53213 = cljs.core.deref(output_checker52770_53183);
var G__52783_53214 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52779_53210,G__52780_53211,G__52781_53212,G__52782_53213,G__52783_53214) : schema.core.fn_validator.call(null,G__52779_53210,G__52780_53211,G__52781_53212,G__52782_53213,G__52783_53214));
} else {
var temp__5753__auto___53215 = (function (){var fexpr__52784 = cljs.core.deref(output_checker52770_53183);
return (fexpr__52784.cljs$core$IFn$_invoke$arity$1 ? fexpr__52784.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52784.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53215)){
var error__49992__auto___53216 = temp__5753__auto___53215;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53216], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52767_53180,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53216], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema52767_53180,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52768_53181], null)));

var ufv___53239 = schema.utils.use_fn_validation;
var output_schema52785_53240 = schema.core.Str;
var input_schema52786_53241 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker52787_53242 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52786_53241);
}),null));
var output_checker52788_53243 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52785_53240);
}),null));
var ret__52081__auto___53245 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__52789){
var validate__49990__auto__ = cljs.core.deref(ufv___53239);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53247 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52789], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52790_53250 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52791_53251 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__52792_53252 = input_schema52786_53241;
var G__52793_53253 = cljs.core.deref(input_checker52787_53242);
var G__52794_53254 = args__49991__auto___53247;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52790_53250,G__52791_53251,G__52792_53252,G__52793_53253,G__52794_53254) : schema.core.fn_validator.call(null,G__52790_53250,G__52791_53251,G__52792_53252,G__52793_53253,G__52794_53254));
} else {
var temp__5753__auto___53255 = (function (){var fexpr__52795 = cljs.core.deref(input_checker52787_53242);
return (fexpr__52795.cljs$core$IFn$_invoke$arity$1 ? fexpr__52795.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53247) : fexpr__52795.call(null,args__49991__auto___53247));
})();
if(cljs.core.truth_(temp__5753__auto___53255)){
var error__49992__auto___53258 = temp__5753__auto___53255;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53258], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52786_53241,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53247,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53258], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52789;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52796_53274 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52797_53275 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__52798_53276 = output_schema52785_53240;
var G__52799_53277 = cljs.core.deref(output_checker52788_53243);
var G__52800_53278 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52796_53274,G__52797_53275,G__52798_53276,G__52799_53277,G__52800_53278) : schema.core.fn_validator.call(null,G__52796_53274,G__52797_53275,G__52798_53276,G__52799_53277,G__52800_53278));
} else {
var temp__5753__auto___53281 = (function (){var fexpr__52802 = cljs.core.deref(output_checker52788_53243);
return (fexpr__52802.cljs$core$IFn$_invoke$arity$1 ? fexpr__52802.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52802.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53281)){
var error__49992__auto___53282 = temp__5753__auto___53281;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53282], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52785_53240,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53282], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema52785_53240,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52786_53241], null)));

var ufv___53283 = schema.utils.use_fn_validation;
var output_schema52803_53284 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema52804_53285 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema52808_53286 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema52813_53287 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker52805_53288 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52804_53285);
}),null));
var output_checker52806_53289 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52803_53284);
}),null));
var input_checker52809_53290 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52808_53286);
}),null));
var output_checker52810_53291 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52803_53284);
}),null));
var input_checker52814_53292 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52813_53287);
}),null));
var output_checker52815_53293 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52803_53284);
}),null));
var ret__52081__auto___53294 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__52821 = arguments.length;
switch (G__52821) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__52807){
var validate__49990__auto__ = cljs.core.deref(ufv___53283);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53307 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52807], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52822_53308 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52823_53309 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__52824_53310 = input_schema52804_53285;
var G__52825_53311 = cljs.core.deref(input_checker52805_53288);
var G__52826_53312 = args__49991__auto___53307;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52822_53308,G__52823_53309,G__52824_53310,G__52825_53311,G__52826_53312) : schema.core.fn_validator.call(null,G__52822_53308,G__52823_53309,G__52824_53310,G__52825_53311,G__52826_53312));
} else {
var temp__5753__auto___53315 = (function (){var fexpr__52827 = cljs.core.deref(input_checker52805_53288);
return (fexpr__52827.cljs$core$IFn$_invoke$arity$1 ? fexpr__52827.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53307) : fexpr__52827.call(null,args__49991__auto___53307));
})();
if(cljs.core.truth_(temp__5753__auto___53315)){
var error__49992__auto___53317 = temp__5753__auto___53315;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53317], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52804_53285,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53307,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53317], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52807;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52828_53336 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52829_53337 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__52830_53338 = output_schema52803_53284;
var G__52831_53339 = cljs.core.deref(output_checker52806_53289);
var G__52832_53340 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52828_53336,G__52829_53337,G__52830_53338,G__52831_53339,G__52832_53340) : schema.core.fn_validator.call(null,G__52828_53336,G__52829_53337,G__52830_53338,G__52831_53339,G__52832_53340));
} else {
var temp__5753__auto___53346 = (function (){var fexpr__52833 = cljs.core.deref(output_checker52806_53289);
return (fexpr__52833.cljs$core$IFn$_invoke$arity$1 ? fexpr__52833.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52833.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53346)){
var error__49992__auto___53347 = temp__5753__auto___53346;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53347], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52803_53284,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53347], null));
} else {
}
}
} else {
}

return o__49994__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__52811,G__52812){
var validate__49990__auto__ = cljs.core.deref(ufv___53283);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53350 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52811,G__52812], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52834_53351 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52835_53352 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__52836_53353 = input_schema52808_53286;
var G__52837_53354 = cljs.core.deref(input_checker52809_53290);
var G__52838_53356 = args__49991__auto___53350;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52834_53351,G__52835_53352,G__52836_53353,G__52837_53354,G__52838_53356) : schema.core.fn_validator.call(null,G__52834_53351,G__52835_53352,G__52836_53353,G__52837_53354,G__52838_53356));
} else {
var temp__5753__auto___53359 = (function (){var fexpr__52839 = cljs.core.deref(input_checker52809_53290);
return (fexpr__52839.cljs$core$IFn$_invoke$arity$1 ? fexpr__52839.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53350) : fexpr__52839.call(null,args__49991__auto___53350));
})();
if(cljs.core.truth_(temp__5753__auto___53359)){
var error__49992__auto___53367 = temp__5753__auto___53359;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53367], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52808_53286,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53350,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53367], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52811;
var start = G__52812;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52840_53370 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52841_53371 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__52842_53372 = output_schema52803_53284;
var G__52843_53373 = cljs.core.deref(output_checker52810_53291);
var G__52844_53374 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52840_53370,G__52841_53371,G__52842_53372,G__52843_53373,G__52844_53374) : schema.core.fn_validator.call(null,G__52840_53370,G__52841_53371,G__52842_53372,G__52843_53373,G__52844_53374));
} else {
var temp__5753__auto___53375 = (function (){var fexpr__52848 = cljs.core.deref(output_checker52810_53291);
return (fexpr__52848.cljs$core$IFn$_invoke$arity$1 ? fexpr__52848.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52848.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53375)){
var error__49992__auto___53376 = temp__5753__auto___53375;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53376], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52803_53284,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53376], null));
} else {
}
}
} else {
}

return o__49994__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__52816,G__52817,G__52818){
var validate__49990__auto__ = cljs.core.deref(ufv___53283);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53387 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52816,G__52817,G__52818], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52849_53389 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52850_53390 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__52851_53391 = input_schema52813_53287;
var G__52852_53392 = cljs.core.deref(input_checker52814_53292);
var G__52853_53393 = args__49991__auto___53387;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52849_53389,G__52850_53390,G__52851_53391,G__52852_53392,G__52853_53393) : schema.core.fn_validator.call(null,G__52849_53389,G__52850_53390,G__52851_53391,G__52852_53392,G__52853_53393));
} else {
var temp__5753__auto___53395 = (function (){var fexpr__52854 = cljs.core.deref(input_checker52814_53292);
return (fexpr__52854.cljs$core$IFn$_invoke$arity$1 ? fexpr__52854.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53387) : fexpr__52854.call(null,args__49991__auto___53387));
})();
if(cljs.core.truth_(temp__5753__auto___53395)){
var error__49992__auto___53399 = temp__5753__auto___53395;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53399], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52813_53287,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53387,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53399], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52816;
var start = G__52817;
var end = G__52818;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4252__auto__ = end;
var y__4253__auto__ = cljs.core.count(ba);
return ((x__4252__auto__ < y__4253__auto__) ? x__4252__auto__ : y__4253__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52856_53414 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52857_53415 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__52858_53416 = output_schema52803_53284;
var G__52859_53417 = cljs.core.deref(output_checker52815_53293);
var G__52860_53418 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52856_53414,G__52857_53415,G__52858_53416,G__52859_53417,G__52860_53418) : schema.core.fn_validator.call(null,G__52856_53414,G__52857_53415,G__52858_53416,G__52859_53417,G__52860_53418));
} else {
var temp__5753__auto___53419 = (function (){var fexpr__52861 = cljs.core.deref(output_checker52815_53293);
return (fexpr__52861.cljs$core$IFn$_invoke$arity$1 ? fexpr__52861.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52861.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53419)){
var error__49992__auto___53420 = temp__5753__auto___53419;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53420], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52803_53284,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53420], null));
} else {
}
}
} else {
}

return o__49994__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema52803_53284,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52804_53285,input_schema52808_53286,input_schema52813_53287], null)));

var ufv___53426 = schema.utils.use_fn_validation;
var output_schema52862_53427 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema52863_53428 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker52864_53429 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52863_53428);
}),null));
var output_checker52865_53430 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52862_53427);
}),null));
var ret__52081__auto___53444 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__52866){
var validate__49990__auto__ = cljs.core.deref(ufv___53426);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53447 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52866], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52867_53450 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52868_53451 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__52869_53452 = input_schema52863_53428;
var G__52870_53453 = cljs.core.deref(input_checker52864_53429);
var G__52871_53454 = args__49991__auto___53447;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52867_53450,G__52868_53451,G__52869_53452,G__52870_53453,G__52871_53454) : schema.core.fn_validator.call(null,G__52867_53450,G__52868_53451,G__52869_53452,G__52870_53453,G__52871_53454));
} else {
var temp__5753__auto___53463 = (function (){var fexpr__52872 = cljs.core.deref(input_checker52864_53429);
return (fexpr__52872.cljs$core$IFn$_invoke$arity$1 ? fexpr__52872.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53447) : fexpr__52872.call(null,args__49991__auto___53447));
})();
if(cljs.core.truth_(temp__5753__auto___53463)){
var error__49992__auto___53464 = temp__5753__auto___53463;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53464], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52863_53428,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53447,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53464], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52866;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4648__auto___53466 = num;
var i_53467 = (0);
while(true){
if((i_53467 < n__4648__auto___53466)){
(new$[i_53467] = (ba[(last - i_53467)]));

var G__53470 = (i_53467 + (1));
i_53467 = G__53470;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52873_53471 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52874_53472 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__52875_53473 = output_schema52862_53427;
var G__52876_53474 = cljs.core.deref(output_checker52865_53430);
var G__52877_53475 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52873_53471,G__52874_53472,G__52875_53473,G__52876_53474,G__52877_53475) : schema.core.fn_validator.call(null,G__52873_53471,G__52874_53472,G__52875_53473,G__52876_53474,G__52877_53475));
} else {
var temp__5753__auto___53476 = (function (){var fexpr__52878 = cljs.core.deref(output_checker52865_53430);
return (fexpr__52878.cljs$core$IFn$_invoke$arity$1 ? fexpr__52878.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52878.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53476)){
var error__49992__auto___53479 = temp__5753__auto___53476;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53479], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52862_53427,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53479], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema52862_53427,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52863_53428], null)));

var ufv___53482 = schema.utils.use_fn_validation;
var output_schema52879_53483 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema52880_53484 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker52881_53485 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52880_53484);
}),null));
var output_checker52882_53486 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52879_53483);
}),null));
var ret__52081__auto___53505 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__52883,G__52884){
var validate__49990__auto__ = cljs.core.deref(ufv___53482);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53510 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52883,G__52884], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52885_53511 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52886_53512 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__52887_53513 = input_schema52880_53484;
var G__52888_53514 = cljs.core.deref(input_checker52881_53485);
var G__52889_53515 = args__49991__auto___53510;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52885_53511,G__52886_53512,G__52887_53513,G__52888_53514,G__52889_53515) : schema.core.fn_validator.call(null,G__52885_53511,G__52886_53512,G__52887_53513,G__52888_53514,G__52889_53515));
} else {
var temp__5753__auto___53518 = (function (){var fexpr__52890 = cljs.core.deref(input_checker52881_53485);
return (fexpr__52890.cljs$core$IFn$_invoke$arity$1 ? fexpr__52890.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53510) : fexpr__52890.call(null,args__49991__auto___53510));
})();
if(cljs.core.truth_(temp__5753__auto___53518)){
var error__49992__auto___53519 = temp__5753__auto___53518;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53519], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52880_53484,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53510,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53519], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52883;
var fragment_size = G__52884;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__53520 = (end_offset | (0));
var G__53521 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__53520;
output = G__53521;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52892_53522 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52893_53523 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__52894_53524 = output_schema52879_53483;
var G__52895_53525 = cljs.core.deref(output_checker52882_53486);
var G__52896_53526 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52892_53522,G__52893_53523,G__52894_53524,G__52895_53525,G__52896_53526) : schema.core.fn_validator.call(null,G__52892_53522,G__52893_53523,G__52894_53524,G__52895_53525,G__52896_53526));
} else {
var temp__5753__auto___53527 = (function (){var fexpr__52897 = cljs.core.deref(output_checker52882_53486);
return (fexpr__52897.cljs$core$IFn$_invoke$arity$1 ? fexpr__52897.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52897.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53527)){
var error__49992__auto___53529 = temp__5753__auto___53527;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53529], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52879_53483,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53529], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema52879_53483,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52880_53484], null)));

var ufv___53535 = schema.utils.use_fn_validation;
var output_schema52899_53536 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema52900_53537 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker52901_53538 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52900_53537);
}),null));
var output_checker52902_53539 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52899_53536);
}),null));
var ret__52081__auto___53545 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__52903){
var validate__49990__auto__ = cljs.core.deref(ufv___53535);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53546 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52903], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52904_53547 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52905_53548 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__52906_53549 = input_schema52900_53537;
var G__52907_53550 = cljs.core.deref(input_checker52901_53538);
var G__52908_53551 = args__49991__auto___53546;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52904_53547,G__52905_53548,G__52906_53549,G__52907_53550,G__52908_53551) : schema.core.fn_validator.call(null,G__52904_53547,G__52905_53548,G__52906_53549,G__52907_53550,G__52908_53551));
} else {
var temp__5753__auto___53554 = (function (){var fexpr__52909 = cljs.core.deref(input_checker52901_53538);
return (fexpr__52909.cljs$core$IFn$_invoke$arity$1 ? fexpr__52909.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53546) : fexpr__52909.call(null,args__49991__auto___53546));
})();
if(cljs.core.truth_(temp__5753__auto___53554)){
var error__49992__auto___53555 = temp__5753__auto___53554;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53555], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52900_53537,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53546,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53555], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52903;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__53568 = (n + (1));
var G__53569 = (i__$1 | (0));
var G__53570 = (out__$1 | (0));
n = G__53568;
i = G__53569;
out = G__53570;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52910_53572 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52911_53573 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__52912_53574 = output_schema52899_53536;
var G__52913_53575 = cljs.core.deref(output_checker52902_53539);
var G__52914_53576 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52910_53572,G__52911_53573,G__52912_53574,G__52913_53575,G__52914_53576) : schema.core.fn_validator.call(null,G__52910_53572,G__52911_53573,G__52912_53574,G__52913_53575,G__52914_53576));
} else {
var temp__5753__auto___53577 = (function (){var fexpr__52915 = cljs.core.deref(output_checker52902_53539);
return (fexpr__52915.cljs$core$IFn$_invoke$arity$1 ? fexpr__52915.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52915.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53577)){
var error__49992__auto___53583 = temp__5753__auto___53577;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53583], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52899_53536,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53583], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema52899_53536,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52900_53537], null)));

var ufv___53590 = schema.utils.use_fn_validation;
var output_schema52916_53591 = deercreeklabs.baracus.ByteArray;
var input_schema52917_53592 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker52918_53593 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52917_53592);
}),null));
var output_checker52919_53594 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52916_53591);
}),null));
var ret__52081__auto___53596 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__52920){
var validate__49990__auto__ = cljs.core.deref(ufv___53590);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53597 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52920], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52921_53598 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52922_53599 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__52923_53600 = input_schema52917_53592;
var G__52924_53601 = cljs.core.deref(input_checker52918_53593);
var G__52925_53602 = args__49991__auto___53597;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52921_53598,G__52922_53599,G__52923_53600,G__52924_53601,G__52925_53602) : schema.core.fn_validator.call(null,G__52921_53598,G__52922_53599,G__52923_53600,G__52924_53601,G__52925_53602));
} else {
var temp__5753__auto___53604 = (function (){var fexpr__52926 = cljs.core.deref(input_checker52918_53593);
return (fexpr__52926.cljs$core$IFn$_invoke$arity$1 ? fexpr__52926.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53597) : fexpr__52926.call(null,args__49991__auto___53597));
})();
if(cljs.core.truth_(temp__5753__auto___53604)){
var error__49992__auto___53605 = temp__5753__auto___53604;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53605], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52917_53592,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53597,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53605], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var i = G__52920;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__53619 = (n >>> (7));
var G__53620 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__53619;
out = G__53620;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52927_53621 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52928_53622 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__52929_53623 = output_schema52916_53591;
var G__52930_53624 = cljs.core.deref(output_checker52919_53594);
var G__52931_53625 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52927_53621,G__52928_53622,G__52929_53623,G__52930_53624,G__52931_53625) : schema.core.fn_validator.call(null,G__52927_53621,G__52928_53622,G__52929_53623,G__52930_53624,G__52931_53625));
} else {
var temp__5753__auto___53626 = (function (){var fexpr__52932 = cljs.core.deref(output_checker52919_53594);
return (fexpr__52932.cljs$core$IFn$_invoke$arity$1 ? fexpr__52932.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52932.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53626)){
var error__49992__auto___53627 = temp__5753__auto___53626;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53627], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52916_53591,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53627], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema52916_53591,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52917_53592], null)));

var ufv___53628 = schema.utils.use_fn_validation;
var output_schema52933_53629 = schema.core.maybe(schema.core.Str);
var input_schema52934_53630 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker52935_53631 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52934_53630);
}),null));
var output_checker52936_53632 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52933_53629);
}),null));
var ret__52081__auto___53637 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__52937){
var validate__49990__auto__ = cljs.core.deref(ufv___53628);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53640 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52937], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52939_53642 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52940_53643 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__52941_53644 = input_schema52934_53630;
var G__52942_53645 = cljs.core.deref(input_checker52935_53631);
var G__52943_53646 = args__49991__auto___53640;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52939_53642,G__52940_53643,G__52941_53644,G__52942_53645,G__52943_53646) : schema.core.fn_validator.call(null,G__52939_53642,G__52940_53643,G__52941_53644,G__52942_53645,G__52943_53646));
} else {
var temp__5753__auto___53651 = (function (){var fexpr__52944 = cljs.core.deref(input_checker52935_53631);
return (fexpr__52944.cljs$core$IFn$_invoke$arity$1 ? fexpr__52944.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53640) : fexpr__52944.call(null,args__49991__auto___53640));
})();
if(cljs.core.truth_(temp__5753__auto___53651)){
var error__49992__auto___53652 = temp__5753__auto___53651;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53652], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52934_53630,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53640,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53652], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var b = G__52937;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52945_53655 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52946_53656 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__52947_53657 = output_schema52933_53629;
var G__52948_53658 = cljs.core.deref(output_checker52936_53632);
var G__52949_53659 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52945_53655,G__52946_53656,G__52947_53657,G__52948_53658,G__52949_53659) : schema.core.fn_validator.call(null,G__52945_53655,G__52946_53656,G__52947_53657,G__52948_53658,G__52949_53659));
} else {
var temp__5753__auto___53663 = (function (){var fexpr__52950 = cljs.core.deref(output_checker52936_53632);
return (fexpr__52950.cljs$core$IFn$_invoke$arity$1 ? fexpr__52950.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52950.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53663)){
var error__49992__auto___53665 = temp__5753__auto___53663;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53665], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52933_53629,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53665], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema52933_53629,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52934_53630], null)));

var ufv___53676 = schema.utils.use_fn_validation;
var output_schema52951_53677 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema52952_53678 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker52953_53679 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52952_53678);
}),null));
var output_checker52954_53680 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52951_53677);
}),null));
var ret__52081__auto___53681 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__52955){
var validate__49990__auto__ = cljs.core.deref(ufv___53676);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53682 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52955], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52956_53683 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52957_53684 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__52958_53685 = input_schema52952_53678;
var G__52959_53686 = cljs.core.deref(input_checker52953_53679);
var G__52960_53687 = args__49991__auto___53682;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52956_53683,G__52957_53684,G__52958_53685,G__52959_53686,G__52960_53687) : schema.core.fn_validator.call(null,G__52956_53683,G__52957_53684,G__52958_53685,G__52959_53686,G__52960_53687));
} else {
var temp__5753__auto___53688 = (function (){var fexpr__52961 = cljs.core.deref(input_checker52953_53679);
return (fexpr__52961.cljs$core$IFn$_invoke$arity$1 ? fexpr__52961.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53682) : fexpr__52961.call(null,args__49991__auto___53682));
})();
if(cljs.core.truth_(temp__5753__auto___53688)){
var error__49992__auto___53689 = temp__5753__auto___53688;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53689], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52952_53678,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53682,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53689], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var s = G__52955;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52962_53690 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52963_53691 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__52964_53692 = output_schema52951_53677;
var G__52965_53693 = cljs.core.deref(output_checker52954_53680);
var G__52966_53694 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52962_53690,G__52963_53691,G__52964_53692,G__52965_53693,G__52966_53694) : schema.core.fn_validator.call(null,G__52962_53690,G__52963_53691,G__52964_53692,G__52965_53693,G__52966_53694));
} else {
var temp__5753__auto___53695 = (function (){var fexpr__52967 = cljs.core.deref(output_checker52954_53680);
return (fexpr__52967.cljs$core$IFn$_invoke$arity$1 ? fexpr__52967.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52967.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53695)){
var error__49992__auto___53696 = temp__5753__auto___53695;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53696], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52951_53677,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53696], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema52951_53677,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52952_53678], null)));

var ufv___53703 = schema.utils.use_fn_validation;
var output_schema52968_53704 = schema.core.maybe(schema.core.Str);
var input_schema52969_53705 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker52970_53706 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52969_53705);
}),null));
var output_checker52971_53707 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52968_53704);
}),null));
var ret__52081__auto___53711 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__52972){
var validate__49990__auto__ = cljs.core.deref(ufv___53703);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53714 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52972], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52974_53715 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52975_53716 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__52976_53717 = input_schema52969_53705;
var G__52977_53718 = cljs.core.deref(input_checker52970_53706);
var G__52978_53719 = args__49991__auto___53714;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52974_53715,G__52975_53716,G__52976_53717,G__52977_53718,G__52978_53719) : schema.core.fn_validator.call(null,G__52974_53715,G__52975_53716,G__52976_53717,G__52977_53718,G__52978_53719));
} else {
var temp__5753__auto___53721 = (function (){var fexpr__52979 = cljs.core.deref(input_checker52970_53706);
return (fexpr__52979.cljs$core$IFn$_invoke$arity$1 ? fexpr__52979.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53714) : fexpr__52979.call(null,args__49991__auto___53714));
})();
if(cljs.core.truth_(temp__5753__auto___53721)){
var error__49992__auto___53722 = temp__5753__auto___53721;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53722], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52969_53705,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53714,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53722], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__52972;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52980_53725 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52981_53726 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__52982_53727 = output_schema52968_53704;
var G__52983_53728 = cljs.core.deref(output_checker52971_53707);
var G__52984_53729 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52980_53725,G__52981_53726,G__52982_53727,G__52983_53728,G__52984_53729) : schema.core.fn_validator.call(null,G__52980_53725,G__52981_53726,G__52982_53727,G__52983_53728,G__52984_53729));
} else {
var temp__5753__auto___53738 = (function (){var fexpr__52985 = cljs.core.deref(output_checker52971_53707);
return (fexpr__52985.cljs$core$IFn$_invoke$arity$1 ? fexpr__52985.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__52985.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53738)){
var error__49992__auto___53741 = temp__5753__auto___53738;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53741], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52968_53704,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53741], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema52968_53704,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52969_53705], null)));

var ufv___53742 = schema.utils.use_fn_validation;
var output_schema52986_53743 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema52987_53744 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker52988_53745 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52987_53744);
}),null));
var output_checker52989_53746 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52986_53743);
}),null));
var ret__52081__auto___53747 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__52990){
var validate__49990__auto__ = cljs.core.deref(ufv___53742);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53748 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52990], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52991_53749 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52992_53750 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__52993_53751 = input_schema52987_53744;
var G__52994_53752 = cljs.core.deref(input_checker52988_53745);
var G__52995_53753 = args__49991__auto___53748;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52991_53749,G__52992_53750,G__52993_53751,G__52994_53752,G__52995_53753) : schema.core.fn_validator.call(null,G__52991_53749,G__52992_53750,G__52993_53751,G__52994_53752,G__52995_53753));
} else {
var temp__5753__auto___53754 = (function (){var fexpr__52996 = cljs.core.deref(input_checker52988_53745);
return (fexpr__52996.cljs$core$IFn$_invoke$arity$1 ? fexpr__52996.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53748) : fexpr__52996.call(null,args__49991__auto___53748));
})();
if(cljs.core.truth_(temp__5753__auto___53754)){
var error__49992__auto___53755 = temp__5753__auto___53754;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53755], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52987_53744,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53748,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53755], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var s = G__52990;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52997_53757 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52998_53758 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__52999_53759 = output_schema52986_53743;
var G__53000_53760 = cljs.core.deref(output_checker52989_53746);
var G__53001_53761 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52997_53757,G__52998_53758,G__52999_53759,G__53000_53760,G__53001_53761) : schema.core.fn_validator.call(null,G__52997_53757,G__52998_53758,G__52999_53759,G__53000_53760,G__53001_53761));
} else {
var temp__5753__auto___53762 = (function (){var fexpr__53002 = cljs.core.deref(output_checker52989_53746);
return (fexpr__53002.cljs$core$IFn$_invoke$arity$1 ? fexpr__53002.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__53002.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53762)){
var error__49992__auto___53763 = temp__5753__auto___53762;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53763], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52986_53743,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53763], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema52986_53743,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52987_53744], null)));

var ufv___53772 = schema.utils.use_fn_validation;
var output_schema53003_53773 = schema.core.maybe(schema.core.Str);
var input_schema53004_53774 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker53005_53775 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53004_53774);
}),null));
var output_checker53006_53776 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53003_53773);
}),null));
var ret__52081__auto___53779 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__53007){
var validate__49990__auto__ = cljs.core.deref(ufv___53772);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53780 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53007], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53009_53781 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53010_53782 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__53011_53783 = input_schema53004_53774;
var G__53012_53784 = cljs.core.deref(input_checker53005_53775);
var G__53013_53785 = args__49991__auto___53780;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53009_53781,G__53010_53782,G__53011_53783,G__53012_53784,G__53013_53785) : schema.core.fn_validator.call(null,G__53009_53781,G__53010_53782,G__53011_53783,G__53012_53784,G__53013_53785));
} else {
var temp__5753__auto___53787 = (function (){var fexpr__53014 = cljs.core.deref(input_checker53005_53775);
return (fexpr__53014.cljs$core$IFn$_invoke$arity$1 ? fexpr__53014.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53780) : fexpr__53014.call(null,args__49991__auto___53780));
})();
if(cljs.core.truth_(temp__5753__auto___53787)){
var error__49992__auto___53789 = temp__5753__auto___53787;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53789], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53004_53774,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53780,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53789], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__53007;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4648__auto___53791 = len;
var i_53792 = (0);
while(true){
if((i_53792 < n__4648__auto___53791)){
var b_53793 = ((ba[i_53792]) & (255));
var j_53794 = ((2) * i_53792);
(ca[j_53794] = (function (){var G__53015 = (b_53793 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__53015) : hex_chars.call(null,G__53015));
})());

(ca[(j_53794 + (1))] = (function (){var G__53016 = (b_53793 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__53016) : hex_chars.call(null,G__53016));
})());

var G__53799 = (i_53792 + (1));
i_53792 = G__53799;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53017_53804 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53018_53805 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__53019_53806 = output_schema53003_53773;
var G__53020_53807 = cljs.core.deref(output_checker53006_53776);
var G__53021_53808 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53017_53804,G__53018_53805,G__53019_53806,G__53020_53807,G__53021_53808) : schema.core.fn_validator.call(null,G__53017_53804,G__53018_53805,G__53019_53806,G__53020_53807,G__53021_53808));
} else {
var temp__5753__auto___53811 = (function (){var fexpr__53022 = cljs.core.deref(output_checker53006_53776);
return (fexpr__53022.cljs$core$IFn$_invoke$arity$1 ? fexpr__53022.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__53022.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53811)){
var error__49992__auto___53812 = temp__5753__auto___53811;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53812], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53003_53773,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53812], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema53003_53773,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53004_53774], null)));

deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
return parseInt(ch,(16));
});
var ufv___53815 = schema.utils.use_fn_validation;
var output_schema53023_53816 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53024_53817 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker53025_53818 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53024_53817);
}),null));
var output_checker53026_53819 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53023_53816);
}),null));
var ret__52081__auto___53820 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__53027){
var validate__49990__auto__ = cljs.core.deref(ufv___53815);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53821 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53027], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53028_53827 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53029_53828 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53030_53829 = input_schema53024_53817;
var G__53031_53830 = cljs.core.deref(input_checker53025_53818);
var G__53032_53831 = args__49991__auto___53821;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53028_53827,G__53029_53828,G__53030_53829,G__53031_53830,G__53032_53831) : schema.core.fn_validator.call(null,G__53028_53827,G__53029_53828,G__53030_53829,G__53031_53830,G__53032_53831));
} else {
var temp__5753__auto___53835 = (function (){var fexpr__53033 = cljs.core.deref(input_checker53025_53818);
return (fexpr__53033.cljs$core$IFn$_invoke$arity$1 ? fexpr__53033.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53821) : fexpr__53033.call(null,args__49991__auto___53821));
})();
if(cljs.core.truth_(temp__5753__auto___53835)){
var error__49992__auto___53838 = temp__5753__auto___53835;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53838], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53024_53817,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53821,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53838], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var s = G__53027;
while(true){
if(cljs.core.truth_(s)){
var ba_len = (cljs.core.count(s) / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4648__auto___53841 = ba_len;
var i_53842 = (0);
while(true){
if((i_53842 < n__4648__auto___53841)){
var j_53843 = ((2) * i_53842);
(ba[i_53842] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_53843)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_53843 + (1))))));

var G__53846 = (i_53842 + (1));
i_53842 = G__53846;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53035_53848 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53036_53849 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53037_53850 = output_schema53023_53816;
var G__53038_53851 = cljs.core.deref(output_checker53026_53819);
var G__53039_53852 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53035_53848,G__53036_53849,G__53037_53850,G__53038_53851,G__53039_53852) : schema.core.fn_validator.call(null,G__53035_53848,G__53036_53849,G__53037_53850,G__53038_53851,G__53039_53852));
} else {
var temp__5753__auto___53862 = (function (){var fexpr__53040 = cljs.core.deref(output_checker53026_53819);
return (fexpr__53040.cljs$core$IFn$_invoke$arity$1 ? fexpr__53040.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__53040.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53862)){
var error__49992__auto___53863 = temp__5753__auto___53862;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53863], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53023_53816,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53863], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema53023_53816,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53024_53817], null)));

var ufv___53864 = schema.utils.use_fn_validation;
var output_schema53043_53865 = deercreeklabs.baracus.ByteArray;
var input_schema53044_53866 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker53045_53867 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53044_53866);
}),null));
var output_checker53046_53868 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53043_53865);
}),null));
var ret__52081__auto___53870 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__53047){
var validate__49990__auto__ = cljs.core.deref(ufv___53864);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___53877 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53047], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53049_53879 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53050_53880 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__53051_53881 = input_schema53044_53866;
var G__53052_53882 = cljs.core.deref(input_checker53045_53867);
var G__53053_53883 = args__49991__auto___53877;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53049_53879,G__53050_53880,G__53051_53881,G__53052_53882,G__53053_53883) : schema.core.fn_validator.call(null,G__53049_53879,G__53050_53880,G__53051_53881,G__53052_53882,G__53053_53883));
} else {
var temp__5753__auto___53888 = (function (){var fexpr__53055 = cljs.core.deref(input_checker53045_53867);
return (fexpr__53055.cljs$core$IFn$_invoke$arity$1 ? fexpr__53055.cljs$core$IFn$_invoke$arity$1(args__49991__auto___53877) : fexpr__53055.call(null,args__49991__auto___53877));
})();
if(cljs.core.truth_(temp__5753__auto___53888)){
var error__49992__auto___53889 = temp__5753__auto___53888;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53889], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53044_53866,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___53877,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53889], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var ba = G__53047;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53056_53894 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53057_53895 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__53058_53896 = output_schema53043_53865;
var G__53059_53897 = cljs.core.deref(output_checker53046_53868);
var G__53060_53898 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53056_53894,G__53057_53895,G__53058_53896,G__53059_53897,G__53060_53898) : schema.core.fn_validator.call(null,G__53056_53894,G__53057_53895,G__53058_53896,G__53059_53897,G__53060_53898));
} else {
var temp__5753__auto___53907 = (function (){var fexpr__53061 = cljs.core.deref(output_checker53046_53868);
return (fexpr__53061.cljs$core$IFn$_invoke$arity$1 ? fexpr__53061.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__53061.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___53907)){
var error__49992__auto___53910 = temp__5753__auto___53907;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___53910], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53043_53865,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___53910], null));
} else {
}
}
} else {
}

return o__49994__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema53043_53865,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53044_53866], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
