goog.provide('deercreeklabs.tube.client');
deercreeklabs.tube.client.default_keepalive_secs = (25);

/**
 * @interface
 */
deercreeklabs.tube.client.ITubeClient = function(){};

var deercreeklabs$tube$client$ITubeClient$send$dyn_54989 = (function (this$,data){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.client.send[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4464__auto__.call(null,this$,data));
} else {
var m__4461__auto__ = (deercreeklabs.tube.client.send["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4461__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("ITubeClient.send",this$);
}
}
});
/**
 * Send binary bytes over this tube
 */
deercreeklabs.tube.client.send = (function deercreeklabs$tube$client$send(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$send$arity$2 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$send$arity$2(this$,data);
} else {
return deercreeklabs$tube$client$ITubeClient$send$dyn_54989(this$,data);
}
});

var deercreeklabs$tube$client$ITubeClient$close$dyn_54990 = (function() {
var G__54991 = null;
var G__54991__1 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
var G__54991__3 = (function (this$,code,reason){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4464__auto__.call(null,this$,code,reason));
} else {
var m__4461__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4461__auto__.call(null,this$,code,reason));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
G__54991 = function(this$,code,reason){
switch(arguments.length){
case 1:
return G__54991__1.call(this,this$);
case 3:
return G__54991__3.call(this,this$,code,reason);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__54991.cljs$core$IFn$_invoke$arity$1 = G__54991__1;
G__54991.cljs$core$IFn$_invoke$arity$3 = G__54991__3;
return G__54991;
})()
;
/**
 * Close this tube
 */
deercreeklabs.tube.client.close = (function deercreeklabs$tube$client$close(var_args){
var G__54653 = arguments.length;
switch (G__54653) {
case 1:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$1 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$1(this$);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_54990(this$);
}
}));

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3 = (function (this$,code,reason){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$3 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$3(this$,code,reason);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_54990(this$,code,reason);
}
}));

(deercreeklabs.tube.client.close.cljs$lang$maxFixedArity = 3);



/**
* @constructor
 * @implements {deercreeklabs.tube.client.ITubeClient}
*/
deercreeklabs.tube.client.TubeClient = (function (conn,close_client_BANG_,_STAR_shutdown_QMARK_){
this.conn = conn;
this.close_client_BANG_ = close_client_BANG_;
this._STAR_shutdown_QMARK_ = _STAR_shutdown_QMARK_;
});
(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$ = cljs.core.PROTOCOL_SENTINEL);

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$send$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
return deercreeklabs.tube.connection.send(self__.conn,data);
}));

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$close$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var code = (1000);
var reason = "Explicit close";
var ws_already_closed_QMARK_ = false;
return (self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3 ? self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3(code,reason,ws_already_closed_QMARK_) : self__.close_client_BANG_.call(null,code,reason,ws_already_closed_QMARK_));
}));

(deercreeklabs.tube.client.TubeClient.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"close-client!","close-client!",-332645616,null),new cljs.core.Symbol(null,"*shutdown?","*shutdown?",282019102,null)], null);
}));

(deercreeklabs.tube.client.TubeClient.cljs$lang$type = true);

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorStr = "deercreeklabs.tube.client/TubeClient");

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"deercreeklabs.tube.client/TubeClient");
}));

/**
 * Positional factory function for deercreeklabs.tube.client/TubeClient.
 */
deercreeklabs.tube.client.__GT_TubeClient = (function deercreeklabs$tube$client$__GT_TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_){
return (new deercreeklabs.tube.client.TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_));
});

deercreeklabs.tube.client._LT_ws_client_cljs = (function deercreeklabs$tube$client$_LT_ws_client_cljs(logger,url,on_error,on_disconnect,handle_rcv_BANG_,log_conn_failure_QMARK_,_STAR_conn,_STAR_shutdown_QMARK_){
var fragment_size = (31999);
var client = (function (){var G__54658 = deercreeklabs.tube.utils.platform_kw();
var G__54658__$1 = (((G__54658 instanceof cljs.core.Keyword))?G__54658.fqn:null);
switch (G__54658__$1) {
case "node":
var WSC = require("ws");
return (new WSC(url));

break;
case "browser":
return (new WebSocket(url));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54658__$1)].join('')));

}
})();
var _STAR_connected_QMARK_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var msg_handler = (function (msg_obj){
var data = (new Int8Array(msg_obj.data));
return (handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1 ? handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1(data) : handle_rcv_BANG_.call(null,data));
});
var closer = (function (){
return client.close();
});
var sender = (function (data){
if(cljs.core.truth_(cljs.core.deref(_STAR_shutdown_QMARK_))){
return null;
} else {
return client.send(data.buffer);
}
});
var ret_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
(client.binaryType = "arraybuffer");

(client.onopen = (function (event){
cljs.core.reset_BANG_(_STAR_connected_QMARK_,true);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ret_ch,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"sender","sender",1557303285),sender,new cljs.core.Keyword(null,"closer","closer",10992481),closer,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330),fragment_size], null));
}));

(client.onclose = (function (event){
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__54671 = cljs.core.deref(_STAR_conn);
var G__54672 = event.code;
var G__54673 = event.reason;
return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(G__54671,G__54672,G__54673) : on_disconnect.call(null,G__54671,G__54672,G__54673));
} else {
return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onerror = (function (err){
if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__54675 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(err);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__54675) : on_error.call(null,G__54675));
} else {
if(cljs.core.truth_(log_conn_failure_QMARK_)){
var G__54676_54994 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__54677_54995 = ["Websocket failed to connect. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.tube.utils.ex_msg(err))].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__54676_54994,G__54677_54995) : logger.call(null,G__54676_54994,G__54677_54995));
} else {
}

return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onmessage = msg_handler);

return ret_ch;
});
deercreeklabs.tube.client.start_keep_alive_loop = (function deercreeklabs$tube$client$start_keep_alive_loop(conn,keep_alive_secs,_STAR_shutdown_QMARK_){
var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_54709){
var state_val_54710 = (state_54709[(1)]);
if((state_val_54710 === (7))){
var inst_54704 = (state_54709[(2)]);
var _ = (function (){var statearr_54712 = state_54709;
(statearr_54712[(4)] = cljs.core.rest((state_54709[(4)])));

return statearr_54712;
})();
var state_54709__$1 = state_54709;
var statearr_54713_54996 = state_54709__$1;
(statearr_54713_54996[(2)] = inst_54704);

(statearr_54713_54996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (1))){
var state_54709__$1 = state_54709;
var statearr_54714_54997 = state_54709__$1;
(statearr_54714_54997[(2)] = null);

(statearr_54714_54997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (4))){
var inst_54678 = (state_54709[(2)]);
var state_54709__$1 = state_54709;
var statearr_54715_54998 = state_54709__$1;
(statearr_54715_54998[(2)] = inst_54678);

(statearr_54715_54998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (13))){
var inst_54696 = deercreeklabs.tube.connection.send_ping(conn);
var state_54709__$1 = state_54709;
var statearr_54716_54999 = state_54709__$1;
(statearr_54716_54999[(2)] = inst_54696);

(statearr_54716_54999[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (6))){
var inst_54685 = cljs.core.deref(_STAR_shutdown_QMARK_);
var inst_54686 = cljs.core.not(inst_54685);
var state_54709__$1 = state_54709;
if(inst_54686){
var statearr_54717_55000 = state_54709__$1;
(statearr_54717_55000[(1)] = (8));

} else {
var statearr_54718_55001 = state_54709__$1;
(statearr_54718_55001[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (3))){
var inst_54707 = (state_54709[(2)]);
var state_54709__$1 = state_54709;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54709__$1,inst_54707);
} else {
if((state_val_54710 === (12))){
var state_54709__$1 = state_54709;
var statearr_54719_55002 = state_54709__$1;
(statearr_54719_55002[(2)] = null);

(statearr_54719_55002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (2))){
var _ = (function (){var statearr_54720 = state_54709;
(statearr_54720[(4)] = cljs.core.cons((5),(state_54709[(4)])));

return statearr_54720;
})();
var state_54709__$1 = state_54709;
var statearr_54721_55003 = state_54709__$1;
(statearr_54721_55003[(2)] = null);

(statearr_54721_55003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (11))){
var inst_54692 = (state_54709[(2)]);
var inst_54693 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_54709__$1 = (function (){var statearr_54723 = state_54709;
(statearr_54723[(7)] = inst_54692);

return statearr_54723;
})();
if(cljs.core.truth_(inst_54693)){
var statearr_54724_55004 = state_54709__$1;
(statearr_54724_55004[(1)] = (12));

} else {
var statearr_54726_55005 = state_54709__$1;
(statearr_54726_55005[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (9))){
var state_54709__$1 = state_54709;
var statearr_54727_55006 = state_54709__$1;
(statearr_54727_55006[(2)] = null);

(statearr_54727_55006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (5))){
var _ = (function (){var statearr_54728 = state_54709;
(statearr_54728[(4)] = cljs.core.rest((state_54709[(4)])));

return statearr_54728;
})();
var state_54709__$1 = state_54709;
var ex54722 = (state_54709__$1[(2)]);
var statearr_54729_55007 = state_54709__$1;
(statearr_54729_55007[(5)] = ex54722);


var statearr_54730_55008 = state_54709__$1;
(statearr_54730_55008[(1)] = (4));

(statearr_54730_55008[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (14))){
var inst_54698 = (state_54709[(2)]);
var state_54709__$1 = (function (){var statearr_54731 = state_54709;
(statearr_54731[(8)] = inst_54698);

return statearr_54731;
})();
var statearr_54732_55009 = state_54709__$1;
(statearr_54732_55009[(2)] = null);

(statearr_54732_55009[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (10))){
var inst_54702 = (state_54709[(2)]);
var state_54709__$1 = state_54709;
var statearr_54733_55010 = state_54709__$1;
(statearr_54733_55010[(2)] = inst_54702);

(statearr_54733_55010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54710 === (8))){
var inst_54688 = (keep_alive_secs | (0));
var inst_54689 = ((1000) * inst_54688);
var inst_54690 = cljs.core.async.timeout(inst_54689);
var state_54709__$1 = state_54709;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54709__$1,(11),inst_54690);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto__ = null;
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto____0 = (function (){
var statearr_54734 = [null,null,null,null,null,null,null,null,null];
(statearr_54734[(0)] = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto__);

(statearr_54734[(1)] = (1));

return statearr_54734;
});
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto____1 = (function (state_54709){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_54709);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e54736){var ex__42028__auto__ = e54736;
var statearr_54737_55013 = state_54709;
(statearr_54737_55013[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_54709[(4)]))){
var statearr_54738_55014 = state_54709;
(statearr_54738_55014[(1)] = cljs.core.first((state_54709[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55015 = state_54709;
state_54709 = G__55015;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto__ = function(state_54709){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto____1.call(this,state_54709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto____0;
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto____1;
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_54739 = f__42470__auto__();
(statearr_54739[(6)] = c__42469__auto__);

return statearr_54739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

return c__42469__auto__;
});
deercreeklabs.tube.client._LT_connect = (function deercreeklabs$tube$client$_LT_connect(wsc,url,logger,options,close_client_BANG_,_STAR_conn,_STAR_shutdown_QMARK_){
var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_54822){
var state_val_54823 = (state_54822[(1)]);
if((state_val_54823 === (7))){
var inst_54817 = (state_54822[(2)]);
var _ = (function (){var statearr_54824 = state_54822;
(statearr_54824[(4)] = cljs.core.rest((state_54822[(4)])));

return statearr_54824;
})();
var state_54822__$1 = state_54822;
var statearr_54825_55016 = state_54822__$1;
(statearr_54825_55016[(2)] = inst_54817);

(statearr_54825_55016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (20))){
var inst_54811 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54826_55023 = state_54822__$1;
(statearr_54826_55023[(2)] = inst_54811);

(statearr_54826_55023[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (1))){
var state_54822__$1 = state_54822;
var statearr_54827_55026 = state_54822__$1;
(statearr_54827_55026[(2)] = null);

(statearr_54827_55026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (4))){
var inst_54740 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54828_55030 = state_54822__$1;
(statearr_54828_55030[(2)] = inst_54740);

(statearr_54828_55030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (15))){
var state_54822__$1 = state_54822;
var statearr_54829_55035 = state_54822__$1;
(statearr_54829_55035[(2)] = null);

(statearr_54829_55035[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (21))){
var state_54822__$1 = state_54822;
var statearr_54830_55036 = state_54822__$1;
(statearr_54830_55036[(2)] = null);

(statearr_54830_55036[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (13))){
var inst_54770 = (state_54822[(7)]);
var inst_54796 = deercreeklabs.tube.utils.current_time_ms();
var inst_54797 = cljs.core.identity(inst_54796);
var inst_54798 = cljs.core.identity(inst_54770);
var inst_54799 = (inst_54797 > inst_54798);
var state_54822__$1 = state_54822;
if(cljs.core.truth_(inst_54799)){
var statearr_54831_55037 = state_54822__$1;
(statearr_54831_55037[(1)] = (18));

} else {
var statearr_54832_55038 = state_54822__$1;
(statearr_54832_55038[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (22))){
var state_54822__$1 = state_54822;
var statearr_54833_55039 = state_54822__$1;
(statearr_54833_55039[(2)] = null);

(statearr_54833_55039[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (6))){
var inst_54772 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_54822__$1 = state_54822;
if(cljs.core.truth_(inst_54772)){
var statearr_54834_55040 = state_54822__$1;
(statearr_54834_55040[(1)] = (8));

} else {
var statearr_54835_55041 = state_54822__$1;
(statearr_54835_55041[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (17))){
var inst_54794 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54836_55042 = state_54822__$1;
(statearr_54836_55042[(2)] = inst_54794);

(statearr_54836_55042[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (3))){
var inst_54820 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54822__$1,inst_54820);
} else {
if((state_val_54823 === (12))){
var inst_54788 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_54822__$1 = state_54822;
if(cljs.core.truth_(inst_54788)){
var statearr_54837_55045 = state_54822__$1;
(statearr_54837_55045[(1)] = (15));

} else {
var statearr_54838_55047 = state_54822__$1;
(statearr_54838_55047[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (2))){
var inst_54761 = (state_54822[(8)]);
var inst_54756 = (state_54822[(9)]);
var inst_54757 = (state_54822[(10)]);
var inst_54763 = (state_54822[(11)]);
var _ = (function (){var statearr_54839 = state_54822;
(statearr_54839[(4)] = cljs.core.cons((5),(state_54822[(4)])));

return statearr_54839;
})();
var inst_54748 = wsc;
var inst_54749 = cljs.core.__destructure_map(inst_54748);
var inst_54750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_54749,new cljs.core.Keyword(null,"sender","sender",1557303285));
var inst_54751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_54749,new cljs.core.Keyword(null,"closer","closer",10992481));
var inst_54752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_54749,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330));
var inst_54753 = options;
var inst_54754 = cljs.core.__destructure_map(inst_54753);
var inst_54755 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54754,new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612),new cljs.core.Keyword(null,"smart","smart",-1065238825));
var inst_54756__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54754,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(5000));
var inst_54757__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54754,new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281),deercreeklabs.tube.client.default_keepalive_secs);
var inst_54758 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54754,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_54759 = cljs.core.constantly(null);
var inst_54760 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54754,new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281),inst_54759);
var inst_54761__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_54762 = (function (){var map__54747 = inst_54754;
var keep_alive_secs = inst_54757__$1;
var connect_timeout_ms = inst_54756__$1;
var closer = inst_54751;
var map__54746 = inst_54749;
var on_rcv = inst_54760;
var compression_type = inst_54755;
var log_conn_failure_QMARK_ = inst_54758;
var ready_ch = inst_54761__$1;
var sender = inst_54750;
var fragment_size = inst_54752;
return (function (conn){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ready_ch,true);
});
})();
var inst_54763__$1 = deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$12((0),url,url,inst_54762,null,null,inst_54750,inst_54751,inst_54752,inst_54755,true,inst_54760);
var inst_54764 = cljs.core.reset_BANG_(_STAR_conn,inst_54763__$1);
var inst_54765 = deercreeklabs.baracus.encode_int(inst_54752);
var inst_54766 = (inst_54750.cljs$core$IFn$_invoke$arity$1 ? inst_54750.cljs$core$IFn$_invoke$arity$1(inst_54765) : inst_54750.call(null,inst_54765));
var inst_54767 = deercreeklabs.tube.utils.current_time_ms();
var inst_54768 = cljs.core.identity(inst_54767);
var inst_54769 = cljs.core.identity(inst_54756__$1);
var inst_54770 = (inst_54768 + inst_54769);
var state_54822__$1 = (function (){var statearr_54840 = state_54822;
(statearr_54840[(12)] = inst_54764);

(statearr_54840[(8)] = inst_54761__$1);

(statearr_54840[(9)] = inst_54756__$1);

(statearr_54840[(10)] = inst_54757__$1);

(statearr_54840[(7)] = inst_54770);

(statearr_54840[(13)] = inst_54766);

(statearr_54840[(11)] = inst_54763__$1);

return statearr_54840;
})();
var statearr_54841_55114 = state_54822__$1;
(statearr_54841_55114[(2)] = null);

(statearr_54841_55114[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (23))){
var inst_54809 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54842_55117 = state_54822__$1;
(statearr_54842_55117[(2)] = inst_54809);

(statearr_54842_55117[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (19))){
var state_54822__$1 = state_54822;
var statearr_54843_55118 = state_54822__$1;
(statearr_54843_55118[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (11))){
var inst_54761 = (state_54822[(8)]);
var inst_54783 = (state_54822[(2)]);
var inst_54784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54783,(0),null);
var inst_54785 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54783,(1),null);
var inst_54786 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_54761,inst_54785);
var state_54822__$1 = (function (){var statearr_54846 = state_54822;
(statearr_54846[(14)] = inst_54784);

return statearr_54846;
})();
if(inst_54786){
var statearr_54847_55119 = state_54822__$1;
(statearr_54847_55119[(1)] = (12));

} else {
var statearr_54848_55120 = state_54822__$1;
(statearr_54848_55120[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (9))){
var inst_54761 = (state_54822[(8)]);
var inst_54778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54779 = cljs.core.async.timeout((100));
var inst_54780 = [inst_54761,inst_54779];
var inst_54781 = (new cljs.core.PersistentVector(null,2,(5),inst_54778,inst_54780,null));
var state_54822__$1 = state_54822;
return cljs.core.async.ioc_alts_BANG_(state_54822__$1,(11),inst_54781);
} else {
if((state_val_54823 === (5))){
var _ = (function (){var statearr_54849 = state_54822;
(statearr_54849[(4)] = cljs.core.rest((state_54822[(4)])));

return statearr_54849;
})();
var state_54822__$1 = state_54822;
var ex54845 = (state_54822__$1[(2)]);
var statearr_54850_55121 = state_54822__$1;
(statearr_54850_55121[(5)] = ex54845);


var statearr_54851_55122 = state_54822__$1;
(statearr_54851_55122[(1)] = (4));

(statearr_54851_55122[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (14))){
var inst_54813 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54852_55124 = state_54822__$1;
(statearr_54852_55124[(2)] = inst_54813);

(statearr_54852_55124[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (16))){
var inst_54757 = (state_54822[(10)]);
var inst_54763 = (state_54822[(11)]);
var inst_54791 = deercreeklabs.tube.client.start_keep_alive_loop(inst_54763,inst_54757,_STAR_shutdown_QMARK_);
var inst_54792 = deercreeklabs.tube.client.__GT_TubeClient(inst_54763,close_client_BANG_,_STAR_shutdown_QMARK_);
var state_54822__$1 = (function (){var statearr_54853 = state_54822;
(statearr_54853[(15)] = inst_54791);

return statearr_54853;
})();
var statearr_54854_55129 = state_54822__$1;
(statearr_54854_55129[(2)] = inst_54792);

(statearr_54854_55129[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (10))){
var inst_54815 = (state_54822[(2)]);
var state_54822__$1 = state_54822;
var statearr_54855_55131 = state_54822__$1;
(statearr_54855_55131[(2)] = inst_54815);

(statearr_54855_55131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (18))){
var inst_54756 = (state_54822[(9)]);
var inst_54763 = (state_54822[(11)]);
var inst_54801 = ["Websocket to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)," connected, but did ","not complete negotiation before timeout (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54756)," ms)"].join('');
var inst_54802 = (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),inst_54801) : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_54801));
var inst_54803 = deercreeklabs.tube.connection.close(inst_54763,(1002),"Protocol negotiation timed out",false);
var state_54822__$1 = (function (){var statearr_54856 = state_54822;
(statearr_54856[(16)] = inst_54803);

(statearr_54856[(17)] = inst_54802);

return statearr_54856;
})();
var statearr_54857_55136 = state_54822__$1;
(statearr_54857_55136[(2)] = null);

(statearr_54857_55136[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54823 === (8))){
var state_54822__$1 = state_54822;
var statearr_54858_55138 = state_54822__$1;
(statearr_54858_55138[(2)] = null);

(statearr_54858_55138[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto__ = null;
var deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto____0 = (function (){
var statearr_54859 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54859[(0)] = deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto__);

(statearr_54859[(1)] = (1));

return statearr_54859;
});
var deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto____1 = (function (state_54822){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_54822);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e54860){var ex__42028__auto__ = e54860;
var statearr_54861_55144 = state_54822;
(statearr_54861_55144[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_54822[(4)]))){
var statearr_54862_55145 = state_54822;
(statearr_54862_55145[(1)] = cljs.core.first((state_54822[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55146 = state_54822;
state_54822 = G__55146;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto__ = function(state_54822){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto____1.call(this,state_54822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto____0;
deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto____1;
return deercreeklabs$tube$client$_LT_connect_$_state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_54863 = f__42470__auto__();
(statearr_54863[(6)] = c__42469__auto__);

return statearr_54863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

return c__42469__auto__;
});
var ufv___55147 = schema.utils.use_fn_validation;
var output_schema54865_55148 = schema.core.Any;
var input_schema54866_55149 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_schema54870_55150 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)], 0)),schema.core.optional_key(new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"logger","logger",-220675947)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one(schema.core.Str,new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null)], null)),schema.core.optional_key(new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),schema.core.Bool,schema.core.optional_key(new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null)),schema.core.optional_key(new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null))]),cljs.core.with_meta(new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),cljs.core.list(new cljs.core.Symbol("s","enum","s/enum",-975416934,null),new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"logger","logger",-220675947)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)], null)))], null);
var input_checker54867_55151 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54866_55149);
}),null));
var output_checker54868_55152 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54865_55148);
}),null));
var input_checker54871_55153 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54870_55150);
}),null));
var output_checker54872_55154 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54865_55148);
}),null));
var ret__52081__auto___55160 = (function (){
/**
 * Inputs: ([url :- s/Str] [url :- s/Str options :- {(s/optional-key :compression-type) (s/enum :none :smart :deflate), (s/optional-key :connect-timeout-ms) s/Int, (s/optional-key :keep-alive-secs) s/Int, (s/optional-key :logger) (s/=> s/Any s/Keyword s/Str), (s/optional-key :log-conn-failure?) s/Bool, (s/optional-key :on-disconnect) (s/=> s/Any), (s/optional-key :on-rcv) (s/=> s/Any)}])
 * 
 *   Will return a connected client or a closed channel (nil) on connection
 * failure or timeout.
 */
deercreeklabs.tube.client._LT_tube_client = (function deercreeklabs$tube$client$_LT_tube_client(var_args){
var G__54876 = arguments.length;
switch (G__54876) {
case 1:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1 = (function (G__54869){
var validate__49990__auto__ = cljs.core.deref(ufv___55147);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___55163 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54869], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54877_55164 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54878_55165 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__54879_55166 = input_schema54866_55149;
var G__54880_55167 = cljs.core.deref(input_checker54867_55151);
var G__54881_55168 = args__49991__auto___55163;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54877_55164,G__54878_55165,G__54879_55166,G__54880_55167,G__54881_55168) : schema.core.fn_validator.call(null,G__54877_55164,G__54878_55165,G__54879_55166,G__54880_55167,G__54881_55168));
} else {
var temp__5753__auto___55169 = (function (){var fexpr__54882 = cljs.core.deref(input_checker54867_55151);
return (fexpr__54882.cljs$core$IFn$_invoke$arity$1 ? fexpr__54882.cljs$core$IFn$_invoke$arity$1(args__49991__auto___55163) : fexpr__54882.call(null,args__49991__auto___55163));
})();
if(cljs.core.truth_(temp__5753__auto___55169)){
var error__49992__auto___55171 = temp__5753__auto___55169;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___55171], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54866_55149,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___55163,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___55171], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var url = G__54869;
while(true){
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2(url,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54883_55176 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54884_55177 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__54885_55178 = output_schema54865_55148;
var G__54886_55179 = cljs.core.deref(output_checker54868_55152);
var G__54887_55180 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54883_55176,G__54884_55177,G__54885_55178,G__54886_55179,G__54887_55180) : schema.core.fn_validator.call(null,G__54883_55176,G__54884_55177,G__54885_55178,G__54886_55179,G__54887_55180));
} else {
var temp__5753__auto___55182 = (function (){var fexpr__54888 = cljs.core.deref(output_checker54868_55152);
return (fexpr__54888.cljs$core$IFn$_invoke$arity$1 ? fexpr__54888.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__54888.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___55182)){
var error__49992__auto___55183 = temp__5753__auto___55182;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___55183], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54865_55148,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___55183], null));
} else {
}
}
} else {
}

return o__49994__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2 = (function (G__54873,G__54874){
var validate__49990__auto__ = cljs.core.deref(ufv___55147);
if(cljs.core.truth_(validate__49990__auto__)){
var args__49991__auto___55186 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54873,G__54874], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54889_55187 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54890_55188 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__54891_55189 = input_schema54870_55150;
var G__54892_55190 = cljs.core.deref(input_checker54871_55153);
var G__54893_55191 = args__49991__auto___55186;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54889_55187,G__54890_55188,G__54891_55189,G__54892_55190,G__54893_55191) : schema.core.fn_validator.call(null,G__54889_55187,G__54890_55188,G__54891_55189,G__54892_55190,G__54893_55191));
} else {
var temp__5753__auto___55194 = (function (){var fexpr__54894 = cljs.core.deref(input_checker54871_55153);
return (fexpr__54894.cljs$core$IFn$_invoke$arity$1 ? fexpr__54894.cljs$core$IFn$_invoke$arity$1(args__49991__auto___55186) : fexpr__54894.call(null,args__49991__auto___55186));
})();
if(cljs.core.truth_(temp__5753__auto___55194)){
var error__49992__auto___55196 = temp__5753__auto___55194;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___55196], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54870_55150,new cljs.core.Keyword(null,"value","value",305978217),args__49991__auto___55186,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___55196], null));
} else {
}
}
} else {
}

var o__49994__auto__ = (function (){var url = G__54873;
var options = G__54874;
while(true){
var c__42469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__42469__auto__,validate__49990__auto__,ufv___55147,output_schema54865_55148,input_schema54866_55149,input_schema54870_55150,input_checker54867_55151,output_checker54868_55152,input_checker54871_55153,output_checker54872_55154){
return (function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_54952){
var state_val_54953 = (state_54952[(1)]);
if((state_val_54953 === (7))){
var inst_54933 = (state_54952[(7)]);
var state_54952__$1 = state_54952;
var statearr_54954_55201 = state_54952__$1;
(statearr_54954_55201[(2)] = inst_54933);

(statearr_54954_55201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (1))){
var state_54952__$1 = state_54952;
var statearr_54955_55203 = state_54952__$1;
(statearr_54955_55203[(2)] = null);

(statearr_54955_55203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (4))){
var inst_54895 = (state_54952[(2)]);
var state_54952__$1 = state_54952;
var statearr_54956_55205 = state_54952__$1;
(statearr_54956_55205[(2)] = inst_54895);

(statearr_54956_55205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (13))){
var inst_54943 = (state_54952[(2)]);
var inst_54944 = deercreeklabs.async_utils.check(inst_54943);
var state_54952__$1 = state_54952;
var statearr_54957_55208 = state_54952__$1;
(statearr_54957_55208[(2)] = inst_54944);

(statearr_54957_55208[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (6))){
var inst_54917 = (state_54952[(8)]);
var inst_54926 = (state_54952[(2)]);
var inst_54927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54926,(0),null);
var inst_54928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54926,(1),null);
var inst_54929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54930 = deercreeklabs.async_utils.check(inst_54927);
var inst_54931 = [inst_54930,inst_54928];
var inst_54932 = (new cljs.core.PersistentVector(null,2,(5),inst_54929,inst_54931,null));
var inst_54933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54932,(0),null);
var inst_54934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54932,(1),null);
var inst_54935 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_54917,inst_54934);
var state_54952__$1 = (function (){var statearr_54958 = state_54952;
(statearr_54958[(7)] = inst_54933);

return statearr_54958;
})();
if(inst_54935){
var statearr_54959_55210 = state_54952__$1;
(statearr_54959_55210[(1)] = (7));

} else {
var statearr_54960_55211 = state_54952__$1;
(statearr_54960_55211[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (3))){
var inst_54950 = (state_54952[(2)]);
var state_54952__$1 = state_54952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54952__$1,inst_54950);
} else {
if((state_val_54953 === (12))){
var inst_54947 = (state_54952[(2)]);
var _ = (function (){var statearr_54961 = state_54952;
(statearr_54961[(4)] = cljs.core.rest((state_54952[(4)])));

return statearr_54961;
})();
var state_54952__$1 = state_54952;
var statearr_54962_55212 = state_54952__$1;
(statearr_54962_55212[(2)] = inst_54947);

(statearr_54962_55212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (2))){
var inst_54912 = (state_54952[(9)]);
var inst_54907 = (state_54952[(10)]);
var inst_54914 = (state_54952[(11)]);
var inst_54917 = (state_54952[(8)]);
var inst_54913 = (state_54952[(12)]);
var _ = (function (){var statearr_54963 = state_54952;
(statearr_54963[(4)] = cljs.core.cons((5),(state_54952[(4)])));

return statearr_54963;
})();
var inst_54905 = options;
var inst_54906 = cljs.core.__destructure_map(inst_54905);
var inst_54907__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54906,new cljs.core.Keyword(null,"logger","logger",-220675947),deercreeklabs.tube.utils.println_logger);
var inst_54908 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54906,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_54909 = cljs.core.constantly(null);
var inst_54910 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54906,new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814),inst_54909);
var inst_54911 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_54906,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(10000));
var inst_54912__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var inst_54913__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var inst_54914__$1 = (function (){var map__54901 = inst_54906;
var logger = inst_54907__$1;
var log_conn_failure_QMARK_ = inst_54908;
var on_disconnect = inst_54910;
var connect_timeout_ms = inst_54911;
var _STAR_shutdown_QMARK_ = inst_54912__$1;
var _STAR_conn = inst_54913__$1;
return (function (code,reason,ws_already_closed_QMARK_){
var conn = cljs.core.deref(_STAR_conn);
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(conn)){
deercreeklabs.tube.connection.close(conn,code,reason,ws_already_closed_QMARK_);
} else {
}

return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(conn,code,reason) : on_disconnect.call(null,conn,code,reason));
});
})();
var inst_54915 = (function (){var map__54901 = inst_54906;
var logger = inst_54907__$1;
var log_conn_failure_QMARK_ = inst_54908;
var on_disconnect = inst_54910;
var connect_timeout_ms = inst_54911;
var _STAR_shutdown_QMARK_ = inst_54912__$1;
var _STAR_conn = inst_54913__$1;
var close_client_BANG_ = inst_54914__$1;
return (function (msg){
try{var G__54967_55219 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__54968_55220 = ["Error in websocket: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__54967_55219,G__54968_55220) : logger.call(null,G__54967_55219,G__54968_55220));

return close_client_BANG_((1011),msg,true);
}catch (e54964){if((e54964 instanceof Error)){
var e = e54964;
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error.") : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error."));

var G__54965 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__54966 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(e);
return (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__54965,G__54966) : logger.call(null,G__54965,G__54966));
} else {
throw e54964;

}
}});
})();
var inst_54916 = (function (){var on_error = inst_54915;
var connect_timeout_ms = inst_54911;
var map__54901 = inst_54906;
var close_client_BANG_ = inst_54914__$1;
var on_disconnect = inst_54910;
var _STAR_conn = inst_54913__$1;
var log_conn_failure_QMARK_ = inst_54908;
var logger = inst_54907__$1;
var _STAR_shutdown_QMARK_ = inst_54912__$1;
return (function (p1__54864_SHARP_){
var temp__5753__auto__ = cljs.core.deref(_STAR_conn);
if(cljs.core.truth_(temp__5753__auto__)){
var conn = temp__5753__auto__;
return deercreeklabs.tube.connection.handle_data(conn,p1__54864_SHARP_);
} else {
return null;
}
});
})();
var inst_54917__$1 = deercreeklabs.tube.client._LT_ws_client_cljs(inst_54907__$1,url,inst_54915,inst_54910,inst_54916,inst_54908,inst_54913__$1,inst_54912__$1);
var inst_54921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54922 = cljs.core.async.timeout(inst_54911);
var inst_54923 = [inst_54917__$1,inst_54922];
var inst_54924 = (new cljs.core.PersistentVector(null,2,(5),inst_54921,inst_54923,null));
var state_54952__$1 = (function (){var statearr_54969 = state_54952;
(statearr_54969[(9)] = inst_54912__$1);

(statearr_54969[(10)] = inst_54907__$1);

(statearr_54969[(11)] = inst_54914__$1);

(statearr_54969[(8)] = inst_54917__$1);

(statearr_54969[(12)] = inst_54913__$1);

return statearr_54969;
})();
return cljs.core.async.ioc_alts_BANG_(state_54952__$1,(6),inst_54924);
} else {
if((state_val_54953 === (11))){
var state_54952__$1 = state_54952;
var statearr_54971_55289 = state_54952__$1;
(statearr_54971_55289[(2)] = null);

(statearr_54971_55289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (9))){
var inst_54939 = (state_54952[(2)]);
var state_54952__$1 = state_54952;
if(cljs.core.truth_(inst_54939)){
var statearr_54972_55299 = state_54952__$1;
(statearr_54972_55299[(1)] = (10));

} else {
var statearr_54973_55302 = state_54952__$1;
(statearr_54973_55302[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (5))){
var _ = (function (){var statearr_54974 = state_54952;
(statearr_54974[(4)] = cljs.core.rest((state_54952[(4)])));

return statearr_54974;
})();
var state_54952__$1 = state_54952;
var ex54970 = (state_54952__$1[(2)]);
var statearr_54975_55317 = state_54952__$1;
(statearr_54975_55317[(5)] = ex54970);


var statearr_54976_55319 = state_54952__$1;
(statearr_54976_55319[(1)] = (4));

(statearr_54976_55319[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54953 === (10))){
var inst_54912 = (state_54952[(9)]);
var inst_54907 = (state_54952[(10)]);
var inst_54914 = (state_54952[(11)]);
var inst_54933 = (state_54952[(7)]);
var inst_54913 = (state_54952[(12)]);
var inst_54941 = deercreeklabs.tube.client._LT_connect(inst_54933,url,inst_54907,options,inst_54914,inst_54913,inst_54912);
var state_54952__$1 = state_54952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54952__$1,(13),inst_54941);
} else {
if((state_val_54953 === (8))){
var state_54952__$1 = state_54952;
var statearr_54977_55343 = state_54952__$1;
(statearr_54977_55343[(2)] = false);

(statearr_54977_55343[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$state_machine__42025__auto__ = null;
var deercreeklabs$tube$client$state_machine__42025__auto____0 = (function (){
var statearr_54978 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54978[(0)] = deercreeklabs$tube$client$state_machine__42025__auto__);

(statearr_54978[(1)] = (1));

return statearr_54978;
});
var deercreeklabs$tube$client$state_machine__42025__auto____1 = (function (state_54952){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_54952);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e54979){var ex__42028__auto__ = e54979;
var statearr_54980_55369 = state_54952;
(statearr_54980_55369[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_54952[(4)]))){
var statearr_54981_55374 = state_54952;
(statearr_54981_55374[(1)] = cljs.core.first((state_54952[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55384 = state_54952;
state_54952 = G__55384;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
deercreeklabs$tube$client$state_machine__42025__auto__ = function(state_54952){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$state_machine__42025__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$state_machine__42025__auto____1.call(this,state_54952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$state_machine__42025__auto____0;
deercreeklabs$tube$client$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$state_machine__42025__auto____1;
return deercreeklabs$tube$client$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_54982 = f__42470__auto__();
(statearr_54982[(6)] = c__42469__auto__);

return statearr_54982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
});})(c__42469__auto__,validate__49990__auto__,ufv___55147,output_schema54865_55148,input_schema54866_55149,input_schema54870_55150,input_checker54867_55151,output_checker54868_55152,input_checker54871_55153,output_checker54872_55154))
);

return c__42469__auto__;
break;
}
})();
if(cljs.core.truth_(validate__49990__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54983_55405 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54984_55406 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__54985_55407 = output_schema54865_55148;
var G__54986_55408 = cljs.core.deref(output_checker54872_55154);
var G__54987_55409 = o__49994__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54983_55405,G__54984_55406,G__54985_55407,G__54986_55408,G__54987_55409) : schema.core.fn_validator.call(null,G__54983_55405,G__54984_55406,G__54985_55407,G__54986_55408,G__54987_55409));
} else {
var temp__5753__auto___55427 = (function (){var fexpr__54988 = cljs.core.deref(output_checker54872_55154);
return (fexpr__54988.cljs$core$IFn$_invoke$arity$1 ? fexpr__54988.cljs$core$IFn$_invoke$arity$1(o__49994__auto__) : fexpr__54988.call(null,o__49994__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___55427)){
var error__49992__auto___55436 = temp__5753__auto___55427;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__49992__auto___55436], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54865_55148,new cljs.core.Keyword(null,"value","value",305978217),o__49994__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__49992__auto___55436], null));
} else {
}
}
} else {
}

return o__49994__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.tube.client._LT_tube_client),schema.core.make_fn_schema(output_schema54865_55148,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54866_55149,input_schema54870_55150], null)));


//# sourceMappingURL=deercreeklabs.tube.client.js.map
