goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47319 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47319(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47322 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47322(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__45994 = coll;
var G__45995 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__45994,G__45995) : shadow.dom.lazy_native_coll_seq.call(null,G__45994,G__45995));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4160__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46054 = arguments.length;
switch (G__46054) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46062 = arguments.length;
switch (G__46062) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46073 = arguments.length;
switch (G__46073) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46083 = arguments.length;
switch (G__46083) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46109 = arguments.length;
switch (G__46109) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46119 = arguments.length;
switch (G__46119) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e46130){if((e46130 instanceof Object)){
var e = e46130;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46130;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46144 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__46145 = null;
var count__46146 = (0);
var i__46147 = (0);
while(true){
if((i__46147 < count__46146)){
var el = chunk__46145.cljs$core$IIndexed$_nth$arity$2(null,i__46147);
var handler_47413__$1 = ((function (seq__46144,chunk__46145,count__46146,i__46147,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46144,chunk__46145,count__46146,i__46147,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47413__$1);


var G__47414 = seq__46144;
var G__47415 = chunk__46145;
var G__47416 = count__46146;
var G__47417 = (i__46147 + (1));
seq__46144 = G__47414;
chunk__46145 = G__47415;
count__46146 = G__47416;
i__46147 = G__47417;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__46144);
if(temp__5753__auto__){
var seq__46144__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46144__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46144__$1);
var G__47419 = cljs.core.chunk_rest(seq__46144__$1);
var G__47420 = c__4591__auto__;
var G__47421 = cljs.core.count(c__4591__auto__);
var G__47422 = (0);
seq__46144 = G__47419;
chunk__46145 = G__47420;
count__46146 = G__47421;
i__46147 = G__47422;
continue;
} else {
var el = cljs.core.first(seq__46144__$1);
var handler_47427__$1 = ((function (seq__46144,chunk__46145,count__46146,i__46147,el,seq__46144__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46144,chunk__46145,count__46146,i__46147,el,seq__46144__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47427__$1);


var G__47431 = cljs.core.next(seq__46144__$1);
var G__47432 = null;
var G__47433 = (0);
var G__47434 = (0);
seq__46144 = G__47431;
chunk__46145 = G__47432;
count__46146 = G__47433;
i__46147 = G__47434;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46178 = arguments.length;
switch (G__46178) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46203 = cljs.core.seq(events);
var chunk__46204 = null;
var count__46205 = (0);
var i__46206 = (0);
while(true){
if((i__46206 < count__46205)){
var vec__46220 = chunk__46204.cljs$core$IIndexed$_nth$arity$2(null,i__46206);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46220,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46220,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47463 = seq__46203;
var G__47464 = chunk__46204;
var G__47465 = count__46205;
var G__47466 = (i__46206 + (1));
seq__46203 = G__47463;
chunk__46204 = G__47464;
count__46205 = G__47465;
i__46206 = G__47466;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__46203);
if(temp__5753__auto__){
var seq__46203__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46203__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46203__$1);
var G__47475 = cljs.core.chunk_rest(seq__46203__$1);
var G__47476 = c__4591__auto__;
var G__47477 = cljs.core.count(c__4591__auto__);
var G__47478 = (0);
seq__46203 = G__47475;
chunk__46204 = G__47476;
count__46205 = G__47477;
i__46206 = G__47478;
continue;
} else {
var vec__46231 = cljs.core.first(seq__46203__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46231,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46231,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47487 = cljs.core.next(seq__46203__$1);
var G__47488 = null;
var G__47489 = (0);
var G__47490 = (0);
seq__46203 = G__47487;
chunk__46204 = G__47488;
count__46205 = G__47489;
i__46206 = G__47490;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__46245 = cljs.core.seq(styles);
var chunk__46246 = null;
var count__46247 = (0);
var i__46248 = (0);
while(true){
if((i__46248 < count__46247)){
var vec__46265 = chunk__46246.cljs$core$IIndexed$_nth$arity$2(null,i__46248);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46265,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46265,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47499 = seq__46245;
var G__47500 = chunk__46246;
var G__47501 = count__46247;
var G__47502 = (i__46248 + (1));
seq__46245 = G__47499;
chunk__46246 = G__47500;
count__46247 = G__47501;
i__46248 = G__47502;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__46245);
if(temp__5753__auto__){
var seq__46245__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46245__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46245__$1);
var G__47507 = cljs.core.chunk_rest(seq__46245__$1);
var G__47508 = c__4591__auto__;
var G__47509 = cljs.core.count(c__4591__auto__);
var G__47510 = (0);
seq__46245 = G__47507;
chunk__46246 = G__47508;
count__46247 = G__47509;
i__46248 = G__47510;
continue;
} else {
var vec__46269 = cljs.core.first(seq__46245__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46269,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46269,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47519 = cljs.core.next(seq__46245__$1);
var G__47520 = null;
var G__47521 = (0);
var G__47522 = (0);
seq__46245 = G__47519;
chunk__46246 = G__47520;
count__46247 = G__47521;
i__46248 = G__47522;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46275_47526 = key;
var G__46275_47527__$1 = (((G__46275_47526 instanceof cljs.core.Keyword))?G__46275_47526.fqn:null);
switch (G__46275_47527__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47544 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4160__auto__ = goog.string.startsWith(ks_47544,"data-");
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return goog.string.startsWith(ks_47544,"aria-");
}
})())){
el.setAttribute(ks_47544,value);
} else {
(el[ks_47544] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46335){
var map__46336 = p__46335;
var map__46336__$1 = cljs.core.__destructure_map(map__46336);
var props = map__46336__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46336__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46337 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46337,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46337,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46337,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__46344 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__46344,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46344;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46348 = arguments.length;
switch (G__46348) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46370){
var vec__46371 = p__46370;
var seq__46372 = cljs.core.seq(vec__46371);
var first__46373 = cljs.core.first(seq__46372);
var seq__46372__$1 = cljs.core.next(seq__46372);
var nn = first__46373;
var first__46373__$1 = cljs.core.first(seq__46372__$1);
var seq__46372__$2 = cljs.core.next(seq__46372__$1);
var np = first__46373__$1;
var nc = seq__46372__$2;
var node = vec__46371;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46379 = nn;
var G__46380 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46379,G__46380) : create_fn.call(null,G__46379,G__46380));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46381 = nn;
var G__46382 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46381,G__46382) : create_fn.call(null,G__46381,G__46382));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46383 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46383,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46383,(1),null);
var seq__46386_47615 = cljs.core.seq(node_children);
var chunk__46387_47616 = null;
var count__46388_47617 = (0);
var i__46389_47618 = (0);
while(true){
if((i__46389_47618 < count__46388_47617)){
var child_struct_47621 = chunk__46387_47616.cljs$core$IIndexed$_nth$arity$2(null,i__46389_47618);
var children_47624 = shadow.dom.dom_node(child_struct_47621);
if(cljs.core.seq_QMARK_(children_47624)){
var seq__46436_47625 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47624));
var chunk__46438_47626 = null;
var count__46439_47627 = (0);
var i__46440_47628 = (0);
while(true){
if((i__46440_47628 < count__46439_47627)){
var child_47632 = chunk__46438_47626.cljs$core$IIndexed$_nth$arity$2(null,i__46440_47628);
if(cljs.core.truth_(child_47632)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47632);


var G__47634 = seq__46436_47625;
var G__47635 = chunk__46438_47626;
var G__47636 = count__46439_47627;
var G__47637 = (i__46440_47628 + (1));
seq__46436_47625 = G__47634;
chunk__46438_47626 = G__47635;
count__46439_47627 = G__47636;
i__46440_47628 = G__47637;
continue;
} else {
var G__47639 = seq__46436_47625;
var G__47640 = chunk__46438_47626;
var G__47641 = count__46439_47627;
var G__47642 = (i__46440_47628 + (1));
seq__46436_47625 = G__47639;
chunk__46438_47626 = G__47640;
count__46439_47627 = G__47641;
i__46440_47628 = G__47642;
continue;
}
} else {
var temp__5753__auto___47647 = cljs.core.seq(seq__46436_47625);
if(temp__5753__auto___47647){
var seq__46436_47648__$1 = temp__5753__auto___47647;
if(cljs.core.chunked_seq_QMARK_(seq__46436_47648__$1)){
var c__4591__auto___47649 = cljs.core.chunk_first(seq__46436_47648__$1);
var G__47650 = cljs.core.chunk_rest(seq__46436_47648__$1);
var G__47651 = c__4591__auto___47649;
var G__47652 = cljs.core.count(c__4591__auto___47649);
var G__47653 = (0);
seq__46436_47625 = G__47650;
chunk__46438_47626 = G__47651;
count__46439_47627 = G__47652;
i__46440_47628 = G__47653;
continue;
} else {
var child_47657 = cljs.core.first(seq__46436_47648__$1);
if(cljs.core.truth_(child_47657)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47657);


var G__47661 = cljs.core.next(seq__46436_47648__$1);
var G__47662 = null;
var G__47663 = (0);
var G__47664 = (0);
seq__46436_47625 = G__47661;
chunk__46438_47626 = G__47662;
count__46439_47627 = G__47663;
i__46440_47628 = G__47664;
continue;
} else {
var G__47665 = cljs.core.next(seq__46436_47648__$1);
var G__47666 = null;
var G__47667 = (0);
var G__47668 = (0);
seq__46436_47625 = G__47665;
chunk__46438_47626 = G__47666;
count__46439_47627 = G__47667;
i__46440_47628 = G__47668;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47624);
}


var G__47677 = seq__46386_47615;
var G__47678 = chunk__46387_47616;
var G__47679 = count__46388_47617;
var G__47680 = (i__46389_47618 + (1));
seq__46386_47615 = G__47677;
chunk__46387_47616 = G__47678;
count__46388_47617 = G__47679;
i__46389_47618 = G__47680;
continue;
} else {
var temp__5753__auto___47681 = cljs.core.seq(seq__46386_47615);
if(temp__5753__auto___47681){
var seq__46386_47683__$1 = temp__5753__auto___47681;
if(cljs.core.chunked_seq_QMARK_(seq__46386_47683__$1)){
var c__4591__auto___47684 = cljs.core.chunk_first(seq__46386_47683__$1);
var G__47685 = cljs.core.chunk_rest(seq__46386_47683__$1);
var G__47686 = c__4591__auto___47684;
var G__47687 = cljs.core.count(c__4591__auto___47684);
var G__47688 = (0);
seq__46386_47615 = G__47685;
chunk__46387_47616 = G__47686;
count__46388_47617 = G__47687;
i__46389_47618 = G__47688;
continue;
} else {
var child_struct_47689 = cljs.core.first(seq__46386_47683__$1);
var children_47693 = shadow.dom.dom_node(child_struct_47689);
if(cljs.core.seq_QMARK_(children_47693)){
var seq__46446_47696 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47693));
var chunk__46448_47697 = null;
var count__46449_47698 = (0);
var i__46450_47699 = (0);
while(true){
if((i__46450_47699 < count__46449_47698)){
var child_47701 = chunk__46448_47697.cljs$core$IIndexed$_nth$arity$2(null,i__46450_47699);
if(cljs.core.truth_(child_47701)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47701);


var G__47702 = seq__46446_47696;
var G__47703 = chunk__46448_47697;
var G__47704 = count__46449_47698;
var G__47705 = (i__46450_47699 + (1));
seq__46446_47696 = G__47702;
chunk__46448_47697 = G__47703;
count__46449_47698 = G__47704;
i__46450_47699 = G__47705;
continue;
} else {
var G__47710 = seq__46446_47696;
var G__47711 = chunk__46448_47697;
var G__47712 = count__46449_47698;
var G__47713 = (i__46450_47699 + (1));
seq__46446_47696 = G__47710;
chunk__46448_47697 = G__47711;
count__46449_47698 = G__47712;
i__46450_47699 = G__47713;
continue;
}
} else {
var temp__5753__auto___47714__$1 = cljs.core.seq(seq__46446_47696);
if(temp__5753__auto___47714__$1){
var seq__46446_47715__$1 = temp__5753__auto___47714__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46446_47715__$1)){
var c__4591__auto___47716 = cljs.core.chunk_first(seq__46446_47715__$1);
var G__47717 = cljs.core.chunk_rest(seq__46446_47715__$1);
var G__47719 = c__4591__auto___47716;
var G__47720 = cljs.core.count(c__4591__auto___47716);
var G__47721 = (0);
seq__46446_47696 = G__47717;
chunk__46448_47697 = G__47719;
count__46449_47698 = G__47720;
i__46450_47699 = G__47721;
continue;
} else {
var child_47722 = cljs.core.first(seq__46446_47715__$1);
if(cljs.core.truth_(child_47722)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47722);


var G__47727 = cljs.core.next(seq__46446_47715__$1);
var G__47728 = null;
var G__47729 = (0);
var G__47730 = (0);
seq__46446_47696 = G__47727;
chunk__46448_47697 = G__47728;
count__46449_47698 = G__47729;
i__46450_47699 = G__47730;
continue;
} else {
var G__47735 = cljs.core.next(seq__46446_47715__$1);
var G__47736 = null;
var G__47737 = (0);
var G__47738 = (0);
seq__46446_47696 = G__47735;
chunk__46448_47697 = G__47736;
count__46449_47698 = G__47737;
i__46450_47699 = G__47738;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47693);
}


var G__47739 = cljs.core.next(seq__46386_47683__$1);
var G__47740 = null;
var G__47741 = (0);
var G__47742 = (0);
seq__46386_47615 = G__47739;
chunk__46387_47616 = G__47740;
count__46388_47617 = G__47741;
i__46389_47618 = G__47742;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46508 = cljs.core.seq(node);
var chunk__46509 = null;
var count__46510 = (0);
var i__46511 = (0);
while(true){
if((i__46511 < count__46510)){
var n = chunk__46509.cljs$core$IIndexed$_nth$arity$2(null,i__46511);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47764 = seq__46508;
var G__47765 = chunk__46509;
var G__47766 = count__46510;
var G__47767 = (i__46511 + (1));
seq__46508 = G__47764;
chunk__46509 = G__47765;
count__46510 = G__47766;
i__46511 = G__47767;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__46508);
if(temp__5753__auto__){
var seq__46508__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46508__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46508__$1);
var G__47769 = cljs.core.chunk_rest(seq__46508__$1);
var G__47770 = c__4591__auto__;
var G__47771 = cljs.core.count(c__4591__auto__);
var G__47772 = (0);
seq__46508 = G__47769;
chunk__46509 = G__47770;
count__46510 = G__47771;
i__46511 = G__47772;
continue;
} else {
var n = cljs.core.first(seq__46508__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47776 = cljs.core.next(seq__46508__$1);
var G__47777 = null;
var G__47778 = (0);
var G__47779 = (0);
seq__46508 = G__47776;
chunk__46509 = G__47777;
count__46510 = G__47778;
i__46511 = G__47779;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46521 = arguments.length;
switch (G__46521) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46526 = arguments.length;
switch (G__46526) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46535 = arguments.length;
switch (G__46535) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4160__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4777__auto__ = [];
var len__4771__auto___47824 = arguments.length;
var i__4772__auto___47825 = (0);
while(true){
if((i__4772__auto___47825 < len__4771__auto___47824)){
args__4777__auto__.push((arguments[i__4772__auto___47825]));

var G__47828 = (i__4772__auto___47825 + (1));
i__4772__auto___47825 = G__47828;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46556_47833 = cljs.core.seq(nodes);
var chunk__46557_47834 = null;
var count__46558_47835 = (0);
var i__46559_47836 = (0);
while(true){
if((i__46559_47836 < count__46558_47835)){
var node_47842 = chunk__46557_47834.cljs$core$IIndexed$_nth$arity$2(null,i__46559_47836);
fragment.appendChild(shadow.dom._to_dom(node_47842));


var G__47843 = seq__46556_47833;
var G__47844 = chunk__46557_47834;
var G__47845 = count__46558_47835;
var G__47846 = (i__46559_47836 + (1));
seq__46556_47833 = G__47843;
chunk__46557_47834 = G__47844;
count__46558_47835 = G__47845;
i__46559_47836 = G__47846;
continue;
} else {
var temp__5753__auto___47847 = cljs.core.seq(seq__46556_47833);
if(temp__5753__auto___47847){
var seq__46556_47848__$1 = temp__5753__auto___47847;
if(cljs.core.chunked_seq_QMARK_(seq__46556_47848__$1)){
var c__4591__auto___47850 = cljs.core.chunk_first(seq__46556_47848__$1);
var G__47851 = cljs.core.chunk_rest(seq__46556_47848__$1);
var G__47852 = c__4591__auto___47850;
var G__47853 = cljs.core.count(c__4591__auto___47850);
var G__47854 = (0);
seq__46556_47833 = G__47851;
chunk__46557_47834 = G__47852;
count__46558_47835 = G__47853;
i__46559_47836 = G__47854;
continue;
} else {
var node_47855 = cljs.core.first(seq__46556_47848__$1);
fragment.appendChild(shadow.dom._to_dom(node_47855));


var G__47856 = cljs.core.next(seq__46556_47848__$1);
var G__47857 = null;
var G__47858 = (0);
var G__47859 = (0);
seq__46556_47833 = G__47856;
chunk__46557_47834 = G__47857;
count__46558_47835 = G__47858;
i__46559_47836 = G__47859;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46548){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46548));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46576_47870 = cljs.core.seq(scripts);
var chunk__46577_47871 = null;
var count__46578_47872 = (0);
var i__46579_47873 = (0);
while(true){
if((i__46579_47873 < count__46578_47872)){
var vec__46594_47875 = chunk__46577_47871.cljs$core$IIndexed$_nth$arity$2(null,i__46579_47873);
var script_tag_47876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46594_47875,(0),null);
var script_body_47877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46594_47875,(1),null);
eval(script_body_47877);


var G__47878 = seq__46576_47870;
var G__47879 = chunk__46577_47871;
var G__47880 = count__46578_47872;
var G__47881 = (i__46579_47873 + (1));
seq__46576_47870 = G__47878;
chunk__46577_47871 = G__47879;
count__46578_47872 = G__47880;
i__46579_47873 = G__47881;
continue;
} else {
var temp__5753__auto___47882 = cljs.core.seq(seq__46576_47870);
if(temp__5753__auto___47882){
var seq__46576_47883__$1 = temp__5753__auto___47882;
if(cljs.core.chunked_seq_QMARK_(seq__46576_47883__$1)){
var c__4591__auto___47884 = cljs.core.chunk_first(seq__46576_47883__$1);
var G__47886 = cljs.core.chunk_rest(seq__46576_47883__$1);
var G__47887 = c__4591__auto___47884;
var G__47888 = cljs.core.count(c__4591__auto___47884);
var G__47889 = (0);
seq__46576_47870 = G__47886;
chunk__46577_47871 = G__47887;
count__46578_47872 = G__47888;
i__46579_47873 = G__47889;
continue;
} else {
var vec__46599_47890 = cljs.core.first(seq__46576_47883__$1);
var script_tag_47891 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46599_47890,(0),null);
var script_body_47892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46599_47890,(1),null);
eval(script_body_47892);


var G__47897 = cljs.core.next(seq__46576_47883__$1);
var G__47898 = null;
var G__47899 = (0);
var G__47900 = (0);
seq__46576_47870 = G__47897;
chunk__46577_47871 = G__47898;
count__46578_47872 = G__47899;
i__46579_47873 = G__47900;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__46603){
var vec__46605 = p__46603;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46605,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46605,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46622 = arguments.length;
switch (G__46622) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__46641 = cljs.core.seq(style_keys);
var chunk__46642 = null;
var count__46643 = (0);
var i__46644 = (0);
while(true){
if((i__46644 < count__46643)){
var it = chunk__46642.cljs$core$IIndexed$_nth$arity$2(null,i__46644);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47930 = seq__46641;
var G__47931 = chunk__46642;
var G__47932 = count__46643;
var G__47933 = (i__46644 + (1));
seq__46641 = G__47930;
chunk__46642 = G__47931;
count__46643 = G__47932;
i__46644 = G__47933;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__46641);
if(temp__5753__auto__){
var seq__46641__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46641__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46641__$1);
var G__47935 = cljs.core.chunk_rest(seq__46641__$1);
var G__47936 = c__4591__auto__;
var G__47937 = cljs.core.count(c__4591__auto__);
var G__47938 = (0);
seq__46641 = G__47935;
chunk__46642 = G__47936;
count__46643 = G__47937;
i__46644 = G__47938;
continue;
} else {
var it = cljs.core.first(seq__46641__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47941 = cljs.core.next(seq__46641__$1);
var G__47942 = null;
var G__47943 = (0);
var G__47944 = (0);
seq__46641 = G__47941;
chunk__46642 = G__47942;
count__46643 = G__47943;
i__46644 = G__47944;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k46656,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__46667 = k46656;
var G__46667__$1 = (((G__46667 instanceof cljs.core.Keyword))?G__46667.fqn:null);
switch (G__46667__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46656,else__4418__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__46671){
var vec__46672 = p__46671;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46672,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46672,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46655){
var self__ = this;
var G__46655__$1 = this;
return (new cljs.core.RecordIter((0),G__46655__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46657,other46658){
var self__ = this;
var this46657__$1 = this;
return (((!((other46658 == null)))) && ((this46657__$1.constructor === other46658.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46657__$1.x,other46658.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46657__$1.y,other46658.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46657__$1.__extmap,other46658.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__46655){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__46686 = cljs.core.keyword_identical_QMARK_;
var expr__46687 = k__4423__auto__;
if(cljs.core.truth_((pred__46686.cljs$core$IFn$_invoke$arity$2 ? pred__46686.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__46687) : pred__46686.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46687)))){
return (new shadow.dom.Coordinate(G__46655,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46686.cljs$core$IFn$_invoke$arity$2 ? pred__46686.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__46687) : pred__46686.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46687)))){
return (new shadow.dom.Coordinate(self__.x,G__46655,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__46655),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__46655){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46655,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46660){
var extmap__4454__auto__ = (function (){var G__46705 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46660,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__46660)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46705);
} else {
return G__46705;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46660),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46660),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k46716,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__46725 = k46716;
var G__46725__$1 = (((G__46725 instanceof cljs.core.Keyword))?G__46725.fqn:null);
switch (G__46725__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46716,else__4418__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__46730){
var vec__46731 = p__46730;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46731,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46731,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Size{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46715){
var self__ = this;
var G__46715__$1 = this;
return (new cljs.core.RecordIter((0),G__46715__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46717,other46718){
var self__ = this;
var this46717__$1 = this;
return (((!((other46718 == null)))) && ((this46717__$1.constructor === other46718.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46717__$1.w,other46718.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46717__$1.h,other46718.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46717__$1.__extmap,other46718.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__46715){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__46742 = cljs.core.keyword_identical_QMARK_;
var expr__46743 = k__4423__auto__;
if(cljs.core.truth_((pred__46742.cljs$core$IFn$_invoke$arity$2 ? pred__46742.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__46743) : pred__46742.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46743)))){
return (new shadow.dom.Size(G__46715,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46742.cljs$core$IFn$_invoke$arity$2 ? pred__46742.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__46743) : pred__46742.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46743)))){
return (new shadow.dom.Size(self__.w,G__46715,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__46715),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__46715){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46715,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46720){
var extmap__4454__auto__ = (function (){var G__46762 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46720,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__46720)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46762);
} else {
return G__46762;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46720),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46720),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4645__auto__ = opts;
var l__4646__auto__ = a__4645__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4646__auto__)){
var G__48068 = (i + (1));
var G__48069 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__48068;
ret = G__48069;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__46816){
var vec__46817 = p__46816;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46817,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46817,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46827 = arguments.length;
switch (G__46827) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__48101 = ps;
var G__48102 = (i + (1));
el__$1 = G__48101;
i = G__48102;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__46850 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46850,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46850,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46850,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__46856_48113 = cljs.core.seq(props);
var chunk__46857_48114 = null;
var count__46858_48115 = (0);
var i__46859_48116 = (0);
while(true){
if((i__46859_48116 < count__46858_48115)){
var vec__46911_48117 = chunk__46857_48114.cljs$core$IIndexed$_nth$arity$2(null,i__46859_48116);
var k_48118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46911_48117,(0),null);
var v_48119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46911_48117,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_48118);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48118),v_48119);


var G__48121 = seq__46856_48113;
var G__48122 = chunk__46857_48114;
var G__48123 = count__46858_48115;
var G__48124 = (i__46859_48116 + (1));
seq__46856_48113 = G__48121;
chunk__46857_48114 = G__48122;
count__46858_48115 = G__48123;
i__46859_48116 = G__48124;
continue;
} else {
var temp__5753__auto___48125 = cljs.core.seq(seq__46856_48113);
if(temp__5753__auto___48125){
var seq__46856_48126__$1 = temp__5753__auto___48125;
if(cljs.core.chunked_seq_QMARK_(seq__46856_48126__$1)){
var c__4591__auto___48128 = cljs.core.chunk_first(seq__46856_48126__$1);
var G__48129 = cljs.core.chunk_rest(seq__46856_48126__$1);
var G__48130 = c__4591__auto___48128;
var G__48131 = cljs.core.count(c__4591__auto___48128);
var G__48132 = (0);
seq__46856_48113 = G__48129;
chunk__46857_48114 = G__48130;
count__46858_48115 = G__48131;
i__46859_48116 = G__48132;
continue;
} else {
var vec__46927_48133 = cljs.core.first(seq__46856_48126__$1);
var k_48134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46927_48133,(0),null);
var v_48135 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46927_48133,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_48134);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48134),v_48135);


var G__48136 = cljs.core.next(seq__46856_48126__$1);
var G__48137 = null;
var G__48138 = (0);
var G__48139 = (0);
seq__46856_48113 = G__48136;
chunk__46857_48114 = G__48137;
count__46858_48115 = G__48138;
i__46859_48116 = G__48139;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__46974 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46974,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46974,(1),null);
var seq__46978_48141 = cljs.core.seq(node_children);
var chunk__46980_48142 = null;
var count__46981_48143 = (0);
var i__46982_48144 = (0);
while(true){
if((i__46982_48144 < count__46981_48143)){
var child_struct_48145 = chunk__46980_48142.cljs$core$IIndexed$_nth$arity$2(null,i__46982_48144);
if((!((child_struct_48145 == null)))){
if(typeof child_struct_48145 === 'string'){
var text_48147 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48147),child_struct_48145].join(''));
} else {
var children_48148 = shadow.dom.svg_node(child_struct_48145);
if(cljs.core.seq_QMARK_(children_48148)){
var seq__47092_48149 = cljs.core.seq(children_48148);
var chunk__47094_48150 = null;
var count__47095_48151 = (0);
var i__47096_48152 = (0);
while(true){
if((i__47096_48152 < count__47095_48151)){
var child_48153 = chunk__47094_48150.cljs$core$IIndexed$_nth$arity$2(null,i__47096_48152);
if(cljs.core.truth_(child_48153)){
node.appendChild(child_48153);


var G__48154 = seq__47092_48149;
var G__48155 = chunk__47094_48150;
var G__48156 = count__47095_48151;
var G__48157 = (i__47096_48152 + (1));
seq__47092_48149 = G__48154;
chunk__47094_48150 = G__48155;
count__47095_48151 = G__48156;
i__47096_48152 = G__48157;
continue;
} else {
var G__48158 = seq__47092_48149;
var G__48159 = chunk__47094_48150;
var G__48160 = count__47095_48151;
var G__48161 = (i__47096_48152 + (1));
seq__47092_48149 = G__48158;
chunk__47094_48150 = G__48159;
count__47095_48151 = G__48160;
i__47096_48152 = G__48161;
continue;
}
} else {
var temp__5753__auto___48162 = cljs.core.seq(seq__47092_48149);
if(temp__5753__auto___48162){
var seq__47092_48163__$1 = temp__5753__auto___48162;
if(cljs.core.chunked_seq_QMARK_(seq__47092_48163__$1)){
var c__4591__auto___48164 = cljs.core.chunk_first(seq__47092_48163__$1);
var G__48165 = cljs.core.chunk_rest(seq__47092_48163__$1);
var G__48166 = c__4591__auto___48164;
var G__48167 = cljs.core.count(c__4591__auto___48164);
var G__48168 = (0);
seq__47092_48149 = G__48165;
chunk__47094_48150 = G__48166;
count__47095_48151 = G__48167;
i__47096_48152 = G__48168;
continue;
} else {
var child_48169 = cljs.core.first(seq__47092_48163__$1);
if(cljs.core.truth_(child_48169)){
node.appendChild(child_48169);


var G__48175 = cljs.core.next(seq__47092_48163__$1);
var G__48176 = null;
var G__48177 = (0);
var G__48178 = (0);
seq__47092_48149 = G__48175;
chunk__47094_48150 = G__48176;
count__47095_48151 = G__48177;
i__47096_48152 = G__48178;
continue;
} else {
var G__48179 = cljs.core.next(seq__47092_48163__$1);
var G__48180 = null;
var G__48181 = (0);
var G__48182 = (0);
seq__47092_48149 = G__48179;
chunk__47094_48150 = G__48180;
count__47095_48151 = G__48181;
i__47096_48152 = G__48182;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48148);
}
}


var G__48188 = seq__46978_48141;
var G__48189 = chunk__46980_48142;
var G__48190 = count__46981_48143;
var G__48191 = (i__46982_48144 + (1));
seq__46978_48141 = G__48188;
chunk__46980_48142 = G__48189;
count__46981_48143 = G__48190;
i__46982_48144 = G__48191;
continue;
} else {
var G__48192 = seq__46978_48141;
var G__48193 = chunk__46980_48142;
var G__48194 = count__46981_48143;
var G__48195 = (i__46982_48144 + (1));
seq__46978_48141 = G__48192;
chunk__46980_48142 = G__48193;
count__46981_48143 = G__48194;
i__46982_48144 = G__48195;
continue;
}
} else {
var temp__5753__auto___48196 = cljs.core.seq(seq__46978_48141);
if(temp__5753__auto___48196){
var seq__46978_48197__$1 = temp__5753__auto___48196;
if(cljs.core.chunked_seq_QMARK_(seq__46978_48197__$1)){
var c__4591__auto___48202 = cljs.core.chunk_first(seq__46978_48197__$1);
var G__48203 = cljs.core.chunk_rest(seq__46978_48197__$1);
var G__48204 = c__4591__auto___48202;
var G__48205 = cljs.core.count(c__4591__auto___48202);
var G__48206 = (0);
seq__46978_48141 = G__48203;
chunk__46980_48142 = G__48204;
count__46981_48143 = G__48205;
i__46982_48144 = G__48206;
continue;
} else {
var child_struct_48210 = cljs.core.first(seq__46978_48197__$1);
if((!((child_struct_48210 == null)))){
if(typeof child_struct_48210 === 'string'){
var text_48211 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48211),child_struct_48210].join(''));
} else {
var children_48212 = shadow.dom.svg_node(child_struct_48210);
if(cljs.core.seq_QMARK_(children_48212)){
var seq__47146_48213 = cljs.core.seq(children_48212);
var chunk__47148_48214 = null;
var count__47149_48215 = (0);
var i__47150_48216 = (0);
while(true){
if((i__47150_48216 < count__47149_48215)){
var child_48218 = chunk__47148_48214.cljs$core$IIndexed$_nth$arity$2(null,i__47150_48216);
if(cljs.core.truth_(child_48218)){
node.appendChild(child_48218);


var G__48219 = seq__47146_48213;
var G__48220 = chunk__47148_48214;
var G__48221 = count__47149_48215;
var G__48222 = (i__47150_48216 + (1));
seq__47146_48213 = G__48219;
chunk__47148_48214 = G__48220;
count__47149_48215 = G__48221;
i__47150_48216 = G__48222;
continue;
} else {
var G__48223 = seq__47146_48213;
var G__48224 = chunk__47148_48214;
var G__48225 = count__47149_48215;
var G__48226 = (i__47150_48216 + (1));
seq__47146_48213 = G__48223;
chunk__47148_48214 = G__48224;
count__47149_48215 = G__48225;
i__47150_48216 = G__48226;
continue;
}
} else {
var temp__5753__auto___48227__$1 = cljs.core.seq(seq__47146_48213);
if(temp__5753__auto___48227__$1){
var seq__47146_48228__$1 = temp__5753__auto___48227__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47146_48228__$1)){
var c__4591__auto___48229 = cljs.core.chunk_first(seq__47146_48228__$1);
var G__48230 = cljs.core.chunk_rest(seq__47146_48228__$1);
var G__48231 = c__4591__auto___48229;
var G__48232 = cljs.core.count(c__4591__auto___48229);
var G__48233 = (0);
seq__47146_48213 = G__48230;
chunk__47148_48214 = G__48231;
count__47149_48215 = G__48232;
i__47150_48216 = G__48233;
continue;
} else {
var child_48238 = cljs.core.first(seq__47146_48228__$1);
if(cljs.core.truth_(child_48238)){
node.appendChild(child_48238);


var G__48239 = cljs.core.next(seq__47146_48228__$1);
var G__48240 = null;
var G__48241 = (0);
var G__48242 = (0);
seq__47146_48213 = G__48239;
chunk__47148_48214 = G__48240;
count__47149_48215 = G__48241;
i__47150_48216 = G__48242;
continue;
} else {
var G__48244 = cljs.core.next(seq__47146_48228__$1);
var G__48245 = null;
var G__48246 = (0);
var G__48247 = (0);
seq__47146_48213 = G__48244;
chunk__47148_48214 = G__48245;
count__47149_48215 = G__48246;
i__47150_48216 = G__48247;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48212);
}
}


var G__48248 = cljs.core.next(seq__46978_48197__$1);
var G__48249 = null;
var G__48250 = (0);
var G__48251 = (0);
seq__46978_48141 = G__48248;
chunk__46980_48142 = G__48249;
count__46981_48143 = G__48250;
i__46982_48144 = G__48251;
continue;
} else {
var G__48252 = cljs.core.next(seq__46978_48197__$1);
var G__48253 = null;
var G__48254 = (0);
var G__48255 = (0);
seq__46978_48141 = G__48252;
chunk__46980_48142 = G__48253;
count__46981_48143 = G__48254;
i__46982_48144 = G__48255;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4777__auto__ = [];
var len__4771__auto___48257 = arguments.length;
var i__4772__auto___48258 = (0);
while(true){
if((i__4772__auto___48258 < len__4771__auto___48257)){
args__4777__auto__.push((arguments[i__4772__auto___48258]));

var G__48259 = (i__4772__auto___48258 + (1));
i__4772__auto___48258 = G__48259;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47213){
var G__47214 = cljs.core.first(seq47213);
var seq47213__$1 = cljs.core.next(seq47213);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47214,seq47213__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47248 = arguments.length;
switch (G__47248) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4149__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4149__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4149__auto__;
}
})())){
var c__42469__auto___48268 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42470__auto__ = (function (){var switch__42024__auto__ = (function (state_47276){
var state_val_47277 = (state_47276[(1)]);
if((state_val_47277 === (1))){
var state_47276__$1 = state_47276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47276__$1,(2),once_or_cleanup);
} else {
if((state_val_47277 === (2))){
var inst_47269 = (state_47276[(2)]);
var inst_47270 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_47276__$1 = (function (){var statearr_47286 = state_47276;
(statearr_47286[(7)] = inst_47269);

return statearr_47286;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47276__$1,inst_47270);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__42025__auto__ = null;
var shadow$dom$state_machine__42025__auto____0 = (function (){
var statearr_47288 = [null,null,null,null,null,null,null,null];
(statearr_47288[(0)] = shadow$dom$state_machine__42025__auto__);

(statearr_47288[(1)] = (1));

return statearr_47288;
});
var shadow$dom$state_machine__42025__auto____1 = (function (state_47276){
while(true){
var ret_value__42026__auto__ = (function (){try{while(true){
var result__42027__auto__ = switch__42024__auto__(state_47276);
if(cljs.core.keyword_identical_QMARK_(result__42027__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42027__auto__;
}
break;
}
}catch (e47291){var ex__42028__auto__ = e47291;
var statearr_47293_48270 = state_47276;
(statearr_47293_48270[(2)] = ex__42028__auto__);


if(cljs.core.seq((state_47276[(4)]))){
var statearr_47294_48271 = state_47276;
(statearr_47294_48271[(1)] = cljs.core.first((state_47276[(4)])));

} else {
throw ex__42028__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42026__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48272 = state_47276;
state_47276 = G__48272;
continue;
} else {
return ret_value__42026__auto__;
}
break;
}
});
shadow$dom$state_machine__42025__auto__ = function(state_47276){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__42025__auto____0.call(this);
case 1:
return shadow$dom$state_machine__42025__auto____1.call(this,state_47276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__42025__auto____0;
shadow$dom$state_machine__42025__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__42025__auto____1;
return shadow$dom$state_machine__42025__auto__;
})()
})();
var state__42471__auto__ = (function (){var statearr_47295 = f__42470__auto__();
(statearr_47295[(6)] = c__42469__auto___48268);

return statearr_47295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42471__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
