goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__50389){
var vec__50390 = p__50389;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50390,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50390,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__50393 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__50393__$1 = (((G__50393 instanceof cljs.core.Keyword))?G__50393.fqn:null);
switch (G__50393__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__50397 = (function (){
var seq__50398 = cljs.core.seq(vars__$1);
var chunk__50399 = null;
var count__50400 = (0);
var i__50401 = (0);
while(true){
if((i__50401 < count__50400)){
var v = chunk__50399.cljs$core$IIndexed$_nth$arity$2(null,i__50401);
var temp__5753__auto___50528 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___50528)){
var t_50529 = temp__5753__auto___50528;
var G__50408_50530 = ((function (seq__50398,chunk__50399,count__50400,i__50401,t_50529,temp__5753__auto___50528,v,each_fixture_fn,G__50393,G__50393__$1,env,once_fixtures,each_fixtures,vec__50390,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_50529)));
});})(seq__50398,chunk__50399,count__50400,i__50401,t_50529,temp__5753__auto___50528,v,each_fixture_fn,G__50393,G__50393__$1,env,once_fixtures,each_fixtures,vec__50390,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__50408_50530) : each_fixture_fn.call(null,G__50408_50530));
} else {
}


var G__50533 = seq__50398;
var G__50534 = chunk__50399;
var G__50535 = count__50400;
var G__50536 = (i__50401 + (1));
seq__50398 = G__50533;
chunk__50399 = G__50534;
count__50400 = G__50535;
i__50401 = G__50536;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__50398);
if(temp__5753__auto__){
var seq__50398__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50398__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__50398__$1);
var G__50537 = cljs.core.chunk_rest(seq__50398__$1);
var G__50538 = c__4591__auto__;
var G__50539 = cljs.core.count(c__4591__auto__);
var G__50540 = (0);
seq__50398 = G__50537;
chunk__50399 = G__50538;
count__50400 = G__50539;
i__50401 = G__50540;
continue;
} else {
var v = cljs.core.first(seq__50398__$1);
var temp__5753__auto___50541__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___50541__$1)){
var t_50542 = temp__5753__auto___50541__$1;
var G__50412_50543 = ((function (seq__50398,chunk__50399,count__50400,i__50401,t_50542,temp__5753__auto___50541__$1,v,seq__50398__$1,temp__5753__auto__,each_fixture_fn,G__50393,G__50393__$1,env,once_fixtures,each_fixtures,vec__50390,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_50542)));
});})(seq__50398,chunk__50399,count__50400,i__50401,t_50542,temp__5753__auto___50541__$1,v,seq__50398__$1,temp__5753__auto__,each_fixture_fn,G__50393,G__50393__$1,env,once_fixtures,each_fixtures,vec__50390,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__50412_50543) : each_fixture_fn.call(null,G__50412_50543));
} else {
}


var G__50546 = cljs.core.next(seq__50398__$1);
var G__50547 = null;
var G__50548 = (0);
var G__50549 = (0);
seq__50398 = G__50546;
chunk__50399 = G__50547;
count__50400 = G__50548;
i__50401 = G__50549;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__50396 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__50396.cljs$core$IFn$_invoke$arity$1 ? fexpr__50396.cljs$core$IFn$_invoke$arity$1(G__50397) : fexpr__50396.call(null,G__50397));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__50393__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__50387_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__50387_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__50415 = shadow.test.env.get_test_ns_info(ns);
var map__50415__$1 = cljs.core.__destructure_map(map__50415);
var test_ns = map__50415__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50415__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__50420,vars){
var map__50421 = p__50420;
var map__50421__$1 = cljs.core.__destructure_map(map__50421);
var env = map__50421__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50421__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__50423_50556 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__50425_50557 = null;
var count__50426_50558 = (0);
var i__50427_50559 = (0);
while(true){
if((i__50427_50559 < count__50426_50558)){
var vec__50446_50563 = chunk__50425_50557.cljs$core$IIndexed$_nth$arity$2(null,i__50427_50559);
var test_ns_50564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50446_50563,(0),null);
var ns_info_50565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50446_50563,(1),null);
var map__50449_50566 = ns_info_50565;
var map__50449_50567__$1 = cljs.core.__destructure_map(map__50449_50566);
var fixtures_50568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50449_50567__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___50571 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_50568);
if(cljs.core.truth_(temp__5753__auto___50571)){
var fix_50572 = temp__5753__auto___50571;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_50564,fix_50572], 0));
} else {
}

var temp__5753__auto___50573 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_50568);
if(cljs.core.truth_(temp__5753__auto___50573)){
var fix_50574 = temp__5753__auto___50573;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_50564,fix_50574], 0));
} else {
}


var G__50576 = seq__50423_50556;
var G__50577 = chunk__50425_50557;
var G__50578 = count__50426_50558;
var G__50579 = (i__50427_50559 + (1));
seq__50423_50556 = G__50576;
chunk__50425_50557 = G__50577;
count__50426_50558 = G__50578;
i__50427_50559 = G__50579;
continue;
} else {
var temp__5753__auto___50580 = cljs.core.seq(seq__50423_50556);
if(temp__5753__auto___50580){
var seq__50423_50581__$1 = temp__5753__auto___50580;
if(cljs.core.chunked_seq_QMARK_(seq__50423_50581__$1)){
var c__4591__auto___50582 = cljs.core.chunk_first(seq__50423_50581__$1);
var G__50583 = cljs.core.chunk_rest(seq__50423_50581__$1);
var G__50584 = c__4591__auto___50582;
var G__50585 = cljs.core.count(c__4591__auto___50582);
var G__50586 = (0);
seq__50423_50556 = G__50583;
chunk__50425_50557 = G__50584;
count__50426_50558 = G__50585;
i__50427_50559 = G__50586;
continue;
} else {
var vec__50452_50587 = cljs.core.first(seq__50423_50581__$1);
var test_ns_50588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50452_50587,(0),null);
var ns_info_50589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50452_50587,(1),null);
var map__50457_50590 = ns_info_50589;
var map__50457_50591__$1 = cljs.core.__destructure_map(map__50457_50590);
var fixtures_50592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50457_50591__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___50595__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_50592);
if(cljs.core.truth_(temp__5753__auto___50595__$1)){
var fix_50596 = temp__5753__auto___50595__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_50588,fix_50596], 0));
} else {
}

var temp__5753__auto___50599__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_50592);
if(cljs.core.truth_(temp__5753__auto___50599__$1)){
var fix_50600 = temp__5753__auto___50599__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_50588,fix_50600], 0));
} else {
}


var G__50601 = cljs.core.next(seq__50423_50581__$1);
var G__50602 = null;
var G__50603 = (0);
var G__50604 = (0);
seq__50423_50556 = G__50601;
chunk__50425_50557 = G__50602;
count__50426_50558 = G__50603;
i__50427_50559 = G__50604;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__50419_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__50419_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__50464 = cljs.test.get_current_env();
var map__50464__$1 = cljs.core.__destructure_map(map__50464);
var env = map__50464__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50464__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50464__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__50466 = arguments.length;
switch (G__50466) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__50474 = arguments.length;
switch (G__50474) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__50476 = shadow.test.env.get_test_ns_info(ns);
var map__50476__$1 = cljs.core.__destructure_map(map__50476);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50476__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__50484 = arguments.length;
switch (G__50484) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__50478_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__50478_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__50498 = arguments.length;
switch (G__50498) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__50495_SHARP_){
var or__4160__auto__ = (re == null);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__50495_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
