goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__43927 = arguments.length;
switch (G__43927) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43930 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43930 = (function (f,blockable,meta43931){
this.f = f;
this.blockable = blockable;
this.meta43931 = meta43931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43932,meta43931__$1){
var self__ = this;
var _43932__$1 = this;
return (new cljs.core.async.t_cljs$core$async43930(self__.f,self__.blockable,meta43931__$1));
}));

(cljs.core.async.t_cljs$core$async43930.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43932){
var self__ = this;
var _43932__$1 = this;
return self__.meta43931;
}));

(cljs.core.async.t_cljs$core$async43930.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43930.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43930.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async43930.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async43930.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta43931","meta43931",1910210596,null)], null);
}));

(cljs.core.async.t_cljs$core$async43930.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43930.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43930");

(cljs.core.async.t_cljs$core$async43930.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async43930");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43930.
 */
cljs.core.async.__GT_t_cljs$core$async43930 = (function cljs$core$async$__GT_t_cljs$core$async43930(f__$1,blockable__$1,meta43931){
return (new cljs.core.async.t_cljs$core$async43930(f__$1,blockable__$1,meta43931));
});

}

return (new cljs.core.async.t_cljs$core$async43930(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__43956 = arguments.length;
switch (G__43956) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__43972 = arguments.length;
switch (G__43972) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__43983 = arguments.length;
switch (G__43983) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_47376 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47376) : fn1.call(null,val_47376));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47376) : fn1.call(null,val_47376));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__43997 = arguments.length;
switch (G__43997) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4648__auto___47390 = n;
var x_47391 = (0);
while(true){
if((x_47391 < n__4648__auto___47390)){
(a[x_47391] = x_47391);

var G__47392 = (x_47391 + (1));
x_47391 = G__47392;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44018 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44018 = (function (flag,meta44019){
this.flag = flag;
this.meta44019 = meta44019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44020,meta44019__$1){
var self__ = this;
var _44020__$1 = this;
return (new cljs.core.async.t_cljs$core$async44018(self__.flag,meta44019__$1));
}));

(cljs.core.async.t_cljs$core$async44018.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44020){
var self__ = this;
var _44020__$1 = this;
return self__.meta44019;
}));

(cljs.core.async.t_cljs$core$async44018.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44018.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44018.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44018.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44018.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44019","meta44019",381446203,null)], null);
}));

(cljs.core.async.t_cljs$core$async44018.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44018");

(cljs.core.async.t_cljs$core$async44018.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async44018");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44018.
 */
cljs.core.async.__GT_t_cljs$core$async44018 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44018(flag__$1,meta44019){
return (new cljs.core.async.t_cljs$core$async44018(flag__$1,meta44019));
});

}

return (new cljs.core.async.t_cljs$core$async44018(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44034 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44034 = (function (flag,cb,meta44035){
this.flag = flag;
this.cb = cb;
this.meta44035 = meta44035;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44034.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44036,meta44035__$1){
var self__ = this;
var _44036__$1 = this;
return (new cljs.core.async.t_cljs$core$async44034(self__.flag,self__.cb,meta44035__$1));
}));

(cljs.core.async.t_cljs$core$async44034.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44036){
var self__ = this;
var _44036__$1 = this;
return self__.meta44035;
}));

(cljs.core.async.t_cljs$core$async44034.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44034.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44034.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44034.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44034.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44035","meta44035",-52841250,null)], null);
}));

(cljs.core.async.t_cljs$core$async44034.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44034.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44034");

(cljs.core.async.t_cljs$core$async44034.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async44034");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44034.
 */
cljs.core.async.__GT_t_cljs$core$async44034 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44034(flag__$1,cb__$1,meta44035){
return (new cljs.core.async.t_cljs$core$async44034(flag__$1,cb__$1,meta44035));
});

}

return (new cljs.core.async.t_cljs$core$async44034(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44061_SHARP_){
var G__44074 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44061_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44074) : fret.call(null,G__44074));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44062_SHARP_){
var G__44079 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44062_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44079) : fret.call(null,G__44079));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4160__auto__ = wport;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return port;
}
})()], null));
} else {
var G__47428 = (i + (1));
i = G__47428;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4160__auto__ = ret;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4149__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4149__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___47435 = arguments.length;
var i__4772__auto___47436 = (0);
while(true){
if((i__4772__auto___47436 < len__4771__auto___47435)){
args__4777__auto__.push((arguments[i__4772__auto___47436]));

var G__47437 = (i__4772__auto___47436 + (1));
i__4772__auto___47436 = G__47437;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44128){
var map__44132 = p__44128;
var map__44132__$1 = cljs.core.__destructure_map(map__44132);
var opts = map__44132__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44116){
var G__44119 = cljs.core.first(seq44116);
var seq44116__$1 = cljs.core.next(seq44116);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44119,seq44116__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44143 = arguments.length;
switch (G__44143) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43853__auto___47453 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_44269){
var state_val_44270 = (state_44269[(1)]);
if((state_val_44270 === (7))){
var inst_44247 = (state_44269[(2)]);
var state_44269__$1 = state_44269;
var statearr_44279_47454 = state_44269__$1;
(statearr_44279_47454[(2)] = inst_44247);

(statearr_44279_47454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (1))){
var state_44269__$1 = state_44269;
var statearr_44280_47457 = state_44269__$1;
(statearr_44280_47457[(2)] = null);

(statearr_44280_47457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (4))){
var inst_44204 = (state_44269[(7)]);
var inst_44204__$1 = (state_44269[(2)]);
var inst_44208 = (inst_44204__$1 == null);
var state_44269__$1 = (function (){var statearr_44284 = state_44269;
(statearr_44284[(7)] = inst_44204__$1);

return statearr_44284;
})();
if(cljs.core.truth_(inst_44208)){
var statearr_44285_47458 = state_44269__$1;
(statearr_44285_47458[(1)] = (5));

} else {
var statearr_44286_47459 = state_44269__$1;
(statearr_44286_47459[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (13))){
var state_44269__$1 = state_44269;
var statearr_44288_47460 = state_44269__$1;
(statearr_44288_47460[(2)] = null);

(statearr_44288_47460[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (6))){
var inst_44204 = (state_44269[(7)]);
var state_44269__$1 = state_44269;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44269__$1,(11),to,inst_44204);
} else {
if((state_val_44270 === (3))){
var inst_44252 = (state_44269[(2)]);
var state_44269__$1 = state_44269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44269__$1,inst_44252);
} else {
if((state_val_44270 === (12))){
var state_44269__$1 = state_44269;
var statearr_44293_47461 = state_44269__$1;
(statearr_44293_47461[(2)] = null);

(statearr_44293_47461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (2))){
var state_44269__$1 = state_44269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44269__$1,(4),from);
} else {
if((state_val_44270 === (11))){
var inst_44231 = (state_44269[(2)]);
var state_44269__$1 = state_44269;
if(cljs.core.truth_(inst_44231)){
var statearr_44294_47462 = state_44269__$1;
(statearr_44294_47462[(1)] = (12));

} else {
var statearr_44295_47463 = state_44269__$1;
(statearr_44295_47463[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (9))){
var state_44269__$1 = state_44269;
var statearr_44296_47464 = state_44269__$1;
(statearr_44296_47464[(2)] = null);

(statearr_44296_47464[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (5))){
var state_44269__$1 = state_44269;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44298_47465 = state_44269__$1;
(statearr_44298_47465[(1)] = (8));

} else {
var statearr_44300_47466 = state_44269__$1;
(statearr_44300_47466[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (14))){
var inst_44245 = (state_44269[(2)]);
var state_44269__$1 = state_44269;
var statearr_44303_47467 = state_44269__$1;
(statearr_44303_47467[(2)] = inst_44245);

(statearr_44303_47467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (10))){
var inst_44221 = (state_44269[(2)]);
var state_44269__$1 = state_44269;
var statearr_44305_47472 = state_44269__$1;
(statearr_44305_47472[(2)] = inst_44221);

(statearr_44305_47472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44270 === (8))){
var inst_44214 = cljs.core.async.close_BANG_(to);
var state_44269__$1 = state_44269;
var statearr_44307_47477 = state_44269__$1;
(statearr_44307_47477[(2)] = inst_44214);

(statearr_44307_47477[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_44313 = [null,null,null,null,null,null,null,null];
(statearr_44313[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_44313[(1)] = (1));

return statearr_44313;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_44269){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44269);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44314){var ex__43485__auto__ = e44314;
var statearr_44315_47486 = state_44269;
(statearr_44315_47486[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44269[(4)]))){
var statearr_44317_47487 = state_44269;
(statearr_44317_47487[(1)] = cljs.core.first((state_44269[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47488 = state_44269;
state_44269 = G__47488;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_44269){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_44269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_44320 = f__43854__auto__();
(statearr_44320[(6)] = c__43853__auto___47453);

return statearr_44320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44335){
var vec__44336 = p__44335;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44336,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44336,(1),null);
var job = vec__44336;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43853__auto___47500 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_44348){
var state_val_44349 = (state_44348[(1)]);
if((state_val_44349 === (1))){
var state_44348__$1 = state_44348;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44348__$1,(2),res,v);
} else {
if((state_val_44349 === (2))){
var inst_44345 = (state_44348[(2)]);
var inst_44346 = cljs.core.async.close_BANG_(res);
var state_44348__$1 = (function (){var statearr_44350 = state_44348;
(statearr_44350[(7)] = inst_44345);

return statearr_44350;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44348__$1,inst_44346);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0 = (function (){
var statearr_44352 = [null,null,null,null,null,null,null,null];
(statearr_44352[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__);

(statearr_44352[(1)] = (1));

return statearr_44352;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1 = (function (state_44348){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44348);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44353){var ex__43485__auto__ = e44353;
var statearr_44354_47503 = state_44348;
(statearr_44354_47503[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44348[(4)]))){
var statearr_44355_47504 = state_44348;
(statearr_44355_47504[(1)] = cljs.core.first((state_44348[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47505 = state_44348;
state_44348 = G__47505;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = function(state_44348){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1.call(this,state_44348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_44356 = f__43854__auto__();
(statearr_44356[(6)] = c__43853__auto___47500);

return statearr_44356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44363){
var vec__44364 = p__44363;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44364,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44364,(1),null);
var job = vec__44364;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4648__auto___47507 = n;
var __47508 = (0);
while(true){
if((__47508 < n__4648__auto___47507)){
var G__44370_47509 = type;
var G__44370_47510__$1 = (((G__44370_47509 instanceof cljs.core.Keyword))?G__44370_47509.fqn:null);
switch (G__44370_47510__$1) {
case "compute":
var c__43853__auto___47512 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47508,c__43853__auto___47512,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async){
return (function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = ((function (__47508,c__43853__auto___47512,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async){
return (function (state_44383){
var state_val_44384 = (state_44383[(1)]);
if((state_val_44384 === (1))){
var state_44383__$1 = state_44383;
var statearr_44390_47515 = state_44383__$1;
(statearr_44390_47515[(2)] = null);

(statearr_44390_47515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44384 === (2))){
var state_44383__$1 = state_44383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44383__$1,(4),jobs);
} else {
if((state_val_44384 === (3))){
var inst_44381 = (state_44383[(2)]);
var state_44383__$1 = state_44383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44383__$1,inst_44381);
} else {
if((state_val_44384 === (4))){
var inst_44373 = (state_44383[(2)]);
var inst_44374 = process(inst_44373);
var state_44383__$1 = state_44383;
if(cljs.core.truth_(inst_44374)){
var statearr_44402_47519 = state_44383__$1;
(statearr_44402_47519[(1)] = (5));

} else {
var statearr_44403_47520 = state_44383__$1;
(statearr_44403_47520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44384 === (5))){
var state_44383__$1 = state_44383;
var statearr_44410_47521 = state_44383__$1;
(statearr_44410_47521[(2)] = null);

(statearr_44410_47521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44384 === (6))){
var state_44383__$1 = state_44383;
var statearr_44419_47523 = state_44383__$1;
(statearr_44419_47523[(2)] = null);

(statearr_44419_47523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44384 === (7))){
var inst_44379 = (state_44383[(2)]);
var state_44383__$1 = state_44383;
var statearr_44427_47525 = state_44383__$1;
(statearr_44427_47525[(2)] = inst_44379);

(statearr_44427_47525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47508,c__43853__auto___47512,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async))
;
return ((function (__47508,switch__43481__auto__,c__43853__auto___47512,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0 = (function (){
var statearr_44437 = [null,null,null,null,null,null,null];
(statearr_44437[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__);

(statearr_44437[(1)] = (1));

return statearr_44437;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1 = (function (state_44383){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44383);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44438){var ex__43485__auto__ = e44438;
var statearr_44439_47526 = state_44383;
(statearr_44439_47526[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44383[(4)]))){
var statearr_44440_47529 = state_44383;
(statearr_44440_47529[(1)] = cljs.core.first((state_44383[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47531 = state_44383;
state_44383 = G__47531;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = function(state_44383){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1.call(this,state_44383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__;
})()
;})(__47508,switch__43481__auto__,c__43853__auto___47512,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async))
})();
var state__43855__auto__ = (function (){var statearr_44443 = f__43854__auto__();
(statearr_44443[(6)] = c__43853__auto___47512);

return statearr_44443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
});})(__47508,c__43853__auto___47512,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async))
);


break;
case "async":
var c__43853__auto___47535 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47508,c__43853__auto___47535,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async){
return (function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = ((function (__47508,c__43853__auto___47535,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async){
return (function (state_44468){
var state_val_44469 = (state_44468[(1)]);
if((state_val_44469 === (1))){
var state_44468__$1 = state_44468;
var statearr_44473_47542 = state_44468__$1;
(statearr_44473_47542[(2)] = null);

(statearr_44473_47542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44469 === (2))){
var state_44468__$1 = state_44468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44468__$1,(4),jobs);
} else {
if((state_val_44469 === (3))){
var inst_44466 = (state_44468[(2)]);
var state_44468__$1 = state_44468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44468__$1,inst_44466);
} else {
if((state_val_44469 === (4))){
var inst_44458 = (state_44468[(2)]);
var inst_44459 = async(inst_44458);
var state_44468__$1 = state_44468;
if(cljs.core.truth_(inst_44459)){
var statearr_44475_47550 = state_44468__$1;
(statearr_44475_47550[(1)] = (5));

} else {
var statearr_44477_47552 = state_44468__$1;
(statearr_44477_47552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44469 === (5))){
var state_44468__$1 = state_44468;
var statearr_44480_47553 = state_44468__$1;
(statearr_44480_47553[(2)] = null);

(statearr_44480_47553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44469 === (6))){
var state_44468__$1 = state_44468;
var statearr_44481_47555 = state_44468__$1;
(statearr_44481_47555[(2)] = null);

(statearr_44481_47555[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44469 === (7))){
var inst_44464 = (state_44468[(2)]);
var state_44468__$1 = state_44468;
var statearr_44483_47558 = state_44468__$1;
(statearr_44483_47558[(2)] = inst_44464);

(statearr_44483_47558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47508,c__43853__auto___47535,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async))
;
return ((function (__47508,switch__43481__auto__,c__43853__auto___47535,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0 = (function (){
var statearr_44485 = [null,null,null,null,null,null,null];
(statearr_44485[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__);

(statearr_44485[(1)] = (1));

return statearr_44485;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1 = (function (state_44468){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44468);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44486){var ex__43485__auto__ = e44486;
var statearr_44487_47570 = state_44468;
(statearr_44487_47570[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44468[(4)]))){
var statearr_44489_47571 = state_44468;
(statearr_44489_47571[(1)] = cljs.core.first((state_44468[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47572 = state_44468;
state_44468 = G__47572;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = function(state_44468){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1.call(this,state_44468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__;
})()
;})(__47508,switch__43481__auto__,c__43853__auto___47535,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async))
})();
var state__43855__auto__ = (function (){var statearr_44491 = f__43854__auto__();
(statearr_44491[(6)] = c__43853__auto___47535);

return statearr_44491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
});})(__47508,c__43853__auto___47535,G__44370_47509,G__44370_47510__$1,n__4648__auto___47507,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44370_47510__$1)].join('')));

}

var G__47574 = (__47508 + (1));
__47508 = G__47574;
continue;
} else {
}
break;
}

var c__43853__auto___47577 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_44539){
var state_val_44540 = (state_44539[(1)]);
if((state_val_44540 === (7))){
var inst_44535 = (state_44539[(2)]);
var state_44539__$1 = state_44539;
var statearr_44548_47578 = state_44539__$1;
(statearr_44548_47578[(2)] = inst_44535);

(statearr_44548_47578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44540 === (1))){
var state_44539__$1 = state_44539;
var statearr_44555_47579 = state_44539__$1;
(statearr_44555_47579[(2)] = null);

(statearr_44555_47579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44540 === (4))){
var inst_44502 = (state_44539[(7)]);
var inst_44502__$1 = (state_44539[(2)]);
var inst_44503 = (inst_44502__$1 == null);
var state_44539__$1 = (function (){var statearr_44567 = state_44539;
(statearr_44567[(7)] = inst_44502__$1);

return statearr_44567;
})();
if(cljs.core.truth_(inst_44503)){
var statearr_44573_47580 = state_44539__$1;
(statearr_44573_47580[(1)] = (5));

} else {
var statearr_44574_47581 = state_44539__$1;
(statearr_44574_47581[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44540 === (6))){
var inst_44502 = (state_44539[(7)]);
var inst_44508 = (state_44539[(8)]);
var inst_44508__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44527 = [inst_44502,inst_44508__$1];
var inst_44528 = (new cljs.core.PersistentVector(null,2,(5),inst_44521,inst_44527,null));
var state_44539__$1 = (function (){var statearr_44581 = state_44539;
(statearr_44581[(8)] = inst_44508__$1);

return statearr_44581;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44539__$1,(8),jobs,inst_44528);
} else {
if((state_val_44540 === (3))){
var inst_44537 = (state_44539[(2)]);
var state_44539__$1 = state_44539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44539__$1,inst_44537);
} else {
if((state_val_44540 === (2))){
var state_44539__$1 = state_44539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44539__$1,(4),from);
} else {
if((state_val_44540 === (9))){
var inst_44532 = (state_44539[(2)]);
var state_44539__$1 = (function (){var statearr_44602 = state_44539;
(statearr_44602[(9)] = inst_44532);

return statearr_44602;
})();
var statearr_44605_47583 = state_44539__$1;
(statearr_44605_47583[(2)] = null);

(statearr_44605_47583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44540 === (5))){
var inst_44505 = cljs.core.async.close_BANG_(jobs);
var state_44539__$1 = state_44539;
var statearr_44610_47584 = state_44539__$1;
(statearr_44610_47584[(2)] = inst_44505);

(statearr_44610_47584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44540 === (8))){
var inst_44508 = (state_44539[(8)]);
var inst_44530 = (state_44539[(2)]);
var state_44539__$1 = (function (){var statearr_44611 = state_44539;
(statearr_44611[(10)] = inst_44530);

return statearr_44611;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44539__$1,(9),results,inst_44508);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0 = (function (){
var statearr_44614 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44614[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__);

(statearr_44614[(1)] = (1));

return statearr_44614;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1 = (function (state_44539){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44539);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44616){var ex__43485__auto__ = e44616;
var statearr_44617_47586 = state_44539;
(statearr_44617_47586[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44539[(4)]))){
var statearr_44618_47588 = state_44539;
(statearr_44618_47588[(1)] = cljs.core.first((state_44539[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47591 = state_44539;
state_44539 = G__47591;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = function(state_44539){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1.call(this,state_44539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_44622 = f__43854__auto__();
(statearr_44622[(6)] = c__43853__auto___47577);

return statearr_44622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_44667){
var state_val_44668 = (state_44667[(1)]);
if((state_val_44668 === (7))){
var inst_44662 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44672_47592 = state_44667__$1;
(statearr_44672_47592[(2)] = inst_44662);

(statearr_44672_47592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (20))){
var state_44667__$1 = state_44667;
var statearr_44673_47595 = state_44667__$1;
(statearr_44673_47595[(2)] = null);

(statearr_44673_47595[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (1))){
var state_44667__$1 = state_44667;
var statearr_44678_47599 = state_44667__$1;
(statearr_44678_47599[(2)] = null);

(statearr_44678_47599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (4))){
var inst_44628 = (state_44667[(7)]);
var inst_44628__$1 = (state_44667[(2)]);
var inst_44629 = (inst_44628__$1 == null);
var state_44667__$1 = (function (){var statearr_44686 = state_44667;
(statearr_44686[(7)] = inst_44628__$1);

return statearr_44686;
})();
if(cljs.core.truth_(inst_44629)){
var statearr_44692_47603 = state_44667__$1;
(statearr_44692_47603[(1)] = (5));

} else {
var statearr_44693_47606 = state_44667__$1;
(statearr_44693_47606[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (15))){
var inst_44644 = (state_44667[(8)]);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44667__$1,(18),to,inst_44644);
} else {
if((state_val_44668 === (21))){
var inst_44657 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44696_47612 = state_44667__$1;
(statearr_44696_47612[(2)] = inst_44657);

(statearr_44696_47612[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (13))){
var inst_44659 = (state_44667[(2)]);
var state_44667__$1 = (function (){var statearr_44702 = state_44667;
(statearr_44702[(9)] = inst_44659);

return statearr_44702;
})();
var statearr_44703_47617 = state_44667__$1;
(statearr_44703_47617[(2)] = null);

(statearr_44703_47617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (6))){
var inst_44628 = (state_44667[(7)]);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44667__$1,(11),inst_44628);
} else {
if((state_val_44668 === (17))){
var inst_44652 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
if(cljs.core.truth_(inst_44652)){
var statearr_44709_47620 = state_44667__$1;
(statearr_44709_47620[(1)] = (19));

} else {
var statearr_44710_47621 = state_44667__$1;
(statearr_44710_47621[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (3))){
var inst_44664 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44667__$1,inst_44664);
} else {
if((state_val_44668 === (12))){
var inst_44641 = (state_44667[(10)]);
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44667__$1,(14),inst_44641);
} else {
if((state_val_44668 === (2))){
var state_44667__$1 = state_44667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44667__$1,(4),results);
} else {
if((state_val_44668 === (19))){
var state_44667__$1 = state_44667;
var statearr_44714_47622 = state_44667__$1;
(statearr_44714_47622[(2)] = null);

(statearr_44714_47622[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (11))){
var inst_44641 = (state_44667[(2)]);
var state_44667__$1 = (function (){var statearr_44722 = state_44667;
(statearr_44722[(10)] = inst_44641);

return statearr_44722;
})();
var statearr_44725_47625 = state_44667__$1;
(statearr_44725_47625[(2)] = null);

(statearr_44725_47625[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (9))){
var state_44667__$1 = state_44667;
var statearr_44729_47629 = state_44667__$1;
(statearr_44729_47629[(2)] = null);

(statearr_44729_47629[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (5))){
var state_44667__$1 = state_44667;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44732_47630 = state_44667__$1;
(statearr_44732_47630[(1)] = (8));

} else {
var statearr_44733_47631 = state_44667__$1;
(statearr_44733_47631[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (14))){
var inst_44644 = (state_44667[(8)]);
var inst_44644__$1 = (state_44667[(2)]);
var inst_44645 = (inst_44644__$1 == null);
var inst_44646 = cljs.core.not(inst_44645);
var state_44667__$1 = (function (){var statearr_44734 = state_44667;
(statearr_44734[(8)] = inst_44644__$1);

return statearr_44734;
})();
if(inst_44646){
var statearr_44735_47633 = state_44667__$1;
(statearr_44735_47633[(1)] = (15));

} else {
var statearr_44736_47634 = state_44667__$1;
(statearr_44736_47634[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (16))){
var state_44667__$1 = state_44667;
var statearr_44740_47635 = state_44667__$1;
(statearr_44740_47635[(2)] = false);

(statearr_44740_47635[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (10))){
var inst_44638 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44743_47636 = state_44667__$1;
(statearr_44743_47636[(2)] = inst_44638);

(statearr_44743_47636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (18))){
var inst_44649 = (state_44667[(2)]);
var state_44667__$1 = state_44667;
var statearr_44746_47637 = state_44667__$1;
(statearr_44746_47637[(2)] = inst_44649);

(statearr_44746_47637[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44668 === (8))){
var inst_44635 = cljs.core.async.close_BANG_(to);
var state_44667__$1 = state_44667;
var statearr_44748_47638 = state_44667__$1;
(statearr_44748_47638[(2)] = inst_44635);

(statearr_44748_47638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0 = (function (){
var statearr_44751 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44751[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__);

(statearr_44751[(1)] = (1));

return statearr_44751;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1 = (function (state_44667){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44667);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44756){var ex__43485__auto__ = e44756;
var statearr_44757_47639 = state_44667;
(statearr_44757_47639[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44667[(4)]))){
var statearr_44759_47640 = state_44667;
(statearr_44759_47640[(1)] = cljs.core.first((state_44667[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47641 = state_44667;
state_44667 = G__47641;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__ = function(state_44667){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1.call(this,state_44667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43482__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_44763 = f__43854__auto__();
(statearr_44763[(6)] = c__43853__auto__);

return statearr_44763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

return c__43853__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44769 = arguments.length;
switch (G__44769) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44784 = arguments.length;
switch (G__44784) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44808 = arguments.length;
switch (G__44808) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43853__auto___47675 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_44846){
var state_val_44847 = (state_44846[(1)]);
if((state_val_44847 === (7))){
var inst_44840 = (state_44846[(2)]);
var state_44846__$1 = state_44846;
var statearr_44854_47680 = state_44846__$1;
(statearr_44854_47680[(2)] = inst_44840);

(statearr_44854_47680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (1))){
var state_44846__$1 = state_44846;
var statearr_44855_47685 = state_44846__$1;
(statearr_44855_47685[(2)] = null);

(statearr_44855_47685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (4))){
var inst_44821 = (state_44846[(7)]);
var inst_44821__$1 = (state_44846[(2)]);
var inst_44822 = (inst_44821__$1 == null);
var state_44846__$1 = (function (){var statearr_44858 = state_44846;
(statearr_44858[(7)] = inst_44821__$1);

return statearr_44858;
})();
if(cljs.core.truth_(inst_44822)){
var statearr_44864_47686 = state_44846__$1;
(statearr_44864_47686[(1)] = (5));

} else {
var statearr_44865_47687 = state_44846__$1;
(statearr_44865_47687[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (13))){
var state_44846__$1 = state_44846;
var statearr_44869_47691 = state_44846__$1;
(statearr_44869_47691[(2)] = null);

(statearr_44869_47691[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (6))){
var inst_44821 = (state_44846[(7)]);
var inst_44827 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44821) : p.call(null,inst_44821));
var state_44846__$1 = state_44846;
if(cljs.core.truth_(inst_44827)){
var statearr_44872_47697 = state_44846__$1;
(statearr_44872_47697[(1)] = (9));

} else {
var statearr_44874_47698 = state_44846__$1;
(statearr_44874_47698[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (3))){
var inst_44842 = (state_44846[(2)]);
var state_44846__$1 = state_44846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44846__$1,inst_44842);
} else {
if((state_val_44847 === (12))){
var state_44846__$1 = state_44846;
var statearr_44876_47708 = state_44846__$1;
(statearr_44876_47708[(2)] = null);

(statearr_44876_47708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (2))){
var state_44846__$1 = state_44846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44846__$1,(4),ch);
} else {
if((state_val_44847 === (11))){
var inst_44821 = (state_44846[(7)]);
var inst_44831 = (state_44846[(2)]);
var state_44846__$1 = state_44846;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44846__$1,(8),inst_44831,inst_44821);
} else {
if((state_val_44847 === (9))){
var state_44846__$1 = state_44846;
var statearr_44878_47709 = state_44846__$1;
(statearr_44878_47709[(2)] = tc);

(statearr_44878_47709[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (5))){
var inst_44824 = cljs.core.async.close_BANG_(tc);
var inst_44825 = cljs.core.async.close_BANG_(fc);
var state_44846__$1 = (function (){var statearr_44880 = state_44846;
(statearr_44880[(8)] = inst_44824);

return statearr_44880;
})();
var statearr_44882_47713 = state_44846__$1;
(statearr_44882_47713[(2)] = inst_44825);

(statearr_44882_47713[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (14))){
var inst_44838 = (state_44846[(2)]);
var state_44846__$1 = state_44846;
var statearr_44883_47715 = state_44846__$1;
(statearr_44883_47715[(2)] = inst_44838);

(statearr_44883_47715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (10))){
var state_44846__$1 = state_44846;
var statearr_44885_47716 = state_44846__$1;
(statearr_44885_47716[(2)] = fc);

(statearr_44885_47716[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44847 === (8))){
var inst_44833 = (state_44846[(2)]);
var state_44846__$1 = state_44846;
if(cljs.core.truth_(inst_44833)){
var statearr_44888_47720 = state_44846__$1;
(statearr_44888_47720[(1)] = (12));

} else {
var statearr_44889_47721 = state_44846__$1;
(statearr_44889_47721[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_44892 = [null,null,null,null,null,null,null,null,null];
(statearr_44892[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_44892[(1)] = (1));

return statearr_44892;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_44846){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44846);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44894){var ex__43485__auto__ = e44894;
var statearr_44895_47730 = state_44846;
(statearr_44895_47730[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44846[(4)]))){
var statearr_44896_47731 = state_44846;
(statearr_44896_47731[(1)] = cljs.core.first((state_44846[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47732 = state_44846;
state_44846 = G__47732;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_44846){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_44846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_44905 = f__43854__auto__();
(statearr_44905[(6)] = c__43853__auto___47675);

return statearr_44905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_44943){
var state_val_44944 = (state_44943[(1)]);
if((state_val_44944 === (7))){
var inst_44939 = (state_44943[(2)]);
var state_44943__$1 = state_44943;
var statearr_44951_47736 = state_44943__$1;
(statearr_44951_47736[(2)] = inst_44939);

(statearr_44951_47736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44944 === (1))){
var inst_44915 = init;
var inst_44916 = inst_44915;
var state_44943__$1 = (function (){var statearr_44955 = state_44943;
(statearr_44955[(7)] = inst_44916);

return statearr_44955;
})();
var statearr_44957_47737 = state_44943__$1;
(statearr_44957_47737[(2)] = null);

(statearr_44957_47737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44944 === (4))){
var inst_44922 = (state_44943[(8)]);
var inst_44922__$1 = (state_44943[(2)]);
var inst_44923 = (inst_44922__$1 == null);
var state_44943__$1 = (function (){var statearr_44958 = state_44943;
(statearr_44958[(8)] = inst_44922__$1);

return statearr_44958;
})();
if(cljs.core.truth_(inst_44923)){
var statearr_44959_47742 = state_44943__$1;
(statearr_44959_47742[(1)] = (5));

} else {
var statearr_44961_47743 = state_44943__$1;
(statearr_44961_47743[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44944 === (6))){
var inst_44916 = (state_44943[(7)]);
var inst_44922 = (state_44943[(8)]);
var inst_44928 = (state_44943[(9)]);
var inst_44928__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44916,inst_44922) : f.call(null,inst_44916,inst_44922));
var inst_44929 = cljs.core.reduced_QMARK_(inst_44928__$1);
var state_44943__$1 = (function (){var statearr_44965 = state_44943;
(statearr_44965[(9)] = inst_44928__$1);

return statearr_44965;
})();
if(inst_44929){
var statearr_44966_47754 = state_44943__$1;
(statearr_44966_47754[(1)] = (8));

} else {
var statearr_44967_47755 = state_44943__$1;
(statearr_44967_47755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44944 === (3))){
var inst_44941 = (state_44943[(2)]);
var state_44943__$1 = state_44943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44943__$1,inst_44941);
} else {
if((state_val_44944 === (2))){
var state_44943__$1 = state_44943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44943__$1,(4),ch);
} else {
if((state_val_44944 === (9))){
var inst_44928 = (state_44943[(9)]);
var inst_44916 = inst_44928;
var state_44943__$1 = (function (){var statearr_44970 = state_44943;
(statearr_44970[(7)] = inst_44916);

return statearr_44970;
})();
var statearr_44973_47756 = state_44943__$1;
(statearr_44973_47756[(2)] = null);

(statearr_44973_47756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44944 === (5))){
var inst_44916 = (state_44943[(7)]);
var state_44943__$1 = state_44943;
var statearr_44976_47758 = state_44943__$1;
(statearr_44976_47758[(2)] = inst_44916);

(statearr_44976_47758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44944 === (10))){
var inst_44936 = (state_44943[(2)]);
var state_44943__$1 = state_44943;
var statearr_44977_47761 = state_44943__$1;
(statearr_44977_47761[(2)] = inst_44936);

(statearr_44977_47761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44944 === (8))){
var inst_44928 = (state_44943[(9)]);
var inst_44932 = cljs.core.deref(inst_44928);
var state_44943__$1 = state_44943;
var statearr_44978_47762 = state_44943__$1;
(statearr_44978_47762[(2)] = inst_44932);

(statearr_44978_47762[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43482__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43482__auto____0 = (function (){
var statearr_44979 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44979[(0)] = cljs$core$async$reduce_$_state_machine__43482__auto__);

(statearr_44979[(1)] = (1));

return statearr_44979;
});
var cljs$core$async$reduce_$_state_machine__43482__auto____1 = (function (state_44943){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_44943);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e44986){var ex__43485__auto__ = e44986;
var statearr_44988_47763 = state_44943;
(statearr_44988_47763[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_44943[(4)]))){
var statearr_44989_47764 = state_44943;
(statearr_44989_47764[(1)] = cljs.core.first((state_44943[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47765 = state_44943;
state_44943 = G__47765;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43482__auto__ = function(state_44943){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43482__auto____1.call(this,state_44943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43482__auto____0;
cljs$core$async$reduce_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43482__auto____1;
return cljs$core$async$reduce_$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_45002 = f__43854__auto__();
(statearr_45002[(6)] = c__43853__auto__);

return statearr_45002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

return c__43853__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_45016){
var state_val_45017 = (state_45016[(1)]);
if((state_val_45017 === (1))){
var inst_45011 = cljs.core.async.reduce(f__$1,init,ch);
var state_45016__$1 = state_45016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45016__$1,(2),inst_45011);
} else {
if((state_val_45017 === (2))){
var inst_45013 = (state_45016[(2)]);
var inst_45014 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45013) : f__$1.call(null,inst_45013));
var state_45016__$1 = state_45016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45016__$1,inst_45014);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43482__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43482__auto____0 = (function (){
var statearr_45029 = [null,null,null,null,null,null,null];
(statearr_45029[(0)] = cljs$core$async$transduce_$_state_machine__43482__auto__);

(statearr_45029[(1)] = (1));

return statearr_45029;
});
var cljs$core$async$transduce_$_state_machine__43482__auto____1 = (function (state_45016){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_45016);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e45030){var ex__43485__auto__ = e45030;
var statearr_45031_47773 = state_45016;
(statearr_45031_47773[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_45016[(4)]))){
var statearr_45033_47775 = state_45016;
(statearr_45033_47775[(1)] = cljs.core.first((state_45016[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47776 = state_45016;
state_45016 = G__47776;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43482__auto__ = function(state_45016){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43482__auto____1.call(this,state_45016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43482__auto____0;
cljs$core$async$transduce_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43482__auto____1;
return cljs$core$async$transduce_$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_45034 = f__43854__auto__();
(statearr_45034[(6)] = c__43853__auto__);

return statearr_45034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

return c__43853__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__45037 = arguments.length;
switch (G__45037) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_45066){
var state_val_45067 = (state_45066[(1)]);
if((state_val_45067 === (7))){
var inst_45048 = (state_45066[(2)]);
var state_45066__$1 = state_45066;
var statearr_45077_47779 = state_45066__$1;
(statearr_45077_47779[(2)] = inst_45048);

(statearr_45077_47779[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (1))){
var inst_45042 = cljs.core.seq(coll);
var inst_45043 = inst_45042;
var state_45066__$1 = (function (){var statearr_45082 = state_45066;
(statearr_45082[(7)] = inst_45043);

return statearr_45082;
})();
var statearr_45083_47782 = state_45066__$1;
(statearr_45083_47782[(2)] = null);

(statearr_45083_47782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (4))){
var inst_45043 = (state_45066[(7)]);
var inst_45046 = cljs.core.first(inst_45043);
var state_45066__$1 = state_45066;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45066__$1,(7),ch,inst_45046);
} else {
if((state_val_45067 === (13))){
var inst_45060 = (state_45066[(2)]);
var state_45066__$1 = state_45066;
var statearr_45090_47783 = state_45066__$1;
(statearr_45090_47783[(2)] = inst_45060);

(statearr_45090_47783[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (6))){
var inst_45051 = (state_45066[(2)]);
var state_45066__$1 = state_45066;
if(cljs.core.truth_(inst_45051)){
var statearr_45094_47790 = state_45066__$1;
(statearr_45094_47790[(1)] = (8));

} else {
var statearr_45095_47794 = state_45066__$1;
(statearr_45095_47794[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (3))){
var inst_45064 = (state_45066[(2)]);
var state_45066__$1 = state_45066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45066__$1,inst_45064);
} else {
if((state_val_45067 === (12))){
var state_45066__$1 = state_45066;
var statearr_45096_47796 = state_45066__$1;
(statearr_45096_47796[(2)] = null);

(statearr_45096_47796[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (2))){
var inst_45043 = (state_45066[(7)]);
var state_45066__$1 = state_45066;
if(cljs.core.truth_(inst_45043)){
var statearr_45097_47798 = state_45066__$1;
(statearr_45097_47798[(1)] = (4));

} else {
var statearr_45098_47799 = state_45066__$1;
(statearr_45098_47799[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (11))){
var inst_45057 = cljs.core.async.close_BANG_(ch);
var state_45066__$1 = state_45066;
var statearr_45100_47802 = state_45066__$1;
(statearr_45100_47802[(2)] = inst_45057);

(statearr_45100_47802[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (9))){
var state_45066__$1 = state_45066;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45101_47803 = state_45066__$1;
(statearr_45101_47803[(1)] = (11));

} else {
var statearr_45102_47804 = state_45066__$1;
(statearr_45102_47804[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (5))){
var inst_45043 = (state_45066[(7)]);
var state_45066__$1 = state_45066;
var statearr_45103_47815 = state_45066__$1;
(statearr_45103_47815[(2)] = inst_45043);

(statearr_45103_47815[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (10))){
var inst_45062 = (state_45066[(2)]);
var state_45066__$1 = state_45066;
var statearr_45104_47821 = state_45066__$1;
(statearr_45104_47821[(2)] = inst_45062);

(statearr_45104_47821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (8))){
var inst_45043 = (state_45066[(7)]);
var inst_45053 = cljs.core.next(inst_45043);
var inst_45043__$1 = inst_45053;
var state_45066__$1 = (function (){var statearr_45105 = state_45066;
(statearr_45105[(7)] = inst_45043__$1);

return statearr_45105;
})();
var statearr_45106_47824 = state_45066__$1;
(statearr_45106_47824[(2)] = null);

(statearr_45106_47824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_45108 = [null,null,null,null,null,null,null,null];
(statearr_45108[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_45108[(1)] = (1));

return statearr_45108;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_45066){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_45066);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e45109){var ex__43485__auto__ = e45109;
var statearr_45110_47838 = state_45066;
(statearr_45110_47838[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_45066[(4)]))){
var statearr_45111_47839 = state_45066;
(statearr_45111_47839[(1)] = cljs.core.first((state_45066[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47846 = state_45066;
state_45066 = G__47846;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_45066){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_45066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_45112 = f__43854__auto__();
(statearr_45112[(6)] = c__43853__auto__);

return statearr_45112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

return c__43853__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__45117 = arguments.length;
switch (G__45117) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_47882 = (function (_){
var x__4463__auto__ = (((_ == null))?null:_);
var m__4464__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4464__auto__.call(null,_));
} else {
var m__4461__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4461__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_47882(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_47892 = (function (m,ch,close_QMARK_){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4464__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4461__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_47892(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_47897 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_47897(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_47898 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_47898(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45168 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45168 = (function (ch,cs,meta45169){
this.ch = ch;
this.cs = cs;
this.meta45169 = meta45169;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45170,meta45169__$1){
var self__ = this;
var _45170__$1 = this;
return (new cljs.core.async.t_cljs$core$async45168(self__.ch,self__.cs,meta45169__$1));
}));

(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45170){
var self__ = this;
var _45170__$1 = this;
return self__.meta45169;
}));

(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async45168.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async45168.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta45169","meta45169",741245640,null)], null);
}));

(cljs.core.async.t_cljs$core$async45168.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45168.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45168");

(cljs.core.async.t_cljs$core$async45168.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45168");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45168.
 */
cljs.core.async.__GT_t_cljs$core$async45168 = (function cljs$core$async$mult_$___GT_t_cljs$core$async45168(ch__$1,cs__$1,meta45169){
return (new cljs.core.async.t_cljs$core$async45168(ch__$1,cs__$1,meta45169));
});

}

return (new cljs.core.async.t_cljs$core$async45168(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43853__auto___47923 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_45346){
var state_val_45347 = (state_45346[(1)]);
if((state_val_45347 === (7))){
var inst_45339 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45352_47924 = state_45346__$1;
(statearr_45352_47924[(2)] = inst_45339);

(statearr_45352_47924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (20))){
var inst_45227 = (state_45346[(7)]);
var inst_45240 = cljs.core.first(inst_45227);
var inst_45241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45240,(0),null);
var inst_45246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45240,(1),null);
var state_45346__$1 = (function (){var statearr_45358 = state_45346;
(statearr_45358[(8)] = inst_45241);

return statearr_45358;
})();
if(cljs.core.truth_(inst_45246)){
var statearr_45361_47943 = state_45346__$1;
(statearr_45361_47943[(1)] = (22));

} else {
var statearr_45362_47945 = state_45346__$1;
(statearr_45362_47945[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (27))){
var inst_45278 = (state_45346[(9)]);
var inst_45283 = (state_45346[(10)]);
var inst_45276 = (state_45346[(11)]);
var inst_45195 = (state_45346[(12)]);
var inst_45283__$1 = cljs.core._nth(inst_45276,inst_45278);
var inst_45284 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45283__$1,inst_45195,done);
var state_45346__$1 = (function (){var statearr_45364 = state_45346;
(statearr_45364[(10)] = inst_45283__$1);

return statearr_45364;
})();
if(cljs.core.truth_(inst_45284)){
var statearr_45365_47956 = state_45346__$1;
(statearr_45365_47956[(1)] = (30));

} else {
var statearr_45366_47958 = state_45346__$1;
(statearr_45366_47958[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (1))){
var state_45346__$1 = state_45346;
var statearr_45368_47961 = state_45346__$1;
(statearr_45368_47961[(2)] = null);

(statearr_45368_47961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (24))){
var inst_45227 = (state_45346[(7)]);
var inst_45251 = (state_45346[(2)]);
var inst_45252 = cljs.core.next(inst_45227);
var inst_45204 = inst_45252;
var inst_45205 = null;
var inst_45206 = (0);
var inst_45207 = (0);
var state_45346__$1 = (function (){var statearr_45370 = state_45346;
(statearr_45370[(13)] = inst_45207);

(statearr_45370[(14)] = inst_45204);

(statearr_45370[(15)] = inst_45206);

(statearr_45370[(16)] = inst_45205);

(statearr_45370[(17)] = inst_45251);

return statearr_45370;
})();
var statearr_45371_47978 = state_45346__$1;
(statearr_45371_47978[(2)] = null);

(statearr_45371_47978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (39))){
var state_45346__$1 = state_45346;
var statearr_45385_47981 = state_45346__$1;
(statearr_45385_47981[(2)] = null);

(statearr_45385_47981[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (4))){
var inst_45195 = (state_45346[(12)]);
var inst_45195__$1 = (state_45346[(2)]);
var inst_45196 = (inst_45195__$1 == null);
var state_45346__$1 = (function (){var statearr_45387 = state_45346;
(statearr_45387[(12)] = inst_45195__$1);

return statearr_45387;
})();
if(cljs.core.truth_(inst_45196)){
var statearr_45388_47989 = state_45346__$1;
(statearr_45388_47989[(1)] = (5));

} else {
var statearr_45389_47991 = state_45346__$1;
(statearr_45389_47991[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (15))){
var inst_45207 = (state_45346[(13)]);
var inst_45204 = (state_45346[(14)]);
var inst_45206 = (state_45346[(15)]);
var inst_45205 = (state_45346[(16)]);
var inst_45223 = (state_45346[(2)]);
var inst_45224 = (inst_45207 + (1));
var tmp45378 = inst_45204;
var tmp45379 = inst_45206;
var tmp45380 = inst_45205;
var inst_45204__$1 = tmp45378;
var inst_45205__$1 = tmp45380;
var inst_45206__$1 = tmp45379;
var inst_45207__$1 = inst_45224;
var state_45346__$1 = (function (){var statearr_45390 = state_45346;
(statearr_45390[(13)] = inst_45207__$1);

(statearr_45390[(14)] = inst_45204__$1);

(statearr_45390[(18)] = inst_45223);

(statearr_45390[(15)] = inst_45206__$1);

(statearr_45390[(16)] = inst_45205__$1);

return statearr_45390;
})();
var statearr_45395_47998 = state_45346__$1;
(statearr_45395_47998[(2)] = null);

(statearr_45395_47998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (21))){
var inst_45255 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45399_48001 = state_45346__$1;
(statearr_45399_48001[(2)] = inst_45255);

(statearr_45399_48001[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (31))){
var inst_45283 = (state_45346[(10)]);
var inst_45287 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45283);
var state_45346__$1 = state_45346;
var statearr_45402_48002 = state_45346__$1;
(statearr_45402_48002[(2)] = inst_45287);

(statearr_45402_48002[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (32))){
var inst_45277 = (state_45346[(19)]);
var inst_45278 = (state_45346[(9)]);
var inst_45275 = (state_45346[(20)]);
var inst_45276 = (state_45346[(11)]);
var inst_45289 = (state_45346[(2)]);
var inst_45292 = (inst_45278 + (1));
var tmp45396 = inst_45277;
var tmp45397 = inst_45275;
var tmp45398 = inst_45276;
var inst_45275__$1 = tmp45397;
var inst_45276__$1 = tmp45398;
var inst_45277__$1 = tmp45396;
var inst_45278__$1 = inst_45292;
var state_45346__$1 = (function (){var statearr_45405 = state_45346;
(statearr_45405[(19)] = inst_45277__$1);

(statearr_45405[(9)] = inst_45278__$1);

(statearr_45405[(21)] = inst_45289);

(statearr_45405[(20)] = inst_45275__$1);

(statearr_45405[(11)] = inst_45276__$1);

return statearr_45405;
})();
var statearr_45408_48015 = state_45346__$1;
(statearr_45408_48015[(2)] = null);

(statearr_45408_48015[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (40))){
var inst_45311 = (state_45346[(22)]);
var inst_45315 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45311);
var state_45346__$1 = state_45346;
var statearr_45410_48020 = state_45346__$1;
(statearr_45410_48020[(2)] = inst_45315);

(statearr_45410_48020[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (33))){
var inst_45295 = (state_45346[(23)]);
var inst_45298 = cljs.core.chunked_seq_QMARK_(inst_45295);
var state_45346__$1 = state_45346;
if(inst_45298){
var statearr_45411_48021 = state_45346__$1;
(statearr_45411_48021[(1)] = (36));

} else {
var statearr_45412_48022 = state_45346__$1;
(statearr_45412_48022[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (13))){
var inst_45217 = (state_45346[(24)]);
var inst_45220 = cljs.core.async.close_BANG_(inst_45217);
var state_45346__$1 = state_45346;
var statearr_45418_48024 = state_45346__$1;
(statearr_45418_48024[(2)] = inst_45220);

(statearr_45418_48024[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (22))){
var inst_45241 = (state_45346[(8)]);
var inst_45248 = cljs.core.async.close_BANG_(inst_45241);
var state_45346__$1 = state_45346;
var statearr_45421_48027 = state_45346__$1;
(statearr_45421_48027[(2)] = inst_45248);

(statearr_45421_48027[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (36))){
var inst_45295 = (state_45346[(23)]);
var inst_45301 = cljs.core.chunk_first(inst_45295);
var inst_45306 = cljs.core.chunk_rest(inst_45295);
var inst_45307 = cljs.core.count(inst_45301);
var inst_45275 = inst_45306;
var inst_45276 = inst_45301;
var inst_45277 = inst_45307;
var inst_45278 = (0);
var state_45346__$1 = (function (){var statearr_45424 = state_45346;
(statearr_45424[(19)] = inst_45277);

(statearr_45424[(9)] = inst_45278);

(statearr_45424[(20)] = inst_45275);

(statearr_45424[(11)] = inst_45276);

return statearr_45424;
})();
var statearr_45425_48039 = state_45346__$1;
(statearr_45425_48039[(2)] = null);

(statearr_45425_48039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (41))){
var inst_45295 = (state_45346[(23)]);
var inst_45317 = (state_45346[(2)]);
var inst_45318 = cljs.core.next(inst_45295);
var inst_45275 = inst_45318;
var inst_45276 = null;
var inst_45277 = (0);
var inst_45278 = (0);
var state_45346__$1 = (function (){var statearr_45427 = state_45346;
(statearr_45427[(25)] = inst_45317);

(statearr_45427[(19)] = inst_45277);

(statearr_45427[(9)] = inst_45278);

(statearr_45427[(20)] = inst_45275);

(statearr_45427[(11)] = inst_45276);

return statearr_45427;
})();
var statearr_45430_48042 = state_45346__$1;
(statearr_45430_48042[(2)] = null);

(statearr_45430_48042[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (43))){
var state_45346__$1 = state_45346;
var statearr_45432_48047 = state_45346__$1;
(statearr_45432_48047[(2)] = null);

(statearr_45432_48047[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (29))){
var inst_45326 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45435_48058 = state_45346__$1;
(statearr_45435_48058[(2)] = inst_45326);

(statearr_45435_48058[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (44))){
var inst_45336 = (state_45346[(2)]);
var state_45346__$1 = (function (){var statearr_45437 = state_45346;
(statearr_45437[(26)] = inst_45336);

return statearr_45437;
})();
var statearr_45438_48061 = state_45346__$1;
(statearr_45438_48061[(2)] = null);

(statearr_45438_48061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (6))){
var inst_45266 = (state_45346[(27)]);
var inst_45265 = cljs.core.deref(cs);
var inst_45266__$1 = cljs.core.keys(inst_45265);
var inst_45267 = cljs.core.count(inst_45266__$1);
var inst_45268 = cljs.core.reset_BANG_(dctr,inst_45267);
var inst_45274 = cljs.core.seq(inst_45266__$1);
var inst_45275 = inst_45274;
var inst_45276 = null;
var inst_45277 = (0);
var inst_45278 = (0);
var state_45346__$1 = (function (){var statearr_45443 = state_45346;
(statearr_45443[(27)] = inst_45266__$1);

(statearr_45443[(19)] = inst_45277);

(statearr_45443[(9)] = inst_45278);

(statearr_45443[(28)] = inst_45268);

(statearr_45443[(20)] = inst_45275);

(statearr_45443[(11)] = inst_45276);

return statearr_45443;
})();
var statearr_45444_48071 = state_45346__$1;
(statearr_45444_48071[(2)] = null);

(statearr_45444_48071[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (28))){
var inst_45295 = (state_45346[(23)]);
var inst_45275 = (state_45346[(20)]);
var inst_45295__$1 = cljs.core.seq(inst_45275);
var state_45346__$1 = (function (){var statearr_45447 = state_45346;
(statearr_45447[(23)] = inst_45295__$1);

return statearr_45447;
})();
if(inst_45295__$1){
var statearr_45450_48074 = state_45346__$1;
(statearr_45450_48074[(1)] = (33));

} else {
var statearr_45451_48076 = state_45346__$1;
(statearr_45451_48076[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (25))){
var inst_45277 = (state_45346[(19)]);
var inst_45278 = (state_45346[(9)]);
var inst_45280 = (inst_45278 < inst_45277);
var inst_45281 = inst_45280;
var state_45346__$1 = state_45346;
if(cljs.core.truth_(inst_45281)){
var statearr_45452_48084 = state_45346__$1;
(statearr_45452_48084[(1)] = (27));

} else {
var statearr_45453_48085 = state_45346__$1;
(statearr_45453_48085[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (34))){
var state_45346__$1 = state_45346;
var statearr_45455_48087 = state_45346__$1;
(statearr_45455_48087[(2)] = null);

(statearr_45455_48087[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (17))){
var state_45346__$1 = state_45346;
var statearr_45456_48090 = state_45346__$1;
(statearr_45456_48090[(2)] = null);

(statearr_45456_48090[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (3))){
var inst_45341 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45346__$1,inst_45341);
} else {
if((state_val_45347 === (12))){
var inst_45260 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45457_48095 = state_45346__$1;
(statearr_45457_48095[(2)] = inst_45260);

(statearr_45457_48095[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (2))){
var state_45346__$1 = state_45346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45346__$1,(4),ch);
} else {
if((state_val_45347 === (23))){
var state_45346__$1 = state_45346;
var statearr_45460_48099 = state_45346__$1;
(statearr_45460_48099[(2)] = null);

(statearr_45460_48099[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (35))){
var inst_45324 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45462_48103 = state_45346__$1;
(statearr_45462_48103[(2)] = inst_45324);

(statearr_45462_48103[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (19))){
var inst_45227 = (state_45346[(7)]);
var inst_45231 = cljs.core.chunk_first(inst_45227);
var inst_45232 = cljs.core.chunk_rest(inst_45227);
var inst_45233 = cljs.core.count(inst_45231);
var inst_45204 = inst_45232;
var inst_45205 = inst_45231;
var inst_45206 = inst_45233;
var inst_45207 = (0);
var state_45346__$1 = (function (){var statearr_45467 = state_45346;
(statearr_45467[(13)] = inst_45207);

(statearr_45467[(14)] = inst_45204);

(statearr_45467[(15)] = inst_45206);

(statearr_45467[(16)] = inst_45205);

return statearr_45467;
})();
var statearr_45469_48110 = state_45346__$1;
(statearr_45469_48110[(2)] = null);

(statearr_45469_48110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (11))){
var inst_45204 = (state_45346[(14)]);
var inst_45227 = (state_45346[(7)]);
var inst_45227__$1 = cljs.core.seq(inst_45204);
var state_45346__$1 = (function (){var statearr_45471 = state_45346;
(statearr_45471[(7)] = inst_45227__$1);

return statearr_45471;
})();
if(inst_45227__$1){
var statearr_45472_48114 = state_45346__$1;
(statearr_45472_48114[(1)] = (16));

} else {
var statearr_45473_48118 = state_45346__$1;
(statearr_45473_48118[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (9))){
var inst_45262 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45474_48120 = state_45346__$1;
(statearr_45474_48120[(2)] = inst_45262);

(statearr_45474_48120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (5))){
var inst_45202 = cljs.core.deref(cs);
var inst_45203 = cljs.core.seq(inst_45202);
var inst_45204 = inst_45203;
var inst_45205 = null;
var inst_45206 = (0);
var inst_45207 = (0);
var state_45346__$1 = (function (){var statearr_45475 = state_45346;
(statearr_45475[(13)] = inst_45207);

(statearr_45475[(14)] = inst_45204);

(statearr_45475[(15)] = inst_45206);

(statearr_45475[(16)] = inst_45205);

return statearr_45475;
})();
var statearr_45476_48123 = state_45346__$1;
(statearr_45476_48123[(2)] = null);

(statearr_45476_48123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (14))){
var state_45346__$1 = state_45346;
var statearr_45483_48127 = state_45346__$1;
(statearr_45483_48127[(2)] = null);

(statearr_45483_48127[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (45))){
var inst_45333 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45485_48128 = state_45346__$1;
(statearr_45485_48128[(2)] = inst_45333);

(statearr_45485_48128[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (26))){
var inst_45266 = (state_45346[(27)]);
var inst_45328 = (state_45346[(2)]);
var inst_45330 = cljs.core.seq(inst_45266);
var state_45346__$1 = (function (){var statearr_45486 = state_45346;
(statearr_45486[(29)] = inst_45328);

return statearr_45486;
})();
if(inst_45330){
var statearr_45487_48130 = state_45346__$1;
(statearr_45487_48130[(1)] = (42));

} else {
var statearr_45488_48131 = state_45346__$1;
(statearr_45488_48131[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (16))){
var inst_45227 = (state_45346[(7)]);
var inst_45229 = cljs.core.chunked_seq_QMARK_(inst_45227);
var state_45346__$1 = state_45346;
if(inst_45229){
var statearr_45493_48136 = state_45346__$1;
(statearr_45493_48136[(1)] = (19));

} else {
var statearr_45494_48137 = state_45346__$1;
(statearr_45494_48137[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (38))){
var inst_45321 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45495_48138 = state_45346__$1;
(statearr_45495_48138[(2)] = inst_45321);

(statearr_45495_48138[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (30))){
var state_45346__$1 = state_45346;
var statearr_45496_48140 = state_45346__$1;
(statearr_45496_48140[(2)] = null);

(statearr_45496_48140[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (10))){
var inst_45207 = (state_45346[(13)]);
var inst_45205 = (state_45346[(16)]);
var inst_45216 = cljs.core._nth(inst_45205,inst_45207);
var inst_45217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45216,(0),null);
var inst_45218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45216,(1),null);
var state_45346__$1 = (function (){var statearr_45502 = state_45346;
(statearr_45502[(24)] = inst_45217);

return statearr_45502;
})();
if(cljs.core.truth_(inst_45218)){
var statearr_45503_48143 = state_45346__$1;
(statearr_45503_48143[(1)] = (13));

} else {
var statearr_45505_48144 = state_45346__$1;
(statearr_45505_48144[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (18))){
var inst_45258 = (state_45346[(2)]);
var state_45346__$1 = state_45346;
var statearr_45510_48147 = state_45346__$1;
(statearr_45510_48147[(2)] = inst_45258);

(statearr_45510_48147[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (42))){
var state_45346__$1 = state_45346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45346__$1,(45),dchan);
} else {
if((state_val_45347 === (37))){
var inst_45295 = (state_45346[(23)]);
var inst_45195 = (state_45346[(12)]);
var inst_45311 = (state_45346[(22)]);
var inst_45311__$1 = cljs.core.first(inst_45295);
var inst_45312 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45311__$1,inst_45195,done);
var state_45346__$1 = (function (){var statearr_45516 = state_45346;
(statearr_45516[(22)] = inst_45311__$1);

return statearr_45516;
})();
if(cljs.core.truth_(inst_45312)){
var statearr_45518_48152 = state_45346__$1;
(statearr_45518_48152[(1)] = (39));

} else {
var statearr_45519_48153 = state_45346__$1;
(statearr_45519_48153[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45347 === (8))){
var inst_45207 = (state_45346[(13)]);
var inst_45206 = (state_45346[(15)]);
var inst_45209 = (inst_45207 < inst_45206);
var inst_45210 = inst_45209;
var state_45346__$1 = state_45346;
if(cljs.core.truth_(inst_45210)){
var statearr_45524_48156 = state_45346__$1;
(statearr_45524_48156[(1)] = (10));

} else {
var statearr_45525_48157 = state_45346__$1;
(statearr_45525_48157[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43482__auto__ = null;
var cljs$core$async$mult_$_state_machine__43482__auto____0 = (function (){
var statearr_45534 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45534[(0)] = cljs$core$async$mult_$_state_machine__43482__auto__);

(statearr_45534[(1)] = (1));

return statearr_45534;
});
var cljs$core$async$mult_$_state_machine__43482__auto____1 = (function (state_45346){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_45346);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e45535){var ex__43485__auto__ = e45535;
var statearr_45536_48163 = state_45346;
(statearr_45536_48163[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_45346[(4)]))){
var statearr_45538_48164 = state_45346;
(statearr_45538_48164[(1)] = cljs.core.first((state_45346[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48167 = state_45346;
state_45346 = G__48167;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43482__auto__ = function(state_45346){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43482__auto____1.call(this,state_45346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43482__auto____0;
cljs$core$async$mult_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43482__auto____1;
return cljs$core$async$mult_$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_45540 = f__43854__auto__();
(statearr_45540[(6)] = c__43853__auto___47923);

return statearr_45540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45544 = arguments.length;
switch (G__45544) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_48178 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_48178(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_48185 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_48185(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_48193 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_48193(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_48203 = (function (m,state_map){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4464__auto__.call(null,m,state_map));
} else {
var m__4461__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4461__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_48203(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_48209 = (function (m,mode){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4464__auto__.call(null,m,mode));
} else {
var m__4461__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4461__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_48209(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___48216 = arguments.length;
var i__4772__auto___48217 = (0);
while(true){
if((i__4772__auto___48217 < len__4771__auto___48216)){
args__4777__auto__.push((arguments[i__4772__auto___48217]));

var G__48218 = (i__4772__auto___48217 + (1));
i__4772__auto___48217 = G__48218;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((3) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4778__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45605){
var map__45607 = p__45605;
var map__45607__$1 = cljs.core.__destructure_map(map__45607);
var opts = map__45607__$1;
var statearr_45608_48221 = state;
(statearr_45608_48221[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45615_48226 = state;
(statearr_45615_48226[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_45630_48227 = state;
(statearr_45630_48227[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45595){
var G__45596 = cljs.core.first(seq45595);
var seq45595__$1 = cljs.core.next(seq45595);
var G__45597 = cljs.core.first(seq45595__$1);
var seq45595__$2 = cljs.core.next(seq45595__$1);
var G__45598 = cljs.core.first(seq45595__$2);
var seq45595__$3 = cljs.core.next(seq45595__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45596,G__45597,G__45598,seq45595__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45655 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45655 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45656){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45656 = meta45656;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45657,meta45656__$1){
var self__ = this;
var _45657__$1 = this;
return (new cljs.core.async.t_cljs$core$async45655(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45656__$1));
}));

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45657){
var self__ = this;
var _45657__$1 = this;
return self__.meta45656;
}));

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45655.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45655.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45656","meta45656",617025991,null)], null);
}));

(cljs.core.async.t_cljs$core$async45655.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45655.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45655");

(cljs.core.async.t_cljs$core$async45655.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45655");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45655.
 */
cljs.core.async.__GT_t_cljs$core$async45655 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45655(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45656){
return (new cljs.core.async.t_cljs$core$async45655(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45656));
});

}

return (new cljs.core.async.t_cljs$core$async45655(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43853__auto___48289 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_45801){
var state_val_45802 = (state_45801[(1)]);
if((state_val_45802 === (7))){
var inst_45793 = (state_45801[(2)]);
var state_45801__$1 = state_45801;
var statearr_45812_48291 = state_45801__$1;
(statearr_45812_48291[(2)] = inst_45793);

(statearr_45812_48291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (20))){
var inst_45784 = (state_45801[(2)]);
var state_45801__$1 = state_45801;
var statearr_45818_48293 = state_45801__$1;
(statearr_45818_48293[(2)] = inst_45784);

(statearr_45818_48293[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (1))){
var inst_45714 = calc_state();
var inst_45715 = cljs.core.__destructure_map(inst_45714);
var inst_45717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45715,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45715,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45715,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45723 = inst_45714;
var state_45801__$1 = (function (){var statearr_45822 = state_45801;
(statearr_45822[(7)] = inst_45719);

(statearr_45822[(8)] = inst_45723);

(statearr_45822[(9)] = inst_45721);

(statearr_45822[(10)] = inst_45717);

return statearr_45822;
})();
var statearr_45826_48303 = state_45801__$1;
(statearr_45826_48303[(2)] = null);

(statearr_45826_48303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (4))){
var inst_45747 = (state_45801[(11)]);
var inst_45746 = (state_45801[(12)]);
var inst_45741 = (state_45801[(2)]);
var inst_45746__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45741,(0),null);
var inst_45747__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45741,(1),null);
var inst_45749 = (inst_45746__$1 == null);
var inst_45750 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45747__$1,change);
var inst_45751 = ((inst_45749) || (inst_45750));
var state_45801__$1 = (function (){var statearr_45838 = state_45801;
(statearr_45838[(11)] = inst_45747__$1);

(statearr_45838[(12)] = inst_45746__$1);

return statearr_45838;
})();
if(cljs.core.truth_(inst_45751)){
var statearr_45841_48308 = state_45801__$1;
(statearr_45841_48308[(1)] = (5));

} else {
var statearr_45844_48310 = state_45801__$1;
(statearr_45844_48310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (15))){
var inst_45727 = (state_45801[(13)]);
var inst_45723 = inst_45727;
var state_45801__$1 = (function (){var statearr_45846 = state_45801;
(statearr_45846[(8)] = inst_45723);

return statearr_45846;
})();
var statearr_45847_48311 = state_45801__$1;
(statearr_45847_48311[(2)] = null);

(statearr_45847_48311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (13))){
var inst_45775 = (state_45801[(2)]);
var state_45801__$1 = state_45801;
if(cljs.core.truth_(inst_45775)){
var statearr_45849_48312 = state_45801__$1;
(statearr_45849_48312[(1)] = (14));

} else {
var statearr_45850_48313 = state_45801__$1;
(statearr_45850_48313[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (6))){
var inst_45747 = (state_45801[(11)]);
var inst_45765 = (state_45801[(14)]);
var inst_45728 = (state_45801[(15)]);
var inst_45765__$1 = (inst_45728.cljs$core$IFn$_invoke$arity$1 ? inst_45728.cljs$core$IFn$_invoke$arity$1(inst_45747) : inst_45728.call(null,inst_45747));
var state_45801__$1 = (function (){var statearr_45856 = state_45801;
(statearr_45856[(14)] = inst_45765__$1);

return statearr_45856;
})();
if(cljs.core.truth_(inst_45765__$1)){
var statearr_45860_48314 = state_45801__$1;
(statearr_45860_48314[(1)] = (11));

} else {
var statearr_45862_48315 = state_45801__$1;
(statearr_45862_48315[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (17))){
var inst_45778 = (state_45801[(2)]);
var state_45801__$1 = state_45801;
if(cljs.core.truth_(inst_45778)){
var statearr_45869_48317 = state_45801__$1;
(statearr_45869_48317[(1)] = (18));

} else {
var statearr_45871_48318 = state_45801__$1;
(statearr_45871_48318[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (3))){
var inst_45798 = (state_45801[(2)]);
var state_45801__$1 = state_45801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45801__$1,inst_45798);
} else {
if((state_val_45802 === (12))){
var inst_45747 = (state_45801[(11)]);
var inst_45728 = (state_45801[(15)]);
var inst_45729 = (state_45801[(16)]);
var inst_45770 = cljs.core.empty_QMARK_(inst_45728);
var inst_45771 = (inst_45729.cljs$core$IFn$_invoke$arity$1 ? inst_45729.cljs$core$IFn$_invoke$arity$1(inst_45747) : inst_45729.call(null,inst_45747));
var inst_45772 = cljs.core.not(inst_45771);
var inst_45773 = ((inst_45770) && (inst_45772));
var state_45801__$1 = state_45801;
var statearr_45878_48319 = state_45801__$1;
(statearr_45878_48319[(2)] = inst_45773);

(statearr_45878_48319[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (2))){
var inst_45723 = (state_45801[(8)]);
var inst_45727 = (state_45801[(13)]);
var inst_45727__$1 = cljs.core.__destructure_map(inst_45723);
var inst_45728 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45727__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45727__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45727__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45801__$1 = (function (){var statearr_45887 = state_45801;
(statearr_45887[(15)] = inst_45728);

(statearr_45887[(13)] = inst_45727__$1);

(statearr_45887[(16)] = inst_45729);

return statearr_45887;
})();
return cljs.core.async.ioc_alts_BANG_(state_45801__$1,(4),inst_45731);
} else {
if((state_val_45802 === (19))){
var state_45801__$1 = state_45801;
var statearr_45888_48333 = state_45801__$1;
(statearr_45888_48333[(2)] = null);

(statearr_45888_48333[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (11))){
var inst_45765 = (state_45801[(14)]);
var state_45801__$1 = state_45801;
var statearr_45889_48338 = state_45801__$1;
(statearr_45889_48338[(2)] = inst_45765);

(statearr_45889_48338[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (9))){
var state_45801__$1 = state_45801;
var statearr_45891_48339 = state_45801__$1;
(statearr_45891_48339[(2)] = null);

(statearr_45891_48339[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (5))){
var inst_45746 = (state_45801[(12)]);
var inst_45753 = (inst_45746 == null);
var state_45801__$1 = state_45801;
if(cljs.core.truth_(inst_45753)){
var statearr_45892_48340 = state_45801__$1;
(statearr_45892_48340[(1)] = (8));

} else {
var statearr_45893_48341 = state_45801__$1;
(statearr_45893_48341[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (14))){
var inst_45746 = (state_45801[(12)]);
var state_45801__$1 = state_45801;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45801__$1,(17),out,inst_45746);
} else {
if((state_val_45802 === (16))){
var inst_45789 = (state_45801[(2)]);
var state_45801__$1 = state_45801;
var statearr_45897_48348 = state_45801__$1;
(statearr_45897_48348[(2)] = inst_45789);

(statearr_45897_48348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (10))){
var inst_45758 = (state_45801[(2)]);
var inst_45760 = calc_state();
var inst_45723 = inst_45760;
var state_45801__$1 = (function (){var statearr_45907 = state_45801;
(statearr_45907[(8)] = inst_45723);

(statearr_45907[(17)] = inst_45758);

return statearr_45907;
})();
var statearr_45908_48356 = state_45801__$1;
(statearr_45908_48356[(2)] = null);

(statearr_45908_48356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (18))){
var inst_45727 = (state_45801[(13)]);
var inst_45723 = inst_45727;
var state_45801__$1 = (function (){var statearr_45910 = state_45801;
(statearr_45910[(8)] = inst_45723);

return statearr_45910;
})();
var statearr_45913_48359 = state_45801__$1;
(statearr_45913_48359[(2)] = null);

(statearr_45913_48359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45802 === (8))){
var inst_45747 = (state_45801[(11)]);
var inst_45755 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45747);
var state_45801__$1 = state_45801;
var statearr_45918_48363 = state_45801__$1;
(statearr_45918_48363[(2)] = inst_45755);

(statearr_45918_48363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43482__auto__ = null;
var cljs$core$async$mix_$_state_machine__43482__auto____0 = (function (){
var statearr_45922 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45922[(0)] = cljs$core$async$mix_$_state_machine__43482__auto__);

(statearr_45922[(1)] = (1));

return statearr_45922;
});
var cljs$core$async$mix_$_state_machine__43482__auto____1 = (function (state_45801){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_45801);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e45925){var ex__43485__auto__ = e45925;
var statearr_45927_48369 = state_45801;
(statearr_45927_48369[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_45801[(4)]))){
var statearr_45929_48371 = state_45801;
(statearr_45929_48371[(1)] = cljs.core.first((state_45801[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48375 = state_45801;
state_45801 = G__48375;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43482__auto__ = function(state_45801){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43482__auto____1.call(this,state_45801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43482__auto____0;
cljs$core$async$mix_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43482__auto____1;
return cljs$core$async$mix_$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_45935 = f__43854__auto__();
(statearr_45935[(6)] = c__43853__auto___48289);

return statearr_45935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_48377 = (function (p,v,ch,close_QMARK_){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4464__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4461__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_48377(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_48378 = (function (p,v,ch){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4464__auto__.call(null,p,v,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4461__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_48378(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_48379 = (function() {
var G__48380 = null;
var G__48380__1 = (function (p){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4464__auto__.call(null,p));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4461__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__48380__2 = (function (p,v){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4464__auto__.call(null,p,v));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4461__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__48380 = function(p,v){
switch(arguments.length){
case 1:
return G__48380__1.call(this,p);
case 2:
return G__48380__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48380.cljs$core$IFn$_invoke$arity$1 = G__48380__1;
G__48380.cljs$core$IFn$_invoke$arity$2 = G__48380__2;
return G__48380;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46017 = arguments.length;
switch (G__46017) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48379(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48379(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46034 = arguments.length;
switch (G__46034) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__46025_SHARP_){
if(cljs.core.truth_((p1__46025_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46025_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__46025_SHARP_.call(null,topic)))){
return p1__46025_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46025_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46063 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46063 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46064){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46064 = meta46064;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46065,meta46064__$1){
var self__ = this;
var _46065__$1 = this;
return (new cljs.core.async.t_cljs$core$async46063(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46064__$1));
}));

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46065){
var self__ = this;
var _46065__$1 = this;
return self__.meta46064;
}));

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async46063.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async46063.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46064","meta46064",468778704,null)], null);
}));

(cljs.core.async.t_cljs$core$async46063.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46063.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46063");

(cljs.core.async.t_cljs$core$async46063.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46063");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46063.
 */
cljs.core.async.__GT_t_cljs$core$async46063 = (function cljs$core$async$__GT_t_cljs$core$async46063(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46064){
return (new cljs.core.async.t_cljs$core$async46063(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46064));
});

}

return (new cljs.core.async.t_cljs$core$async46063(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43853__auto___48402 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_46196){
var state_val_46197 = (state_46196[(1)]);
if((state_val_46197 === (7))){
var inst_46189 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
var statearr_46203_48403 = state_46196__$1;
(statearr_46203_48403[(2)] = inst_46189);

(statearr_46203_48403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (20))){
var state_46196__$1 = state_46196;
var statearr_46206_48404 = state_46196__$1;
(statearr_46206_48404[(2)] = null);

(statearr_46206_48404[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (1))){
var state_46196__$1 = state_46196;
var statearr_46207_48406 = state_46196__$1;
(statearr_46207_48406[(2)] = null);

(statearr_46207_48406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (24))){
var inst_46166 = (state_46196[(7)]);
var inst_46181 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46166);
var state_46196__$1 = state_46196;
var statearr_46209_48408 = state_46196__$1;
(statearr_46209_48408[(2)] = inst_46181);

(statearr_46209_48408[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (4))){
var inst_46106 = (state_46196[(8)]);
var inst_46106__$1 = (state_46196[(2)]);
var inst_46107 = (inst_46106__$1 == null);
var state_46196__$1 = (function (){var statearr_46214 = state_46196;
(statearr_46214[(8)] = inst_46106__$1);

return statearr_46214;
})();
if(cljs.core.truth_(inst_46107)){
var statearr_46218_48409 = state_46196__$1;
(statearr_46218_48409[(1)] = (5));

} else {
var statearr_46223_48410 = state_46196__$1;
(statearr_46223_48410[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (15))){
var inst_46160 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
var statearr_46227_48411 = state_46196__$1;
(statearr_46227_48411[(2)] = inst_46160);

(statearr_46227_48411[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (21))){
var inst_46186 = (state_46196[(2)]);
var state_46196__$1 = (function (){var statearr_46230 = state_46196;
(statearr_46230[(9)] = inst_46186);

return statearr_46230;
})();
var statearr_46232_48412 = state_46196__$1;
(statearr_46232_48412[(2)] = null);

(statearr_46232_48412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (13))){
var inst_46137 = (state_46196[(10)]);
var inst_46139 = cljs.core.chunked_seq_QMARK_(inst_46137);
var state_46196__$1 = state_46196;
if(inst_46139){
var statearr_46235_48413 = state_46196__$1;
(statearr_46235_48413[(1)] = (16));

} else {
var statearr_46236_48414 = state_46196__$1;
(statearr_46236_48414[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (22))){
var inst_46175 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
if(cljs.core.truth_(inst_46175)){
var statearr_46237_48415 = state_46196__$1;
(statearr_46237_48415[(1)] = (23));

} else {
var statearr_46241_48416 = state_46196__$1;
(statearr_46241_48416[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (6))){
var inst_46168 = (state_46196[(11)]);
var inst_46106 = (state_46196[(8)]);
var inst_46166 = (state_46196[(7)]);
var inst_46166__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_46106) : topic_fn.call(null,inst_46106));
var inst_46167 = cljs.core.deref(mults);
var inst_46168__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46167,inst_46166__$1);
var state_46196__$1 = (function (){var statearr_46243 = state_46196;
(statearr_46243[(11)] = inst_46168__$1);

(statearr_46243[(7)] = inst_46166__$1);

return statearr_46243;
})();
if(cljs.core.truth_(inst_46168__$1)){
var statearr_46244_48417 = state_46196__$1;
(statearr_46244_48417[(1)] = (19));

} else {
var statearr_46245_48418 = state_46196__$1;
(statearr_46245_48418[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (25))){
var inst_46183 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
var statearr_46249_48419 = state_46196__$1;
(statearr_46249_48419[(2)] = inst_46183);

(statearr_46249_48419[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (17))){
var inst_46137 = (state_46196[(10)]);
var inst_46151 = cljs.core.first(inst_46137);
var inst_46152 = cljs.core.async.muxch_STAR_(inst_46151);
var inst_46153 = cljs.core.async.close_BANG_(inst_46152);
var inst_46154 = cljs.core.next(inst_46137);
var inst_46116 = inst_46154;
var inst_46117 = null;
var inst_46118 = (0);
var inst_46119 = (0);
var state_46196__$1 = (function (){var statearr_46255 = state_46196;
(statearr_46255[(12)] = inst_46119);

(statearr_46255[(13)] = inst_46153);

(statearr_46255[(14)] = inst_46118);

(statearr_46255[(15)] = inst_46116);

(statearr_46255[(16)] = inst_46117);

return statearr_46255;
})();
var statearr_46260_48420 = state_46196__$1;
(statearr_46260_48420[(2)] = null);

(statearr_46260_48420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (3))){
var inst_46191 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46196__$1,inst_46191);
} else {
if((state_val_46197 === (12))){
var inst_46162 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
var statearr_46269_48425 = state_46196__$1;
(statearr_46269_48425[(2)] = inst_46162);

(statearr_46269_48425[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (2))){
var state_46196__$1 = state_46196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46196__$1,(4),ch);
} else {
if((state_val_46197 === (23))){
var state_46196__$1 = state_46196;
var statearr_46270_48428 = state_46196__$1;
(statearr_46270_48428[(2)] = null);

(statearr_46270_48428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (19))){
var inst_46168 = (state_46196[(11)]);
var inst_46106 = (state_46196[(8)]);
var inst_46172 = cljs.core.async.muxch_STAR_(inst_46168);
var state_46196__$1 = state_46196;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46196__$1,(22),inst_46172,inst_46106);
} else {
if((state_val_46197 === (11))){
var inst_46116 = (state_46196[(15)]);
var inst_46137 = (state_46196[(10)]);
var inst_46137__$1 = cljs.core.seq(inst_46116);
var state_46196__$1 = (function (){var statearr_46273 = state_46196;
(statearr_46273[(10)] = inst_46137__$1);

return statearr_46273;
})();
if(inst_46137__$1){
var statearr_46274_48433 = state_46196__$1;
(statearr_46274_48433[(1)] = (13));

} else {
var statearr_46277_48435 = state_46196__$1;
(statearr_46277_48435[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (9))){
var inst_46164 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
var statearr_46280_48440 = state_46196__$1;
(statearr_46280_48440[(2)] = inst_46164);

(statearr_46280_48440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (5))){
var inst_46113 = cljs.core.deref(mults);
var inst_46114 = cljs.core.vals(inst_46113);
var inst_46115 = cljs.core.seq(inst_46114);
var inst_46116 = inst_46115;
var inst_46117 = null;
var inst_46118 = (0);
var inst_46119 = (0);
var state_46196__$1 = (function (){var statearr_46285 = state_46196;
(statearr_46285[(12)] = inst_46119);

(statearr_46285[(14)] = inst_46118);

(statearr_46285[(15)] = inst_46116);

(statearr_46285[(16)] = inst_46117);

return statearr_46285;
})();
var statearr_46286_48446 = state_46196__$1;
(statearr_46286_48446[(2)] = null);

(statearr_46286_48446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (14))){
var state_46196__$1 = state_46196;
var statearr_46294_48447 = state_46196__$1;
(statearr_46294_48447[(2)] = null);

(statearr_46294_48447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (16))){
var inst_46137 = (state_46196[(10)]);
var inst_46144 = cljs.core.chunk_first(inst_46137);
var inst_46145 = cljs.core.chunk_rest(inst_46137);
var inst_46147 = cljs.core.count(inst_46144);
var inst_46116 = inst_46145;
var inst_46117 = inst_46144;
var inst_46118 = inst_46147;
var inst_46119 = (0);
var state_46196__$1 = (function (){var statearr_46297 = state_46196;
(statearr_46297[(12)] = inst_46119);

(statearr_46297[(14)] = inst_46118);

(statearr_46297[(15)] = inst_46116);

(statearr_46297[(16)] = inst_46117);

return statearr_46297;
})();
var statearr_46299_48455 = state_46196__$1;
(statearr_46299_48455[(2)] = null);

(statearr_46299_48455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (10))){
var inst_46119 = (state_46196[(12)]);
var inst_46118 = (state_46196[(14)]);
var inst_46116 = (state_46196[(15)]);
var inst_46117 = (state_46196[(16)]);
var inst_46130 = cljs.core._nth(inst_46117,inst_46119);
var inst_46131 = cljs.core.async.muxch_STAR_(inst_46130);
var inst_46132 = cljs.core.async.close_BANG_(inst_46131);
var inst_46133 = (inst_46119 + (1));
var tmp46290 = inst_46118;
var tmp46291 = inst_46116;
var tmp46292 = inst_46117;
var inst_46116__$1 = tmp46291;
var inst_46117__$1 = tmp46292;
var inst_46118__$1 = tmp46290;
var inst_46119__$1 = inst_46133;
var state_46196__$1 = (function (){var statearr_46304 = state_46196;
(statearr_46304[(12)] = inst_46119__$1);

(statearr_46304[(14)] = inst_46118__$1);

(statearr_46304[(15)] = inst_46116__$1);

(statearr_46304[(17)] = inst_46132);

(statearr_46304[(16)] = inst_46117__$1);

return statearr_46304;
})();
var statearr_46308_48457 = state_46196__$1;
(statearr_46308_48457[(2)] = null);

(statearr_46308_48457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (18))){
var inst_46157 = (state_46196[(2)]);
var state_46196__$1 = state_46196;
var statearr_46317_48458 = state_46196__$1;
(statearr_46317_48458[(2)] = inst_46157);

(statearr_46317_48458[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46197 === (8))){
var inst_46119 = (state_46196[(12)]);
var inst_46118 = (state_46196[(14)]);
var inst_46123 = (inst_46119 < inst_46118);
var inst_46124 = inst_46123;
var state_46196__$1 = state_46196;
if(cljs.core.truth_(inst_46124)){
var statearr_46318_48459 = state_46196__$1;
(statearr_46318_48459[(1)] = (10));

} else {
var statearr_46319_48460 = state_46196__$1;
(statearr_46319_48460[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_46323 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46323[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_46323[(1)] = (1));

return statearr_46323;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_46196){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_46196);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e46325){var ex__43485__auto__ = e46325;
var statearr_46326_48462 = state_46196;
(statearr_46326_48462[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_46196[(4)]))){
var statearr_46327_48463 = state_46196;
(statearr_46327_48463[(1)] = cljs.core.first((state_46196[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48465 = state_46196;
state_46196 = G__48465;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_46196){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_46196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_46328 = f__43854__auto__();
(statearr_46328[(6)] = c__43853__auto___48402);

return statearr_46328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__46333 = arguments.length;
switch (G__46333) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__46351 = arguments.length;
switch (G__46351) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__46363 = arguments.length;
switch (G__46363) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43853__auto___48483 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_46420){
var state_val_46421 = (state_46420[(1)]);
if((state_val_46421 === (7))){
var state_46420__$1 = state_46420;
var statearr_46422_48489 = state_46420__$1;
(statearr_46422_48489[(2)] = null);

(statearr_46422_48489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (1))){
var state_46420__$1 = state_46420;
var statearr_46423_48492 = state_46420__$1;
(statearr_46423_48492[(2)] = null);

(statearr_46423_48492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (4))){
var inst_46374 = (state_46420[(7)]);
var inst_46372 = (state_46420[(8)]);
var inst_46376 = (inst_46374 < inst_46372);
var state_46420__$1 = state_46420;
if(cljs.core.truth_(inst_46376)){
var statearr_46424_48494 = state_46420__$1;
(statearr_46424_48494[(1)] = (6));

} else {
var statearr_46425_48495 = state_46420__$1;
(statearr_46425_48495[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (15))){
var inst_46406 = (state_46420[(9)]);
var inst_46411 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_46406);
var state_46420__$1 = state_46420;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46420__$1,(17),out,inst_46411);
} else {
if((state_val_46421 === (13))){
var inst_46406 = (state_46420[(9)]);
var inst_46406__$1 = (state_46420[(2)]);
var inst_46407 = cljs.core.some(cljs.core.nil_QMARK_,inst_46406__$1);
var state_46420__$1 = (function (){var statearr_46426 = state_46420;
(statearr_46426[(9)] = inst_46406__$1);

return statearr_46426;
})();
if(cljs.core.truth_(inst_46407)){
var statearr_46427_48496 = state_46420__$1;
(statearr_46427_48496[(1)] = (14));

} else {
var statearr_46428_48497 = state_46420__$1;
(statearr_46428_48497[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (6))){
var state_46420__$1 = state_46420;
var statearr_46429_48498 = state_46420__$1;
(statearr_46429_48498[(2)] = null);

(statearr_46429_48498[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (17))){
var inst_46413 = (state_46420[(2)]);
var state_46420__$1 = (function (){var statearr_46435 = state_46420;
(statearr_46435[(10)] = inst_46413);

return statearr_46435;
})();
var statearr_46437_48501 = state_46420__$1;
(statearr_46437_48501[(2)] = null);

(statearr_46437_48501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (3))){
var inst_46418 = (state_46420[(2)]);
var state_46420__$1 = state_46420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46420__$1,inst_46418);
} else {
if((state_val_46421 === (12))){
var _ = (function (){var statearr_46439 = state_46420;
(statearr_46439[(4)] = cljs.core.rest((state_46420[(4)])));

return statearr_46439;
})();
var state_46420__$1 = state_46420;
var ex46430 = (state_46420__$1[(2)]);
var statearr_46446_48505 = state_46420__$1;
(statearr_46446_48505[(5)] = ex46430);


if((ex46430 instanceof Object)){
var statearr_46450_48506 = state_46420__$1;
(statearr_46450_48506[(1)] = (11));

(statearr_46450_48506[(5)] = null);

} else {
throw ex46430;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (2))){
var inst_46371 = cljs.core.reset_BANG_(dctr,cnt);
var inst_46372 = cnt;
var inst_46374 = (0);
var state_46420__$1 = (function (){var statearr_46453 = state_46420;
(statearr_46453[(7)] = inst_46374);

(statearr_46453[(11)] = inst_46371);

(statearr_46453[(8)] = inst_46372);

return statearr_46453;
})();
var statearr_46454_48507 = state_46420__$1;
(statearr_46454_48507[(2)] = null);

(statearr_46454_48507[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (11))){
var inst_46385 = (state_46420[(2)]);
var inst_46386 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_46420__$1 = (function (){var statearr_46457 = state_46420;
(statearr_46457[(12)] = inst_46385);

return statearr_46457;
})();
var statearr_46458_48508 = state_46420__$1;
(statearr_46458_48508[(2)] = inst_46386);

(statearr_46458_48508[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (9))){
var inst_46374 = (state_46420[(7)]);
var _ = (function (){var statearr_46460 = state_46420;
(statearr_46460[(4)] = cljs.core.cons((12),(state_46420[(4)])));

return statearr_46460;
})();
var inst_46392 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_46374) : chs__$1.call(null,inst_46374));
var inst_46393 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_46374) : done.call(null,inst_46374));
var inst_46394 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_46392,inst_46393);
var ___$1 = (function (){var statearr_46461 = state_46420;
(statearr_46461[(4)] = cljs.core.rest((state_46420[(4)])));

return statearr_46461;
})();
var state_46420__$1 = state_46420;
var statearr_46466_48509 = state_46420__$1;
(statearr_46466_48509[(2)] = inst_46394);

(statearr_46466_48509[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (5))){
var inst_46404 = (state_46420[(2)]);
var state_46420__$1 = (function (){var statearr_46468 = state_46420;
(statearr_46468[(13)] = inst_46404);

return statearr_46468;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46420__$1,(13),dchan);
} else {
if((state_val_46421 === (14))){
var inst_46409 = cljs.core.async.close_BANG_(out);
var state_46420__$1 = state_46420;
var statearr_46470_48510 = state_46420__$1;
(statearr_46470_48510[(2)] = inst_46409);

(statearr_46470_48510[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (16))){
var inst_46416 = (state_46420[(2)]);
var state_46420__$1 = state_46420;
var statearr_46475_48511 = state_46420__$1;
(statearr_46475_48511[(2)] = inst_46416);

(statearr_46475_48511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (10))){
var inst_46374 = (state_46420[(7)]);
var inst_46397 = (state_46420[(2)]);
var inst_46398 = (inst_46374 + (1));
var inst_46374__$1 = inst_46398;
var state_46420__$1 = (function (){var statearr_46480 = state_46420;
(statearr_46480[(7)] = inst_46374__$1);

(statearr_46480[(14)] = inst_46397);

return statearr_46480;
})();
var statearr_46481_48514 = state_46420__$1;
(statearr_46481_48514[(2)] = null);

(statearr_46481_48514[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46421 === (8))){
var inst_46402 = (state_46420[(2)]);
var state_46420__$1 = state_46420;
var statearr_46483_48515 = state_46420__$1;
(statearr_46483_48515[(2)] = inst_46402);

(statearr_46483_48515[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_46488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46488[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_46488[(1)] = (1));

return statearr_46488;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_46420){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_46420);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e46491){var ex__43485__auto__ = e46491;
var statearr_46492_48516 = state_46420;
(statearr_46492_48516[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_46420[(4)]))){
var statearr_46493_48517 = state_46420;
(statearr_46493_48517[(1)] = cljs.core.first((state_46420[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48519 = state_46420;
state_46420 = G__48519;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_46420){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_46420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_46494 = f__43854__auto__();
(statearr_46494[(6)] = c__43853__auto___48483);

return statearr_46494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__46497 = arguments.length;
switch (G__46497) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43853__auto___48527 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_46530){
var state_val_46531 = (state_46530[(1)]);
if((state_val_46531 === (7))){
var inst_46508 = (state_46530[(7)]);
var inst_46509 = (state_46530[(8)]);
var inst_46508__$1 = (state_46530[(2)]);
var inst_46509__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46508__$1,(0),null);
var inst_46510 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46508__$1,(1),null);
var inst_46511 = (inst_46509__$1 == null);
var state_46530__$1 = (function (){var statearr_46535 = state_46530;
(statearr_46535[(7)] = inst_46508__$1);

(statearr_46535[(9)] = inst_46510);

(statearr_46535[(8)] = inst_46509__$1);

return statearr_46535;
})();
if(cljs.core.truth_(inst_46511)){
var statearr_46537_48533 = state_46530__$1;
(statearr_46537_48533[(1)] = (8));

} else {
var statearr_46538_48534 = state_46530__$1;
(statearr_46538_48534[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46531 === (1))){
var inst_46498 = cljs.core.vec(chs);
var inst_46499 = inst_46498;
var state_46530__$1 = (function (){var statearr_46539 = state_46530;
(statearr_46539[(10)] = inst_46499);

return statearr_46539;
})();
var statearr_46540_48538 = state_46530__$1;
(statearr_46540_48538[(2)] = null);

(statearr_46540_48538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46531 === (4))){
var inst_46499 = (state_46530[(10)]);
var state_46530__$1 = state_46530;
return cljs.core.async.ioc_alts_BANG_(state_46530__$1,(7),inst_46499);
} else {
if((state_val_46531 === (6))){
var inst_46525 = (state_46530[(2)]);
var state_46530__$1 = state_46530;
var statearr_46541_48540 = state_46530__$1;
(statearr_46541_48540[(2)] = inst_46525);

(statearr_46541_48540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46531 === (3))){
var inst_46527 = (state_46530[(2)]);
var state_46530__$1 = state_46530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46530__$1,inst_46527);
} else {
if((state_val_46531 === (2))){
var inst_46499 = (state_46530[(10)]);
var inst_46501 = cljs.core.count(inst_46499);
var inst_46502 = (inst_46501 > (0));
var state_46530__$1 = state_46530;
if(cljs.core.truth_(inst_46502)){
var statearr_46547_48543 = state_46530__$1;
(statearr_46547_48543[(1)] = (4));

} else {
var statearr_46548_48544 = state_46530__$1;
(statearr_46548_48544[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46531 === (11))){
var inst_46499 = (state_46530[(10)]);
var inst_46518 = (state_46530[(2)]);
var tmp46542 = inst_46499;
var inst_46499__$1 = tmp46542;
var state_46530__$1 = (function (){var statearr_46550 = state_46530;
(statearr_46550[(10)] = inst_46499__$1);

(statearr_46550[(11)] = inst_46518);

return statearr_46550;
})();
var statearr_46551_48549 = state_46530__$1;
(statearr_46551_48549[(2)] = null);

(statearr_46551_48549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46531 === (9))){
var inst_46509 = (state_46530[(8)]);
var state_46530__$1 = state_46530;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46530__$1,(11),out,inst_46509);
} else {
if((state_val_46531 === (5))){
var inst_46523 = cljs.core.async.close_BANG_(out);
var state_46530__$1 = state_46530;
var statearr_46557_48552 = state_46530__$1;
(statearr_46557_48552[(2)] = inst_46523);

(statearr_46557_48552[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46531 === (10))){
var inst_46521 = (state_46530[(2)]);
var state_46530__$1 = state_46530;
var statearr_46560_48553 = state_46530__$1;
(statearr_46560_48553[(2)] = inst_46521);

(statearr_46560_48553[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46531 === (8))){
var inst_46508 = (state_46530[(7)]);
var inst_46510 = (state_46530[(9)]);
var inst_46499 = (state_46530[(10)]);
var inst_46509 = (state_46530[(8)]);
var inst_46513 = (function (){var cs = inst_46499;
var vec__46504 = inst_46508;
var v = inst_46509;
var c = inst_46510;
return (function (p1__46495_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__46495_SHARP_);
});
})();
var inst_46514 = cljs.core.filterv(inst_46513,inst_46499);
var inst_46499__$1 = inst_46514;
var state_46530__$1 = (function (){var statearr_46563 = state_46530;
(statearr_46563[(10)] = inst_46499__$1);

return statearr_46563;
})();
var statearr_46564_48554 = state_46530__$1;
(statearr_46564_48554[(2)] = null);

(statearr_46564_48554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_46573 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46573[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_46573[(1)] = (1));

return statearr_46573;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_46530){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_46530);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e46574){var ex__43485__auto__ = e46574;
var statearr_46575_48556 = state_46530;
(statearr_46575_48556[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_46530[(4)]))){
var statearr_46580_48557 = state_46530;
(statearr_46580_48557[(1)] = cljs.core.first((state_46530[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48558 = state_46530;
state_46530 = G__48558;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_46530){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_46530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_46589 = f__43854__auto__();
(statearr_46589[(6)] = c__43853__auto___48527);

return statearr_46589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__46610 = arguments.length;
switch (G__46610) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43853__auto___48570 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_46640){
var state_val_46641 = (state_46640[(1)]);
if((state_val_46641 === (7))){
var inst_46622 = (state_46640[(7)]);
var inst_46622__$1 = (state_46640[(2)]);
var inst_46623 = (inst_46622__$1 == null);
var inst_46624 = cljs.core.not(inst_46623);
var state_46640__$1 = (function (){var statearr_46649 = state_46640;
(statearr_46649[(7)] = inst_46622__$1);

return statearr_46649;
})();
if(inst_46624){
var statearr_46650_48571 = state_46640__$1;
(statearr_46650_48571[(1)] = (8));

} else {
var statearr_46651_48572 = state_46640__$1;
(statearr_46651_48572[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (1))){
var inst_46617 = (0);
var state_46640__$1 = (function (){var statearr_46655 = state_46640;
(statearr_46655[(8)] = inst_46617);

return statearr_46655;
})();
var statearr_46656_48573 = state_46640__$1;
(statearr_46656_48573[(2)] = null);

(statearr_46656_48573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (4))){
var state_46640__$1 = state_46640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46640__$1,(7),ch);
} else {
if((state_val_46641 === (6))){
var inst_46635 = (state_46640[(2)]);
var state_46640__$1 = state_46640;
var statearr_46657_48578 = state_46640__$1;
(statearr_46657_48578[(2)] = inst_46635);

(statearr_46657_48578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (3))){
var inst_46637 = (state_46640[(2)]);
var inst_46638 = cljs.core.async.close_BANG_(out);
var state_46640__$1 = (function (){var statearr_46661 = state_46640;
(statearr_46661[(9)] = inst_46637);

return statearr_46661;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46640__$1,inst_46638);
} else {
if((state_val_46641 === (2))){
var inst_46617 = (state_46640[(8)]);
var inst_46619 = (inst_46617 < n);
var state_46640__$1 = state_46640;
if(cljs.core.truth_(inst_46619)){
var statearr_46662_48579 = state_46640__$1;
(statearr_46662_48579[(1)] = (4));

} else {
var statearr_46664_48580 = state_46640__$1;
(statearr_46664_48580[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (11))){
var inst_46617 = (state_46640[(8)]);
var inst_46627 = (state_46640[(2)]);
var inst_46628 = (inst_46617 + (1));
var inst_46617__$1 = inst_46628;
var state_46640__$1 = (function (){var statearr_46666 = state_46640;
(statearr_46666[(8)] = inst_46617__$1);

(statearr_46666[(10)] = inst_46627);

return statearr_46666;
})();
var statearr_46667_48586 = state_46640__$1;
(statearr_46667_48586[(2)] = null);

(statearr_46667_48586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (9))){
var state_46640__$1 = state_46640;
var statearr_46668_48587 = state_46640__$1;
(statearr_46668_48587[(2)] = null);

(statearr_46668_48587[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (5))){
var state_46640__$1 = state_46640;
var statearr_46669_48589 = state_46640__$1;
(statearr_46669_48589[(2)] = null);

(statearr_46669_48589[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (10))){
var inst_46632 = (state_46640[(2)]);
var state_46640__$1 = state_46640;
var statearr_46674_48590 = state_46640__$1;
(statearr_46674_48590[(2)] = inst_46632);

(statearr_46674_48590[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46641 === (8))){
var inst_46622 = (state_46640[(7)]);
var state_46640__$1 = state_46640;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46640__$1,(11),out,inst_46622);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_46680 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46680[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_46680[(1)] = (1));

return statearr_46680;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_46640){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_46640);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e46681){var ex__43485__auto__ = e46681;
var statearr_46682_48597 = state_46640;
(statearr_46682_48597[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_46640[(4)]))){
var statearr_46685_48598 = state_46640;
(statearr_46685_48598[(1)] = cljs.core.first((state_46640[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48599 = state_46640;
state_46640 = G__48599;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_46640){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_46640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_46689 = f__43854__auto__();
(statearr_46689[(6)] = c__43853__auto___48570);

return statearr_46689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46691 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46691 = (function (f,ch,meta46692){
this.f = f;
this.ch = ch;
this.meta46692 = meta46692;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46693,meta46692__$1){
var self__ = this;
var _46693__$1 = this;
return (new cljs.core.async.t_cljs$core$async46691(self__.f,self__.ch,meta46692__$1));
}));

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46693){
var self__ = this;
var _46693__$1 = this;
return self__.meta46692;
}));

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46702 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46702 = (function (f,ch,meta46692,_,fn1,meta46703){
this.f = f;
this.ch = ch;
this.meta46692 = meta46692;
this._ = _;
this.fn1 = fn1;
this.meta46703 = meta46703;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46702.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46704,meta46703__$1){
var self__ = this;
var _46704__$1 = this;
return (new cljs.core.async.t_cljs$core$async46702(self__.f,self__.ch,self__.meta46692,self__._,self__.fn1,meta46703__$1));
}));

(cljs.core.async.t_cljs$core$async46702.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46704){
var self__ = this;
var _46704__$1 = this;
return self__.meta46703;
}));

(cljs.core.async.t_cljs$core$async46702.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46702.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async46702.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46702.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__46690_SHARP_){
var G__46710 = (((p1__46690_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__46690_SHARP_) : self__.f.call(null,p1__46690_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__46710) : f1.call(null,G__46710));
});
}));

(cljs.core.async.t_cljs$core$async46702.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46692","meta46692",162946954,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async46691","cljs.core.async/t_cljs$core$async46691",1452678008,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta46703","meta46703",1813838807,null)], null);
}));

(cljs.core.async.t_cljs$core$async46702.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46702.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46702");

(cljs.core.async.t_cljs$core$async46702.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46702");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46702.
 */
cljs.core.async.__GT_t_cljs$core$async46702 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46702(f__$1,ch__$1,meta46692__$1,___$2,fn1__$1,meta46703){
return (new cljs.core.async.t_cljs$core$async46702(f__$1,ch__$1,meta46692__$1,___$2,fn1__$1,meta46703));
});

}

return (new cljs.core.async.t_cljs$core$async46702(self__.f,self__.ch,self__.meta46692,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4149__auto__ = ret;
if(cljs.core.truth_(and__4149__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4149__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__46714 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__46714) : self__.f.call(null,G__46714));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46691.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async46691.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46692","meta46692",162946954,null)], null);
}));

(cljs.core.async.t_cljs$core$async46691.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46691.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46691");

(cljs.core.async.t_cljs$core$async46691.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46691");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46691.
 */
cljs.core.async.__GT_t_cljs$core$async46691 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46691(f__$1,ch__$1,meta46692){
return (new cljs.core.async.t_cljs$core$async46691(f__$1,ch__$1,meta46692));
});

}

return (new cljs.core.async.t_cljs$core$async46691(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46727 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46727 = (function (f,ch,meta46728){
this.f = f;
this.ch = ch;
this.meta46728 = meta46728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46729,meta46728__$1){
var self__ = this;
var _46729__$1 = this;
return (new cljs.core.async.t_cljs$core$async46727(self__.f,self__.ch,meta46728__$1));
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46729){
var self__ = this;
var _46729__$1 = this;
return self__.meta46728;
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async46727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46728","meta46728",212090302,null)], null);
}));

(cljs.core.async.t_cljs$core$async46727.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46727.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46727");

(cljs.core.async.t_cljs$core$async46727.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46727");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46727.
 */
cljs.core.async.__GT_t_cljs$core$async46727 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async46727(f__$1,ch__$1,meta46728){
return (new cljs.core.async.t_cljs$core$async46727(f__$1,ch__$1,meta46728));
});

}

return (new cljs.core.async.t_cljs$core$async46727(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46734 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46734 = (function (p,ch,meta46735){
this.p = p;
this.ch = ch;
this.meta46735 = meta46735;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46736,meta46735__$1){
var self__ = this;
var _46736__$1 = this;
return (new cljs.core.async.t_cljs$core$async46734(self__.p,self__.ch,meta46735__$1));
}));

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46736){
var self__ = this;
var _46736__$1 = this;
return self__.meta46735;
}));

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46734.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async46734.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46735","meta46735",1834353300,null)], null);
}));

(cljs.core.async.t_cljs$core$async46734.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46734.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46734");

(cljs.core.async.t_cljs$core$async46734.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async46734");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46734.
 */
cljs.core.async.__GT_t_cljs$core$async46734 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async46734(p__$1,ch__$1,meta46735){
return (new cljs.core.async.t_cljs$core$async46734(p__$1,ch__$1,meta46735));
});

}

return (new cljs.core.async.t_cljs$core$async46734(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__46760 = arguments.length;
switch (G__46760) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43853__auto___48679 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_46785){
var state_val_46786 = (state_46785[(1)]);
if((state_val_46786 === (7))){
var inst_46781 = (state_46785[(2)]);
var state_46785__$1 = state_46785;
var statearr_46787_48680 = state_46785__$1;
(statearr_46787_48680[(2)] = inst_46781);

(statearr_46787_48680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (1))){
var state_46785__$1 = state_46785;
var statearr_46788_48686 = state_46785__$1;
(statearr_46788_48686[(2)] = null);

(statearr_46788_48686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (4))){
var inst_46767 = (state_46785[(7)]);
var inst_46767__$1 = (state_46785[(2)]);
var inst_46768 = (inst_46767__$1 == null);
var state_46785__$1 = (function (){var statearr_46789 = state_46785;
(statearr_46789[(7)] = inst_46767__$1);

return statearr_46789;
})();
if(cljs.core.truth_(inst_46768)){
var statearr_46790_48701 = state_46785__$1;
(statearr_46790_48701[(1)] = (5));

} else {
var statearr_46791_48702 = state_46785__$1;
(statearr_46791_48702[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (6))){
var inst_46767 = (state_46785[(7)]);
var inst_46772 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46767) : p.call(null,inst_46767));
var state_46785__$1 = state_46785;
if(cljs.core.truth_(inst_46772)){
var statearr_46793_48704 = state_46785__$1;
(statearr_46793_48704[(1)] = (8));

} else {
var statearr_46794_48705 = state_46785__$1;
(statearr_46794_48705[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (3))){
var inst_46783 = (state_46785[(2)]);
var state_46785__$1 = state_46785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46785__$1,inst_46783);
} else {
if((state_val_46786 === (2))){
var state_46785__$1 = state_46785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46785__$1,(4),ch);
} else {
if((state_val_46786 === (11))){
var inst_46775 = (state_46785[(2)]);
var state_46785__$1 = state_46785;
var statearr_46795_48724 = state_46785__$1;
(statearr_46795_48724[(2)] = inst_46775);

(statearr_46795_48724[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (9))){
var state_46785__$1 = state_46785;
var statearr_46796_48730 = state_46785__$1;
(statearr_46796_48730[(2)] = null);

(statearr_46796_48730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (5))){
var inst_46770 = cljs.core.async.close_BANG_(out);
var state_46785__$1 = state_46785;
var statearr_46797_48740 = state_46785__$1;
(statearr_46797_48740[(2)] = inst_46770);

(statearr_46797_48740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (10))){
var inst_46778 = (state_46785[(2)]);
var state_46785__$1 = (function (){var statearr_46798 = state_46785;
(statearr_46798[(8)] = inst_46778);

return statearr_46798;
})();
var statearr_46799_48745 = state_46785__$1;
(statearr_46799_48745[(2)] = null);

(statearr_46799_48745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46786 === (8))){
var inst_46767 = (state_46785[(7)]);
var state_46785__$1 = state_46785;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46785__$1,(11),out,inst_46767);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_46806 = [null,null,null,null,null,null,null,null,null];
(statearr_46806[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_46806[(1)] = (1));

return statearr_46806;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_46785){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_46785);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e46807){var ex__43485__auto__ = e46807;
var statearr_46808_48757 = state_46785;
(statearr_46808_48757[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_46785[(4)]))){
var statearr_46809_48762 = state_46785;
(statearr_46809_48762[(1)] = cljs.core.first((state_46785[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48771 = state_46785;
state_46785 = G__48771;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_46785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_46785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_46811 = f__43854__auto__();
(statearr_46811[(6)] = c__43853__auto___48679);

return statearr_46811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__46817 = arguments.length;
switch (G__46817) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_46885){
var state_val_46886 = (state_46885[(1)]);
if((state_val_46886 === (7))){
var inst_46877 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46898_48798 = state_46885__$1;
(statearr_46898_48798[(2)] = inst_46877);

(statearr_46898_48798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (20))){
var inst_46847 = (state_46885[(7)]);
var inst_46858 = (state_46885[(2)]);
var inst_46859 = cljs.core.next(inst_46847);
var inst_46832 = inst_46859;
var inst_46833 = null;
var inst_46834 = (0);
var inst_46835 = (0);
var state_46885__$1 = (function (){var statearr_46901 = state_46885;
(statearr_46901[(8)] = inst_46858);

(statearr_46901[(9)] = inst_46832);

(statearr_46901[(10)] = inst_46835);

(statearr_46901[(11)] = inst_46834);

(statearr_46901[(12)] = inst_46833);

return statearr_46901;
})();
var statearr_46902_48800 = state_46885__$1;
(statearr_46902_48800[(2)] = null);

(statearr_46902_48800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (1))){
var state_46885__$1 = state_46885;
var statearr_46903_48802 = state_46885__$1;
(statearr_46903_48802[(2)] = null);

(statearr_46903_48802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (4))){
var inst_46820 = (state_46885[(13)]);
var inst_46820__$1 = (state_46885[(2)]);
var inst_46821 = (inst_46820__$1 == null);
var state_46885__$1 = (function (){var statearr_46905 = state_46885;
(statearr_46905[(13)] = inst_46820__$1);

return statearr_46905;
})();
if(cljs.core.truth_(inst_46821)){
var statearr_46906_48807 = state_46885__$1;
(statearr_46906_48807[(1)] = (5));

} else {
var statearr_46907_48809 = state_46885__$1;
(statearr_46907_48809[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (15))){
var state_46885__$1 = state_46885;
var statearr_46911_48810 = state_46885__$1;
(statearr_46911_48810[(2)] = null);

(statearr_46911_48810[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (21))){
var state_46885__$1 = state_46885;
var statearr_46912_48812 = state_46885__$1;
(statearr_46912_48812[(2)] = null);

(statearr_46912_48812[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (13))){
var inst_46832 = (state_46885[(9)]);
var inst_46835 = (state_46885[(10)]);
var inst_46834 = (state_46885[(11)]);
var inst_46833 = (state_46885[(12)]);
var inst_46843 = (state_46885[(2)]);
var inst_46844 = (inst_46835 + (1));
var tmp46908 = inst_46832;
var tmp46909 = inst_46834;
var tmp46910 = inst_46833;
var inst_46832__$1 = tmp46908;
var inst_46833__$1 = tmp46910;
var inst_46834__$1 = tmp46909;
var inst_46835__$1 = inst_46844;
var state_46885__$1 = (function (){var statearr_46913 = state_46885;
(statearr_46913[(14)] = inst_46843);

(statearr_46913[(9)] = inst_46832__$1);

(statearr_46913[(10)] = inst_46835__$1);

(statearr_46913[(11)] = inst_46834__$1);

(statearr_46913[(12)] = inst_46833__$1);

return statearr_46913;
})();
var statearr_46914_48813 = state_46885__$1;
(statearr_46914_48813[(2)] = null);

(statearr_46914_48813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (22))){
var state_46885__$1 = state_46885;
var statearr_46917_48815 = state_46885__$1;
(statearr_46917_48815[(2)] = null);

(statearr_46917_48815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (6))){
var inst_46820 = (state_46885[(13)]);
var inst_46829 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46820) : f.call(null,inst_46820));
var inst_46830 = cljs.core.seq(inst_46829);
var inst_46832 = inst_46830;
var inst_46833 = null;
var inst_46834 = (0);
var inst_46835 = (0);
var state_46885__$1 = (function (){var statearr_46920 = state_46885;
(statearr_46920[(9)] = inst_46832);

(statearr_46920[(10)] = inst_46835);

(statearr_46920[(11)] = inst_46834);

(statearr_46920[(12)] = inst_46833);

return statearr_46920;
})();
var statearr_46921_48830 = state_46885__$1;
(statearr_46921_48830[(2)] = null);

(statearr_46921_48830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (17))){
var inst_46847 = (state_46885[(7)]);
var inst_46851 = cljs.core.chunk_first(inst_46847);
var inst_46852 = cljs.core.chunk_rest(inst_46847);
var inst_46853 = cljs.core.count(inst_46851);
var inst_46832 = inst_46852;
var inst_46833 = inst_46851;
var inst_46834 = inst_46853;
var inst_46835 = (0);
var state_46885__$1 = (function (){var statearr_46922 = state_46885;
(statearr_46922[(9)] = inst_46832);

(statearr_46922[(10)] = inst_46835);

(statearr_46922[(11)] = inst_46834);

(statearr_46922[(12)] = inst_46833);

return statearr_46922;
})();
var statearr_46923_48833 = state_46885__$1;
(statearr_46923_48833[(2)] = null);

(statearr_46923_48833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (3))){
var inst_46879 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46885__$1,inst_46879);
} else {
if((state_val_46886 === (12))){
var inst_46867 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46930_48834 = state_46885__$1;
(statearr_46930_48834[(2)] = inst_46867);

(statearr_46930_48834[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (2))){
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46885__$1,(4),in$);
} else {
if((state_val_46886 === (23))){
var inst_46875 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46933_48840 = state_46885__$1;
(statearr_46933_48840[(2)] = inst_46875);

(statearr_46933_48840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (19))){
var inst_46862 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46935_48852 = state_46885__$1;
(statearr_46935_48852[(2)] = inst_46862);

(statearr_46935_48852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (11))){
var inst_46847 = (state_46885[(7)]);
var inst_46832 = (state_46885[(9)]);
var inst_46847__$1 = cljs.core.seq(inst_46832);
var state_46885__$1 = (function (){var statearr_46936 = state_46885;
(statearr_46936[(7)] = inst_46847__$1);

return statearr_46936;
})();
if(inst_46847__$1){
var statearr_46937_48862 = state_46885__$1;
(statearr_46937_48862[(1)] = (14));

} else {
var statearr_46938_48865 = state_46885__$1;
(statearr_46938_48865[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (9))){
var inst_46869 = (state_46885[(2)]);
var inst_46870 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_46885__$1 = (function (){var statearr_46939 = state_46885;
(statearr_46939[(15)] = inst_46869);

return statearr_46939;
})();
if(cljs.core.truth_(inst_46870)){
var statearr_46940_48868 = state_46885__$1;
(statearr_46940_48868[(1)] = (21));

} else {
var statearr_46941_48870 = state_46885__$1;
(statearr_46941_48870[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (5))){
var inst_46823 = cljs.core.async.close_BANG_(out);
var state_46885__$1 = state_46885;
var statearr_46942_48871 = state_46885__$1;
(statearr_46942_48871[(2)] = inst_46823);

(statearr_46942_48871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (14))){
var inst_46847 = (state_46885[(7)]);
var inst_46849 = cljs.core.chunked_seq_QMARK_(inst_46847);
var state_46885__$1 = state_46885;
if(inst_46849){
var statearr_46947_48877 = state_46885__$1;
(statearr_46947_48877[(1)] = (17));

} else {
var statearr_46948_48878 = state_46885__$1;
(statearr_46948_48878[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (16))){
var inst_46865 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46956_48880 = state_46885__$1;
(statearr_46956_48880[(2)] = inst_46865);

(statearr_46956_48880[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (10))){
var inst_46835 = (state_46885[(10)]);
var inst_46833 = (state_46885[(12)]);
var inst_46841 = cljs.core._nth(inst_46833,inst_46835);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46885__$1,(13),out,inst_46841);
} else {
if((state_val_46886 === (18))){
var inst_46847 = (state_46885[(7)]);
var inst_46856 = cljs.core.first(inst_46847);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46885__$1,(20),out,inst_46856);
} else {
if((state_val_46886 === (8))){
var inst_46835 = (state_46885[(10)]);
var inst_46834 = (state_46885[(11)]);
var inst_46837 = (inst_46835 < inst_46834);
var inst_46838 = inst_46837;
var state_46885__$1 = state_46885;
if(cljs.core.truth_(inst_46838)){
var statearr_46967_48888 = state_46885__$1;
(statearr_46967_48888[(1)] = (10));

} else {
var statearr_46968_48890 = state_46885__$1;
(statearr_46968_48890[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43482__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43482__auto____0 = (function (){
var statearr_46974 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46974[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43482__auto__);

(statearr_46974[(1)] = (1));

return statearr_46974;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43482__auto____1 = (function (state_46885){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_46885);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e46975){var ex__43485__auto__ = e46975;
var statearr_46976_48901 = state_46885;
(statearr_46976_48901[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_46885[(4)]))){
var statearr_46977_48908 = state_46885;
(statearr_46977_48908[(1)] = cljs.core.first((state_46885[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48915 = state_46885;
state_46885 = G__48915;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43482__auto__ = function(state_46885){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43482__auto____1.call(this,state_46885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43482__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43482__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_46981 = f__43854__auto__();
(statearr_46981[(6)] = c__43853__auto__);

return statearr_46981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

return c__43853__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__46985 = arguments.length;
switch (G__46985) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__46999 = arguments.length;
switch (G__46999) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__47011 = arguments.length;
switch (G__47011) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43853__auto___48956 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_47048){
var state_val_47049 = (state_47048[(1)]);
if((state_val_47049 === (7))){
var inst_47043 = (state_47048[(2)]);
var state_47048__$1 = state_47048;
var statearr_47063_48964 = state_47048__$1;
(statearr_47063_48964[(2)] = inst_47043);

(statearr_47063_48964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47049 === (1))){
var inst_47014 = null;
var state_47048__$1 = (function (){var statearr_47064 = state_47048;
(statearr_47064[(7)] = inst_47014);

return statearr_47064;
})();
var statearr_47065_48972 = state_47048__$1;
(statearr_47065_48972[(2)] = null);

(statearr_47065_48972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47049 === (4))){
var inst_47020 = (state_47048[(8)]);
var inst_47020__$1 = (state_47048[(2)]);
var inst_47021 = (inst_47020__$1 == null);
var inst_47022 = cljs.core.not(inst_47021);
var state_47048__$1 = (function (){var statearr_47066 = state_47048;
(statearr_47066[(8)] = inst_47020__$1);

return statearr_47066;
})();
if(inst_47022){
var statearr_47069_48979 = state_47048__$1;
(statearr_47069_48979[(1)] = (5));

} else {
var statearr_47078_48984 = state_47048__$1;
(statearr_47078_48984[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47049 === (6))){
var state_47048__$1 = state_47048;
var statearr_47085_48985 = state_47048__$1;
(statearr_47085_48985[(2)] = null);

(statearr_47085_48985[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47049 === (3))){
var inst_47045 = (state_47048[(2)]);
var inst_47046 = cljs.core.async.close_BANG_(out);
var state_47048__$1 = (function (){var statearr_47092 = state_47048;
(statearr_47092[(9)] = inst_47045);

return statearr_47092;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47048__$1,inst_47046);
} else {
if((state_val_47049 === (2))){
var state_47048__$1 = state_47048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47048__$1,(4),ch);
} else {
if((state_val_47049 === (11))){
var inst_47020 = (state_47048[(8)]);
var inst_47029 = (state_47048[(2)]);
var inst_47014 = inst_47020;
var state_47048__$1 = (function (){var statearr_47094 = state_47048;
(statearr_47094[(7)] = inst_47014);

(statearr_47094[(10)] = inst_47029);

return statearr_47094;
})();
var statearr_47095_49009 = state_47048__$1;
(statearr_47095_49009[(2)] = null);

(statearr_47095_49009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47049 === (9))){
var inst_47020 = (state_47048[(8)]);
var state_47048__$1 = state_47048;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47048__$1,(11),out,inst_47020);
} else {
if((state_val_47049 === (5))){
var inst_47014 = (state_47048[(7)]);
var inst_47020 = (state_47048[(8)]);
var inst_47024 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47020,inst_47014);
var state_47048__$1 = state_47048;
if(inst_47024){
var statearr_47099_49016 = state_47048__$1;
(statearr_47099_49016[(1)] = (8));

} else {
var statearr_47100_49017 = state_47048__$1;
(statearr_47100_49017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47049 === (10))){
var inst_47040 = (state_47048[(2)]);
var state_47048__$1 = state_47048;
var statearr_47101_49021 = state_47048__$1;
(statearr_47101_49021[(2)] = inst_47040);

(statearr_47101_49021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47049 === (8))){
var inst_47014 = (state_47048[(7)]);
var tmp47096 = inst_47014;
var inst_47014__$1 = tmp47096;
var state_47048__$1 = (function (){var statearr_47102 = state_47048;
(statearr_47102[(7)] = inst_47014__$1);

return statearr_47102;
})();
var statearr_47103_49024 = state_47048__$1;
(statearr_47103_49024[(2)] = null);

(statearr_47103_49024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_47105 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47105[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_47105[(1)] = (1));

return statearr_47105;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_47048){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_47048);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e47106){var ex__43485__auto__ = e47106;
var statearr_47107_49029 = state_47048;
(statearr_47107_49029[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_47048[(4)]))){
var statearr_47108_49030 = state_47048;
(statearr_47108_49030[(1)] = cljs.core.first((state_47048[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49031 = state_47048;
state_47048 = G__49031;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_47048){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_47048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_47109 = f__43854__auto__();
(statearr_47109[(6)] = c__43853__auto___48956);

return statearr_47109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__47114 = arguments.length;
switch (G__47114) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43853__auto___49038 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_47158){
var state_val_47159 = (state_47158[(1)]);
if((state_val_47159 === (7))){
var inst_47154 = (state_47158[(2)]);
var state_47158__$1 = state_47158;
var statearr_47165_49039 = state_47158__$1;
(statearr_47165_49039[(2)] = inst_47154);

(statearr_47165_49039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (1))){
var inst_47117 = (new Array(n));
var inst_47118 = inst_47117;
var inst_47119 = (0);
var state_47158__$1 = (function (){var statearr_47166 = state_47158;
(statearr_47166[(7)] = inst_47118);

(statearr_47166[(8)] = inst_47119);

return statearr_47166;
})();
var statearr_47167_49040 = state_47158__$1;
(statearr_47167_49040[(2)] = null);

(statearr_47167_49040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (4))){
var inst_47124 = (state_47158[(9)]);
var inst_47124__$1 = (state_47158[(2)]);
var inst_47125 = (inst_47124__$1 == null);
var inst_47126 = cljs.core.not(inst_47125);
var state_47158__$1 = (function (){var statearr_47168 = state_47158;
(statearr_47168[(9)] = inst_47124__$1);

return statearr_47168;
})();
if(inst_47126){
var statearr_47169_49041 = state_47158__$1;
(statearr_47169_49041[(1)] = (5));

} else {
var statearr_47170_49043 = state_47158__$1;
(statearr_47170_49043[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (15))){
var inst_47148 = (state_47158[(2)]);
var state_47158__$1 = state_47158;
var statearr_47175_49044 = state_47158__$1;
(statearr_47175_49044[(2)] = inst_47148);

(statearr_47175_49044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (13))){
var state_47158__$1 = state_47158;
var statearr_47180_49045 = state_47158__$1;
(statearr_47180_49045[(2)] = null);

(statearr_47180_49045[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (6))){
var inst_47119 = (state_47158[(8)]);
var inst_47144 = (inst_47119 > (0));
var state_47158__$1 = state_47158;
if(cljs.core.truth_(inst_47144)){
var statearr_47201_49051 = state_47158__$1;
(statearr_47201_49051[(1)] = (12));

} else {
var statearr_47202_49053 = state_47158__$1;
(statearr_47202_49053[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (3))){
var inst_47156 = (state_47158[(2)]);
var state_47158__$1 = state_47158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47158__$1,inst_47156);
} else {
if((state_val_47159 === (12))){
var inst_47118 = (state_47158[(7)]);
var inst_47146 = cljs.core.vec(inst_47118);
var state_47158__$1 = state_47158;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47158__$1,(15),out,inst_47146);
} else {
if((state_val_47159 === (2))){
var state_47158__$1 = state_47158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47158__$1,(4),ch);
} else {
if((state_val_47159 === (11))){
var inst_47138 = (state_47158[(2)]);
var inst_47139 = (new Array(n));
var inst_47118 = inst_47139;
var inst_47119 = (0);
var state_47158__$1 = (function (){var statearr_47209 = state_47158;
(statearr_47209[(7)] = inst_47118);

(statearr_47209[(8)] = inst_47119);

(statearr_47209[(10)] = inst_47138);

return statearr_47209;
})();
var statearr_47210_49060 = state_47158__$1;
(statearr_47210_49060[(2)] = null);

(statearr_47210_49060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (9))){
var inst_47118 = (state_47158[(7)]);
var inst_47136 = cljs.core.vec(inst_47118);
var state_47158__$1 = state_47158;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47158__$1,(11),out,inst_47136);
} else {
if((state_val_47159 === (5))){
var inst_47129 = (state_47158[(11)]);
var inst_47118 = (state_47158[(7)]);
var inst_47119 = (state_47158[(8)]);
var inst_47124 = (state_47158[(9)]);
var inst_47128 = (inst_47118[inst_47119] = inst_47124);
var inst_47129__$1 = (inst_47119 + (1));
var inst_47130 = (inst_47129__$1 < n);
var state_47158__$1 = (function (){var statearr_47216 = state_47158;
(statearr_47216[(11)] = inst_47129__$1);

(statearr_47216[(12)] = inst_47128);

return statearr_47216;
})();
if(cljs.core.truth_(inst_47130)){
var statearr_47217_49063 = state_47158__$1;
(statearr_47217_49063[(1)] = (8));

} else {
var statearr_47218_49064 = state_47158__$1;
(statearr_47218_49064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (14))){
var inst_47151 = (state_47158[(2)]);
var inst_47152 = cljs.core.async.close_BANG_(out);
var state_47158__$1 = (function (){var statearr_47220 = state_47158;
(statearr_47220[(13)] = inst_47151);

return statearr_47220;
})();
var statearr_47221_49070 = state_47158__$1;
(statearr_47221_49070[(2)] = inst_47152);

(statearr_47221_49070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (10))){
var inst_47142 = (state_47158[(2)]);
var state_47158__$1 = state_47158;
var statearr_47222_49071 = state_47158__$1;
(statearr_47222_49071[(2)] = inst_47142);

(statearr_47222_49071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47159 === (8))){
var inst_47129 = (state_47158[(11)]);
var inst_47118 = (state_47158[(7)]);
var tmp47219 = inst_47118;
var inst_47118__$1 = tmp47219;
var inst_47119 = inst_47129;
var state_47158__$1 = (function (){var statearr_47224 = state_47158;
(statearr_47224[(7)] = inst_47118__$1);

(statearr_47224[(8)] = inst_47119);

return statearr_47224;
})();
var statearr_47225_49083 = state_47158__$1;
(statearr_47225_49083[(2)] = null);

(statearr_47225_49083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_47226 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47226[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_47226[(1)] = (1));

return statearr_47226;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_47158){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_47158);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e47227){var ex__43485__auto__ = e47227;
var statearr_47228_49085 = state_47158;
(statearr_47228_49085[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_47158[(4)]))){
var statearr_47229_49086 = state_47158;
(statearr_47229_49086[(1)] = cljs.core.first((state_47158[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49087 = state_47158;
state_47158 = G__49087;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_47158){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_47158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_47230 = f__43854__auto__();
(statearr_47230[(6)] = c__43853__auto___49038);

return statearr_47230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__47240 = arguments.length;
switch (G__47240) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43853__auto___49095 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_47291){
var state_val_47292 = (state_47291[(1)]);
if((state_val_47292 === (7))){
var inst_47287 = (state_47291[(2)]);
var state_47291__$1 = state_47291;
var statearr_47293_49101 = state_47291__$1;
(statearr_47293_49101[(2)] = inst_47287);

(statearr_47293_49101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (1))){
var inst_47250 = [];
var inst_47251 = inst_47250;
var inst_47252 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_47291__$1 = (function (){var statearr_47294 = state_47291;
(statearr_47294[(7)] = inst_47252);

(statearr_47294[(8)] = inst_47251);

return statearr_47294;
})();
var statearr_47295_49102 = state_47291__$1;
(statearr_47295_49102[(2)] = null);

(statearr_47295_49102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (4))){
var inst_47255 = (state_47291[(9)]);
var inst_47255__$1 = (state_47291[(2)]);
var inst_47256 = (inst_47255__$1 == null);
var inst_47257 = cljs.core.not(inst_47256);
var state_47291__$1 = (function (){var statearr_47298 = state_47291;
(statearr_47298[(9)] = inst_47255__$1);

return statearr_47298;
})();
if(inst_47257){
var statearr_47301_49104 = state_47291__$1;
(statearr_47301_49104[(1)] = (5));

} else {
var statearr_47302_49106 = state_47291__$1;
(statearr_47302_49106[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (15))){
var inst_47281 = (state_47291[(2)]);
var state_47291__$1 = state_47291;
var statearr_47303_49108 = state_47291__$1;
(statearr_47303_49108[(2)] = inst_47281);

(statearr_47303_49108[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (13))){
var state_47291__$1 = state_47291;
var statearr_47304_49109 = state_47291__$1;
(statearr_47304_49109[(2)] = null);

(statearr_47304_49109[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (6))){
var inst_47251 = (state_47291[(8)]);
var inst_47276 = inst_47251.length;
var inst_47277 = (inst_47276 > (0));
var state_47291__$1 = state_47291;
if(cljs.core.truth_(inst_47277)){
var statearr_47305_49111 = state_47291__$1;
(statearr_47305_49111[(1)] = (12));

} else {
var statearr_47309_49116 = state_47291__$1;
(statearr_47309_49116[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (3))){
var inst_47289 = (state_47291[(2)]);
var state_47291__$1 = state_47291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47291__$1,inst_47289);
} else {
if((state_val_47292 === (12))){
var inst_47251 = (state_47291[(8)]);
var inst_47279 = cljs.core.vec(inst_47251);
var state_47291__$1 = state_47291;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47291__$1,(15),out,inst_47279);
} else {
if((state_val_47292 === (2))){
var state_47291__$1 = state_47291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47291__$1,(4),ch);
} else {
if((state_val_47292 === (11))){
var inst_47259 = (state_47291[(10)]);
var inst_47255 = (state_47291[(9)]);
var inst_47269 = (state_47291[(2)]);
var inst_47270 = [];
var inst_47271 = inst_47270.push(inst_47255);
var inst_47251 = inst_47270;
var inst_47252 = inst_47259;
var state_47291__$1 = (function (){var statearr_47312 = state_47291;
(statearr_47312[(11)] = inst_47271);

(statearr_47312[(7)] = inst_47252);

(statearr_47312[(8)] = inst_47251);

(statearr_47312[(12)] = inst_47269);

return statearr_47312;
})();
var statearr_47317_49118 = state_47291__$1;
(statearr_47317_49118[(2)] = null);

(statearr_47317_49118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (9))){
var inst_47251 = (state_47291[(8)]);
var inst_47267 = cljs.core.vec(inst_47251);
var state_47291__$1 = state_47291;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47291__$1,(11),out,inst_47267);
} else {
if((state_val_47292 === (5))){
var inst_47252 = (state_47291[(7)]);
var inst_47259 = (state_47291[(10)]);
var inst_47255 = (state_47291[(9)]);
var inst_47259__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47255) : f.call(null,inst_47255));
var inst_47260 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47259__$1,inst_47252);
var inst_47261 = cljs.core.keyword_identical_QMARK_(inst_47252,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_47262 = ((inst_47260) || (inst_47261));
var state_47291__$1 = (function (){var statearr_47320 = state_47291;
(statearr_47320[(10)] = inst_47259__$1);

return statearr_47320;
})();
if(cljs.core.truth_(inst_47262)){
var statearr_47321_49120 = state_47291__$1;
(statearr_47321_49120[(1)] = (8));

} else {
var statearr_47322_49121 = state_47291__$1;
(statearr_47322_49121[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (14))){
var inst_47284 = (state_47291[(2)]);
var inst_47285 = cljs.core.async.close_BANG_(out);
var state_47291__$1 = (function (){var statearr_47328 = state_47291;
(statearr_47328[(13)] = inst_47284);

return statearr_47328;
})();
var statearr_47329_49126 = state_47291__$1;
(statearr_47329_49126[(2)] = inst_47285);

(statearr_47329_49126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (10))){
var inst_47274 = (state_47291[(2)]);
var state_47291__$1 = state_47291;
var statearr_47330_49131 = state_47291__$1;
(statearr_47330_49131[(2)] = inst_47274);

(statearr_47330_49131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47292 === (8))){
var inst_47251 = (state_47291[(8)]);
var inst_47259 = (state_47291[(10)]);
var inst_47255 = (state_47291[(9)]);
var inst_47264 = inst_47251.push(inst_47255);
var tmp47323 = inst_47251;
var inst_47251__$1 = tmp47323;
var inst_47252 = inst_47259;
var state_47291__$1 = (function (){var statearr_47333 = state_47291;
(statearr_47333[(7)] = inst_47252);

(statearr_47333[(14)] = inst_47264);

(statearr_47333[(8)] = inst_47251__$1);

return statearr_47333;
})();
var statearr_47334_49133 = state_47291__$1;
(statearr_47334_49133[(2)] = null);

(statearr_47334_49133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43482__auto__ = null;
var cljs$core$async$state_machine__43482__auto____0 = (function (){
var statearr_47335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47335[(0)] = cljs$core$async$state_machine__43482__auto__);

(statearr_47335[(1)] = (1));

return statearr_47335;
});
var cljs$core$async$state_machine__43482__auto____1 = (function (state_47291){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_47291);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e47338){var ex__43485__auto__ = e47338;
var statearr_47339_49145 = state_47291;
(statearr_47339_49145[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_47291[(4)]))){
var statearr_47340_49151 = state_47291;
(statearr_47340_49151[(1)] = cljs.core.first((state_47291[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49152 = state_47291;
state_47291 = G__49152;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
cljs$core$async$state_machine__43482__auto__ = function(state_47291){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43482__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43482__auto____1.call(this,state_47291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43482__auto____0;
cljs$core$async$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43482__auto____1;
return cljs$core$async$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_47341 = f__43854__auto__();
(statearr_47341[(6)] = c__43853__auto___49095);

return statearr_47341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
