goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___54267 = schema.utils.use_fn_validation;
var output_schema53877_54268 = schema.core.Bool;
var input_schema53878_54269 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53879_54270 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53878_54269);
}),null));
var output_checker53880_54271 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53877_54268);
}),null));
var ret__53164__auto___54272 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__53881){
var validate__51189__auto__ = cljs.core.deref(ufv___54267);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54273 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53881], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53898_54274 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53899_54275 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__53900_54276 = input_schema53878_54269;
var G__53901_54277 = cljs.core.deref(input_checker53879_54270);
var G__53902_54278 = args__51190__auto___54273;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53898_54274,G__53899_54275,G__53900_54276,G__53901_54277,G__53902_54278) : schema.core.fn_validator.call(null,G__53898_54274,G__53899_54275,G__53900_54276,G__53901_54277,G__53902_54278));
} else {
var temp__5753__auto___54279 = (function (){var fexpr__53903 = cljs.core.deref(input_checker53879_54270);
return (fexpr__53903.cljs$core$IFn$_invoke$arity$1 ? fexpr__53903.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54273) : fexpr__53903.call(null,args__51190__auto___54273));
})();
if(cljs.core.truth_(temp__5753__auto___54279)){
var error__51191__auto___54280 = temp__5753__auto___54279;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54280], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53878_54269,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54273,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54280], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var arg = G__53881;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53904_54281 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53905_54282 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__53906_54283 = output_schema53877_54268;
var G__53907_54284 = cljs.core.deref(output_checker53880_54271);
var G__53908_54285 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53904_54281,G__53905_54282,G__53906_54283,G__53907_54284,G__53908_54285) : schema.core.fn_validator.call(null,G__53904_54281,G__53905_54282,G__53906_54283,G__53907_54284,G__53908_54285));
} else {
var temp__5753__auto___54287 = (function (){var fexpr__53909 = cljs.core.deref(output_checker53880_54271);
return (fexpr__53909.cljs$core$IFn$_invoke$arity$1 ? fexpr__53909.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__53909.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54287)){
var error__51191__auto___54288 = temp__5753__auto___54287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54288], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53877_54268,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54288], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema53877_54268,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53878_54269], null)));

var ufv___54289 = schema.utils.use_fn_validation;
var output_schema53910_54290 = deercreeklabs.baracus.ByteArray;
var input_schema53911_54291 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema53915_54292 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker53912_54293 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53911_54291);
}),null));
var output_checker53913_54294 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53910_54290);
}),null));
var input_checker53916_54295 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53915_54292);
}),null));
var output_checker53917_54296 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53910_54290);
}),null));
var ret__53164__auto___54298 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__53922 = arguments.length;
switch (G__53922) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__53914){
var validate__51189__auto__ = cljs.core.deref(ufv___54289);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54300 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53914], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53923_54301 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53924_54302 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53925_54303 = input_schema53911_54291;
var G__53926_54304 = cljs.core.deref(input_checker53912_54293);
var G__53927_54305 = args__51190__auto___54300;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53923_54301,G__53924_54302,G__53925_54303,G__53926_54304,G__53927_54305) : schema.core.fn_validator.call(null,G__53923_54301,G__53924_54302,G__53925_54303,G__53926_54304,G__53927_54305));
} else {
var temp__5753__auto___54306 = (function (){var fexpr__53928 = cljs.core.deref(input_checker53912_54293);
return (fexpr__53928.cljs$core$IFn$_invoke$arity$1 ? fexpr__53928.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54300) : fexpr__53928.call(null,args__51190__auto___54300));
})();
if(cljs.core.truth_(temp__5753__auto___54306)){
var error__51191__auto___54307 = temp__5753__auto___54306;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54307], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53911_54291,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54300,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54307], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var size_or_seq = G__53914;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53929_54308 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53930_54309 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53931_54310 = output_schema53910_54290;
var G__53932_54311 = cljs.core.deref(output_checker53913_54294);
var G__53933_54312 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53929_54308,G__53930_54309,G__53931_54310,G__53932_54311,G__53933_54312) : schema.core.fn_validator.call(null,G__53929_54308,G__53930_54309,G__53931_54310,G__53932_54311,G__53933_54312));
} else {
var temp__5753__auto___54313 = (function (){var fexpr__53934 = cljs.core.deref(output_checker53913_54294);
return (fexpr__53934.cljs$core$IFn$_invoke$arity$1 ? fexpr__53934.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__53934.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54313)){
var error__51191__auto___54314 = temp__5753__auto___54313;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54314], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53910_54290,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54314], null));
} else {
}
}
} else {
}

return o__51192__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__53918,G__53919){
var validate__51189__auto__ = cljs.core.deref(ufv___54289);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54315 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53918,G__53919], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53935_54316 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53936_54317 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53937_54318 = input_schema53915_54292;
var G__53938_54319 = cljs.core.deref(input_checker53916_54295);
var G__53939_54320 = args__51190__auto___54315;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53935_54316,G__53936_54317,G__53937_54318,G__53938_54319,G__53939_54320) : schema.core.fn_validator.call(null,G__53935_54316,G__53936_54317,G__53937_54318,G__53938_54319,G__53939_54320));
} else {
var temp__5753__auto___54321 = (function (){var fexpr__53940 = cljs.core.deref(input_checker53916_54295);
return (fexpr__53940.cljs$core$IFn$_invoke$arity$1 ? fexpr__53940.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54315) : fexpr__53940.call(null,args__51190__auto___54315));
})();
if(cljs.core.truth_(temp__5753__auto___54321)){
var error__51191__auto___54322 = temp__5753__auto___54321;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54322], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53915_54292,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54315,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54322], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var size = G__53918;
var init_val_or_seq = G__53919;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53941_54323 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53942_54324 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53943_54325 = output_schema53910_54290;
var G__53944_54326 = cljs.core.deref(output_checker53917_54296);
var G__53945_54327 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53941_54323,G__53942_54324,G__53943_54325,G__53944_54326,G__53945_54327) : schema.core.fn_validator.call(null,G__53941_54323,G__53942_54324,G__53943_54325,G__53944_54326,G__53945_54327));
} else {
var temp__5753__auto___54329 = (function (){var fexpr__53946 = cljs.core.deref(output_checker53917_54296);
return (fexpr__53946.cljs$core$IFn$_invoke$arity$1 ? fexpr__53946.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__53946.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54329)){
var error__51191__auto___54330 = temp__5753__auto___54329;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54330], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53910_54290,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54330], null));
} else {
}
}
} else {
}

return o__51192__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema53910_54290,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53911_54291,input_schema53915_54292], null)));

var ufv___54331 = schema.utils.use_fn_validation;
var output_schema53947_54332 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53948_54333 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker53949_54334 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53948_54333);
}),null));
var output_checker53950_54335 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53947_54332);
}),null));
var ret__53164__auto___54336 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__53951){
var validate__51189__auto__ = cljs.core.deref(ufv___54331);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54337 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53951], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53953_54338 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53954_54339 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__53955_54340 = input_schema53948_54333;
var G__53956_54341 = cljs.core.deref(input_checker53949_54334);
var G__53957_54342 = args__51190__auto___54337;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53953_54338,G__53954_54339,G__53955_54340,G__53956_54341,G__53957_54342) : schema.core.fn_validator.call(null,G__53953_54338,G__53954_54339,G__53955_54340,G__53956_54341,G__53957_54342));
} else {
var temp__5753__auto___54347 = (function (){var fexpr__53958 = cljs.core.deref(input_checker53949_54334);
return (fexpr__53958.cljs$core$IFn$_invoke$arity$1 ? fexpr__53958.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54337) : fexpr__53958.call(null,args__51190__auto___54337));
})();
if(cljs.core.truth_(temp__5753__auto___54347)){
var error__51191__auto___54349 = temp__5753__auto___54347;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54349], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53948_54333,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54337,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54349], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var arrays = G__53951;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__53959 = cljs.core.count(arrays__$1);
switch (G__53959) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__53959,arrays__$1,validate__51189__auto__,ufv___54331,output_schema53947_54332,input_schema53948_54333,input_checker53949_54334,output_checker53950_54335){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__53959,arrays__$1,validate__51189__auto__,ufv___54331,output_schema53947_54332,input_schema53948_54333,input_checker53949_54334,output_checker53950_54335))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__53959,arrays__$1,validate__51189__auto__,ufv___54331,output_schema53947_54332,input_schema53948_54333,input_checker53949_54334,output_checker53950_54335){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__53959,arrays__$1,validate__51189__auto__,ufv___54331,output_schema53947_54332,input_schema53948_54333,input_checker53949_54334,output_checker53950_54335))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53960_54358 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53961_54359 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__53962_54360 = output_schema53947_54332;
var G__53963_54361 = cljs.core.deref(output_checker53950_54335);
var G__53964_54362 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53960_54358,G__53961_54359,G__53962_54360,G__53963_54361,G__53964_54362) : schema.core.fn_validator.call(null,G__53960_54358,G__53961_54359,G__53962_54360,G__53963_54361,G__53964_54362));
} else {
var temp__5753__auto___54363 = (function (){var fexpr__53965 = cljs.core.deref(output_checker53950_54335);
return (fexpr__53965.cljs$core$IFn$_invoke$arity$1 ? fexpr__53965.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__53965.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54363)){
var error__51191__auto___54364 = temp__5753__auto___54363;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54364], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53947_54332,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54364], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema53947_54332,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53948_54333], null)));

var ufv___54365 = schema.utils.use_fn_validation;
var output_schema53966_54366 = schema.core.Bool;
var input_schema53967_54367 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker53968_54368 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53967_54367);
}),null));
var output_checker53969_54369 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53966_54366);
}),null));
var ret__53164__auto___54370 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__53970,G__53971){
var validate__51189__auto__ = cljs.core.deref(ufv___54365);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54371 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53970,G__53971], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53972_54373 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53973_54374 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__53974_54375 = input_schema53967_54367;
var G__53975_54376 = cljs.core.deref(input_checker53968_54368);
var G__53976_54377 = args__51190__auto___54371;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53972_54373,G__53973_54374,G__53974_54375,G__53975_54376,G__53976_54377) : schema.core.fn_validator.call(null,G__53972_54373,G__53973_54374,G__53974_54375,G__53975_54376,G__53976_54377));
} else {
var temp__5753__auto___54379 = (function (){var fexpr__53977 = cljs.core.deref(input_checker53968_54368);
return (fexpr__53977.cljs$core$IFn$_invoke$arity$1 ? fexpr__53977.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54371) : fexpr__53977.call(null,args__51190__auto___54371));
})();
if(cljs.core.truth_(temp__5753__auto___54379)){
var error__51191__auto___54380 = temp__5753__auto___54379;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54380], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53967_54367,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54371,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54380], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var a = G__53970;
var b = G__53971;
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b))){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__54384 = ((i + (1)) | (0));
i = G__54384;
continue;
} else {
return false;
}
}
break;
}
} else {
return false;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53979_54386 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53980_54387 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__53981_54388 = output_schema53966_54366;
var G__53982_54389 = cljs.core.deref(output_checker53969_54369);
var G__53983_54390 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53979_54386,G__53980_54387,G__53981_54388,G__53982_54389,G__53983_54390) : schema.core.fn_validator.call(null,G__53979_54386,G__53980_54387,G__53981_54388,G__53982_54389,G__53983_54390));
} else {
var temp__5753__auto___54391 = (function (){var fexpr__53985 = cljs.core.deref(output_checker53969_54369);
return (fexpr__53985.cljs$core$IFn$_invoke$arity$1 ? fexpr__53985.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__53985.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54391)){
var error__51191__auto___54392 = temp__5753__auto___54391;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54392], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53966_54366,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54392], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema53966_54366,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53967_54367], null)));

var ufv___54393 = schema.utils.use_fn_validation;
var output_schema53986_54394 = schema.core.Str;
var input_schema53987_54395 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker53988_54396 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53987_54395);
}),null));
var output_checker53989_54397 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53986_54394);
}),null));
var ret__53164__auto___54398 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__53990){
var validate__51189__auto__ = cljs.core.deref(ufv___54393);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54399 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53990], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53991_54400 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53992_54401 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__53993_54402 = input_schema53987_54395;
var G__53994_54403 = cljs.core.deref(input_checker53988_54396);
var G__53995_54404 = args__51190__auto___54399;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53991_54400,G__53992_54401,G__53993_54402,G__53994_54403,G__53995_54404) : schema.core.fn_validator.call(null,G__53991_54400,G__53992_54401,G__53993_54402,G__53994_54403,G__53995_54404));
} else {
var temp__5753__auto___54408 = (function (){var fexpr__53996 = cljs.core.deref(input_checker53988_54396);
return (fexpr__53996.cljs$core$IFn$_invoke$arity$1 ? fexpr__53996.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54399) : fexpr__53996.call(null,args__51190__auto___54399));
})();
if(cljs.core.truth_(temp__5753__auto___54408)){
var error__51191__auto___54409 = temp__5753__auto___54408;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54409], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53987_54395,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54399,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54409], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__53990;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53997_54412 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53998_54413 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__53999_54414 = output_schema53986_54394;
var G__54000_54415 = cljs.core.deref(output_checker53989_54397);
var G__54001_54416 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53997_54412,G__53998_54413,G__53999_54414,G__54000_54415,G__54001_54416) : schema.core.fn_validator.call(null,G__53997_54412,G__53998_54413,G__53999_54414,G__54000_54415,G__54001_54416));
} else {
var temp__5753__auto___54422 = (function (){var fexpr__54002 = cljs.core.deref(output_checker53989_54397);
return (fexpr__54002.cljs$core$IFn$_invoke$arity$1 ? fexpr__54002.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54002.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54422)){
var error__51191__auto___54424 = temp__5753__auto___54422;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54424], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53986_54394,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54424], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema53986_54394,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53987_54395], null)));

var ufv___54429 = schema.utils.use_fn_validation;
var output_schema54003_54430 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54004_54431 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema54008_54432 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema54013_54433 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker54005_54434 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54004_54431);
}),null));
var output_checker54006_54435 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54003_54430);
}),null));
var input_checker54009_54436 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54008_54432);
}),null));
var output_checker54010_54437 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54003_54430);
}),null));
var input_checker54014_54438 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54013_54433);
}),null));
var output_checker54015_54439 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54003_54430);
}),null));
var ret__53164__auto___54454 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__54023 = arguments.length;
switch (G__54023) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__54007){
var validate__51189__auto__ = cljs.core.deref(ufv___54429);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54456 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54007], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54025_54457 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54026_54458 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54027_54459 = input_schema54004_54431;
var G__54028_54460 = cljs.core.deref(input_checker54005_54434);
var G__54029_54461 = args__51190__auto___54456;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54025_54457,G__54026_54458,G__54027_54459,G__54028_54460,G__54029_54461) : schema.core.fn_validator.call(null,G__54025_54457,G__54026_54458,G__54027_54459,G__54028_54460,G__54029_54461));
} else {
var temp__5753__auto___54462 = (function (){var fexpr__54030 = cljs.core.deref(input_checker54005_54434);
return (fexpr__54030.cljs$core$IFn$_invoke$arity$1 ? fexpr__54030.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54456) : fexpr__54030.call(null,args__51190__auto___54456));
})();
if(cljs.core.truth_(temp__5753__auto___54462)){
var error__51191__auto___54463 = temp__5753__auto___54462;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54463], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54004_54431,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54456,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54463], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54007;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54031_54482 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54032_54484 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54033_54485 = output_schema54003_54430;
var G__54034_54486 = cljs.core.deref(output_checker54006_54435);
var G__54035_54487 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54031_54482,G__54032_54484,G__54033_54485,G__54034_54486,G__54035_54487) : schema.core.fn_validator.call(null,G__54031_54482,G__54032_54484,G__54033_54485,G__54034_54486,G__54035_54487));
} else {
var temp__5753__auto___54488 = (function (){var fexpr__54036 = cljs.core.deref(output_checker54006_54435);
return (fexpr__54036.cljs$core$IFn$_invoke$arity$1 ? fexpr__54036.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54036.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54488)){
var error__51191__auto___54490 = temp__5753__auto___54488;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54490], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54003_54430,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54490], null));
} else {
}
}
} else {
}

return o__51192__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__54011,G__54012){
var validate__51189__auto__ = cljs.core.deref(ufv___54429);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54493 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54011,G__54012], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54037_54494 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54038_54495 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54039_54496 = input_schema54008_54432;
var G__54040_54497 = cljs.core.deref(input_checker54009_54436);
var G__54041_54498 = args__51190__auto___54493;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54037_54494,G__54038_54495,G__54039_54496,G__54040_54497,G__54041_54498) : schema.core.fn_validator.call(null,G__54037_54494,G__54038_54495,G__54039_54496,G__54040_54497,G__54041_54498));
} else {
var temp__5753__auto___54501 = (function (){var fexpr__54042 = cljs.core.deref(input_checker54009_54436);
return (fexpr__54042.cljs$core$IFn$_invoke$arity$1 ? fexpr__54042.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54493) : fexpr__54042.call(null,args__51190__auto___54493));
})();
if(cljs.core.truth_(temp__5753__auto___54501)){
var error__51191__auto___54503 = temp__5753__auto___54501;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54503], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54008_54432,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54493,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54503], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54011;
var start = G__54012;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54043_54523 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54044_54524 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54045_54525 = output_schema54003_54430;
var G__54046_54526 = cljs.core.deref(output_checker54010_54437);
var G__54047_54527 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54043_54523,G__54044_54524,G__54045_54525,G__54046_54526,G__54047_54527) : schema.core.fn_validator.call(null,G__54043_54523,G__54044_54524,G__54045_54525,G__54046_54526,G__54047_54527));
} else {
var temp__5753__auto___54528 = (function (){var fexpr__54048 = cljs.core.deref(output_checker54010_54437);
return (fexpr__54048.cljs$core$IFn$_invoke$arity$1 ? fexpr__54048.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54048.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54528)){
var error__51191__auto___54529 = temp__5753__auto___54528;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54529], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54003_54430,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54529], null));
} else {
}
}
} else {
}

return o__51192__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__54016,G__54017,G__54018){
var validate__51189__auto__ = cljs.core.deref(ufv___54429);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54530 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54016,G__54017,G__54018], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54049_54531 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54050_54532 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54051_54533 = input_schema54013_54433;
var G__54052_54534 = cljs.core.deref(input_checker54014_54438);
var G__54053_54535 = args__51190__auto___54530;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54049_54531,G__54050_54532,G__54051_54533,G__54052_54534,G__54053_54535) : schema.core.fn_validator.call(null,G__54049_54531,G__54050_54532,G__54051_54533,G__54052_54534,G__54053_54535));
} else {
var temp__5753__auto___54537 = (function (){var fexpr__54054 = cljs.core.deref(input_checker54014_54438);
return (fexpr__54054.cljs$core$IFn$_invoke$arity$1 ? fexpr__54054.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54530) : fexpr__54054.call(null,args__51190__auto___54530));
})();
if(cljs.core.truth_(temp__5753__auto___54537)){
var error__51191__auto___54538 = temp__5753__auto___54537;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54538], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54013_54433,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54530,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54538], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54016;
var start = G__54017;
var end = G__54018;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4252__auto__ = end;
var y__4253__auto__ = cljs.core.count(ba);
return ((x__4252__auto__ < y__4253__auto__) ? x__4252__auto__ : y__4253__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54055_54549 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54056_54550 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__54057_54551 = output_schema54003_54430;
var G__54058_54552 = cljs.core.deref(output_checker54015_54439);
var G__54059_54553 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54055_54549,G__54056_54550,G__54057_54551,G__54058_54552,G__54059_54553) : schema.core.fn_validator.call(null,G__54055_54549,G__54056_54550,G__54057_54551,G__54058_54552,G__54059_54553));
} else {
var temp__5753__auto___54555 = (function (){var fexpr__54060 = cljs.core.deref(output_checker54015_54439);
return (fexpr__54060.cljs$core$IFn$_invoke$arity$1 ? fexpr__54060.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54060.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54555)){
var error__51191__auto___54557 = temp__5753__auto___54555;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54557], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54003_54430,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54557], null));
} else {
}
}
} else {
}

return o__51192__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema54003_54430,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54004_54431,input_schema54008_54432,input_schema54013_54433], null)));

var ufv___54560 = schema.utils.use_fn_validation;
var output_schema54062_54561 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54063_54562 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54064_54563 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54063_54562);
}),null));
var output_checker54065_54564 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54062_54561);
}),null));
var ret__53164__auto___54573 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__54066){
var validate__51189__auto__ = cljs.core.deref(ufv___54560);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54576 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54066], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54068_54577 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54069_54578 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__54070_54579 = input_schema54063_54562;
var G__54071_54580 = cljs.core.deref(input_checker54064_54563);
var G__54072_54581 = args__51190__auto___54576;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54068_54577,G__54069_54578,G__54070_54579,G__54071_54580,G__54072_54581) : schema.core.fn_validator.call(null,G__54068_54577,G__54069_54578,G__54070_54579,G__54071_54580,G__54072_54581));
} else {
var temp__5753__auto___54582 = (function (){var fexpr__54073 = cljs.core.deref(input_checker54064_54563);
return (fexpr__54073.cljs$core$IFn$_invoke$arity$1 ? fexpr__54073.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54576) : fexpr__54073.call(null,args__51190__auto___54576));
})();
if(cljs.core.truth_(temp__5753__auto___54582)){
var error__51191__auto___54583 = temp__5753__auto___54582;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54583], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54063_54562,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54576,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54583], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54066;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4648__auto___54584 = num;
var i_54585 = (0);
while(true){
if((i_54585 < n__4648__auto___54584)){
(new$[i_54585] = (ba[(last - i_54585)]));

var G__54592 = (i_54585 + (1));
i_54585 = G__54592;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54074_54593 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54075_54594 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__54076_54595 = output_schema54062_54561;
var G__54077_54596 = cljs.core.deref(output_checker54065_54564);
var G__54078_54597 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54074_54593,G__54075_54594,G__54076_54595,G__54077_54596,G__54078_54597) : schema.core.fn_validator.call(null,G__54074_54593,G__54075_54594,G__54076_54595,G__54077_54596,G__54078_54597));
} else {
var temp__5753__auto___54603 = (function (){var fexpr__54079 = cljs.core.deref(output_checker54065_54564);
return (fexpr__54079.cljs$core$IFn$_invoke$arity$1 ? fexpr__54079.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54079.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54603)){
var error__51191__auto___54604 = temp__5753__auto___54603;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54604], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54062_54561,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54604], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema54062_54561,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54063_54562], null)));

var ufv___54607 = schema.utils.use_fn_validation;
var output_schema54080_54608 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema54081_54609 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54082_54610 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54081_54609);
}),null));
var output_checker54083_54611 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54080_54608);
}),null));
var ret__53164__auto___54615 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__54084,G__54085){
var validate__51189__auto__ = cljs.core.deref(ufv___54607);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54616 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54084,G__54085], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54086_54617 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54087_54618 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__54088_54619 = input_schema54081_54609;
var G__54089_54620 = cljs.core.deref(input_checker54082_54610);
var G__54090_54621 = args__51190__auto___54616;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54086_54617,G__54087_54618,G__54088_54619,G__54089_54620,G__54090_54621) : schema.core.fn_validator.call(null,G__54086_54617,G__54087_54618,G__54088_54619,G__54089_54620,G__54090_54621));
} else {
var temp__5753__auto___54631 = (function (){var fexpr__54091 = cljs.core.deref(input_checker54082_54610);
return (fexpr__54091.cljs$core$IFn$_invoke$arity$1 ? fexpr__54091.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54616) : fexpr__54091.call(null,args__51190__auto___54616));
})();
if(cljs.core.truth_(temp__5753__auto___54631)){
var error__51191__auto___54633 = temp__5753__auto___54631;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54633], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54081_54609,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54616,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54633], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54084;
var fragment_size = G__54085;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__54634 = (end_offset | (0));
var G__54635 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__54634;
output = G__54635;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54092_54636 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54093_54637 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__54094_54638 = output_schema54080_54608;
var G__54095_54639 = cljs.core.deref(output_checker54083_54611);
var G__54096_54640 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54092_54636,G__54093_54637,G__54094_54638,G__54095_54639,G__54096_54640) : schema.core.fn_validator.call(null,G__54092_54636,G__54093_54637,G__54094_54638,G__54095_54639,G__54096_54640));
} else {
var temp__5753__auto___54648 = (function (){var fexpr__54097 = cljs.core.deref(output_checker54083_54611);
return (fexpr__54097.cljs$core$IFn$_invoke$arity$1 ? fexpr__54097.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54097.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54648)){
var error__51191__auto___54651 = temp__5753__auto___54648;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54651], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54080_54608,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54651], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema54080_54608,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54081_54609], null)));

var ufv___54654 = schema.utils.use_fn_validation;
var output_schema54098_54655 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema54099_54656 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker54100_54657 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54099_54656);
}),null));
var output_checker54101_54658 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54098_54655);
}),null));
var ret__53164__auto___54663 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__54102){
var validate__51189__auto__ = cljs.core.deref(ufv___54654);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54665 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54102], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54103_54667 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54104_54668 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__54105_54669 = input_schema54099_54656;
var G__54106_54670 = cljs.core.deref(input_checker54100_54657);
var G__54107_54671 = args__51190__auto___54665;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54103_54667,G__54104_54668,G__54105_54669,G__54106_54670,G__54107_54671) : schema.core.fn_validator.call(null,G__54103_54667,G__54104_54668,G__54105_54669,G__54106_54670,G__54107_54671));
} else {
var temp__5753__auto___54681 = (function (){var fexpr__54108 = cljs.core.deref(input_checker54100_54657);
return (fexpr__54108.cljs$core$IFn$_invoke$arity$1 ? fexpr__54108.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54665) : fexpr__54108.call(null,args__51190__auto___54665));
})();
if(cljs.core.truth_(temp__5753__auto___54681)){
var error__51191__auto___54683 = temp__5753__auto___54681;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54683], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54099_54656,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54665,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54683], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54102;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__54701 = (n + (1));
var G__54702 = (i__$1 | (0));
var G__54703 = (out__$1 | (0));
n = G__54701;
i = G__54702;
out = G__54703;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54110_54707 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54111_54708 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__54112_54709 = output_schema54098_54655;
var G__54113_54710 = cljs.core.deref(output_checker54101_54658);
var G__54114_54711 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54110_54707,G__54111_54708,G__54112_54709,G__54113_54710,G__54114_54711) : schema.core.fn_validator.call(null,G__54110_54707,G__54111_54708,G__54112_54709,G__54113_54710,G__54114_54711));
} else {
var temp__5753__auto___54720 = (function (){var fexpr__54115 = cljs.core.deref(output_checker54101_54658);
return (fexpr__54115.cljs$core$IFn$_invoke$arity$1 ? fexpr__54115.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54115.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54720)){
var error__51191__auto___54723 = temp__5753__auto___54720;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54723], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54098_54655,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54723], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema54098_54655,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54099_54656], null)));

var ufv___54725 = schema.utils.use_fn_validation;
var output_schema54116_54726 = deercreeklabs.baracus.ByteArray;
var input_schema54117_54727 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54118_54728 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54117_54727);
}),null));
var output_checker54119_54729 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54116_54726);
}),null));
var ret__53164__auto___54732 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__54120){
var validate__51189__auto__ = cljs.core.deref(ufv___54725);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54733 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54120], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54121_54734 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54122_54735 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__54123_54736 = input_schema54117_54727;
var G__54124_54737 = cljs.core.deref(input_checker54118_54728);
var G__54125_54738 = args__51190__auto___54733;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54121_54734,G__54122_54735,G__54123_54736,G__54124_54737,G__54125_54738) : schema.core.fn_validator.call(null,G__54121_54734,G__54122_54735,G__54123_54736,G__54124_54737,G__54125_54738));
} else {
var temp__5753__auto___54741 = (function (){var fexpr__54126 = cljs.core.deref(input_checker54118_54728);
return (fexpr__54126.cljs$core$IFn$_invoke$arity$1 ? fexpr__54126.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54733) : fexpr__54126.call(null,args__51190__auto___54733));
})();
if(cljs.core.truth_(temp__5753__auto___54741)){
var error__51191__auto___54742 = temp__5753__auto___54741;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54742], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54117_54727,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54733,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54742], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var i = G__54120;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__54745 = (n >>> (7));
var G__54746 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__54745;
out = G__54746;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54127_54748 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54128_54749 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__54129_54750 = output_schema54116_54726;
var G__54130_54751 = cljs.core.deref(output_checker54119_54729);
var G__54131_54752 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54127_54748,G__54128_54749,G__54129_54750,G__54130_54751,G__54131_54752) : schema.core.fn_validator.call(null,G__54127_54748,G__54128_54749,G__54129_54750,G__54130_54751,G__54131_54752));
} else {
var temp__5753__auto___54774 = (function (){var fexpr__54132 = cljs.core.deref(output_checker54119_54729);
return (fexpr__54132.cljs$core$IFn$_invoke$arity$1 ? fexpr__54132.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54132.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54774)){
var error__51191__auto___54775 = temp__5753__auto___54774;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54775], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54116_54726,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54775], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema54116_54726,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54117_54727], null)));

var ufv___54779 = schema.utils.use_fn_validation;
var output_schema54134_54780 = schema.core.maybe(schema.core.Str);
var input_schema54135_54781 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54136_54782 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54135_54781);
}),null));
var output_checker54137_54783 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54134_54780);
}),null));
var ret__53164__auto___54784 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__54138){
var validate__51189__auto__ = cljs.core.deref(ufv___54779);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54785 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54138], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54139_54786 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54140_54787 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__54141_54788 = input_schema54135_54781;
var G__54142_54789 = cljs.core.deref(input_checker54136_54782);
var G__54143_54790 = args__51190__auto___54785;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54139_54786,G__54140_54787,G__54141_54788,G__54142_54789,G__54143_54790) : schema.core.fn_validator.call(null,G__54139_54786,G__54140_54787,G__54141_54788,G__54142_54789,G__54143_54790));
} else {
var temp__5753__auto___54791 = (function (){var fexpr__54144 = cljs.core.deref(input_checker54136_54782);
return (fexpr__54144.cljs$core$IFn$_invoke$arity$1 ? fexpr__54144.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54785) : fexpr__54144.call(null,args__51190__auto___54785));
})();
if(cljs.core.truth_(temp__5753__auto___54791)){
var error__51191__auto___54792 = temp__5753__auto___54791;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54792], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54135_54781,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54785,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54792], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var b = G__54138;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54145_54793 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54146_54794 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__54147_54795 = output_schema54134_54780;
var G__54148_54796 = cljs.core.deref(output_checker54137_54783);
var G__54149_54797 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54145_54793,G__54146_54794,G__54147_54795,G__54148_54796,G__54149_54797) : schema.core.fn_validator.call(null,G__54145_54793,G__54146_54794,G__54147_54795,G__54148_54796,G__54149_54797));
} else {
var temp__5753__auto___54798 = (function (){var fexpr__54150 = cljs.core.deref(output_checker54137_54783);
return (fexpr__54150.cljs$core$IFn$_invoke$arity$1 ? fexpr__54150.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54150.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54798)){
var error__51191__auto___54799 = temp__5753__auto___54798;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54799], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54134_54780,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54799], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema54134_54780,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54135_54781], null)));

var ufv___54800 = schema.utils.use_fn_validation;
var output_schema54151_54801 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54152_54802 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker54153_54803 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54152_54802);
}),null));
var output_checker54154_54804 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54151_54801);
}),null));
var ret__53164__auto___54813 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__54155){
var validate__51189__auto__ = cljs.core.deref(ufv___54800);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54814 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54155], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54156_54817 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54157_54818 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54158_54819 = input_schema54152_54802;
var G__54159_54820 = cljs.core.deref(input_checker54153_54803);
var G__54160_54821 = args__51190__auto___54814;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54156_54817,G__54157_54818,G__54158_54819,G__54159_54820,G__54160_54821) : schema.core.fn_validator.call(null,G__54156_54817,G__54157_54818,G__54158_54819,G__54159_54820,G__54160_54821));
} else {
var temp__5753__auto___54823 = (function (){var fexpr__54161 = cljs.core.deref(input_checker54153_54803);
return (fexpr__54161.cljs$core$IFn$_invoke$arity$1 ? fexpr__54161.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54814) : fexpr__54161.call(null,args__51190__auto___54814));
})();
if(cljs.core.truth_(temp__5753__auto___54823)){
var error__51191__auto___54824 = temp__5753__auto___54823;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54824], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54152_54802,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54814,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54824], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var s = G__54155;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54162_54826 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54163_54827 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54164_54828 = output_schema54151_54801;
var G__54165_54829 = cljs.core.deref(output_checker54154_54804);
var G__54166_54830 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54162_54826,G__54163_54827,G__54164_54828,G__54165_54829,G__54166_54830) : schema.core.fn_validator.call(null,G__54162_54826,G__54163_54827,G__54164_54828,G__54165_54829,G__54166_54830));
} else {
var temp__5753__auto___54833 = (function (){var fexpr__54167 = cljs.core.deref(output_checker54154_54804);
return (fexpr__54167.cljs$core$IFn$_invoke$arity$1 ? fexpr__54167.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54167.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54833)){
var error__51191__auto___54835 = temp__5753__auto___54833;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54835], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54151_54801,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54835], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema54151_54801,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54152_54802], null)));

var ufv___54846 = schema.utils.use_fn_validation;
var output_schema54168_54847 = schema.core.maybe(schema.core.Str);
var input_schema54169_54848 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54170_54849 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54169_54848);
}),null));
var output_checker54171_54850 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54168_54847);
}),null));
var ret__53164__auto___54851 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__54172){
var validate__51189__auto__ = cljs.core.deref(ufv___54846);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54852 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54172], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54174_54853 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54175_54854 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54176_54855 = input_schema54169_54848;
var G__54177_54856 = cljs.core.deref(input_checker54170_54849);
var G__54178_54857 = args__51190__auto___54852;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54174_54853,G__54175_54854,G__54176_54855,G__54177_54856,G__54178_54857) : schema.core.fn_validator.call(null,G__54174_54853,G__54175_54854,G__54176_54855,G__54177_54856,G__54178_54857));
} else {
var temp__5753__auto___54858 = (function (){var fexpr__54179 = cljs.core.deref(input_checker54170_54849);
return (fexpr__54179.cljs$core$IFn$_invoke$arity$1 ? fexpr__54179.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54852) : fexpr__54179.call(null,args__51190__auto___54852));
})();
if(cljs.core.truth_(temp__5753__auto___54858)){
var error__51191__auto___54863 = temp__5753__auto___54858;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54863], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54169_54848,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54852,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54863], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54172;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54180_54871 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54181_54872 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54182_54873 = output_schema54168_54847;
var G__54183_54874 = cljs.core.deref(output_checker54171_54850);
var G__54184_54875 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54180_54871,G__54181_54872,G__54182_54873,G__54183_54874,G__54184_54875) : schema.core.fn_validator.call(null,G__54180_54871,G__54181_54872,G__54182_54873,G__54183_54874,G__54184_54875));
} else {
var temp__5753__auto___54877 = (function (){var fexpr__54185 = cljs.core.deref(output_checker54171_54850);
return (fexpr__54185.cljs$core$IFn$_invoke$arity$1 ? fexpr__54185.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54185.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54877)){
var error__51191__auto___54879 = temp__5753__auto___54877;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54879], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54168_54847,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54879], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema54168_54847,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54169_54848], null)));

var ufv___54883 = schema.utils.use_fn_validation;
var output_schema54186_54884 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54187_54885 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker54188_54886 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54187_54885);
}),null));
var output_checker54189_54887 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54186_54884);
}),null));
var ret__53164__auto___54897 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__54190){
var validate__51189__auto__ = cljs.core.deref(ufv___54883);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54898 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54190], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54191_54899 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54192_54900 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54193_54901 = input_schema54187_54885;
var G__54194_54902 = cljs.core.deref(input_checker54188_54886);
var G__54195_54903 = args__51190__auto___54898;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54191_54899,G__54192_54900,G__54193_54901,G__54194_54902,G__54195_54903) : schema.core.fn_validator.call(null,G__54191_54899,G__54192_54900,G__54193_54901,G__54194_54902,G__54195_54903));
} else {
var temp__5753__auto___54904 = (function (){var fexpr__54197 = cljs.core.deref(input_checker54188_54886);
return (fexpr__54197.cljs$core$IFn$_invoke$arity$1 ? fexpr__54197.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54898) : fexpr__54197.call(null,args__51190__auto___54898));
})();
if(cljs.core.truth_(temp__5753__auto___54904)){
var error__51191__auto___54905 = temp__5753__auto___54904;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54905], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54187_54885,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54898,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54905], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var s = G__54190;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54198_54907 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54199_54908 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54200_54909 = output_schema54186_54884;
var G__54201_54910 = cljs.core.deref(output_checker54189_54887);
var G__54202_54911 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54198_54907,G__54199_54908,G__54200_54909,G__54201_54910,G__54202_54911) : schema.core.fn_validator.call(null,G__54198_54907,G__54199_54908,G__54200_54909,G__54201_54910,G__54202_54911));
} else {
var temp__5753__auto___54920 = (function (){var fexpr__54203 = cljs.core.deref(output_checker54189_54887);
return (fexpr__54203.cljs$core$IFn$_invoke$arity$1 ? fexpr__54203.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54203.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54920)){
var error__51191__auto___54923 = temp__5753__auto___54920;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54923], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54186_54884,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54923], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema54186_54884,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54187_54885], null)));

var ufv___54927 = schema.utils.use_fn_validation;
var output_schema54206_54928 = schema.core.maybe(schema.core.Str);
var input_schema54208_54929 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker54209_54930 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54208_54929);
}),null));
var output_checker54210_54931 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54206_54928);
}),null));
var ret__53164__auto___54932 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__54211){
var validate__51189__auto__ = cljs.core.deref(ufv___54927);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54935 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54211], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54213_54937 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54214_54938 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54215_54939 = input_schema54208_54929;
var G__54216_54940 = cljs.core.deref(input_checker54209_54930);
var G__54217_54941 = args__51190__auto___54935;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54213_54937,G__54214_54938,G__54215_54939,G__54216_54940,G__54217_54941) : schema.core.fn_validator.call(null,G__54213_54937,G__54214_54938,G__54215_54939,G__54216_54940,G__54217_54941));
} else {
var temp__5753__auto___54943 = (function (){var fexpr__54218 = cljs.core.deref(input_checker54209_54930);
return (fexpr__54218.cljs$core$IFn$_invoke$arity$1 ? fexpr__54218.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54935) : fexpr__54218.call(null,args__51190__auto___54935));
})();
if(cljs.core.truth_(temp__5753__auto___54943)){
var error__51191__auto___54952 = temp__5753__auto___54943;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54952], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54208_54929,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54935,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54952], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54211;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4648__auto___54956 = len;
var i_54957 = (0);
while(true){
if((i_54957 < n__4648__auto___54956)){
var b_54958 = ((ba[i_54957]) & (255));
var j_54959 = ((2) * i_54957);
(ca[j_54959] = (function (){var G__54219 = (b_54958 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__54219) : hex_chars.call(null,G__54219));
})());

(ca[(j_54959 + (1))] = (function (){var G__54220 = (b_54958 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__54220) : hex_chars.call(null,G__54220));
})());

var G__54960 = (i_54957 + (1));
i_54957 = G__54960;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54221_54961 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54222_54962 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__54223_54963 = output_schema54206_54928;
var G__54224_54964 = cljs.core.deref(output_checker54210_54931);
var G__54225_54965 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54221_54961,G__54222_54962,G__54223_54963,G__54224_54964,G__54225_54965) : schema.core.fn_validator.call(null,G__54221_54961,G__54222_54962,G__54223_54963,G__54224_54964,G__54225_54965));
} else {
var temp__5753__auto___54972 = (function (){var fexpr__54226 = cljs.core.deref(output_checker54210_54931);
return (fexpr__54226.cljs$core$IFn$_invoke$arity$1 ? fexpr__54226.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54226.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54972)){
var error__51191__auto___54974 = temp__5753__auto___54972;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___54974], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54206_54928,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___54974], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema54206_54928,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54208_54929], null)));

deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
return parseInt(ch,(16));
});
var ufv___54982 = schema.utils.use_fn_validation;
var output_schema54227_54983 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema54228_54984 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker54229_54985 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54228_54984);
}),null));
var output_checker54230_54986 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54227_54983);
}),null));
var ret__53164__auto___54988 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__54231){
var validate__51189__auto__ = cljs.core.deref(ufv___54982);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___54990 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54231], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54232_54992 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54233_54993 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54234_54994 = input_schema54228_54984;
var G__54235_54995 = cljs.core.deref(input_checker54229_54985);
var G__54236_54996 = args__51190__auto___54990;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54232_54992,G__54233_54993,G__54234_54994,G__54235_54995,G__54236_54996) : schema.core.fn_validator.call(null,G__54232_54992,G__54233_54993,G__54234_54994,G__54235_54995,G__54236_54996));
} else {
var temp__5753__auto___55005 = (function (){var fexpr__54237 = cljs.core.deref(input_checker54229_54985);
return (fexpr__54237.cljs$core$IFn$_invoke$arity$1 ? fexpr__54237.cljs$core$IFn$_invoke$arity$1(args__51190__auto___54990) : fexpr__54237.call(null,args__51190__auto___54990));
})();
if(cljs.core.truth_(temp__5753__auto___55005)){
var error__51191__auto___55006 = temp__5753__auto___55005;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___55006], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54228_54984,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___54990,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___55006], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var s = G__54231;
while(true){
if(cljs.core.truth_(s)){
var ba_len = (cljs.core.count(s) / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4648__auto___55009 = ba_len;
var i_55010 = (0);
while(true){
if((i_55010 < n__4648__auto___55009)){
var j_55011 = ((2) * i_55010);
(ba[i_55010] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_55011)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_55011 + (1))))));

var G__55012 = (i_55010 + (1));
i_55010 = G__55012;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54239_55013 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54240_55014 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__54241_55015 = output_schema54227_54983;
var G__54242_55016 = cljs.core.deref(output_checker54230_54986);
var G__54243_55017 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54239_55013,G__54240_55014,G__54241_55015,G__54242_55016,G__54243_55017) : schema.core.fn_validator.call(null,G__54239_55013,G__54240_55014,G__54241_55015,G__54242_55016,G__54243_55017));
} else {
var temp__5753__auto___55019 = (function (){var fexpr__54244 = cljs.core.deref(output_checker54230_54986);
return (fexpr__54244.cljs$core$IFn$_invoke$arity$1 ? fexpr__54244.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54244.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___55019)){
var error__51191__auto___55025 = temp__5753__auto___55019;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___55025], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54227_54983,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___55025], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema54227_54983,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54228_54984], null)));

var ufv___55031 = schema.utils.use_fn_validation;
var output_schema54245_55032 = deercreeklabs.baracus.ByteArray;
var input_schema54246_55033 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker54247_55034 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54246_55033);
}),null));
var output_checker54248_55035 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54245_55032);
}),null));
var ret__53164__auto___55037 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__54249){
var validate__51189__auto__ = cljs.core.deref(ufv___55031);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___55038 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54249], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54253_55039 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54254_55040 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__54255_55041 = input_schema54246_55033;
var G__54256_55042 = cljs.core.deref(input_checker54247_55034);
var G__54257_55043 = args__51190__auto___55038;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54253_55039,G__54254_55040,G__54255_55041,G__54256_55042,G__54257_55043) : schema.core.fn_validator.call(null,G__54253_55039,G__54254_55040,G__54255_55041,G__54256_55042,G__54257_55043));
} else {
var temp__5753__auto___55046 = (function (){var fexpr__54258 = cljs.core.deref(input_checker54247_55034);
return (fexpr__54258.cljs$core$IFn$_invoke$arity$1 ? fexpr__54258.cljs$core$IFn$_invoke$arity$1(args__51190__auto___55038) : fexpr__54258.call(null,args__51190__auto___55038));
})();
if(cljs.core.truth_(temp__5753__auto___55046)){
var error__51191__auto___55047 = temp__5753__auto___55046;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___55047], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54246_55033,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___55038,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___55047], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var ba = G__54249;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54260_55049 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54261_55050 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__54262_55051 = output_schema54245_55032;
var G__54263_55052 = cljs.core.deref(output_checker54248_55035);
var G__54264_55053 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54260_55049,G__54261_55050,G__54262_55051,G__54263_55052,G__54264_55053) : schema.core.fn_validator.call(null,G__54260_55049,G__54261_55050,G__54262_55051,G__54263_55052,G__54264_55053));
} else {
var temp__5753__auto___55062 = (function (){var fexpr__54265 = cljs.core.deref(output_checker54248_55035);
return (fexpr__54265.cljs$core$IFn$_invoke$arity$1 ? fexpr__54265.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__54265.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___55062)){
var error__51191__auto___55064 = temp__5753__auto___55062;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___55064], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54245_55032,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___55064], null));
} else {
}
}
} else {
}

return o__51192__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema54245_55032,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54246_55033], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
