goog.provide('deercreeklabs.tube.client');
deercreeklabs.tube.client.default_keepalive_secs = (25);

/**
 * @interface
 */
deercreeklabs.tube.client.ITubeClient = function(){};

var deercreeklabs$tube$client$ITubeClient$send$dyn_56187 = (function (this$,data){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.client.send[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4464__auto__.call(null,this$,data));
} else {
var m__4461__auto__ = (deercreeklabs.tube.client.send["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4461__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("ITubeClient.send",this$);
}
}
});
/**
 * Send binary bytes over this tube
 */
deercreeklabs.tube.client.send = (function deercreeklabs$tube$client$send(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$send$arity$2 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$send$arity$2(this$,data);
} else {
return deercreeklabs$tube$client$ITubeClient$send$dyn_56187(this$,data);
}
});

var deercreeklabs$tube$client$ITubeClient$close$dyn_56188 = (function() {
var G__56189 = null;
var G__56189__1 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
var G__56189__3 = (function (this$,code,reason){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4464__auto__.call(null,this$,code,reason));
} else {
var m__4461__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4461__auto__.call(null,this$,code,reason));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
G__56189 = function(this$,code,reason){
switch(arguments.length){
case 1:
return G__56189__1.call(this,this$);
case 3:
return G__56189__3.call(this,this$,code,reason);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__56189.cljs$core$IFn$_invoke$arity$1 = G__56189__1;
G__56189.cljs$core$IFn$_invoke$arity$3 = G__56189__3;
return G__56189;
})()
;
/**
 * Close this tube
 */
deercreeklabs.tube.client.close = (function deercreeklabs$tube$client$close(var_args){
var G__55853 = arguments.length;
switch (G__55853) {
case 1:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$1 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$1(this$);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_56188(this$);
}
}));

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3 = (function (this$,code,reason){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$3 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$3(this$,code,reason);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_56188(this$,code,reason);
}
}));

(deercreeklabs.tube.client.close.cljs$lang$maxFixedArity = 3);



/**
* @constructor
 * @implements {deercreeklabs.tube.client.ITubeClient}
*/
deercreeklabs.tube.client.TubeClient = (function (conn,close_client_BANG_,_STAR_shutdown_QMARK_){
this.conn = conn;
this.close_client_BANG_ = close_client_BANG_;
this._STAR_shutdown_QMARK_ = _STAR_shutdown_QMARK_;
});
(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$ = cljs.core.PROTOCOL_SENTINEL);

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$send$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
return deercreeklabs.tube.connection.send(self__.conn,data);
}));

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$close$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var code = (1000);
var reason = "Explicit close";
var ws_already_closed_QMARK_ = false;
return (self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3 ? self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3(code,reason,ws_already_closed_QMARK_) : self__.close_client_BANG_.call(null,code,reason,ws_already_closed_QMARK_));
}));

(deercreeklabs.tube.client.TubeClient.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"close-client!","close-client!",-332645616,null),new cljs.core.Symbol(null,"*shutdown?","*shutdown?",282019102,null)], null);
}));

(deercreeklabs.tube.client.TubeClient.cljs$lang$type = true);

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorStr = "deercreeklabs.tube.client/TubeClient");

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"deercreeklabs.tube.client/TubeClient");
}));

/**
 * Positional factory function for deercreeklabs.tube.client/TubeClient.
 */
deercreeklabs.tube.client.__GT_TubeClient = (function deercreeklabs$tube$client$__GT_TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_){
return (new deercreeklabs.tube.client.TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_));
});

deercreeklabs.tube.client._LT_ws_client_cljs = (function deercreeklabs$tube$client$_LT_ws_client_cljs(logger,url,on_error,on_disconnect,handle_rcv_BANG_,log_conn_failure_QMARK_,_STAR_conn,_STAR_shutdown_QMARK_){
var fragment_size = (31999);
var client = (function (){var G__55868 = deercreeklabs.tube.utils.platform_kw();
var G__55868__$1 = (((G__55868 instanceof cljs.core.Keyword))?G__55868.fqn:null);
switch (G__55868__$1) {
case "node":
var WSC = require("ws");
return (new WSC(url));

break;
case "browser":
return (new WebSocket(url));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55868__$1)].join('')));

}
})();
var _STAR_connected_QMARK_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var msg_handler = (function (msg_obj){
var data = (new Int8Array(msg_obj.data));
return (handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1 ? handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1(data) : handle_rcv_BANG_.call(null,data));
});
var closer = (function (){
return client.close();
});
var sender = (function (data){
if(cljs.core.truth_(cljs.core.deref(_STAR_shutdown_QMARK_))){
return null;
} else {
return client.send(data.buffer);
}
});
var ret_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
(client.binaryType = "arraybuffer");

(client.onopen = (function (event){
cljs.core.reset_BANG_(_STAR_connected_QMARK_,true);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ret_ch,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"sender","sender",1557303285),sender,new cljs.core.Keyword(null,"closer","closer",10992481),closer,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330),fragment_size], null));
}));

(client.onclose = (function (event){
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__55870 = cljs.core.deref(_STAR_conn);
var G__55871 = event.code;
var G__55872 = event.reason;
return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(G__55870,G__55871,G__55872) : on_disconnect.call(null,G__55870,G__55871,G__55872));
} else {
return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onerror = (function (err){
if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__55874 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(err);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__55874) : on_error.call(null,G__55874));
} else {
if(cljs.core.truth_(log_conn_failure_QMARK_)){
var G__55875_56192 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__55876_56193 = ["Websocket failed to connect. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.tube.utils.ex_msg(err))].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__55875_56192,G__55876_56193) : logger.call(null,G__55875_56192,G__55876_56193));
} else {
}

return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onmessage = msg_handler);

return ret_ch;
});
deercreeklabs.tube.client.start_keep_alive_loop = (function deercreeklabs$tube$client$start_keep_alive_loop(conn,keep_alive_secs,_STAR_shutdown_QMARK_){
var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_55908){
var state_val_55909 = (state_55908[(1)]);
if((state_val_55909 === (7))){
var inst_55903 = (state_55908[(2)]);
var _ = (function (){var statearr_55911 = state_55908;
(statearr_55911[(4)] = cljs.core.rest((state_55908[(4)])));

return statearr_55911;
})();
var state_55908__$1 = state_55908;
var statearr_55912_56194 = state_55908__$1;
(statearr_55912_56194[(2)] = inst_55903);

(statearr_55912_56194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (1))){
var state_55908__$1 = state_55908;
var statearr_55913_56195 = state_55908__$1;
(statearr_55913_56195[(2)] = null);

(statearr_55913_56195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (4))){
var inst_55877 = (state_55908[(2)]);
var state_55908__$1 = state_55908;
var statearr_55914_56196 = state_55908__$1;
(statearr_55914_56196[(2)] = inst_55877);

(statearr_55914_56196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (13))){
var inst_55895 = deercreeklabs.tube.connection.send_ping(conn);
var state_55908__$1 = state_55908;
var statearr_55915_56197 = state_55908__$1;
(statearr_55915_56197[(2)] = inst_55895);

(statearr_55915_56197[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (6))){
var inst_55884 = cljs.core.deref(_STAR_shutdown_QMARK_);
var inst_55885 = cljs.core.not(inst_55884);
var state_55908__$1 = state_55908;
if(inst_55885){
var statearr_55917_56198 = state_55908__$1;
(statearr_55917_56198[(1)] = (8));

} else {
var statearr_55918_56199 = state_55908__$1;
(statearr_55918_56199[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (3))){
var inst_55906 = (state_55908[(2)]);
var state_55908__$1 = state_55908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55908__$1,inst_55906);
} else {
if((state_val_55909 === (12))){
var state_55908__$1 = state_55908;
var statearr_55919_56202 = state_55908__$1;
(statearr_55919_56202[(2)] = null);

(statearr_55919_56202[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (2))){
var _ = (function (){var statearr_55920 = state_55908;
(statearr_55920[(4)] = cljs.core.cons((5),(state_55908[(4)])));

return statearr_55920;
})();
var state_55908__$1 = state_55908;
var statearr_55921_56203 = state_55908__$1;
(statearr_55921_56203[(2)] = null);

(statearr_55921_56203[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (11))){
var inst_55891 = (state_55908[(2)]);
var inst_55892 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_55908__$1 = (function (){var statearr_55923 = state_55908;
(statearr_55923[(7)] = inst_55891);

return statearr_55923;
})();
if(cljs.core.truth_(inst_55892)){
var statearr_55924_56204 = state_55908__$1;
(statearr_55924_56204[(1)] = (12));

} else {
var statearr_55925_56205 = state_55908__$1;
(statearr_55925_56205[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (9))){
var state_55908__$1 = state_55908;
var statearr_55926_56206 = state_55908__$1;
(statearr_55926_56206[(2)] = null);

(statearr_55926_56206[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (5))){
var _ = (function (){var statearr_55927 = state_55908;
(statearr_55927[(4)] = cljs.core.rest((state_55908[(4)])));

return statearr_55927;
})();
var state_55908__$1 = state_55908;
var ex55922 = (state_55908__$1[(2)]);
var statearr_55928_56208 = state_55908__$1;
(statearr_55928_56208[(5)] = ex55922);


var statearr_55929_56214 = state_55908__$1;
(statearr_55929_56214[(1)] = (4));

(statearr_55929_56214[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (14))){
var inst_55897 = (state_55908[(2)]);
var state_55908__$1 = (function (){var statearr_55930 = state_55908;
(statearr_55930[(8)] = inst_55897);

return statearr_55930;
})();
var statearr_55931_56217 = state_55908__$1;
(statearr_55931_56217[(2)] = null);

(statearr_55931_56217[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (10))){
var inst_55901 = (state_55908[(2)]);
var state_55908__$1 = state_55908;
var statearr_55932_56225 = state_55908__$1;
(statearr_55932_56225[(2)] = inst_55901);

(statearr_55932_56225[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55909 === (8))){
var inst_55887 = (keep_alive_secs | (0));
var inst_55888 = ((1000) * inst_55887);
var inst_55889 = cljs.core.async.timeout(inst_55888);
var state_55908__$1 = state_55908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55908__$1,(11),inst_55889);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto__ = null;
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto____0 = (function (){
var statearr_55933 = [null,null,null,null,null,null,null,null,null];
(statearr_55933[(0)] = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto__);

(statearr_55933[(1)] = (1));

return statearr_55933;
});
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto____1 = (function (state_55908){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_55908);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e55934){var ex__43485__auto__ = e55934;
var statearr_55935_56226 = state_55908;
(statearr_55935_56226[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_55908[(4)]))){
var statearr_55936_56227 = state_55908;
(statearr_55936_56227[(1)] = cljs.core.first((state_55908[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56228 = state_55908;
state_55908 = G__56228;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto__ = function(state_55908){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto____1.call(this,state_55908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto____0;
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto____1;
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_55937 = f__43854__auto__();
(statearr_55937[(6)] = c__43853__auto__);

return statearr_55937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

return c__43853__auto__;
});
deercreeklabs.tube.client._LT_connect = (function deercreeklabs$tube$client$_LT_connect(wsc,url,logger,options,close_client_BANG_,_STAR_conn,_STAR_shutdown_QMARK_){
var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_56020){
var state_val_56021 = (state_56020[(1)]);
if((state_val_56021 === (7))){
var inst_56015 = (state_56020[(2)]);
var _ = (function (){var statearr_56022 = state_56020;
(statearr_56022[(4)] = cljs.core.rest((state_56020[(4)])));

return statearr_56022;
})();
var state_56020__$1 = state_56020;
var statearr_56023_56243 = state_56020__$1;
(statearr_56023_56243[(2)] = inst_56015);

(statearr_56023_56243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (20))){
var inst_56009 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
var statearr_56024_56251 = state_56020__$1;
(statearr_56024_56251[(2)] = inst_56009);

(statearr_56024_56251[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (1))){
var state_56020__$1 = state_56020;
var statearr_56025_56257 = state_56020__$1;
(statearr_56025_56257[(2)] = null);

(statearr_56025_56257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (4))){
var inst_55938 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
var statearr_56026_56272 = state_56020__$1;
(statearr_56026_56272[(2)] = inst_55938);

(statearr_56026_56272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (15))){
var state_56020__$1 = state_56020;
var statearr_56027_56277 = state_56020__$1;
(statearr_56027_56277[(2)] = null);

(statearr_56027_56277[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (21))){
var state_56020__$1 = state_56020;
var statearr_56028_56285 = state_56020__$1;
(statearr_56028_56285[(2)] = null);

(statearr_56028_56285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (13))){
var inst_55968 = (state_56020[(7)]);
var inst_55994 = deercreeklabs.tube.utils.current_time_ms();
var inst_55995 = cljs.core.identity(inst_55994);
var inst_55996 = cljs.core.identity(inst_55968);
var inst_55997 = (inst_55995 > inst_55996);
var state_56020__$1 = state_56020;
if(cljs.core.truth_(inst_55997)){
var statearr_56029_56300 = state_56020__$1;
(statearr_56029_56300[(1)] = (18));

} else {
var statearr_56030_56305 = state_56020__$1;
(statearr_56030_56305[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (22))){
var state_56020__$1 = state_56020;
var statearr_56031_56306 = state_56020__$1;
(statearr_56031_56306[(2)] = null);

(statearr_56031_56306[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (6))){
var inst_55970 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_56020__$1 = state_56020;
if(cljs.core.truth_(inst_55970)){
var statearr_56032_56309 = state_56020__$1;
(statearr_56032_56309[(1)] = (8));

} else {
var statearr_56033_56310 = state_56020__$1;
(statearr_56033_56310[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (17))){
var inst_55992 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
var statearr_56034_56311 = state_56020__$1;
(statearr_56034_56311[(2)] = inst_55992);

(statearr_56034_56311[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (3))){
var inst_56018 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56020__$1,inst_56018);
} else {
if((state_val_56021 === (12))){
var inst_55986 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_56020__$1 = state_56020;
if(cljs.core.truth_(inst_55986)){
var statearr_56035_56312 = state_56020__$1;
(statearr_56035_56312[(1)] = (15));

} else {
var statearr_56036_56313 = state_56020__$1;
(statearr_56036_56313[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (2))){
var inst_55955 = (state_56020[(8)]);
var inst_55959 = (state_56020[(9)]);
var inst_55961 = (state_56020[(10)]);
var inst_55954 = (state_56020[(11)]);
var _ = (function (){var statearr_56037 = state_56020;
(statearr_56037[(4)] = cljs.core.cons((5),(state_56020[(4)])));

return statearr_56037;
})();
var inst_55946 = wsc;
var inst_55947 = cljs.core.__destructure_map(inst_55946);
var inst_55948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_55947,new cljs.core.Keyword(null,"sender","sender",1557303285));
var inst_55949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_55947,new cljs.core.Keyword(null,"closer","closer",10992481));
var inst_55950 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_55947,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330));
var inst_55951 = options;
var inst_55952 = cljs.core.__destructure_map(inst_55951);
var inst_55953 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55952,new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612),new cljs.core.Keyword(null,"smart","smart",-1065238825));
var inst_55954__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55952,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(5000));
var inst_55955__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55952,new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281),deercreeklabs.tube.client.default_keepalive_secs);
var inst_55956 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55952,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_55957 = cljs.core.constantly(null);
var inst_55958 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55952,new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281),inst_55957);
var inst_55959__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_55960 = (function (){var map__55944 = inst_55947;
var keep_alive_secs = inst_55955__$1;
var connect_timeout_ms = inst_55954__$1;
var closer = inst_55949;
var map__55945 = inst_55952;
var on_rcv = inst_55958;
var compression_type = inst_55953;
var log_conn_failure_QMARK_ = inst_55956;
var ready_ch = inst_55959__$1;
var sender = inst_55948;
var fragment_size = inst_55950;
return (function (conn){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ready_ch,true);
});
})();
var inst_55961__$1 = deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$12((0),url,url,inst_55960,null,null,inst_55948,inst_55949,inst_55950,inst_55953,true,inst_55958);
var inst_55962 = cljs.core.reset_BANG_(_STAR_conn,inst_55961__$1);
var inst_55963 = deercreeklabs.baracus.encode_int(inst_55950);
var inst_55964 = (inst_55948.cljs$core$IFn$_invoke$arity$1 ? inst_55948.cljs$core$IFn$_invoke$arity$1(inst_55963) : inst_55948.call(null,inst_55963));
var inst_55965 = deercreeklabs.tube.utils.current_time_ms();
var inst_55966 = cljs.core.identity(inst_55965);
var inst_55967 = cljs.core.identity(inst_55954__$1);
var inst_55968 = (inst_55966 + inst_55967);
var state_56020__$1 = (function (){var statearr_56038 = state_56020;
(statearr_56038[(8)] = inst_55955__$1);

(statearr_56038[(12)] = inst_55964);

(statearr_56038[(7)] = inst_55968);

(statearr_56038[(13)] = inst_55962);

(statearr_56038[(9)] = inst_55959__$1);

(statearr_56038[(10)] = inst_55961__$1);

(statearr_56038[(11)] = inst_55954__$1);

return statearr_56038;
})();
var statearr_56039_56322 = state_56020__$1;
(statearr_56039_56322[(2)] = null);

(statearr_56039_56322[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (23))){
var inst_56007 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
var statearr_56040_56324 = state_56020__$1;
(statearr_56040_56324[(2)] = inst_56007);

(statearr_56040_56324[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (19))){
var state_56020__$1 = state_56020;
var statearr_56041_56327 = state_56020__$1;
(statearr_56041_56327[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (11))){
var inst_55959 = (state_56020[(9)]);
var inst_55981 = (state_56020[(2)]);
var inst_55982 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55981,(0),null);
var inst_55983 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55981,(1),null);
var inst_55984 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55959,inst_55983);
var state_56020__$1 = (function (){var statearr_56044 = state_56020;
(statearr_56044[(14)] = inst_55982);

return statearr_56044;
})();
if(inst_55984){
var statearr_56045_56330 = state_56020__$1;
(statearr_56045_56330[(1)] = (12));

} else {
var statearr_56046_56331 = state_56020__$1;
(statearr_56046_56331[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (9))){
var inst_55959 = (state_56020[(9)]);
var inst_55976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55977 = cljs.core.async.timeout((100));
var inst_55978 = [inst_55959,inst_55977];
var inst_55979 = (new cljs.core.PersistentVector(null,2,(5),inst_55976,inst_55978,null));
var state_56020__$1 = state_56020;
return cljs.core.async.ioc_alts_BANG_(state_56020__$1,(11),inst_55979);
} else {
if((state_val_56021 === (5))){
var _ = (function (){var statearr_56047 = state_56020;
(statearr_56047[(4)] = cljs.core.rest((state_56020[(4)])));

return statearr_56047;
})();
var state_56020__$1 = state_56020;
var ex56043 = (state_56020__$1[(2)]);
var statearr_56048_56335 = state_56020__$1;
(statearr_56048_56335[(5)] = ex56043);


var statearr_56049_56336 = state_56020__$1;
(statearr_56049_56336[(1)] = (4));

(statearr_56049_56336[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (14))){
var inst_56011 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
var statearr_56050_56337 = state_56020__$1;
(statearr_56050_56337[(2)] = inst_56011);

(statearr_56050_56337[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (16))){
var inst_55955 = (state_56020[(8)]);
var inst_55961 = (state_56020[(10)]);
var inst_55989 = deercreeklabs.tube.client.start_keep_alive_loop(inst_55961,inst_55955,_STAR_shutdown_QMARK_);
var inst_55990 = deercreeklabs.tube.client.__GT_TubeClient(inst_55961,close_client_BANG_,_STAR_shutdown_QMARK_);
var state_56020__$1 = (function (){var statearr_56051 = state_56020;
(statearr_56051[(15)] = inst_55989);

return statearr_56051;
})();
var statearr_56052_56338 = state_56020__$1;
(statearr_56052_56338[(2)] = inst_55990);

(statearr_56052_56338[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (10))){
var inst_56013 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
var statearr_56053_56340 = state_56020__$1;
(statearr_56053_56340[(2)] = inst_56013);

(statearr_56053_56340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (18))){
var inst_55961 = (state_56020[(10)]);
var inst_55954 = (state_56020[(11)]);
var inst_55999 = ["Websocket to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)," connected, but did ","not complete negotiation before timeout (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_55954)," ms)"].join('');
var inst_56000 = (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),inst_55999) : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_55999));
var inst_56001 = deercreeklabs.tube.connection.close(inst_55961,(1002),"Protocol negotiation timed out",false);
var state_56020__$1 = (function (){var statearr_56054 = state_56020;
(statearr_56054[(16)] = inst_56000);

(statearr_56054[(17)] = inst_56001);

return statearr_56054;
})();
var statearr_56055_56342 = state_56020__$1;
(statearr_56055_56342[(2)] = null);

(statearr_56055_56342[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (8))){
var state_56020__$1 = state_56020;
var statearr_56056_56344 = state_56020__$1;
(statearr_56056_56344[(2)] = null);

(statearr_56056_56344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto__ = null;
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto____0 = (function (){
var statearr_56057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56057[(0)] = deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto__);

(statearr_56057[(1)] = (1));

return statearr_56057;
});
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto____1 = (function (state_56020){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_56020);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e56058){var ex__43485__auto__ = e56058;
var statearr_56059_56347 = state_56020;
(statearr_56059_56347[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_56020[(4)]))){
var statearr_56060_56348 = state_56020;
(statearr_56060_56348[(1)] = cljs.core.first((state_56020[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56350 = state_56020;
state_56020 = G__56350;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto__ = function(state_56020){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto____1.call(this,state_56020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto____0;
deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto____1;
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_56061 = f__43854__auto__();
(statearr_56061[(6)] = c__43853__auto__);

return statearr_56061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

return c__43853__auto__;
});
var ufv___56351 = schema.utils.use_fn_validation;
var output_schema56063_56352 = schema.core.Any;
var input_schema56064_56353 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_schema56068_56354 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)], 0)),schema.core.optional_key(new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"logger","logger",-220675947)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one(schema.core.Str,new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null)], null)),schema.core.optional_key(new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),schema.core.Bool,schema.core.optional_key(new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null)),schema.core.optional_key(new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null))]),cljs.core.with_meta(new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),cljs.core.list(new cljs.core.Symbol("s","enum","s/enum",-975416934,null),new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"logger","logger",-220675947)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)], null)))], null);
var input_checker56065_56355 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema56064_56353);
}),null));
var output_checker56066_56356 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema56063_56352);
}),null));
var input_checker56069_56357 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema56068_56354);
}),null));
var output_checker56070_56358 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema56063_56352);
}),null));
var ret__53164__auto___56367 = (function (){
/**
 * Inputs: ([url :- s/Str] [url :- s/Str options :- {(s/optional-key :compression-type) (s/enum :none :smart :deflate), (s/optional-key :connect-timeout-ms) s/Int, (s/optional-key :keep-alive-secs) s/Int, (s/optional-key :logger) (s/=> s/Any s/Keyword s/Str), (s/optional-key :log-conn-failure?) s/Bool, (s/optional-key :on-disconnect) (s/=> s/Any), (s/optional-key :on-rcv) (s/=> s/Any)}])
 * 
 *   Will return a connected client or a closed channel (nil) on connection
 * failure or timeout.
 */
deercreeklabs.tube.client._LT_tube_client = (function deercreeklabs$tube$client$_LT_tube_client(var_args){
var G__56074 = arguments.length;
switch (G__56074) {
case 1:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1 = (function (G__56067){
var validate__51189__auto__ = cljs.core.deref(ufv___56351);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___56370 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__56067], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56075_56371 = new cljs.core.Keyword(null,"input","input",556931961);
var G__56076_56372 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56077_56373 = input_schema56064_56353;
var G__56078_56374 = cljs.core.deref(input_checker56065_56355);
var G__56079_56375 = args__51190__auto___56370;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56075_56371,G__56076_56372,G__56077_56373,G__56078_56374,G__56079_56375) : schema.core.fn_validator.call(null,G__56075_56371,G__56076_56372,G__56077_56373,G__56078_56374,G__56079_56375));
} else {
var temp__5753__auto___56379 = (function (){var fexpr__56080 = cljs.core.deref(input_checker56065_56355);
return (fexpr__56080.cljs$core$IFn$_invoke$arity$1 ? fexpr__56080.cljs$core$IFn$_invoke$arity$1(args__51190__auto___56370) : fexpr__56080.call(null,args__51190__auto___56370));
})();
if(cljs.core.truth_(temp__5753__auto___56379)){
var error__51191__auto___56380 = temp__5753__auto___56379;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___56380], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema56064_56353,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___56370,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___56380], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var url = G__56067;
while(true){
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2(url,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56081_56385 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__56082_56386 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56083_56387 = output_schema56063_56352;
var G__56084_56388 = cljs.core.deref(output_checker56066_56356);
var G__56085_56389 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56081_56385,G__56082_56386,G__56083_56387,G__56084_56388,G__56085_56389) : schema.core.fn_validator.call(null,G__56081_56385,G__56082_56386,G__56083_56387,G__56084_56388,G__56085_56389));
} else {
var temp__5753__auto___56393 = (function (){var fexpr__56086 = cljs.core.deref(output_checker56066_56356);
return (fexpr__56086.cljs$core$IFn$_invoke$arity$1 ? fexpr__56086.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__56086.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___56393)){
var error__51191__auto___56394 = temp__5753__auto___56393;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___56394], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema56063_56352,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___56394], null));
} else {
}
}
} else {
}

return o__51192__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2 = (function (G__56071,G__56072){
var validate__51189__auto__ = cljs.core.deref(ufv___56351);
if(cljs.core.truth_(validate__51189__auto__)){
var args__51190__auto___56396 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__56071,G__56072], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56087_56397 = new cljs.core.Keyword(null,"input","input",556931961);
var G__56088_56398 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56089_56399 = input_schema56068_56354;
var G__56090_56400 = cljs.core.deref(input_checker56069_56357);
var G__56091_56401 = args__51190__auto___56396;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56087_56397,G__56088_56398,G__56089_56399,G__56090_56400,G__56091_56401) : schema.core.fn_validator.call(null,G__56087_56397,G__56088_56398,G__56089_56399,G__56090_56400,G__56091_56401));
} else {
var temp__5753__auto___56402 = (function (){var fexpr__56092 = cljs.core.deref(input_checker56069_56357);
return (fexpr__56092.cljs$core$IFn$_invoke$arity$1 ? fexpr__56092.cljs$core$IFn$_invoke$arity$1(args__51190__auto___56396) : fexpr__56092.call(null,args__51190__auto___56396));
})();
if(cljs.core.truth_(temp__5753__auto___56402)){
var error__51191__auto___56403 = temp__5753__auto___56402;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___56403], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema56068_56354,new cljs.core.Keyword(null,"value","value",305978217),args__51190__auto___56396,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___56403], null));
} else {
}
}
} else {
}

var o__51192__auto__ = (function (){var url = G__56071;
var options = G__56072;
while(true){
var c__43853__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__43853__auto__,validate__51189__auto__,ufv___56351,output_schema56063_56352,input_schema56064_56353,input_schema56068_56354,input_checker56065_56355,output_checker56066_56356,input_checker56069_56357,output_checker56070_56358){
return (function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_56150){
var state_val_56151 = (state_56150[(1)]);
if((state_val_56151 === (7))){
var inst_56131 = (state_56150[(7)]);
var state_56150__$1 = state_56150;
var statearr_56152_56404 = state_56150__$1;
(statearr_56152_56404[(2)] = inst_56131);

(statearr_56152_56404[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (1))){
var state_56150__$1 = state_56150;
var statearr_56153_56405 = state_56150__$1;
(statearr_56153_56405[(2)] = null);

(statearr_56153_56405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (4))){
var inst_56093 = (state_56150[(2)]);
var state_56150__$1 = state_56150;
var statearr_56154_56406 = state_56150__$1;
(statearr_56154_56406[(2)] = inst_56093);

(statearr_56154_56406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (13))){
var inst_56141 = (state_56150[(2)]);
var inst_56142 = deercreeklabs.async_utils.check(inst_56141);
var state_56150__$1 = state_56150;
var statearr_56155_56413 = state_56150__$1;
(statearr_56155_56413[(2)] = inst_56142);

(statearr_56155_56413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (6))){
var inst_56115 = (state_56150[(8)]);
var inst_56124 = (state_56150[(2)]);
var inst_56125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56124,(0),null);
var inst_56126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56124,(1),null);
var inst_56127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56128 = deercreeklabs.async_utils.check(inst_56125);
var inst_56129 = [inst_56128,inst_56126];
var inst_56130 = (new cljs.core.PersistentVector(null,2,(5),inst_56127,inst_56129,null));
var inst_56131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56130,(0),null);
var inst_56132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56130,(1),null);
var inst_56133 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_56115,inst_56132);
var state_56150__$1 = (function (){var statearr_56156 = state_56150;
(statearr_56156[(7)] = inst_56131);

return statearr_56156;
})();
if(inst_56133){
var statearr_56157_56431 = state_56150__$1;
(statearr_56157_56431[(1)] = (7));

} else {
var statearr_56158_56432 = state_56150__$1;
(statearr_56158_56432[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (3))){
var inst_56148 = (state_56150[(2)]);
var state_56150__$1 = state_56150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56150__$1,inst_56148);
} else {
if((state_val_56151 === (12))){
var inst_56145 = (state_56150[(2)]);
var _ = (function (){var statearr_56159 = state_56150;
(statearr_56159[(4)] = cljs.core.rest((state_56150[(4)])));

return statearr_56159;
})();
var state_56150__$1 = state_56150;
var statearr_56160_56448 = state_56150__$1;
(statearr_56160_56448[(2)] = inst_56145);

(statearr_56160_56448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (2))){
var inst_56111 = (state_56150[(9)]);
var inst_56110 = (state_56150[(10)]);
var inst_56105 = (state_56150[(11)]);
var inst_56112 = (state_56150[(12)]);
var inst_56115 = (state_56150[(8)]);
var _ = (function (){var statearr_56161 = state_56150;
(statearr_56161[(4)] = cljs.core.cons((5),(state_56150[(4)])));

return statearr_56161;
})();
var inst_56103 = options;
var inst_56104 = cljs.core.__destructure_map(inst_56103);
var inst_56105__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56104,new cljs.core.Keyword(null,"logger","logger",-220675947),deercreeklabs.tube.utils.println_logger);
var inst_56106 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56104,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_56107 = cljs.core.constantly(null);
var inst_56108 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56104,new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814),inst_56107);
var inst_56109 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_56104,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(10000));
var inst_56110__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var inst_56111__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var inst_56112__$1 = (function (){var map__56099 = inst_56104;
var logger = inst_56105__$1;
var log_conn_failure_QMARK_ = inst_56106;
var on_disconnect = inst_56108;
var connect_timeout_ms = inst_56109;
var _STAR_shutdown_QMARK_ = inst_56110__$1;
var _STAR_conn = inst_56111__$1;
return (function (code,reason,ws_already_closed_QMARK_){
var conn = cljs.core.deref(_STAR_conn);
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(conn)){
deercreeklabs.tube.connection.close(conn,code,reason,ws_already_closed_QMARK_);
} else {
}

return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(conn,code,reason) : on_disconnect.call(null,conn,code,reason));
});
})();
var inst_56113 = (function (){var map__56099 = inst_56104;
var logger = inst_56105__$1;
var log_conn_failure_QMARK_ = inst_56106;
var on_disconnect = inst_56108;
var connect_timeout_ms = inst_56109;
var _STAR_shutdown_QMARK_ = inst_56110__$1;
var _STAR_conn = inst_56111__$1;
var close_client_BANG_ = inst_56112__$1;
return (function (msg){
try{var G__56165_56524 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__56166_56525 = ["Error in websocket: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__56165_56524,G__56166_56525) : logger.call(null,G__56165_56524,G__56166_56525));

return close_client_BANG_((1011),msg,true);
}catch (e56162){if((e56162 instanceof Error)){
var e = e56162;
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error.") : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error."));

var G__56163 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__56164 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(e);
return (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__56163,G__56164) : logger.call(null,G__56163,G__56164));
} else {
throw e56162;

}
}});
})();
var inst_56114 = (function (){var on_error = inst_56113;
var connect_timeout_ms = inst_56109;
var close_client_BANG_ = inst_56112__$1;
var on_disconnect = inst_56108;
var _STAR_conn = inst_56111__$1;
var log_conn_failure_QMARK_ = inst_56106;
var map__56099 = inst_56104;
var logger = inst_56105__$1;
var _STAR_shutdown_QMARK_ = inst_56110__$1;
return (function (p1__56062_SHARP_){
var temp__5753__auto__ = cljs.core.deref(_STAR_conn);
if(cljs.core.truth_(temp__5753__auto__)){
var conn = temp__5753__auto__;
return deercreeklabs.tube.connection.handle_data(conn,p1__56062_SHARP_);
} else {
return null;
}
});
})();
var inst_56115__$1 = deercreeklabs.tube.client._LT_ws_client_cljs(inst_56105__$1,url,inst_56113,inst_56108,inst_56114,inst_56106,inst_56111__$1,inst_56110__$1);
var inst_56119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56120 = cljs.core.async.timeout(inst_56109);
var inst_56121 = [inst_56115__$1,inst_56120];
var inst_56122 = (new cljs.core.PersistentVector(null,2,(5),inst_56119,inst_56121,null));
var state_56150__$1 = (function (){var statearr_56167 = state_56150;
(statearr_56167[(9)] = inst_56111__$1);

(statearr_56167[(10)] = inst_56110__$1);

(statearr_56167[(11)] = inst_56105__$1);

(statearr_56167[(12)] = inst_56112__$1);

(statearr_56167[(8)] = inst_56115__$1);

return statearr_56167;
})();
return cljs.core.async.ioc_alts_BANG_(state_56150__$1,(6),inst_56122);
} else {
if((state_val_56151 === (11))){
var state_56150__$1 = state_56150;
var statearr_56169_56599 = state_56150__$1;
(statearr_56169_56599[(2)] = null);

(statearr_56169_56599[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (9))){
var inst_56137 = (state_56150[(2)]);
var state_56150__$1 = state_56150;
if(cljs.core.truth_(inst_56137)){
var statearr_56170_56605 = state_56150__$1;
(statearr_56170_56605[(1)] = (10));

} else {
var statearr_56171_56610 = state_56150__$1;
(statearr_56171_56610[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (5))){
var _ = (function (){var statearr_56172 = state_56150;
(statearr_56172[(4)] = cljs.core.rest((state_56150[(4)])));

return statearr_56172;
})();
var state_56150__$1 = state_56150;
var ex56168 = (state_56150__$1[(2)]);
var statearr_56173_56622 = state_56150__$1;
(statearr_56173_56622[(5)] = ex56168);


var statearr_56174_56628 = state_56150__$1;
(statearr_56174_56628[(1)] = (4));

(statearr_56174_56628[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (10))){
var inst_56111 = (state_56150[(9)]);
var inst_56110 = (state_56150[(10)]);
var inst_56105 = (state_56150[(11)]);
var inst_56131 = (state_56150[(7)]);
var inst_56112 = (state_56150[(12)]);
var inst_56139 = deercreeklabs.tube.client._LT_connect(inst_56131,url,inst_56105,options,inst_56112,inst_56111,inst_56110);
var state_56150__$1 = state_56150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56150__$1,(13),inst_56139);
} else {
if((state_val_56151 === (8))){
var state_56150__$1 = state_56150;
var statearr_56175_56656 = state_56150__$1;
(statearr_56175_56656[(2)] = false);

(statearr_56175_56656[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$state_machine__43482__auto__ = null;
var deercreeklabs$tube$client$state_machine__43482__auto____0 = (function (){
var statearr_56176 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56176[(0)] = deercreeklabs$tube$client$state_machine__43482__auto__);

(statearr_56176[(1)] = (1));

return statearr_56176;
});
var deercreeklabs$tube$client$state_machine__43482__auto____1 = (function (state_56150){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_56150);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e56177){var ex__43485__auto__ = e56177;
var statearr_56178_56685 = state_56150;
(statearr_56178_56685[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_56150[(4)]))){
var statearr_56179_56689 = state_56150;
(statearr_56179_56689[(1)] = cljs.core.first((state_56150[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56690 = state_56150;
state_56150 = G__56690;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
deercreeklabs$tube$client$state_machine__43482__auto__ = function(state_56150){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$state_machine__43482__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$state_machine__43482__auto____1.call(this,state_56150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$state_machine__43482__auto____0;
deercreeklabs$tube$client$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$state_machine__43482__auto____1;
return deercreeklabs$tube$client$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_56180 = f__43854__auto__();
(statearr_56180[(6)] = c__43853__auto__);

return statearr_56180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
});})(c__43853__auto__,validate__51189__auto__,ufv___56351,output_schema56063_56352,input_schema56064_56353,input_schema56068_56354,input_checker56065_56355,output_checker56066_56356,input_checker56069_56357,output_checker56070_56358))
);

return c__43853__auto__;
break;
}
})();
if(cljs.core.truth_(validate__51189__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__56181_56691 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__56182_56692 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__56183_56693 = output_schema56063_56352;
var G__56184_56694 = cljs.core.deref(output_checker56070_56358);
var G__56185_56695 = o__51192__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__56181_56691,G__56182_56692,G__56183_56693,G__56184_56694,G__56185_56695) : schema.core.fn_validator.call(null,G__56181_56691,G__56182_56692,G__56183_56693,G__56184_56694,G__56185_56695));
} else {
var temp__5753__auto___56698 = (function (){var fexpr__56186 = cljs.core.deref(output_checker56070_56358);
return (fexpr__56186.cljs$core$IFn$_invoke$arity$1 ? fexpr__56186.cljs$core$IFn$_invoke$arity$1(o__51192__auto__) : fexpr__56186.call(null,o__51192__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___56698)){
var error__51191__auto___56699 = temp__5753__auto___56698;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51191__auto___56699], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema56063_56352,new cljs.core.Keyword(null,"value","value",305978217),o__51192__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51191__auto___56699], null));
} else {
}
}
} else {
}

return o__51192__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.tube.client._LT_tube_client),schema.core.make_fn_schema(output_schema56063_56352,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema56064_56353,input_schema56068_56354], null)));


//# sourceMappingURL=deercreeklabs.tube.client.js.map
