goog.provide('deercreeklabs.tube.connection');
deercreeklabs.tube.connection.max_num_fragments = (2147483647);
deercreeklabs.tube.connection.ping_control_code = (16);
deercreeklabs.tube.connection.pong_control_code = (17);

/**
 * @interface
 */
deercreeklabs.tube.connection.IConnection = function(){};

var deercreeklabs$tube$connection$IConnection$set_on_rcv_BANG_$dyn_55838 = (function (this$,on_rcv){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.set_on_rcv_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,on_rcv) : m__4464__auto__.call(null,this$,on_rcv));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.set_on_rcv_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,on_rcv) : m__4461__auto__.call(null,this$,on_rcv));
} else {
throw cljs.core.missing_protocol("IConnection.set-on-rcv!",this$);
}
}
});
/**
 * Set the receive handler
 */
deercreeklabs.tube.connection.set_on_rcv_BANG_ = (function deercreeklabs$tube$connection$set_on_rcv_BANG_(this$,on_rcv){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$set_on_rcv_BANG_$arity$2 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$set_on_rcv_BANG_$arity$2(this$,on_rcv);
} else {
return deercreeklabs$tube$connection$IConnection$set_on_rcv_BANG_$dyn_55838(this$,on_rcv);
}
});

var deercreeklabs$tube$connection$IConnection$get_conn_id$dyn_55839 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.get_conn_id[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.get_conn_id["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IConnection.get-conn-id",this$);
}
}
});
/**
 * Return the connection id
 */
deercreeklabs.tube.connection.get_conn_id = (function deercreeklabs$tube$connection$get_conn_id(this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$get_conn_id$arity$1 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$get_conn_id$arity$1(this$);
} else {
return deercreeklabs$tube$connection$IConnection$get_conn_id$dyn_55839(this$);
}
});

var deercreeklabs$tube$connection$IConnection$get_uri$dyn_55840 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.get_uri[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.get_uri["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IConnection.get-uri",this$);
}
}
});
deercreeklabs.tube.connection.get_uri = (function deercreeklabs$tube$connection$get_uri(this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$get_uri$arity$1 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$get_uri$arity$1(this$);
} else {
return deercreeklabs$tube$connection$IConnection$get_uri$dyn_55840(this$);
}
});

var deercreeklabs$tube$connection$IConnection$get_remote_addr$dyn_55841 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.get_remote_addr[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.get_remote_addr["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IConnection.get-remote-addr",this$);
}
}
});
deercreeklabs.tube.connection.get_remote_addr = (function deercreeklabs$tube$connection$get_remote_addr(this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$get_remote_addr$arity$1 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$get_remote_addr$arity$1(this$);
} else {
return deercreeklabs$tube$connection$IConnection$get_remote_addr$dyn_55841(this$);
}
});

var deercreeklabs$tube$connection$IConnection$get_state$dyn_55842 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.get_state[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.get_state["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IConnection.get-state",this$);
}
}
});
/**
 * Return the state for this connection
 */
deercreeklabs.tube.connection.get_state = (function deercreeklabs$tube$connection$get_state(this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$get_state$arity$1 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$get_state$arity$1(this$);
} else {
return deercreeklabs$tube$connection$IConnection$get_state$dyn_55842(this$);
}
});

var deercreeklabs$tube$connection$IConnection$send$dyn_55843 = (function (this$,data){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.send[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4464__auto__.call(null,this$,data));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.send["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4461__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("IConnection.send",this$);
}
}
});
/**
 * Send binary bytes over this connection
 */
deercreeklabs.tube.connection.send = (function deercreeklabs$tube$connection$send(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$send$arity$2 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$send$arity$2(this$,data);
} else {
return deercreeklabs$tube$connection$IConnection$send$dyn_55843(this$,data);
}
});

var deercreeklabs$tube$connection$IConnection$send_ping$dyn_55844 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.send_ping[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.send_ping["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IConnection.send-ping",this$);
}
}
});
/**
 * Send a tube-specific ping (not an RFC6455 ping)
 */
deercreeklabs.tube.connection.send_ping = (function deercreeklabs$tube$connection$send_ping(this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$send_ping$arity$1 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$send_ping$arity$1(this$);
} else {
return deercreeklabs$tube$connection$IConnection$send_ping$dyn_55844(this$);
}
});

var deercreeklabs$tube$connection$IConnection$send_pong$dyn_55845 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.send_pong[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.send_pong["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IConnection.send-pong",this$);
}
}
});
/**
 * Send a tube-specific pong (not an RFC6455 pong)
 */
deercreeklabs.tube.connection.send_pong = (function deercreeklabs$tube$connection$send_pong(this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$send_pong$arity$1 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$send_pong$arity$1(this$);
} else {
return deercreeklabs$tube$connection$IConnection$send_pong$dyn_55845(this$);
}
});

var deercreeklabs$tube$connection$IConnection$close$dyn_55846 = (function() {
var G__55847 = null;
var G__55847__1 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.close[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.close["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IConnection.close",this$);
}
}
});
var G__55847__4 = (function (this$,code,reason,ws_already_closed_QMARK_){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.close[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(this$,code,reason,ws_already_closed_QMARK_) : m__4464__auto__.call(null,this$,code,reason,ws_already_closed_QMARK_));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.close["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(this$,code,reason,ws_already_closed_QMARK_) : m__4461__auto__.call(null,this$,code,reason,ws_already_closed_QMARK_));
} else {
throw cljs.core.missing_protocol("IConnection.close",this$);
}
}
});
G__55847 = function(this$,code,reason,ws_already_closed_QMARK_){
switch(arguments.length){
case 1:
return G__55847__1.call(this,this$);
case 4:
return G__55847__4.call(this,this$,code,reason,ws_already_closed_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__55847.cljs$core$IFn$_invoke$arity$1 = G__55847__1;
G__55847.cljs$core$IFn$_invoke$arity$4 = G__55847__4;
return G__55847;
})()
;
/**
 * Close this connection
 */
deercreeklabs.tube.connection.close = (function deercreeklabs$tube$connection$close(var_args){
var G__55777 = arguments.length;
switch (G__55777) {
case 1:
return deercreeklabs.tube.connection.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return deercreeklabs.tube.connection.close.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.connection.close.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$close$arity$1 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$close$arity$1(this$);
} else {
return deercreeklabs$tube$connection$IConnection$close$dyn_55846(this$);
}
}));

(deercreeklabs.tube.connection.close.cljs$core$IFn$_invoke$arity$4 = (function (this$,code,reason,ws_already_closed_QMARK_){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$close$arity$4 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$close$arity$4(this$,code,reason,ws_already_closed_QMARK_);
} else {
return deercreeklabs$tube$connection$IConnection$close$dyn_55846(this$,code,reason,ws_already_closed_QMARK_);
}
}));

(deercreeklabs.tube.connection.close.cljs$lang$maxFixedArity = 4);


var deercreeklabs$tube$connection$IConnection$handle_data$dyn_55849 = (function (this$,data){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.handle_data[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4464__auto__.call(null,this$,data));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.handle_data["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4461__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("IConnection.handle-data",this$);
}
}
});
/**
 * The network layer calls this on receipt of data
 */
deercreeklabs.tube.connection.handle_data = (function deercreeklabs$tube$connection$handle_data(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$handle_data$arity$2 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$handle_data$arity$2(this$,data);
} else {
return deercreeklabs$tube$connection$IConnection$handle_data$dyn_55849(this$,data);
}
});

var deercreeklabs$tube$connection$IConnection$handle_connected_STAR_$dyn_55850 = (function (this$,data){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.handle_connected_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4464__auto__.call(null,this$,data));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.handle_connected_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4461__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("IConnection.handle-connected*",this$);
}
}
});
/**
 * Internal use only
 */
deercreeklabs.tube.connection.handle_connected_STAR_ = (function deercreeklabs$tube$connection$handle_connected_STAR_(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$handle_connected_STAR_$arity$2 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$handle_connected_STAR_$arity$2(this$,data);
} else {
return deercreeklabs$tube$connection$IConnection$handle_connected_STAR_$dyn_55850(this$,data);
}
});

var deercreeklabs$tube$connection$IConnection$handle_ready_STAR_$dyn_55852 = (function (this$,data){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.handle_ready_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4464__auto__.call(null,this$,data));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.handle_ready_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4461__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("IConnection.handle-ready*",this$);
}
}
});
/**
 * Internal use only
 */
deercreeklabs.tube.connection.handle_ready_STAR_ = (function deercreeklabs$tube$connection$handle_ready_STAR_(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$handle_ready_STAR_$arity$2 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$handle_ready_STAR_$arity$2(this$,data);
} else {
return deercreeklabs$tube$connection$IConnection$handle_ready_STAR_$dyn_55852(this$,data);
}
});

var deercreeklabs$tube$connection$IConnection$handle_ready_end_STAR_$dyn_55854 = (function (this$,data,compressed_QMARK_){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.handle_ready_end_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(this$,data,compressed_QMARK_) : m__4464__auto__.call(null,this$,data,compressed_QMARK_));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.handle_ready_end_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(this$,data,compressed_QMARK_) : m__4461__auto__.call(null,this$,data,compressed_QMARK_));
} else {
throw cljs.core.missing_protocol("IConnection.handle-ready-end*",this$);
}
}
});
/**
 * Internal use only
 */
deercreeklabs.tube.connection.handle_ready_end_STAR_ = (function deercreeklabs$tube$connection$handle_ready_end_STAR_(this$,data,compressed_QMARK_){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$handle_ready_end_STAR_$arity$3 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$handle_ready_end_STAR_$arity$3(this$,data,compressed_QMARK_);
} else {
return deercreeklabs$tube$connection$IConnection$handle_ready_end_STAR_$dyn_55854(this$,data,compressed_QMARK_);
}
});

var deercreeklabs$tube$connection$IConnection$handle_msg_in_flight_STAR_$dyn_55855 = (function (this$,data){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (deercreeklabs.tube.connection.handle_msg_in_flight_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4464__auto__.call(null,this$,data));
} else {
var m__4461__auto__ = (deercreeklabs.tube.connection.handle_msg_in_flight_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4461__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("IConnection.handle-msg-in-flight*",this$);
}
}
});
/**
 * Internal use only
 */
deercreeklabs.tube.connection.handle_msg_in_flight_STAR_ = (function deercreeklabs$tube$connection$handle_msg_in_flight_STAR_(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$connection$IConnection$handle_msg_in_flight_STAR_$arity$2 == null)))))){
return this$.deercreeklabs$tube$connection$IConnection$handle_msg_in_flight_STAR_$arity$2(this$,data);
} else {
return deercreeklabs$tube$connection$IConnection$handle_msg_in_flight_STAR_$dyn_55855(this$,data);
}
});

deercreeklabs.tube.connection.send_STAR_ = (function deercreeklabs$tube$connection$send_STAR_(conn,data,compress,_STAR_peer_fragment_size,sender){
var vec__55809 = (compress.cljs$core$IFn$_invoke$arity$1 ? compress.cljs$core$IFn$_invoke$arity$1(data) : compress.call(null,data));
var compression_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55809,(0),null);
var compressed = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55809,(1),null);
var frags = deercreeklabs.baracus.byte_array__GT_fragments(compressed,((cljs.core.deref(_STAR_peer_fragment_size) | (0)) - (6)));
var num_frags = cljs.core.count(frags);
var _ = (((num_frags > (deercreeklabs.tube.connection.max_num_fragments | (0))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Maximum message fragments exceeded.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"too-many-fragments","too-many-fragments",-2088122512),new cljs.core.Keyword(null,"num-fragments","num-fragments",1971435427),num_frags,new cljs.core.Keyword(null,"max-num-framents","max-num-framents",-1715654370),deercreeklabs.tube.connection.max_num_fragments], null))})():null);
var first_byte = (compression_id << (3));
var header = (((num_frags <= (7)))?deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(first_byte | num_frags)], null)):deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_byte], null)),deercreeklabs.baracus.encode_int(num_frags)], null)));
var frags__$1 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(frags,(0),(function (p1__55808_SHARP_){
return deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [header,p1__55808_SHARP_], null));
}));
var seq__55812 = cljs.core.seq(frags__$1);
var chunk__55813 = null;
var count__55814 = (0);
var i__55815 = (0);
while(true){
if((i__55815 < count__55814)){
var frag = chunk__55813.cljs$core$IIndexed$_nth$arity$2(null,i__55815);
(sender.cljs$core$IFn$_invoke$arity$1 ? sender.cljs$core$IFn$_invoke$arity$1(frag) : sender.call(null,frag));


var G__55856 = seq__55812;
var G__55857 = chunk__55813;
var G__55858 = count__55814;
var G__55859 = (i__55815 + (1));
seq__55812 = G__55856;
chunk__55813 = G__55857;
count__55814 = G__55858;
i__55815 = G__55859;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__55812);
if(temp__5753__auto__){
var seq__55812__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__55812__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__55812__$1);
var G__55860 = cljs.core.chunk_rest(seq__55812__$1);
var G__55861 = c__4591__auto__;
var G__55862 = cljs.core.count(c__4591__auto__);
var G__55863 = (0);
seq__55812 = G__55860;
chunk__55813 = G__55861;
count__55814 = G__55862;
i__55815 = G__55863;
continue;
} else {
var frag = cljs.core.first(seq__55812__$1);
(sender.cljs$core$IFn$_invoke$arity$1 ? sender.cljs$core$IFn$_invoke$arity$1(frag) : sender.call(null,frag));


var G__55864 = cljs.core.next(seq__55812__$1);
var G__55865 = null;
var G__55866 = (0);
var G__55867 = (0);
seq__55812 = G__55864;
chunk__55813 = G__55865;
count__55814 = G__55866;
i__55815 = G__55867;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {deercreeklabs.tube.connection.IConnection}
*/
deercreeklabs.tube.connection.Connection = (function (conn_id,uri,remote_addr,on_connect,conn_req,sender,closer,fragment_size,compress,client_QMARK_,output_stream,_STAR_on_rcv,_STAR_on_disconnect,_STAR_state,_STAR_peer_fragment_size,_STAR_num_fragments_expected,_STAR_num_fragments_rcvd,_STAR_cur_msg_compressed_QMARK_,_STAR_conn_count){
this.conn_id = conn_id;
this.uri = uri;
this.remote_addr = remote_addr;
this.on_connect = on_connect;
this.conn_req = conn_req;
this.sender = sender;
this.closer = closer;
this.fragment_size = fragment_size;
this.compress = compress;
this.client_QMARK_ = client_QMARK_;
this.output_stream = output_stream;
this._STAR_on_rcv = _STAR_on_rcv;
this._STAR_on_disconnect = _STAR_on_disconnect;
this._STAR_state = _STAR_state;
this._STAR_peer_fragment_size = _STAR_peer_fragment_size;
this._STAR_num_fragments_expected = _STAR_num_fragments_expected;
this._STAR_num_fragments_rcvd = _STAR_num_fragments_rcvd;
this._STAR_cur_msg_compressed_QMARK_ = _STAR_cur_msg_compressed_QMARK_;
this._STAR_conn_count = _STAR_conn_count;
});
(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$ = cljs.core.PROTOCOL_SENTINEL);

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$get_uri$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.uri;
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$handle_data$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
var G__55817 = cljs.core.deref(self__._STAR_state);
var G__55817__$1 = (((G__55817 instanceof cljs.core.Keyword))?G__55817.fqn:null);
switch (G__55817__$1) {
case "connected":
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_connected_STAR_$arity$2(null,data);

break;
case "ready":
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_ready_STAR_$arity$2(null,data);

break;
case "msg-in-flight":
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_msg_in_flight_STAR_$arity$2(null,data);

break;
case "shutdown":
return null;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55817__$1)].join('')));

}
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$set_on_rcv_BANG_$arity$2 = (function (this$,on_rcv){
var self__ = this;
var this$__$1 = this;
return cljs.core.reset_BANG_(self__._STAR_on_rcv,on_rcv);
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$get_remote_addr$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.remote_addr;
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$get_conn_id$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.conn_id;
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$handle_msg_in_flight_STAR_$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.output_stream,cljs.core.conj,data);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__._STAR_num_fragments_rcvd,(function (p1__55816_SHARP_){
return ((p1__55816_SHARP_ | (0)) + (1));
}));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__._STAR_num_fragments_rcvd),cljs.core.deref(self__._STAR_num_fragments_expected))){
cljs.core.reset_BANG_(self__._STAR_state,new cljs.core.Keyword(null,"ready","ready",1086465795));

cljs.core.reset_BANG_(self__._STAR_num_fragments_rcvd,(0));

var whole = deercreeklabs.baracus.concat_byte_arrays(cljs.core.deref(self__.output_stream));
var msg = (cljs.core.truth_(cljs.core.deref(self__._STAR_cur_msg_compressed_QMARK_))?whole:whole);
cljs.core.reset_BANG_(self__.output_stream,cljs.core.PersistentVector.EMPTY);

var fexpr__55818 = cljs.core.deref(self__._STAR_on_rcv);
return (fexpr__55818.cljs$core$IFn$_invoke$arity$2 ? fexpr__55818.cljs$core$IFn$_invoke$arity$2(this$__$1,msg) : fexpr__55818.call(null,this$__$1,msg));
} else {
return null;
}
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$handle_ready_end_STAR_$arity$3 = (function (this$,data,compressed_QMARK_){
var self__ = this;
var this$__$1 = this;
cljs.core.reset_BANG_(self__._STAR_cur_msg_compressed_QMARK_,compressed_QMARK_);

var num_frags = ((data[(0)]) & (7));
var rest_of_bytes = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(data,(1));
var vec__55819 = (((num_frags > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [num_frags,rest_of_bytes], null):deercreeklabs.baracus.decode_int(rest_of_bytes));
var num_frags__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55819,(0),null);
var extra_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55819,(1),null);
cljs.core.reset_BANG_(self__._STAR_num_fragments_expected,num_frags__$1);

cljs.core.reset_BANG_(self__._STAR_state,new cljs.core.Keyword(null,"msg-in-flight","msg-in-flight",1305952780));

if(cljs.core.truth_(extra_data)){
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_data$arity$2(null,extra_data);
} else {
return null;
}
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$get_state$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.deref(self__._STAR_state);
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$handle_connected_STAR_$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
var vec__55822 = deercreeklabs.baracus.decode_int(data);
var peer_fragment_size = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55822,(0),null);
var extra_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55822,(1),null);
var state = cljs.core.deref(self__._STAR_state);
cljs.core.reset_BANG_(self__._STAR_peer_fragment_size,peer_fragment_size);

if(cljs.core.truth_(self__.client_QMARK_)){
} else {
var G__55825_55873 = deercreeklabs.baracus.encode_int(self__.fragment_size);
(self__.sender.cljs$core$IFn$_invoke$arity$1 ? self__.sender.cljs$core$IFn$_invoke$arity$1(G__55825_55873) : self__.sender.call(null,G__55825_55873));
}

cljs.core.reset_BANG_(self__._STAR_state,new cljs.core.Keyword(null,"ready","ready",1086465795));

if(cljs.core.truth_(extra_data)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Extra data in negotiation header.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"execution-error","execution-error",12306475),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"extra-data-in-negotiation-header","extra-data-in-negotiation-header",-782619612),new cljs.core.Keyword(null,"data-str","data-str",1243557545),deercreeklabs.baracus.byte_array__GT_debug_str(data),new cljs.core.Keyword(null,"extra-data-str","extra-data-str",11561622),deercreeklabs.baracus.byte_array__GT_debug_str(extra_data)], null));
} else {
}

if(cljs.core.truth_(self__.on_connect)){
if(cljs.core.truth_(self__.client_QMARK_)){
return (self__.on_connect.cljs$core$IFn$_invoke$arity$1 ? self__.on_connect.cljs$core$IFn$_invoke$arity$1(this$__$1) : self__.on_connect.call(null,this$__$1));
} else {
var G__55826 = this$__$1;
var G__55827 = self__.conn_req;
var G__55828 = cljs.core.deref(self__._STAR_conn_count);
return (self__.on_connect.cljs$core$IFn$_invoke$arity$3 ? self__.on_connect.cljs$core$IFn$_invoke$arity$3(G__55826,G__55827,G__55828) : self__.on_connect.call(null,G__55826,G__55827,G__55828));
}
} else {
return null;
}
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$send_ping$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__55829 = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(deercreeklabs.tube.connection.ping_control_code << (3))], null));
return (self__.sender.cljs$core$IFn$_invoke$arity$1 ? self__.sender.cljs$core$IFn$_invoke$arity$1(G__55829) : self__.sender.call(null,G__55829));
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$close$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1.deercreeklabs$tube$connection$IConnection$close$arity$4(null,(1000),"Explicit close",false);
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$close$arity$4 = (function (this$,code,reason,ws_already_closed_QMARK_){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"shutdown","shutdown",-1876565378),cljs.core.deref(self__._STAR_state))){
return null;
} else {
cljs.core.reset_BANG_(self__._STAR_state,new cljs.core.Keyword(null,"shutdown","shutdown",-1876565378));

if(cljs.core.truth_(ws_already_closed_QMARK_)){
return null;
} else {
return (self__.closer.cljs$core$IFn$_invoke$arity$0 ? self__.closer.cljs$core$IFn$_invoke$arity$0() : self__.closer.call(null));
}
}
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$handle_ready_STAR_$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
var masked = ((data[(0)]) & (248));
var code = (masked >> (3));
var pred__55830 = cljs.core._EQ_;
var expr__55831 = code;
if(cljs.core.truth_((pred__55830.cljs$core$IFn$_invoke$arity$2 ? pred__55830.cljs$core$IFn$_invoke$arity$2((0),expr__55831) : pred__55830.call(null,(0),expr__55831)))){
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_ready_end_STAR_$arity$3(null,data,false);
} else {
if(cljs.core.truth_((pred__55830.cljs$core$IFn$_invoke$arity$2 ? pred__55830.cljs$core$IFn$_invoke$arity$2((1),expr__55831) : pred__55830.call(null,(1),expr__55831)))){
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_ready_end_STAR_$arity$3(null,data,true);
} else {
if(cljs.core.truth_((pred__55830.cljs$core$IFn$_invoke$arity$2 ? pred__55830.cljs$core$IFn$_invoke$arity$2(deercreeklabs.tube.connection.ping_control_code,expr__55831) : pred__55830.call(null,deercreeklabs.tube.connection.ping_control_code,expr__55831)))){
this$__$1.deercreeklabs$tube$connection$IConnection$send_pong$arity$1(null);

if((cljs.core.count(data) > (1))){
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_data$arity$2(null,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(data,(1)));
} else {
return null;
}
} else {
if(cljs.core.truth_((pred__55830.cljs$core$IFn$_invoke$arity$2 ? pred__55830.cljs$core$IFn$_invoke$arity$2(deercreeklabs.tube.connection.pong_control_code,expr__55831) : pred__55830.call(null,deercreeklabs.tube.connection.pong_control_code,expr__55831)))){
if((cljs.core.count(data) > (1))){
return this$__$1.deercreeklabs$tube$connection$IConnection$handle_data$arity$2(null,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(data,(1)));
} else {
return null;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Got unknown control code: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code),"`.\n",deercreeklabs.tube.utils.pprint_str(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"masked","masked",1191724351),masked], null))].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"masked","masked",1191724351),masked], null));
}
}
}
}
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$send$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
var G__55833 = cljs.core.deref(self__._STAR_state);
var G__55833__$1 = (((G__55833 instanceof cljs.core.Keyword))?G__55833.fqn:null);
switch (G__55833__$1) {
case "connected":
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Attempt to send before negotiation is complete.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"execution-error","execution-error",12306475),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"send-before-negotiation-complete","send-before-negotiation-complete",-1145981018),new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.deref(self__._STAR_state)], null));

break;
case "ready":
return deercreeklabs.tube.connection.send_STAR_(this$__$1,data,self__.compress,self__._STAR_peer_fragment_size,self__.sender);

break;
case "msg-in-flight":
return deercreeklabs.tube.connection.send_STAR_(this$__$1,data,self__.compress,self__._STAR_peer_fragment_size,self__.sender);

break;
case "shutdown":
return null;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55833__$1)].join('')));

}
}));

(deercreeklabs.tube.connection.Connection.prototype.deercreeklabs$tube$connection$IConnection$send_pong$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__55834 = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(deercreeklabs.tube.connection.pong_control_code << (3))], null));
return (self__.sender.cljs$core$IFn$_invoke$arity$1 ? self__.sender.cljs$core$IFn$_invoke$arity$1(G__55834) : self__.sender.call(null,G__55834));
}));

(deercreeklabs.tube.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn-id","conn-id",1723829251,null),new cljs.core.Symbol(null,"uri","uri",865819680,null),new cljs.core.Symbol(null,"remote-addr","remote-addr",-1838711792,null),new cljs.core.Symbol(null,"on-connect","on-connect",491558471,null),new cljs.core.Symbol(null,"conn-req","conn-req",1991982399,null),new cljs.core.Symbol(null,"sender","sender",-1097132484,null),new cljs.core.Symbol(null,"closer","closer",1651524008,null),new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.Symbol(null,"compress","compress",209814009,null),new cljs.core.Symbol(null,"client?","client?",-292881531,null),new cljs.core.Symbol(null,"output-stream","output-stream",-680962132,null),new cljs.core.Symbol(null,"*on-rcv","*on-rcv",1190170360,null),new cljs.core.Symbol(null,"*on-disconnect","*on-disconnect",-254490040,null),new cljs.core.Symbol(null,"*state","*state",2112112842,null),new cljs.core.Symbol(null,"*peer-fragment-size","*peer-fragment-size",-432224090,null),new cljs.core.Symbol(null,"*num-fragments-expected","*num-fragments-expected",-1335297359,null),new cljs.core.Symbol(null,"*num-fragments-rcvd","*num-fragments-rcvd",-1992026978,null),new cljs.core.Symbol(null,"*cur-msg-compressed?","*cur-msg-compressed?",879641247,null),new cljs.core.Symbol(null,"*conn-count","*conn-count",-995608012,null)], null);
}));

(deercreeklabs.tube.connection.Connection.cljs$lang$type = true);

(deercreeklabs.tube.connection.Connection.cljs$lang$ctorStr = "deercreeklabs.tube.connection/Connection");

(deercreeklabs.tube.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"deercreeklabs.tube.connection/Connection");
}));

/**
 * Positional factory function for deercreeklabs.tube.connection/Connection.
 */
deercreeklabs.tube.connection.__GT_Connection = (function deercreeklabs$tube$connection$__GT_Connection(conn_id,uri,remote_addr,on_connect,conn_req,sender,closer,fragment_size,compress,client_QMARK_,output_stream,_STAR_on_rcv,_STAR_on_disconnect,_STAR_state,_STAR_peer_fragment_size,_STAR_num_fragments_expected,_STAR_num_fragments_rcvd,_STAR_cur_msg_compressed_QMARK_,_STAR_conn_count){
return (new deercreeklabs.tube.connection.Connection(conn_id,uri,remote_addr,on_connect,conn_req,sender,closer,fragment_size,compress,client_QMARK_,output_stream,_STAR_on_rcv,_STAR_on_disconnect,_STAR_state,_STAR_peer_fragment_size,_STAR_num_fragments_expected,_STAR_num_fragments_rcvd,_STAR_cur_msg_compressed_QMARK_,_STAR_conn_count));
});

deercreeklabs.tube.connection.connection = (function deercreeklabs$tube$connection$connection(var_args){
var G__55837 = arguments.length;
switch (G__55837) {
case 11:
return deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$11 = (function (conn_id,uri,remote_addr,on_connect,conn_req,_STAR_conn_count,sender,closer,fragment_size,compression_type,client_QMARK_){
return deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$12(conn_id,uri,remote_addr,on_connect,conn_req,_STAR_conn_count,sender,closer,fragment_size,compression_type,client_QMARK_,null);
}));

(deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$12 = (function (conn_id,uri,remote_addr,on_connect,conn_req,_STAR_conn_count,sender,closer,fragment_size,compression_type,client_QMARK_,on_rcv){
var _STAR_on_rcv = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(on_rcv);
var compress = (function (p1__55835_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(0),p1__55835_SHARP_],null));
});
var output_stream = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
var _STAR_on_disconnect = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var _STAR_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"connected","connected",-169833045));
var _STAR_peer_fragment_size = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var _STAR_num_fragments_expected = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var _STAR_num_fragments_rcvd = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var _STAR_cur_msg_compressed_QMARK_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return deercreeklabs.tube.connection.__GT_Connection(conn_id,uri,remote_addr,on_connect,conn_req,sender,closer,fragment_size,compress,client_QMARK_,output_stream,_STAR_on_rcv,_STAR_on_disconnect,_STAR_state,_STAR_peer_fragment_size,_STAR_num_fragments_expected,_STAR_num_fragments_rcvd,_STAR_cur_msg_compressed_QMARK_,_STAR_conn_count);
}));

(deercreeklabs.tube.connection.connection.cljs$lang$maxFixedArity = 12);


//# sourceMappingURL=deercreeklabs.tube.connection.js.map
