goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49042 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49042(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49052 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49052(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__47469 = coll;
var G__47470 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__47469,G__47470) : shadow.dom.lazy_native_coll_seq.call(null,G__47469,G__47470));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4160__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__47514 = arguments.length;
switch (G__47514) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__47524 = arguments.length;
switch (G__47524) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__47532 = arguments.length;
switch (G__47532) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__47551 = arguments.length;
switch (G__47551) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__47575 = arguments.length;
switch (G__47575) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__47587 = arguments.length;
switch (G__47587) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e47611){if((e47611 instanceof Object)){
var e = e47611;
return console.log("didnt support attachEvent",el,e);
} else {
throw e47611;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__47623 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__47624 = null;
var count__47626 = (0);
var i__47627 = (0);
while(true){
if((i__47627 < count__47626)){
var el = chunk__47624.cljs$core$IIndexed$_nth$arity$2(null,i__47627);
var handler_49119__$1 = ((function (seq__47623,chunk__47624,count__47626,i__47627,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47623,chunk__47624,count__47626,i__47627,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49119__$1);


var G__49122 = seq__47623;
var G__49123 = chunk__47624;
var G__49124 = count__47626;
var G__49125 = (i__47627 + (1));
seq__47623 = G__49122;
chunk__47624 = G__49123;
count__47626 = G__49124;
i__47627 = G__49125;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__47623);
if(temp__5753__auto__){
var seq__47623__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47623__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__47623__$1);
var G__49127 = cljs.core.chunk_rest(seq__47623__$1);
var G__49128 = c__4591__auto__;
var G__49129 = cljs.core.count(c__4591__auto__);
var G__49130 = (0);
seq__47623 = G__49127;
chunk__47624 = G__49128;
count__47626 = G__49129;
i__47627 = G__49130;
continue;
} else {
var el = cljs.core.first(seq__47623__$1);
var handler_49132__$1 = ((function (seq__47623,chunk__47624,count__47626,i__47627,el,seq__47623__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47623,chunk__47624,count__47626,i__47627,el,seq__47623__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49132__$1);


var G__49134 = cljs.core.next(seq__47623__$1);
var G__49135 = null;
var G__49136 = (0);
var G__49137 = (0);
seq__47623 = G__49134;
chunk__47624 = G__49135;
count__47626 = G__49136;
i__47627 = G__49137;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__47651 = arguments.length;
switch (G__47651) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__47676 = cljs.core.seq(events);
var chunk__47677 = null;
var count__47678 = (0);
var i__47679 = (0);
while(true){
if((i__47679 < count__47678)){
var vec__47699 = chunk__47677.cljs$core$IIndexed$_nth$arity$2(null,i__47679);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47699,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47699,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49158 = seq__47676;
var G__49159 = chunk__47677;
var G__49160 = count__47678;
var G__49161 = (i__47679 + (1));
seq__47676 = G__49158;
chunk__47677 = G__49159;
count__47678 = G__49160;
i__47679 = G__49161;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__47676);
if(temp__5753__auto__){
var seq__47676__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47676__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__47676__$1);
var G__49163 = cljs.core.chunk_rest(seq__47676__$1);
var G__49164 = c__4591__auto__;
var G__49165 = cljs.core.count(c__4591__auto__);
var G__49166 = (0);
seq__47676 = G__49163;
chunk__47677 = G__49164;
count__47678 = G__49165;
i__47679 = G__49166;
continue;
} else {
var vec__47710 = cljs.core.first(seq__47676__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47710,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47710,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49168 = cljs.core.next(seq__47676__$1);
var G__49169 = null;
var G__49170 = (0);
var G__49171 = (0);
seq__47676 = G__49168;
chunk__47677 = G__49169;
count__47678 = G__49170;
i__47679 = G__49171;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__47722 = cljs.core.seq(styles);
var chunk__47723 = null;
var count__47724 = (0);
var i__47725 = (0);
while(true){
if((i__47725 < count__47724)){
var vec__47738 = chunk__47723.cljs$core$IIndexed$_nth$arity$2(null,i__47725);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47738,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47738,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49177 = seq__47722;
var G__49178 = chunk__47723;
var G__49179 = count__47724;
var G__49180 = (i__47725 + (1));
seq__47722 = G__49177;
chunk__47723 = G__49178;
count__47724 = G__49179;
i__47725 = G__49180;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__47722);
if(temp__5753__auto__){
var seq__47722__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47722__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__47722__$1);
var G__49186 = cljs.core.chunk_rest(seq__47722__$1);
var G__49187 = c__4591__auto__;
var G__49188 = cljs.core.count(c__4591__auto__);
var G__49189 = (0);
seq__47722 = G__49186;
chunk__47723 = G__49187;
count__47724 = G__49188;
i__47725 = G__49189;
continue;
} else {
var vec__47744 = cljs.core.first(seq__47722__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47744,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47744,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49190 = cljs.core.next(seq__47722__$1);
var G__49191 = null;
var G__49192 = (0);
var G__49193 = (0);
seq__47722 = G__49190;
chunk__47723 = G__49191;
count__47724 = G__49192;
i__47725 = G__49193;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__47760_49196 = key;
var G__47760_49197__$1 = (((G__47760_49196 instanceof cljs.core.Keyword))?G__47760_49196.fqn:null);
switch (G__47760_49197__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49206 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4160__auto__ = goog.string.startsWith(ks_49206,"data-");
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return goog.string.startsWith(ks_49206,"aria-");
}
})())){
el.setAttribute(ks_49206,value);
} else {
(el[ks_49206] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__47784){
var map__47785 = p__47784;
var map__47785__$1 = cljs.core.__destructure_map(map__47785);
var props = map__47785__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47785__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__47791 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47791,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47791,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47791,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__47795 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__47795,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__47795;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__47801 = arguments.length;
switch (G__47801) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__47840){
var vec__47843 = p__47840;
var seq__47844 = cljs.core.seq(vec__47843);
var first__47845 = cljs.core.first(seq__47844);
var seq__47844__$1 = cljs.core.next(seq__47844);
var nn = first__47845;
var first__47845__$1 = cljs.core.first(seq__47844__$1);
var seq__47844__$2 = cljs.core.next(seq__47844__$1);
var np = first__47845__$1;
var nc = seq__47844__$2;
var node = vec__47843;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47854 = nn;
var G__47855 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47854,G__47855) : create_fn.call(null,G__47854,G__47855));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47856 = nn;
var G__47857 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47856,G__47857) : create_fn.call(null,G__47856,G__47857));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__47871 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47871,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47871,(1),null);
var seq__47878_49249 = cljs.core.seq(node_children);
var chunk__47879_49250 = null;
var count__47880_49251 = (0);
var i__47881_49252 = (0);
while(true){
if((i__47881_49252 < count__47880_49251)){
var child_struct_49253 = chunk__47879_49250.cljs$core$IIndexed$_nth$arity$2(null,i__47881_49252);
var children_49254 = shadow.dom.dom_node(child_struct_49253);
if(cljs.core.seq_QMARK_(children_49254)){
var seq__47929_49255 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49254));
var chunk__47931_49256 = null;
var count__47932_49257 = (0);
var i__47933_49258 = (0);
while(true){
if((i__47933_49258 < count__47932_49257)){
var child_49259 = chunk__47931_49256.cljs$core$IIndexed$_nth$arity$2(null,i__47933_49258);
if(cljs.core.truth_(child_49259)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49259);


var G__49262 = seq__47929_49255;
var G__49263 = chunk__47931_49256;
var G__49264 = count__47932_49257;
var G__49265 = (i__47933_49258 + (1));
seq__47929_49255 = G__49262;
chunk__47931_49256 = G__49263;
count__47932_49257 = G__49264;
i__47933_49258 = G__49265;
continue;
} else {
var G__49266 = seq__47929_49255;
var G__49267 = chunk__47931_49256;
var G__49268 = count__47932_49257;
var G__49269 = (i__47933_49258 + (1));
seq__47929_49255 = G__49266;
chunk__47931_49256 = G__49267;
count__47932_49257 = G__49268;
i__47933_49258 = G__49269;
continue;
}
} else {
var temp__5753__auto___49270 = cljs.core.seq(seq__47929_49255);
if(temp__5753__auto___49270){
var seq__47929_49271__$1 = temp__5753__auto___49270;
if(cljs.core.chunked_seq_QMARK_(seq__47929_49271__$1)){
var c__4591__auto___49272 = cljs.core.chunk_first(seq__47929_49271__$1);
var G__49273 = cljs.core.chunk_rest(seq__47929_49271__$1);
var G__49274 = c__4591__auto___49272;
var G__49275 = cljs.core.count(c__4591__auto___49272);
var G__49276 = (0);
seq__47929_49255 = G__49273;
chunk__47931_49256 = G__49274;
count__47932_49257 = G__49275;
i__47933_49258 = G__49276;
continue;
} else {
var child_49278 = cljs.core.first(seq__47929_49271__$1);
if(cljs.core.truth_(child_49278)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49278);


var G__49279 = cljs.core.next(seq__47929_49271__$1);
var G__49280 = null;
var G__49281 = (0);
var G__49282 = (0);
seq__47929_49255 = G__49279;
chunk__47931_49256 = G__49280;
count__47932_49257 = G__49281;
i__47933_49258 = G__49282;
continue;
} else {
var G__49283 = cljs.core.next(seq__47929_49271__$1);
var G__49284 = null;
var G__49285 = (0);
var G__49286 = (0);
seq__47929_49255 = G__49283;
chunk__47931_49256 = G__49284;
count__47932_49257 = G__49285;
i__47933_49258 = G__49286;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49254);
}


var G__49289 = seq__47878_49249;
var G__49290 = chunk__47879_49250;
var G__49291 = count__47880_49251;
var G__49292 = (i__47881_49252 + (1));
seq__47878_49249 = G__49289;
chunk__47879_49250 = G__49290;
count__47880_49251 = G__49291;
i__47881_49252 = G__49292;
continue;
} else {
var temp__5753__auto___49293 = cljs.core.seq(seq__47878_49249);
if(temp__5753__auto___49293){
var seq__47878_49294__$1 = temp__5753__auto___49293;
if(cljs.core.chunked_seq_QMARK_(seq__47878_49294__$1)){
var c__4591__auto___49295 = cljs.core.chunk_first(seq__47878_49294__$1);
var G__49296 = cljs.core.chunk_rest(seq__47878_49294__$1);
var G__49297 = c__4591__auto___49295;
var G__49298 = cljs.core.count(c__4591__auto___49295);
var G__49299 = (0);
seq__47878_49249 = G__49296;
chunk__47879_49250 = G__49297;
count__47880_49251 = G__49298;
i__47881_49252 = G__49299;
continue;
} else {
var child_struct_49302 = cljs.core.first(seq__47878_49294__$1);
var children_49304 = shadow.dom.dom_node(child_struct_49302);
if(cljs.core.seq_QMARK_(children_49304)){
var seq__47982_49305 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49304));
var chunk__47984_49306 = null;
var count__47985_49307 = (0);
var i__47986_49308 = (0);
while(true){
if((i__47986_49308 < count__47985_49307)){
var child_49309 = chunk__47984_49306.cljs$core$IIndexed$_nth$arity$2(null,i__47986_49308);
if(cljs.core.truth_(child_49309)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49309);


var G__49311 = seq__47982_49305;
var G__49312 = chunk__47984_49306;
var G__49313 = count__47985_49307;
var G__49314 = (i__47986_49308 + (1));
seq__47982_49305 = G__49311;
chunk__47984_49306 = G__49312;
count__47985_49307 = G__49313;
i__47986_49308 = G__49314;
continue;
} else {
var G__49316 = seq__47982_49305;
var G__49317 = chunk__47984_49306;
var G__49318 = count__47985_49307;
var G__49319 = (i__47986_49308 + (1));
seq__47982_49305 = G__49316;
chunk__47984_49306 = G__49317;
count__47985_49307 = G__49318;
i__47986_49308 = G__49319;
continue;
}
} else {
var temp__5753__auto___49320__$1 = cljs.core.seq(seq__47982_49305);
if(temp__5753__auto___49320__$1){
var seq__47982_49321__$1 = temp__5753__auto___49320__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47982_49321__$1)){
var c__4591__auto___49322 = cljs.core.chunk_first(seq__47982_49321__$1);
var G__49323 = cljs.core.chunk_rest(seq__47982_49321__$1);
var G__49324 = c__4591__auto___49322;
var G__49325 = cljs.core.count(c__4591__auto___49322);
var G__49326 = (0);
seq__47982_49305 = G__49323;
chunk__47984_49306 = G__49324;
count__47985_49307 = G__49325;
i__47986_49308 = G__49326;
continue;
} else {
var child_49327 = cljs.core.first(seq__47982_49321__$1);
if(cljs.core.truth_(child_49327)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49327);


var G__49328 = cljs.core.next(seq__47982_49321__$1);
var G__49329 = null;
var G__49330 = (0);
var G__49331 = (0);
seq__47982_49305 = G__49328;
chunk__47984_49306 = G__49329;
count__47985_49307 = G__49330;
i__47986_49308 = G__49331;
continue;
} else {
var G__49332 = cljs.core.next(seq__47982_49321__$1);
var G__49333 = null;
var G__49334 = (0);
var G__49335 = (0);
seq__47982_49305 = G__49332;
chunk__47984_49306 = G__49333;
count__47985_49307 = G__49334;
i__47986_49308 = G__49335;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49304);
}


var G__49337 = cljs.core.next(seq__47878_49294__$1);
var G__49338 = null;
var G__49339 = (0);
var G__49340 = (0);
seq__47878_49249 = G__49337;
chunk__47879_49250 = G__49338;
count__47880_49251 = G__49339;
i__47881_49252 = G__49340;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__48043 = cljs.core.seq(node);
var chunk__48044 = null;
var count__48045 = (0);
var i__48046 = (0);
while(true){
if((i__48046 < count__48045)){
var n = chunk__48044.cljs$core$IIndexed$_nth$arity$2(null,i__48046);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49347 = seq__48043;
var G__49348 = chunk__48044;
var G__49349 = count__48045;
var G__49350 = (i__48046 + (1));
seq__48043 = G__49347;
chunk__48044 = G__49348;
count__48045 = G__49349;
i__48046 = G__49350;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48043);
if(temp__5753__auto__){
var seq__48043__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48043__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__48043__$1);
var G__49353 = cljs.core.chunk_rest(seq__48043__$1);
var G__49354 = c__4591__auto__;
var G__49355 = cljs.core.count(c__4591__auto__);
var G__49356 = (0);
seq__48043 = G__49353;
chunk__48044 = G__49354;
count__48045 = G__49355;
i__48046 = G__49356;
continue;
} else {
var n = cljs.core.first(seq__48043__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49358 = cljs.core.next(seq__48043__$1);
var G__49359 = null;
var G__49360 = (0);
var G__49361 = (0);
seq__48043 = G__49358;
chunk__48044 = G__49359;
count__48045 = G__49360;
i__48046 = G__49361;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__48091 = arguments.length;
switch (G__48091) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__48113 = arguments.length;
switch (G__48113) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__48150 = arguments.length;
switch (G__48150) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4160__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4777__auto__ = [];
var len__4771__auto___49384 = arguments.length;
var i__4772__auto___49385 = (0);
while(true){
if((i__4772__auto___49385 < len__4771__auto___49384)){
args__4777__auto__.push((arguments[i__4772__auto___49385]));

var G__49388 = (i__4772__auto___49385 + (1));
i__4772__auto___49385 = G__49388;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__48197_49389 = cljs.core.seq(nodes);
var chunk__48198_49390 = null;
var count__48199_49391 = (0);
var i__48200_49392 = (0);
while(true){
if((i__48200_49392 < count__48199_49391)){
var node_49393 = chunk__48198_49390.cljs$core$IIndexed$_nth$arity$2(null,i__48200_49392);
fragment.appendChild(shadow.dom._to_dom(node_49393));


var G__49394 = seq__48197_49389;
var G__49395 = chunk__48198_49390;
var G__49396 = count__48199_49391;
var G__49397 = (i__48200_49392 + (1));
seq__48197_49389 = G__49394;
chunk__48198_49390 = G__49395;
count__48199_49391 = G__49396;
i__48200_49392 = G__49397;
continue;
} else {
var temp__5753__auto___49398 = cljs.core.seq(seq__48197_49389);
if(temp__5753__auto___49398){
var seq__48197_49399__$1 = temp__5753__auto___49398;
if(cljs.core.chunked_seq_QMARK_(seq__48197_49399__$1)){
var c__4591__auto___49400 = cljs.core.chunk_first(seq__48197_49399__$1);
var G__49401 = cljs.core.chunk_rest(seq__48197_49399__$1);
var G__49402 = c__4591__auto___49400;
var G__49403 = cljs.core.count(c__4591__auto___49400);
var G__49404 = (0);
seq__48197_49389 = G__49401;
chunk__48198_49390 = G__49402;
count__48199_49391 = G__49403;
i__48200_49392 = G__49404;
continue;
} else {
var node_49405 = cljs.core.first(seq__48197_49399__$1);
fragment.appendChild(shadow.dom._to_dom(node_49405));


var G__49406 = cljs.core.next(seq__48197_49399__$1);
var G__49407 = null;
var G__49408 = (0);
var G__49409 = (0);
seq__48197_49389 = G__49406;
chunk__48198_49390 = G__49407;
count__48199_49391 = G__49408;
i__48200_49392 = G__49409;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq48180){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48180));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__48236_49413 = cljs.core.seq(scripts);
var chunk__48237_49414 = null;
var count__48238_49415 = (0);
var i__48239_49416 = (0);
while(true){
if((i__48239_49416 < count__48238_49415)){
var vec__48256_49417 = chunk__48237_49414.cljs$core$IIndexed$_nth$arity$2(null,i__48239_49416);
var script_tag_49418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48256_49417,(0),null);
var script_body_49419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48256_49417,(1),null);
eval(script_body_49419);


var G__49420 = seq__48236_49413;
var G__49421 = chunk__48237_49414;
var G__49422 = count__48238_49415;
var G__49423 = (i__48239_49416 + (1));
seq__48236_49413 = G__49420;
chunk__48237_49414 = G__49421;
count__48238_49415 = G__49422;
i__48239_49416 = G__49423;
continue;
} else {
var temp__5753__auto___49424 = cljs.core.seq(seq__48236_49413);
if(temp__5753__auto___49424){
var seq__48236_49425__$1 = temp__5753__auto___49424;
if(cljs.core.chunked_seq_QMARK_(seq__48236_49425__$1)){
var c__4591__auto___49426 = cljs.core.chunk_first(seq__48236_49425__$1);
var G__49427 = cljs.core.chunk_rest(seq__48236_49425__$1);
var G__49428 = c__4591__auto___49426;
var G__49429 = cljs.core.count(c__4591__auto___49426);
var G__49430 = (0);
seq__48236_49413 = G__49427;
chunk__48237_49414 = G__49428;
count__48238_49415 = G__49429;
i__48239_49416 = G__49430;
continue;
} else {
var vec__48276_49431 = cljs.core.first(seq__48236_49425__$1);
var script_tag_49432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48276_49431,(0),null);
var script_body_49433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48276_49431,(1),null);
eval(script_body_49433);


var G__49438 = cljs.core.next(seq__48236_49425__$1);
var G__49439 = null;
var G__49440 = (0);
var G__49441 = (0);
seq__48236_49413 = G__49438;
chunk__48237_49414 = G__49439;
count__48238_49415 = G__49440;
i__48239_49416 = G__49441;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__48283){
var vec__48284 = p__48283;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48284,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48284,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__48294 = arguments.length;
switch (G__48294) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__48321 = cljs.core.seq(style_keys);
var chunk__48322 = null;
var count__48323 = (0);
var i__48324 = (0);
while(true){
if((i__48324 < count__48323)){
var it = chunk__48322.cljs$core$IIndexed$_nth$arity$2(null,i__48324);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49450 = seq__48321;
var G__49451 = chunk__48322;
var G__49452 = count__48323;
var G__49453 = (i__48324 + (1));
seq__48321 = G__49450;
chunk__48322 = G__49451;
count__48323 = G__49452;
i__48324 = G__49453;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48321);
if(temp__5753__auto__){
var seq__48321__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48321__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__48321__$1);
var G__49454 = cljs.core.chunk_rest(seq__48321__$1);
var G__49455 = c__4591__auto__;
var G__49456 = cljs.core.count(c__4591__auto__);
var G__49457 = (0);
seq__48321 = G__49454;
chunk__48322 = G__49455;
count__48323 = G__49456;
i__48324 = G__49457;
continue;
} else {
var it = cljs.core.first(seq__48321__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49463 = cljs.core.next(seq__48321__$1);
var G__49464 = null;
var G__49465 = (0);
var G__49466 = (0);
seq__48321 = G__49463;
chunk__48322 = G__49464;
count__48323 = G__49465;
i__48324 = G__49466;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k48345,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__48368 = k48345;
var G__48368__$1 = (((G__48368 instanceof cljs.core.Keyword))?G__48368.fqn:null);
switch (G__48368__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k48345,else__4418__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__48370){
var vec__48372 = p__48370;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48372,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48372,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48344){
var self__ = this;
var G__48344__$1 = this;
return (new cljs.core.RecordIter((0),G__48344__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48346,other48347){
var self__ = this;
var this48346__$1 = this;
return (((!((other48347 == null)))) && ((this48346__$1.constructor === other48347.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48346__$1.x,other48347.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48346__$1.y,other48347.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48346__$1.__extmap,other48347.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__48344){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__48391 = cljs.core.keyword_identical_QMARK_;
var expr__48392 = k__4423__auto__;
if(cljs.core.truth_((pred__48391.cljs$core$IFn$_invoke$arity$2 ? pred__48391.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__48392) : pred__48391.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__48392)))){
return (new shadow.dom.Coordinate(G__48344,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__48391.cljs$core$IFn$_invoke$arity$2 ? pred__48391.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__48392) : pred__48391.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__48392)))){
return (new shadow.dom.Coordinate(self__.x,G__48344,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__48344),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__48344){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__48344,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__48355){
var extmap__4454__auto__ = (function (){var G__48405 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__48355,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__48355)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__48405);
} else {
return G__48405;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__48355),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__48355),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k48422,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__48442 = k48422;
var G__48442__$1 = (((G__48442 instanceof cljs.core.Keyword))?G__48442.fqn:null);
switch (G__48442__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k48422,else__4418__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__48448){
var vec__48449 = p__48448;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48449,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48449,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Size{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48421){
var self__ = this;
var G__48421__$1 = this;
return (new cljs.core.RecordIter((0),G__48421__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48423,other48424){
var self__ = this;
var this48423__$1 = this;
return (((!((other48424 == null)))) && ((this48423__$1.constructor === other48424.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48423__$1.w,other48424.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48423__$1.h,other48424.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48423__$1.__extmap,other48424.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__48421){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__48469 = cljs.core.keyword_identical_QMARK_;
var expr__48470 = k__4423__auto__;
if(cljs.core.truth_((pred__48469.cljs$core$IFn$_invoke$arity$2 ? pred__48469.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__48470) : pred__48469.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__48470)))){
return (new shadow.dom.Size(G__48421,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__48469.cljs$core$IFn$_invoke$arity$2 ? pred__48469.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__48470) : pred__48469.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__48470)))){
return (new shadow.dom.Size(self__.w,G__48421,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__48421),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__48421){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__48421,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__48429){
var extmap__4454__auto__ = (function (){var G__48499 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__48429,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__48429)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__48499);
} else {
return G__48499;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__48429),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__48429),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4645__auto__ = opts;
var l__4646__auto__ = a__4645__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4646__auto__)){
var G__49530 = (i + (1));
var G__49531 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__49530;
ret = G__49531;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__48528){
var vec__48529 = p__48528;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48529,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48529,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__48541 = arguments.length;
switch (G__48541) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__49554 = ps;
var G__49555 = (i + (1));
el__$1 = G__49554;
i = G__49555;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__48605 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48605,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48605,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48605,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__48608_49567 = cljs.core.seq(props);
var chunk__48609_49568 = null;
var count__48610_49569 = (0);
var i__48611_49570 = (0);
while(true){
if((i__48611_49570 < count__48610_49569)){
var vec__48621_49574 = chunk__48609_49568.cljs$core$IIndexed$_nth$arity$2(null,i__48611_49570);
var k_49575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48621_49574,(0),null);
var v_49576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48621_49574,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_49575);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_49575),v_49576);


var G__49584 = seq__48608_49567;
var G__49585 = chunk__48609_49568;
var G__49586 = count__48610_49569;
var G__49587 = (i__48611_49570 + (1));
seq__48608_49567 = G__49584;
chunk__48609_49568 = G__49585;
count__48610_49569 = G__49586;
i__48611_49570 = G__49587;
continue;
} else {
var temp__5753__auto___49588 = cljs.core.seq(seq__48608_49567);
if(temp__5753__auto___49588){
var seq__48608_49593__$1 = temp__5753__auto___49588;
if(cljs.core.chunked_seq_QMARK_(seq__48608_49593__$1)){
var c__4591__auto___49594 = cljs.core.chunk_first(seq__48608_49593__$1);
var G__49595 = cljs.core.chunk_rest(seq__48608_49593__$1);
var G__49596 = c__4591__auto___49594;
var G__49598 = cljs.core.count(c__4591__auto___49594);
var G__49599 = (0);
seq__48608_49567 = G__49595;
chunk__48609_49568 = G__49596;
count__48610_49569 = G__49598;
i__48611_49570 = G__49599;
continue;
} else {
var vec__48625_49602 = cljs.core.first(seq__48608_49593__$1);
var k_49603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48625_49602,(0),null);
var v_49604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48625_49602,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_49603);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_49603),v_49604);


var G__49617 = cljs.core.next(seq__48608_49593__$1);
var G__49618 = null;
var G__49619 = (0);
var G__49620 = (0);
seq__48608_49567 = G__49617;
chunk__48609_49568 = G__49618;
count__48610_49569 = G__49619;
i__48611_49570 = G__49620;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__48631 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48631,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48631,(1),null);
var seq__48634_49635 = cljs.core.seq(node_children);
var chunk__48636_49636 = null;
var count__48637_49637 = (0);
var i__48638_49638 = (0);
while(true){
if((i__48638_49638 < count__48637_49637)){
var child_struct_49644 = chunk__48636_49636.cljs$core$IIndexed$_nth$arity$2(null,i__48638_49638);
if((!((child_struct_49644 == null)))){
if(typeof child_struct_49644 === 'string'){
var text_49646 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_49646),child_struct_49644].join(''));
} else {
var children_49651 = shadow.dom.svg_node(child_struct_49644);
if(cljs.core.seq_QMARK_(children_49651)){
var seq__48788_49652 = cljs.core.seq(children_49651);
var chunk__48790_49653 = null;
var count__48791_49654 = (0);
var i__48792_49655 = (0);
while(true){
if((i__48792_49655 < count__48791_49654)){
var child_49656 = chunk__48790_49653.cljs$core$IIndexed$_nth$arity$2(null,i__48792_49655);
if(cljs.core.truth_(child_49656)){
node.appendChild(child_49656);


var G__49657 = seq__48788_49652;
var G__49658 = chunk__48790_49653;
var G__49659 = count__48791_49654;
var G__49660 = (i__48792_49655 + (1));
seq__48788_49652 = G__49657;
chunk__48790_49653 = G__49658;
count__48791_49654 = G__49659;
i__48792_49655 = G__49660;
continue;
} else {
var G__49662 = seq__48788_49652;
var G__49663 = chunk__48790_49653;
var G__49664 = count__48791_49654;
var G__49665 = (i__48792_49655 + (1));
seq__48788_49652 = G__49662;
chunk__48790_49653 = G__49663;
count__48791_49654 = G__49664;
i__48792_49655 = G__49665;
continue;
}
} else {
var temp__5753__auto___49666 = cljs.core.seq(seq__48788_49652);
if(temp__5753__auto___49666){
var seq__48788_49667__$1 = temp__5753__auto___49666;
if(cljs.core.chunked_seq_QMARK_(seq__48788_49667__$1)){
var c__4591__auto___49668 = cljs.core.chunk_first(seq__48788_49667__$1);
var G__49669 = cljs.core.chunk_rest(seq__48788_49667__$1);
var G__49670 = c__4591__auto___49668;
var G__49671 = cljs.core.count(c__4591__auto___49668);
var G__49672 = (0);
seq__48788_49652 = G__49669;
chunk__48790_49653 = G__49670;
count__48791_49654 = G__49671;
i__48792_49655 = G__49672;
continue;
} else {
var child_49673 = cljs.core.first(seq__48788_49667__$1);
if(cljs.core.truth_(child_49673)){
node.appendChild(child_49673);


var G__49674 = cljs.core.next(seq__48788_49667__$1);
var G__49675 = null;
var G__49676 = (0);
var G__49677 = (0);
seq__48788_49652 = G__49674;
chunk__48790_49653 = G__49675;
count__48791_49654 = G__49676;
i__48792_49655 = G__49677;
continue;
} else {
var G__49678 = cljs.core.next(seq__48788_49667__$1);
var G__49679 = null;
var G__49680 = (0);
var G__49681 = (0);
seq__48788_49652 = G__49678;
chunk__48790_49653 = G__49679;
count__48791_49654 = G__49680;
i__48792_49655 = G__49681;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_49651);
}
}


var G__49686 = seq__48634_49635;
var G__49687 = chunk__48636_49636;
var G__49688 = count__48637_49637;
var G__49689 = (i__48638_49638 + (1));
seq__48634_49635 = G__49686;
chunk__48636_49636 = G__49687;
count__48637_49637 = G__49688;
i__48638_49638 = G__49689;
continue;
} else {
var G__49691 = seq__48634_49635;
var G__49692 = chunk__48636_49636;
var G__49693 = count__48637_49637;
var G__49694 = (i__48638_49638 + (1));
seq__48634_49635 = G__49691;
chunk__48636_49636 = G__49692;
count__48637_49637 = G__49693;
i__48638_49638 = G__49694;
continue;
}
} else {
var temp__5753__auto___49697 = cljs.core.seq(seq__48634_49635);
if(temp__5753__auto___49697){
var seq__48634_49698__$1 = temp__5753__auto___49697;
if(cljs.core.chunked_seq_QMARK_(seq__48634_49698__$1)){
var c__4591__auto___49700 = cljs.core.chunk_first(seq__48634_49698__$1);
var G__49701 = cljs.core.chunk_rest(seq__48634_49698__$1);
var G__49702 = c__4591__auto___49700;
var G__49703 = cljs.core.count(c__4591__auto___49700);
var G__49704 = (0);
seq__48634_49635 = G__49701;
chunk__48636_49636 = G__49702;
count__48637_49637 = G__49703;
i__48638_49638 = G__49704;
continue;
} else {
var child_struct_49705 = cljs.core.first(seq__48634_49698__$1);
if((!((child_struct_49705 == null)))){
if(typeof child_struct_49705 === 'string'){
var text_49706 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_49706),child_struct_49705].join(''));
} else {
var children_49707 = shadow.dom.svg_node(child_struct_49705);
if(cljs.core.seq_QMARK_(children_49707)){
var seq__48816_49708 = cljs.core.seq(children_49707);
var chunk__48818_49709 = null;
var count__48819_49710 = (0);
var i__48820_49711 = (0);
while(true){
if((i__48820_49711 < count__48819_49710)){
var child_49713 = chunk__48818_49709.cljs$core$IIndexed$_nth$arity$2(null,i__48820_49711);
if(cljs.core.truth_(child_49713)){
node.appendChild(child_49713);


var G__49716 = seq__48816_49708;
var G__49717 = chunk__48818_49709;
var G__49718 = count__48819_49710;
var G__49719 = (i__48820_49711 + (1));
seq__48816_49708 = G__49716;
chunk__48818_49709 = G__49717;
count__48819_49710 = G__49718;
i__48820_49711 = G__49719;
continue;
} else {
var G__49720 = seq__48816_49708;
var G__49721 = chunk__48818_49709;
var G__49722 = count__48819_49710;
var G__49723 = (i__48820_49711 + (1));
seq__48816_49708 = G__49720;
chunk__48818_49709 = G__49721;
count__48819_49710 = G__49722;
i__48820_49711 = G__49723;
continue;
}
} else {
var temp__5753__auto___49724__$1 = cljs.core.seq(seq__48816_49708);
if(temp__5753__auto___49724__$1){
var seq__48816_49725__$1 = temp__5753__auto___49724__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48816_49725__$1)){
var c__4591__auto___49726 = cljs.core.chunk_first(seq__48816_49725__$1);
var G__49727 = cljs.core.chunk_rest(seq__48816_49725__$1);
var G__49728 = c__4591__auto___49726;
var G__49729 = cljs.core.count(c__4591__auto___49726);
var G__49730 = (0);
seq__48816_49708 = G__49727;
chunk__48818_49709 = G__49728;
count__48819_49710 = G__49729;
i__48820_49711 = G__49730;
continue;
} else {
var child_49731 = cljs.core.first(seq__48816_49725__$1);
if(cljs.core.truth_(child_49731)){
node.appendChild(child_49731);


var G__49732 = cljs.core.next(seq__48816_49725__$1);
var G__49733 = null;
var G__49734 = (0);
var G__49735 = (0);
seq__48816_49708 = G__49732;
chunk__48818_49709 = G__49733;
count__48819_49710 = G__49734;
i__48820_49711 = G__49735;
continue;
} else {
var G__49736 = cljs.core.next(seq__48816_49725__$1);
var G__49737 = null;
var G__49738 = (0);
var G__49739 = (0);
seq__48816_49708 = G__49736;
chunk__48818_49709 = G__49737;
count__48819_49710 = G__49738;
i__48820_49711 = G__49739;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_49707);
}
}


var G__49744 = cljs.core.next(seq__48634_49698__$1);
var G__49745 = null;
var G__49746 = (0);
var G__49747 = (0);
seq__48634_49635 = G__49744;
chunk__48636_49636 = G__49745;
count__48637_49637 = G__49746;
i__48638_49638 = G__49747;
continue;
} else {
var G__49748 = cljs.core.next(seq__48634_49698__$1);
var G__49749 = null;
var G__49750 = (0);
var G__49751 = (0);
seq__48634_49635 = G__49748;
chunk__48636_49636 = G__49749;
count__48637_49637 = G__49750;
i__48638_49638 = G__49751;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4777__auto__ = [];
var len__4771__auto___49761 = arguments.length;
var i__4772__auto___49763 = (0);
while(true){
if((i__4772__auto___49763 < len__4771__auto___49761)){
args__4777__auto__.push((arguments[i__4772__auto___49763]));

var G__49765 = (i__4772__auto___49763 + (1));
i__4772__auto___49763 = G__49765;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq48881){
var G__48882 = cljs.core.first(seq48881);
var seq48881__$1 = cljs.core.next(seq48881);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48882,seq48881__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__48921 = arguments.length;
switch (G__48921) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4149__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4149__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4149__auto__;
}
})())){
var c__43853__auto___49783 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43854__auto__ = (function (){var switch__43481__auto__ = (function (state_48969){
var state_val_48970 = (state_48969[(1)]);
if((state_val_48970 === (1))){
var state_48969__$1 = state_48969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48969__$1,(2),once_or_cleanup);
} else {
if((state_val_48970 === (2))){
var inst_48966 = (state_48969[(2)]);
var inst_48967 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_48969__$1 = (function (){var statearr_48992 = state_48969;
(statearr_48992[(7)] = inst_48966);

return statearr_48992;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48969__$1,inst_48967);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43482__auto__ = null;
var shadow$dom$state_machine__43482__auto____0 = (function (){
var statearr_49002 = [null,null,null,null,null,null,null,null];
(statearr_49002[(0)] = shadow$dom$state_machine__43482__auto__);

(statearr_49002[(1)] = (1));

return statearr_49002;
});
var shadow$dom$state_machine__43482__auto____1 = (function (state_48969){
while(true){
var ret_value__43483__auto__ = (function (){try{while(true){
var result__43484__auto__ = switch__43481__auto__(state_48969);
if(cljs.core.keyword_identical_QMARK_(result__43484__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43484__auto__;
}
break;
}
}catch (e49012){var ex__43485__auto__ = e49012;
var statearr_49014_49797 = state_48969;
(statearr_49014_49797[(2)] = ex__43485__auto__);


if(cljs.core.seq((state_48969[(4)]))){
var statearr_49015_49799 = state_48969;
(statearr_49015_49799[(1)] = cljs.core.first((state_48969[(4)])));

} else {
throw ex__43485__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49801 = state_48969;
state_48969 = G__49801;
continue;
} else {
return ret_value__43483__auto__;
}
break;
}
});
shadow$dom$state_machine__43482__auto__ = function(state_48969){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43482__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43482__auto____1.call(this,state_48969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43482__auto____0;
shadow$dom$state_machine__43482__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43482__auto____1;
return shadow$dom$state_machine__43482__auto__;
})()
})();
var state__43855__auto__ = (function (){var statearr_49022 = f__43854__auto__();
(statearr_49022[(6)] = c__43853__auto___49783);

return statearr_49022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43855__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
