goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__53206){
var vec__53207 = p__53206;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53207,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53207,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__53211 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__53211__$1 = (((G__53211 instanceof cljs.core.Keyword))?G__53211.fqn:null);
switch (G__53211__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__53213 = (function (){
var seq__53214 = cljs.core.seq(vars__$1);
var chunk__53215 = null;
var count__53216 = (0);
var i__53217 = (0);
while(true){
if((i__53217 < count__53216)){
var v = chunk__53215.cljs$core$IIndexed$_nth$arity$2(null,i__53217);
var temp__5753__auto___53295 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___53295)){
var t_53296 = temp__5753__auto___53295;
var G__53220_53297 = ((function (seq__53214,chunk__53215,count__53216,i__53217,t_53296,temp__5753__auto___53295,v,each_fixture_fn,G__53211,G__53211__$1,env,once_fixtures,each_fixtures,vec__53207,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_53296)));
});})(seq__53214,chunk__53215,count__53216,i__53217,t_53296,temp__5753__auto___53295,v,each_fixture_fn,G__53211,G__53211__$1,env,once_fixtures,each_fixtures,vec__53207,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__53220_53297) : each_fixture_fn.call(null,G__53220_53297));
} else {
}


var G__53301 = seq__53214;
var G__53302 = chunk__53215;
var G__53303 = count__53216;
var G__53304 = (i__53217 + (1));
seq__53214 = G__53301;
chunk__53215 = G__53302;
count__53216 = G__53303;
i__53217 = G__53304;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__53214);
if(temp__5753__auto__){
var seq__53214__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53214__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__53214__$1);
var G__53305 = cljs.core.chunk_rest(seq__53214__$1);
var G__53306 = c__4591__auto__;
var G__53307 = cljs.core.count(c__4591__auto__);
var G__53308 = (0);
seq__53214 = G__53305;
chunk__53215 = G__53306;
count__53216 = G__53307;
i__53217 = G__53308;
continue;
} else {
var v = cljs.core.first(seq__53214__$1);
var temp__5753__auto___53309__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___53309__$1)){
var t_53310 = temp__5753__auto___53309__$1;
var G__53221_53311 = ((function (seq__53214,chunk__53215,count__53216,i__53217,t_53310,temp__5753__auto___53309__$1,v,seq__53214__$1,temp__5753__auto__,each_fixture_fn,G__53211,G__53211__$1,env,once_fixtures,each_fixtures,vec__53207,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_53310)));
});})(seq__53214,chunk__53215,count__53216,i__53217,t_53310,temp__5753__auto___53309__$1,v,seq__53214__$1,temp__5753__auto__,each_fixture_fn,G__53211,G__53211__$1,env,once_fixtures,each_fixtures,vec__53207,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__53221_53311) : each_fixture_fn.call(null,G__53221_53311));
} else {
}


var G__53312 = cljs.core.next(seq__53214__$1);
var G__53313 = null;
var G__53314 = (0);
var G__53315 = (0);
seq__53214 = G__53312;
chunk__53215 = G__53313;
count__53216 = G__53314;
i__53217 = G__53315;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__53212 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__53212.cljs$core$IFn$_invoke$arity$1 ? fexpr__53212.cljs$core$IFn$_invoke$arity$1(G__53213) : fexpr__53212.call(null,G__53213));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__53211__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__53204_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53204_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__53225 = shadow.test.env.get_test_ns_info(ns);
var map__53225__$1 = cljs.core.__destructure_map(map__53225);
var test_ns = map__53225__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53225__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__53230,vars){
var map__53231 = p__53230;
var map__53231__$1 = cljs.core.__destructure_map(map__53231);
var env = map__53231__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53231__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__53237_53316 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__53239_53317 = null;
var count__53240_53318 = (0);
var i__53241_53319 = (0);
while(true){
if((i__53241_53319 < count__53240_53318)){
var vec__53256_53320 = chunk__53239_53317.cljs$core$IIndexed$_nth$arity$2(null,i__53241_53319);
var test_ns_53321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53256_53320,(0),null);
var ns_info_53322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53256_53320,(1),null);
var map__53259_53323 = ns_info_53322;
var map__53259_53324__$1 = cljs.core.__destructure_map(map__53259_53323);
var fixtures_53325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53259_53324__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___53326 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_53325);
if(cljs.core.truth_(temp__5753__auto___53326)){
var fix_53328 = temp__5753__auto___53326;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53321,fix_53328], 0));
} else {
}

var temp__5753__auto___53329 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_53325);
if(cljs.core.truth_(temp__5753__auto___53329)){
var fix_53330 = temp__5753__auto___53329;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53321,fix_53330], 0));
} else {
}


var G__53331 = seq__53237_53316;
var G__53332 = chunk__53239_53317;
var G__53333 = count__53240_53318;
var G__53334 = (i__53241_53319 + (1));
seq__53237_53316 = G__53331;
chunk__53239_53317 = G__53332;
count__53240_53318 = G__53333;
i__53241_53319 = G__53334;
continue;
} else {
var temp__5753__auto___53335 = cljs.core.seq(seq__53237_53316);
if(temp__5753__auto___53335){
var seq__53237_53336__$1 = temp__5753__auto___53335;
if(cljs.core.chunked_seq_QMARK_(seq__53237_53336__$1)){
var c__4591__auto___53337 = cljs.core.chunk_first(seq__53237_53336__$1);
var G__53338 = cljs.core.chunk_rest(seq__53237_53336__$1);
var G__53339 = c__4591__auto___53337;
var G__53340 = cljs.core.count(c__4591__auto___53337);
var G__53341 = (0);
seq__53237_53316 = G__53338;
chunk__53239_53317 = G__53339;
count__53240_53318 = G__53340;
i__53241_53319 = G__53341;
continue;
} else {
var vec__53260_53342 = cljs.core.first(seq__53237_53336__$1);
var test_ns_53343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53260_53342,(0),null);
var ns_info_53344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53260_53342,(1),null);
var map__53263_53347 = ns_info_53344;
var map__53263_53348__$1 = cljs.core.__destructure_map(map__53263_53347);
var fixtures_53349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53263_53348__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___53356__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_53349);
if(cljs.core.truth_(temp__5753__auto___53356__$1)){
var fix_53357 = temp__5753__auto___53356__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53343,fix_53357], 0));
} else {
}

var temp__5753__auto___53358__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_53349);
if(cljs.core.truth_(temp__5753__auto___53358__$1)){
var fix_53360 = temp__5753__auto___53358__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53343,fix_53360], 0));
} else {
}


var G__53361 = cljs.core.next(seq__53237_53336__$1);
var G__53362 = null;
var G__53363 = (0);
var G__53364 = (0);
seq__53237_53316 = G__53361;
chunk__53239_53317 = G__53362;
count__53240_53318 = G__53363;
i__53241_53319 = G__53364;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__53229_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53229_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__53264 = cljs.test.get_current_env();
var map__53264__$1 = cljs.core.__destructure_map(map__53264);
var env = map__53264__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53264__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53264__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__53271 = arguments.length;
switch (G__53271) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__53273 = arguments.length;
switch (G__53273) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__53275 = shadow.test.env.get_test_ns_info(ns);
var map__53275__$1 = cljs.core.__destructure_map(map__53275);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53275__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__53285 = arguments.length;
switch (G__53285) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__53276_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53276_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__53293 = arguments.length;
switch (G__53293) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__53287_SHARP_){
var or__4160__auto__ = (re == null);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__53287_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
