goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___54029 = schema.utils.use_fn_validation;
var output_schema53571_54030 = schema.core.Bool;
var input_schema53572_54031 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53573_54032 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53572_54031);
}),null));
var output_checker53574_54033 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53571_54030);
}),null));
var ret__52561__auto___54034 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__53575){
var validate__50752__auto__ = cljs.core.deref(ufv___54029);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54035 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53575], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53592_54036 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53593_54037 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__53594_54038 = input_schema53572_54031;
var G__53595_54039 = cljs.core.deref(input_checker53573_54032);
var G__53596_54040 = args__50753__auto___54035;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53592_54036,G__53593_54037,G__53594_54038,G__53595_54039,G__53596_54040) : schema.core.fn_validator.call(null,G__53592_54036,G__53593_54037,G__53594_54038,G__53595_54039,G__53596_54040));
} else {
var temp__5753__auto___54041 = (function (){var fexpr__53597 = cljs.core.deref(input_checker53573_54032);
return (fexpr__53597.cljs$core$IFn$_invoke$arity$1 ? fexpr__53597.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54035) : fexpr__53597.call(null,args__50753__auto___54035));
})();
if(cljs.core.truth_(temp__5753__auto___54041)){
var error__50754__auto___54042 = temp__5753__auto___54041;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54042], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53572_54031,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54035,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54042], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var arg = G__53575;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53604_54044 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53605_54045 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__53606_54046 = output_schema53571_54030;
var G__53607_54047 = cljs.core.deref(output_checker53574_54033);
var G__53608_54048 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53604_54044,G__53605_54045,G__53606_54046,G__53607_54047,G__53608_54048) : schema.core.fn_validator.call(null,G__53604_54044,G__53605_54045,G__53606_54046,G__53607_54047,G__53608_54048));
} else {
var temp__5753__auto___54049 = (function (){var fexpr__53610 = cljs.core.deref(output_checker53574_54033);
return (fexpr__53610.cljs$core$IFn$_invoke$arity$1 ? fexpr__53610.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53610.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54049)){
var error__50754__auto___54050 = temp__5753__auto___54049;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54050], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53571_54030,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54050], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema53571_54030,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53572_54031], null)));

var ufv___54051 = schema.utils.use_fn_validation;
var output_schema53618_54052 = deercreeklabs.baracus.ByteArray;
var input_schema53619_54053 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema53623_54054 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker53620_54055 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53619_54053);
}),null));
var output_checker53621_54056 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53618_54052);
}),null));
var input_checker53624_54057 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53623_54054);
}),null));
var output_checker53625_54058 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53618_54052);
}),null));
var ret__52561__auto___54060 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__53632 = arguments.length;
switch (G__53632) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__53622){
var validate__50752__auto__ = cljs.core.deref(ufv___54051);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54063 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53622], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53633_54064 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53634_54065 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53635_54066 = input_schema53619_54053;
var G__53636_54067 = cljs.core.deref(input_checker53620_54055);
var G__53637_54068 = args__50753__auto___54063;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53633_54064,G__53634_54065,G__53635_54066,G__53636_54067,G__53637_54068) : schema.core.fn_validator.call(null,G__53633_54064,G__53634_54065,G__53635_54066,G__53636_54067,G__53637_54068));
} else {
var temp__5753__auto___54069 = (function (){var fexpr__53638 = cljs.core.deref(input_checker53620_54055);
return (fexpr__53638.cljs$core$IFn$_invoke$arity$1 ? fexpr__53638.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54063) : fexpr__53638.call(null,args__50753__auto___54063));
})();
if(cljs.core.truth_(temp__5753__auto___54069)){
var error__50754__auto___54070 = temp__5753__auto___54069;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54070], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53619_54053,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54063,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54070], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var size_or_seq = G__53622;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53640_54071 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53641_54072 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53642_54073 = output_schema53618_54052;
var G__53643_54074 = cljs.core.deref(output_checker53621_54056);
var G__53644_54075 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53640_54071,G__53641_54072,G__53642_54073,G__53643_54074,G__53644_54075) : schema.core.fn_validator.call(null,G__53640_54071,G__53641_54072,G__53642_54073,G__53643_54074,G__53644_54075));
} else {
var temp__5753__auto___54076 = (function (){var fexpr__53645 = cljs.core.deref(output_checker53621_54056);
return (fexpr__53645.cljs$core$IFn$_invoke$arity$1 ? fexpr__53645.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53645.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54076)){
var error__50754__auto___54077 = temp__5753__auto___54076;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54077], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53618_54052,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54077], null));
} else {
}
}
} else {
}

return o__50755__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__53626,G__53627){
var validate__50752__auto__ = cljs.core.deref(ufv___54051);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54078 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53626,G__53627], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53646_54079 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53647_54080 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53648_54081 = input_schema53623_54054;
var G__53649_54082 = cljs.core.deref(input_checker53624_54057);
var G__53650_54083 = args__50753__auto___54078;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53646_54079,G__53647_54080,G__53648_54081,G__53649_54082,G__53650_54083) : schema.core.fn_validator.call(null,G__53646_54079,G__53647_54080,G__53648_54081,G__53649_54082,G__53650_54083));
} else {
var temp__5753__auto___54084 = (function (){var fexpr__53652 = cljs.core.deref(input_checker53624_54057);
return (fexpr__53652.cljs$core$IFn$_invoke$arity$1 ? fexpr__53652.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54078) : fexpr__53652.call(null,args__50753__auto___54078));
})();
if(cljs.core.truth_(temp__5753__auto___54084)){
var error__50754__auto___54085 = temp__5753__auto___54084;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54085], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53623_54054,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54078,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54085], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var size = G__53626;
var init_val_or_seq = G__53627;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53653_54087 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53654_54088 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__53655_54089 = output_schema53618_54052;
var G__53656_54090 = cljs.core.deref(output_checker53625_54058);
var G__53657_54091 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53653_54087,G__53654_54088,G__53655_54089,G__53656_54090,G__53657_54091) : schema.core.fn_validator.call(null,G__53653_54087,G__53654_54088,G__53655_54089,G__53656_54090,G__53657_54091));
} else {
var temp__5753__auto___54092 = (function (){var fexpr__53658 = cljs.core.deref(output_checker53625_54058);
return (fexpr__53658.cljs$core$IFn$_invoke$arity$1 ? fexpr__53658.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53658.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54092)){
var error__50754__auto___54093 = temp__5753__auto___54092;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54093], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53618_54052,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54093], null));
} else {
}
}
} else {
}

return o__50755__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema53618_54052,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53619_54053,input_schema53623_54054], null)));

var ufv___54096 = schema.utils.use_fn_validation;
var output_schema53660_54097 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53661_54098 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker53662_54099 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53661_54098);
}),null));
var output_checker53663_54100 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53660_54097);
}),null));
var ret__52561__auto___54101 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__53664){
var validate__50752__auto__ = cljs.core.deref(ufv___54096);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54103 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53664], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53666_54104 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53667_54105 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__53668_54106 = input_schema53661_54098;
var G__53669_54107 = cljs.core.deref(input_checker53662_54099);
var G__53670_54108 = args__50753__auto___54103;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53666_54104,G__53667_54105,G__53668_54106,G__53669_54107,G__53670_54108) : schema.core.fn_validator.call(null,G__53666_54104,G__53667_54105,G__53668_54106,G__53669_54107,G__53670_54108));
} else {
var temp__5753__auto___54109 = (function (){var fexpr__53671 = cljs.core.deref(input_checker53662_54099);
return (fexpr__53671.cljs$core$IFn$_invoke$arity$1 ? fexpr__53671.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54103) : fexpr__53671.call(null,args__50753__auto___54103));
})();
if(cljs.core.truth_(temp__5753__auto___54109)){
var error__50754__auto___54110 = temp__5753__auto___54109;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54110], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53661_54098,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54103,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54110], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var arrays = G__53664;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__53672 = cljs.core.count(arrays__$1);
switch (G__53672) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__53672,arrays__$1,validate__50752__auto__,ufv___54096,output_schema53660_54097,input_schema53661_54098,input_checker53662_54099,output_checker53663_54100){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__53672,arrays__$1,validate__50752__auto__,ufv___54096,output_schema53660_54097,input_schema53661_54098,input_checker53662_54099,output_checker53663_54100))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__53672,arrays__$1,validate__50752__auto__,ufv___54096,output_schema53660_54097,input_schema53661_54098,input_checker53662_54099,output_checker53663_54100){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__53672,arrays__$1,validate__50752__auto__,ufv___54096,output_schema53660_54097,input_schema53661_54098,input_checker53662_54099,output_checker53663_54100))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53674_54115 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53675_54116 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__53676_54117 = output_schema53660_54097;
var G__53677_54118 = cljs.core.deref(output_checker53663_54100);
var G__53678_54119 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53674_54115,G__53675_54116,G__53676_54117,G__53677_54118,G__53678_54119) : schema.core.fn_validator.call(null,G__53674_54115,G__53675_54116,G__53676_54117,G__53677_54118,G__53678_54119));
} else {
var temp__5753__auto___54122 = (function (){var fexpr__53680 = cljs.core.deref(output_checker53663_54100);
return (fexpr__53680.cljs$core$IFn$_invoke$arity$1 ? fexpr__53680.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53680.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54122)){
var error__50754__auto___54123 = temp__5753__auto___54122;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54123], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53660_54097,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54123], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema53660_54097,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53661_54098], null)));

var ufv___54127 = schema.utils.use_fn_validation;
var output_schema53681_54128 = schema.core.Bool;
var input_schema53682_54129 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker53683_54130 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53682_54129);
}),null));
var output_checker53684_54131 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53681_54128);
}),null));
var ret__52561__auto___54133 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__53685,G__53686){
var validate__50752__auto__ = cljs.core.deref(ufv___54127);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54134 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53685,G__53686], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53691_54135 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53692_54136 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__53693_54137 = input_schema53682_54129;
var G__53694_54138 = cljs.core.deref(input_checker53683_54130);
var G__53695_54139 = args__50753__auto___54134;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53691_54135,G__53692_54136,G__53693_54137,G__53694_54138,G__53695_54139) : schema.core.fn_validator.call(null,G__53691_54135,G__53692_54136,G__53693_54137,G__53694_54138,G__53695_54139));
} else {
var temp__5753__auto___54141 = (function (){var fexpr__53696 = cljs.core.deref(input_checker53683_54130);
return (fexpr__53696.cljs$core$IFn$_invoke$arity$1 ? fexpr__53696.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54134) : fexpr__53696.call(null,args__50753__auto___54134));
})();
if(cljs.core.truth_(temp__5753__auto___54141)){
var error__50754__auto___54142 = temp__5753__auto___54141;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54142], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53682_54129,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54134,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54142], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var a = G__53685;
var b = G__53686;
while(true){
var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__4210__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__54143 = ((i + (1)) | (0));
i = G__54143;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__4210__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53698_54144 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53699_54145 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__53700_54146 = output_schema53681_54128;
var G__53701_54147 = cljs.core.deref(output_checker53684_54131);
var G__53702_54148 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53698_54144,G__53699_54145,G__53700_54146,G__53701_54147,G__53702_54148) : schema.core.fn_validator.call(null,G__53698_54144,G__53699_54145,G__53700_54146,G__53701_54147,G__53702_54148));
} else {
var temp__5753__auto___54149 = (function (){var fexpr__53703 = cljs.core.deref(output_checker53684_54131);
return (fexpr__53703.cljs$core$IFn$_invoke$arity$1 ? fexpr__53703.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53703.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54149)){
var error__50754__auto___54150 = temp__5753__auto___54149;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54150], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53681_54128,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54150], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema53681_54128,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53682_54129], null)));

var ufv___54153 = schema.utils.use_fn_validation;
var output_schema53705_54154 = schema.core.Str;
var input_schema53706_54155 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker53707_54156 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53706_54155);
}),null));
var output_checker53708_54157 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53705_54154);
}),null));
var ret__52561__auto___54160 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__53709){
var validate__50752__auto__ = cljs.core.deref(ufv___54153);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54162 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53709], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53710_54163 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53711_54164 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__53712_54165 = input_schema53706_54155;
var G__53713_54166 = cljs.core.deref(input_checker53707_54156);
var G__53714_54167 = args__50753__auto___54162;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53710_54163,G__53711_54164,G__53712_54165,G__53713_54166,G__53714_54167) : schema.core.fn_validator.call(null,G__53710_54163,G__53711_54164,G__53712_54165,G__53713_54166,G__53714_54167));
} else {
var temp__5753__auto___54168 = (function (){var fexpr__53715 = cljs.core.deref(input_checker53707_54156);
return (fexpr__53715.cljs$core$IFn$_invoke$arity$1 ? fexpr__53715.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54162) : fexpr__53715.call(null,args__50753__auto___54162));
})();
if(cljs.core.truth_(temp__5753__auto___54168)){
var error__50754__auto___54170 = temp__5753__auto___54168;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54170], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53706_54155,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54162,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54170], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53709;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53717_54172 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53718_54173 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__53719_54174 = output_schema53705_54154;
var G__53720_54175 = cljs.core.deref(output_checker53708_54157);
var G__53721_54176 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53717_54172,G__53718_54173,G__53719_54174,G__53720_54175,G__53721_54176) : schema.core.fn_validator.call(null,G__53717_54172,G__53718_54173,G__53719_54174,G__53720_54175,G__53721_54176));
} else {
var temp__5753__auto___54177 = (function (){var fexpr__53722 = cljs.core.deref(output_checker53708_54157);
return (fexpr__53722.cljs$core$IFn$_invoke$arity$1 ? fexpr__53722.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53722.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54177)){
var error__50754__auto___54178 = temp__5753__auto___54177;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54178], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53705_54154,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54178], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema53705_54154,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53706_54155], null)));

var ufv___54179 = schema.utils.use_fn_validation;
var output_schema53724_54180 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53725_54181 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema53729_54182 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema53734_54183 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker53726_54184 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53725_54181);
}),null));
var output_checker53727_54185 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53724_54180);
}),null));
var input_checker53730_54186 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53729_54182);
}),null));
var output_checker53731_54187 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53724_54180);
}),null));
var input_checker53735_54188 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53734_54183);
}),null));
var output_checker53736_54189 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53724_54180);
}),null));
var ret__52561__auto___54191 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__53742 = arguments.length;
switch (G__53742) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__53728){
var validate__50752__auto__ = cljs.core.deref(ufv___54179);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54197 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53728], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53743_54198 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53744_54199 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__53745_54200 = input_schema53725_54181;
var G__53746_54201 = cljs.core.deref(input_checker53726_54184);
var G__53747_54202 = args__50753__auto___54197;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53743_54198,G__53744_54199,G__53745_54200,G__53746_54201,G__53747_54202) : schema.core.fn_validator.call(null,G__53743_54198,G__53744_54199,G__53745_54200,G__53746_54201,G__53747_54202));
} else {
var temp__5753__auto___54203 = (function (){var fexpr__53748 = cljs.core.deref(input_checker53726_54184);
return (fexpr__53748.cljs$core$IFn$_invoke$arity$1 ? fexpr__53748.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54197) : fexpr__53748.call(null,args__50753__auto___54197));
})();
if(cljs.core.truth_(temp__5753__auto___54203)){
var error__50754__auto___54204 = temp__5753__auto___54203;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54204], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53725_54181,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54197,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54204], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53728;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53749_54216 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53750_54217 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__53751_54218 = output_schema53724_54180;
var G__53752_54219 = cljs.core.deref(output_checker53727_54185);
var G__53753_54220 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53749_54216,G__53750_54217,G__53751_54218,G__53752_54219,G__53753_54220) : schema.core.fn_validator.call(null,G__53749_54216,G__53750_54217,G__53751_54218,G__53752_54219,G__53753_54220));
} else {
var temp__5753__auto___54221 = (function (){var fexpr__53754 = cljs.core.deref(output_checker53727_54185);
return (fexpr__53754.cljs$core$IFn$_invoke$arity$1 ? fexpr__53754.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53754.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54221)){
var error__50754__auto___54223 = temp__5753__auto___54221;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54223], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53724_54180,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54223], null));
} else {
}
}
} else {
}

return o__50755__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__53732,G__53733){
var validate__50752__auto__ = cljs.core.deref(ufv___54179);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54226 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53732,G__53733], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53756_54227 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53757_54228 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__53758_54229 = input_schema53729_54182;
var G__53759_54230 = cljs.core.deref(input_checker53730_54186);
var G__53760_54231 = args__50753__auto___54226;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53756_54227,G__53757_54228,G__53758_54229,G__53759_54230,G__53760_54231) : schema.core.fn_validator.call(null,G__53756_54227,G__53757_54228,G__53758_54229,G__53759_54230,G__53760_54231));
} else {
var temp__5753__auto___54233 = (function (){var fexpr__53761 = cljs.core.deref(input_checker53730_54186);
return (fexpr__53761.cljs$core$IFn$_invoke$arity$1 ? fexpr__53761.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54226) : fexpr__53761.call(null,args__50753__auto___54226));
})();
if(cljs.core.truth_(temp__5753__auto___54233)){
var error__50754__auto___54241 = temp__5753__auto___54233;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54241], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53729_54182,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54226,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54241], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53732;
var start = G__53733;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53762_54244 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53763_54245 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__53764_54246 = output_schema53724_54180;
var G__53765_54247 = cljs.core.deref(output_checker53731_54187);
var G__53766_54248 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53762_54244,G__53763_54245,G__53764_54246,G__53765_54247,G__53766_54248) : schema.core.fn_validator.call(null,G__53762_54244,G__53763_54245,G__53764_54246,G__53765_54247,G__53766_54248));
} else {
var temp__5753__auto___54250 = (function (){var fexpr__53768 = cljs.core.deref(output_checker53731_54187);
return (fexpr__53768.cljs$core$IFn$_invoke$arity$1 ? fexpr__53768.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53768.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54250)){
var error__50754__auto___54251 = temp__5753__auto___54250;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54251], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53724_54180,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54251], null));
} else {
}
}
} else {
}

return o__50755__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__53737,G__53738,G__53739){
var validate__50752__auto__ = cljs.core.deref(ufv___54179);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54262 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53737,G__53738,G__53739], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53769_54264 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53770_54265 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__53771_54266 = input_schema53734_54183;
var G__53772_54267 = cljs.core.deref(input_checker53735_54188);
var G__53773_54268 = args__50753__auto___54262;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53769_54264,G__53770_54265,G__53771_54266,G__53772_54267,G__53773_54268) : schema.core.fn_validator.call(null,G__53769_54264,G__53770_54265,G__53771_54266,G__53772_54267,G__53773_54268));
} else {
var temp__5753__auto___54271 = (function (){var fexpr__53774 = cljs.core.deref(input_checker53735_54188);
return (fexpr__53774.cljs$core$IFn$_invoke$arity$1 ? fexpr__53774.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54262) : fexpr__53774.call(null,args__50753__auto___54262));
})();
if(cljs.core.truth_(temp__5753__auto___54271)){
var error__50754__auto___54274 = temp__5753__auto___54271;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54274], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53734_54183,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54262,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54274], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53737;
var start = G__53738;
var end = G__53739;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4298__auto__ = end;
var y__4299__auto__ = cljs.core.count(ba);
return ((x__4298__auto__ < y__4299__auto__) ? x__4298__auto__ : y__4299__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53776_54280 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53777_54281 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__53778_54282 = output_schema53724_54180;
var G__53779_54283 = cljs.core.deref(output_checker53736_54189);
var G__53780_54284 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53776_54280,G__53777_54281,G__53778_54282,G__53779_54283,G__53780_54284) : schema.core.fn_validator.call(null,G__53776_54280,G__53777_54281,G__53778_54282,G__53779_54283,G__53780_54284));
} else {
var temp__5753__auto___54285 = (function (){var fexpr__53781 = cljs.core.deref(output_checker53736_54189);
return (fexpr__53781.cljs$core$IFn$_invoke$arity$1 ? fexpr__53781.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53781.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54285)){
var error__50754__auto___54286 = temp__5753__auto___54285;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54286], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53724_54180,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54286], null));
} else {
}
}
} else {
}

return o__50755__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema53724_54180,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53725_54181,input_schema53729_54182,input_schema53734_54183], null)));

var ufv___54289 = schema.utils.use_fn_validation;
var output_schema53782_54290 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53783_54291 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker53784_54292 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53783_54291);
}),null));
var output_checker53785_54293 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53782_54290);
}),null));
var ret__52561__auto___54295 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__53786){
var validate__50752__auto__ = cljs.core.deref(ufv___54289);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54298 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53786], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53788_54300 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53789_54301 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__53790_54302 = input_schema53783_54291;
var G__53791_54303 = cljs.core.deref(input_checker53784_54292);
var G__53792_54304 = args__50753__auto___54298;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53788_54300,G__53789_54301,G__53790_54302,G__53791_54303,G__53792_54304) : schema.core.fn_validator.call(null,G__53788_54300,G__53789_54301,G__53790_54302,G__53791_54303,G__53792_54304));
} else {
var temp__5753__auto___54306 = (function (){var fexpr__53793 = cljs.core.deref(input_checker53784_54292);
return (fexpr__53793.cljs$core$IFn$_invoke$arity$1 ? fexpr__53793.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54298) : fexpr__53793.call(null,args__50753__auto___54298));
})();
if(cljs.core.truth_(temp__5753__auto___54306)){
var error__50754__auto___54317 = temp__5753__auto___54306;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54317], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53783_54291,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54298,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54317], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53786;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4695__auto___54325 = num;
var i_54326 = (0);
while(true){
if((i_54326 < n__4695__auto___54325)){
(new$[i_54326] = (ba[(last - i_54326)]));

var G__54327 = (i_54326 + (1));
i_54326 = G__54327;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53795_54328 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53796_54329 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__53797_54330 = output_schema53782_54290;
var G__53798_54331 = cljs.core.deref(output_checker53785_54293);
var G__53799_54332 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53795_54328,G__53796_54329,G__53797_54330,G__53798_54331,G__53799_54332) : schema.core.fn_validator.call(null,G__53795_54328,G__53796_54329,G__53797_54330,G__53798_54331,G__53799_54332));
} else {
var temp__5753__auto___54333 = (function (){var fexpr__53800 = cljs.core.deref(output_checker53785_54293);
return (fexpr__53800.cljs$core$IFn$_invoke$arity$1 ? fexpr__53800.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53800.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54333)){
var error__50754__auto___54334 = temp__5753__auto___54333;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54334], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53782_54290,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54334], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema53782_54290,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53783_54291], null)));

var ufv___54336 = schema.utils.use_fn_validation;
var output_schema53801_54337 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema53802_54338 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53803_54339 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53802_54338);
}),null));
var output_checker53804_54340 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53801_54337);
}),null));
var ret__52561__auto___54341 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__53805,G__53806){
var validate__50752__auto__ = cljs.core.deref(ufv___54336);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54342 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53805,G__53806], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53808_54343 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53809_54344 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__53810_54345 = input_schema53802_54338;
var G__53811_54346 = cljs.core.deref(input_checker53803_54339);
var G__53812_54347 = args__50753__auto___54342;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53808_54343,G__53809_54344,G__53810_54345,G__53811_54346,G__53812_54347) : schema.core.fn_validator.call(null,G__53808_54343,G__53809_54344,G__53810_54345,G__53811_54346,G__53812_54347));
} else {
var temp__5753__auto___54349 = (function (){var fexpr__53813 = cljs.core.deref(input_checker53803_54339);
return (fexpr__53813.cljs$core$IFn$_invoke$arity$1 ? fexpr__53813.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54342) : fexpr__53813.call(null,args__50753__auto___54342));
})();
if(cljs.core.truth_(temp__5753__auto___54349)){
var error__50754__auto___54350 = temp__5753__auto___54349;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54350], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53802_54338,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54342,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54350], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53805;
var fragment_size = G__53806;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__54356 = (end_offset | (0));
var G__54357 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__54356;
output = G__54357;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53818_54359 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53819_54360 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__53820_54361 = output_schema53801_54337;
var G__53821_54362 = cljs.core.deref(output_checker53804_54340);
var G__53822_54363 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53818_54359,G__53819_54360,G__53820_54361,G__53821_54362,G__53822_54363) : schema.core.fn_validator.call(null,G__53818_54359,G__53819_54360,G__53820_54361,G__53821_54362,G__53822_54363));
} else {
var temp__5753__auto___54366 = (function (){var fexpr__53823 = cljs.core.deref(output_checker53804_54340);
return (fexpr__53823.cljs$core$IFn$_invoke$arity$1 ? fexpr__53823.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53823.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54366)){
var error__50754__auto___54369 = temp__5753__auto___54366;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54369], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53801_54337,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54369], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema53801_54337,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53802_54338], null)));

var ufv___54371 = schema.utils.use_fn_validation;
var output_schema53825_54372 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema53826_54373 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker53827_54374 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53826_54373);
}),null));
var output_checker53828_54375 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53825_54372);
}),null));
var ret__52561__auto___54377 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__53829){
var validate__50752__auto__ = cljs.core.deref(ufv___54371);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54380 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53829], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53830_54381 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53831_54382 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__53832_54383 = input_schema53826_54373;
var G__53833_54384 = cljs.core.deref(input_checker53827_54374);
var G__53834_54385 = args__50753__auto___54380;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53830_54381,G__53831_54382,G__53832_54383,G__53833_54384,G__53834_54385) : schema.core.fn_validator.call(null,G__53830_54381,G__53831_54382,G__53832_54383,G__53833_54384,G__53834_54385));
} else {
var temp__5753__auto___54386 = (function (){var fexpr__53836 = cljs.core.deref(input_checker53827_54374);
return (fexpr__53836.cljs$core$IFn$_invoke$arity$1 ? fexpr__53836.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54380) : fexpr__53836.call(null,args__50753__auto___54380));
})();
if(cljs.core.truth_(temp__5753__auto___54386)){
var error__50754__auto___54388 = temp__5753__auto___54386;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54388], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53826_54373,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54380,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54388], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53829;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__54398 = (n + (1));
var G__54399 = (i__$1 | (0));
var G__54400 = (out__$1 | (0));
n = G__54398;
i = G__54399;
out = G__54400;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53838_54402 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53839_54403 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__53840_54404 = output_schema53825_54372;
var G__53841_54405 = cljs.core.deref(output_checker53828_54375);
var G__53842_54406 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53838_54402,G__53839_54403,G__53840_54404,G__53841_54405,G__53842_54406) : schema.core.fn_validator.call(null,G__53838_54402,G__53839_54403,G__53840_54404,G__53841_54405,G__53842_54406));
} else {
var temp__5753__auto___54407 = (function (){var fexpr__53843 = cljs.core.deref(output_checker53828_54375);
return (fexpr__53843.cljs$core$IFn$_invoke$arity$1 ? fexpr__53843.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53843.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54407)){
var error__50754__auto___54408 = temp__5753__auto___54407;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54408], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53825_54372,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54408], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema53825_54372,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53826_54373], null)));

var ufv___54409 = schema.utils.use_fn_validation;
var output_schema53844_54410 = deercreeklabs.baracus.ByteArray;
var input_schema53845_54411 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53846_54412 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53845_54411);
}),null));
var output_checker53847_54413 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53844_54410);
}),null));
var ret__52561__auto___54414 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__53848){
var validate__50752__auto__ = cljs.core.deref(ufv___54409);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54415 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53848], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53852_54416 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53853_54417 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__53854_54418 = input_schema53845_54411;
var G__53855_54419 = cljs.core.deref(input_checker53846_54412);
var G__53856_54420 = args__50753__auto___54415;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53852_54416,G__53853_54417,G__53854_54418,G__53855_54419,G__53856_54420) : schema.core.fn_validator.call(null,G__53852_54416,G__53853_54417,G__53854_54418,G__53855_54419,G__53856_54420));
} else {
var temp__5753__auto___54427 = (function (){var fexpr__53857 = cljs.core.deref(input_checker53846_54412);
return (fexpr__53857.cljs$core$IFn$_invoke$arity$1 ? fexpr__53857.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54415) : fexpr__53857.call(null,args__50753__auto___54415));
})();
if(cljs.core.truth_(temp__5753__auto___54427)){
var error__50754__auto___54430 = temp__5753__auto___54427;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54430], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53845_54411,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54415,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54430], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var i = G__53848;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__54435 = (n >>> (7));
var G__54436 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__54435;
out = G__54436;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53860_54438 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53861_54439 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__53862_54440 = output_schema53844_54410;
var G__53863_54441 = cljs.core.deref(output_checker53847_54413);
var G__53864_54442 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53860_54438,G__53861_54439,G__53862_54440,G__53863_54441,G__53864_54442) : schema.core.fn_validator.call(null,G__53860_54438,G__53861_54439,G__53862_54440,G__53863_54441,G__53864_54442));
} else {
var temp__5753__auto___54443 = (function (){var fexpr__53865 = cljs.core.deref(output_checker53847_54413);
return (fexpr__53865.cljs$core$IFn$_invoke$arity$1 ? fexpr__53865.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53865.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54443)){
var error__50754__auto___54444 = temp__5753__auto___54443;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54444], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53844_54410,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54444], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema53844_54410,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53845_54411], null)));

var ufv___54446 = schema.utils.use_fn_validation;
var output_schema53867_54447 = schema.core.maybe(schema.core.Str);
var input_schema53868_54448 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker53869_54449 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53868_54448);
}),null));
var output_checker53870_54450 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53867_54447);
}),null));
var ret__52561__auto___54453 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__53871){
var validate__50752__auto__ = cljs.core.deref(ufv___54446);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54454 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53871], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53873_54455 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53874_54456 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__53875_54457 = input_schema53868_54448;
var G__53876_54458 = cljs.core.deref(input_checker53869_54449);
var G__53877_54459 = args__50753__auto___54454;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53873_54455,G__53874_54456,G__53875_54457,G__53876_54458,G__53877_54459) : schema.core.fn_validator.call(null,G__53873_54455,G__53874_54456,G__53875_54457,G__53876_54458,G__53877_54459));
} else {
var temp__5753__auto___54469 = (function (){var fexpr__53878 = cljs.core.deref(input_checker53869_54449);
return (fexpr__53878.cljs$core$IFn$_invoke$arity$1 ? fexpr__53878.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54454) : fexpr__53878.call(null,args__50753__auto___54454));
})();
if(cljs.core.truth_(temp__5753__auto___54469)){
var error__50754__auto___54470 = temp__5753__auto___54469;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54470], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53868_54448,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54454,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54470], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var b = G__53871;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53880_54473 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53881_54474 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__53882_54475 = output_schema53867_54447;
var G__53883_54476 = cljs.core.deref(output_checker53870_54450);
var G__53884_54477 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53880_54473,G__53881_54474,G__53882_54475,G__53883_54476,G__53884_54477) : schema.core.fn_validator.call(null,G__53880_54473,G__53881_54474,G__53882_54475,G__53883_54476,G__53884_54477));
} else {
var temp__5753__auto___54478 = (function (){var fexpr__53885 = cljs.core.deref(output_checker53870_54450);
return (fexpr__53885.cljs$core$IFn$_invoke$arity$1 ? fexpr__53885.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53885.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54478)){
var error__50754__auto___54479 = temp__5753__auto___54478;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54479], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53867_54447,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54479], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema53867_54447,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53868_54448], null)));

var ufv___54480 = schema.utils.use_fn_validation;
var output_schema53886_54481 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53887_54482 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker53888_54483 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53887_54482);
}),null));
var output_checker53889_54484 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53886_54481);
}),null));
var ret__52561__auto___54485 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__53890){
var validate__50752__auto__ = cljs.core.deref(ufv___54480);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54491 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53890], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53895_54492 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53896_54493 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53897_54494 = input_schema53887_54482;
var G__53898_54495 = cljs.core.deref(input_checker53888_54483);
var G__53899_54496 = args__50753__auto___54491;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53895_54492,G__53896_54493,G__53897_54494,G__53898_54495,G__53899_54496) : schema.core.fn_validator.call(null,G__53895_54492,G__53896_54493,G__53897_54494,G__53898_54495,G__53899_54496));
} else {
var temp__5753__auto___54500 = (function (){var fexpr__53900 = cljs.core.deref(input_checker53888_54483);
return (fexpr__53900.cljs$core$IFn$_invoke$arity$1 ? fexpr__53900.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54491) : fexpr__53900.call(null,args__50753__auto___54491));
})();
if(cljs.core.truth_(temp__5753__auto___54500)){
var error__50754__auto___54503 = temp__5753__auto___54500;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54503], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53887_54482,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54491,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54503], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var s = G__53890;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53902_54505 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53903_54506 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53904_54507 = output_schema53886_54481;
var G__53905_54508 = cljs.core.deref(output_checker53889_54484);
var G__53906_54509 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53902_54505,G__53903_54506,G__53904_54507,G__53905_54508,G__53906_54509) : schema.core.fn_validator.call(null,G__53902_54505,G__53903_54506,G__53904_54507,G__53905_54508,G__53906_54509));
} else {
var temp__5753__auto___54510 = (function (){var fexpr__53907 = cljs.core.deref(output_checker53889_54484);
return (fexpr__53907.cljs$core$IFn$_invoke$arity$1 ? fexpr__53907.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53907.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54510)){
var error__50754__auto___54512 = temp__5753__auto___54510;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54512], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53886_54481,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54512], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema53886_54481,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53887_54482], null)));

var ufv___54515 = schema.utils.use_fn_validation;
var output_schema53908_54516 = schema.core.maybe(schema.core.Str);
var input_schema53909_54517 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker53910_54518 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53909_54517);
}),null));
var output_checker53911_54519 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53908_54516);
}),null));
var ret__52561__auto___54522 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__53912){
var validate__50752__auto__ = cljs.core.deref(ufv___54515);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54523 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53912], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53914_54524 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53915_54525 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__53916_54526 = input_schema53909_54517;
var G__53917_54527 = cljs.core.deref(input_checker53910_54518);
var G__53918_54528 = args__50753__auto___54523;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53914_54524,G__53915_54525,G__53916_54526,G__53917_54527,G__53918_54528) : schema.core.fn_validator.call(null,G__53914_54524,G__53915_54525,G__53916_54526,G__53917_54527,G__53918_54528));
} else {
var temp__5753__auto___54530 = (function (){var fexpr__53919 = cljs.core.deref(input_checker53910_54518);
return (fexpr__53919.cljs$core$IFn$_invoke$arity$1 ? fexpr__53919.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54523) : fexpr__53919.call(null,args__50753__auto___54523));
})();
if(cljs.core.truth_(temp__5753__auto___54530)){
var error__50754__auto___54538 = temp__5753__auto___54530;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54538], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53909_54517,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54523,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54538], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53912;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53920_54541 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53921_54542 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__53922_54543 = output_schema53908_54516;
var G__53923_54544 = cljs.core.deref(output_checker53911_54519);
var G__53924_54545 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53920_54541,G__53921_54542,G__53922_54543,G__53923_54544,G__53924_54545) : schema.core.fn_validator.call(null,G__53920_54541,G__53921_54542,G__53922_54543,G__53923_54544,G__53924_54545));
} else {
var temp__5753__auto___54546 = (function (){var fexpr__53926 = cljs.core.deref(output_checker53911_54519);
return (fexpr__53926.cljs$core$IFn$_invoke$arity$1 ? fexpr__53926.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53926.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54546)){
var error__50754__auto___54547 = temp__5753__auto___54546;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54547], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53908_54516,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54547], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema53908_54516,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53909_54517], null)));

var ufv___54548 = schema.utils.use_fn_validation;
var output_schema53928_54549 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53929_54550 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker53930_54551 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53929_54550);
}),null));
var output_checker53931_54552 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53928_54549);
}),null));
var ret__52561__auto___54553 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__53932){
var validate__50752__auto__ = cljs.core.deref(ufv___54548);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54554 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53932], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53933_54556 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53934_54557 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53935_54558 = input_schema53929_54550;
var G__53936_54559 = cljs.core.deref(input_checker53930_54551);
var G__53937_54560 = args__50753__auto___54554;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53933_54556,G__53934_54557,G__53935_54558,G__53936_54559,G__53937_54560) : schema.core.fn_validator.call(null,G__53933_54556,G__53934_54557,G__53935_54558,G__53936_54559,G__53937_54560));
} else {
var temp__5753__auto___54576 = (function (){var fexpr__53938 = cljs.core.deref(input_checker53930_54551);
return (fexpr__53938.cljs$core$IFn$_invoke$arity$1 ? fexpr__53938.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54554) : fexpr__53938.call(null,args__50753__auto___54554));
})();
if(cljs.core.truth_(temp__5753__auto___54576)){
var error__50754__auto___54577 = temp__5753__auto___54576;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54577], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53929_54550,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54554,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54577], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var s = G__53932;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53939_54585 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53940_54586 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53941_54587 = output_schema53928_54549;
var G__53942_54588 = cljs.core.deref(output_checker53931_54552);
var G__53943_54589 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53939_54585,G__53940_54586,G__53941_54587,G__53942_54588,G__53943_54589) : schema.core.fn_validator.call(null,G__53939_54585,G__53940_54586,G__53941_54587,G__53942_54588,G__53943_54589));
} else {
var temp__5753__auto___54592 = (function (){var fexpr__53945 = cljs.core.deref(output_checker53931_54552);
return (fexpr__53945.cljs$core$IFn$_invoke$arity$1 ? fexpr__53945.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53945.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54592)){
var error__50754__auto___54595 = temp__5753__auto___54592;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54595], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53928_54549,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54595], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema53928_54549,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53929_54550], null)));

var ufv___54598 = schema.utils.use_fn_validation;
var output_schema53946_54599 = schema.core.maybe(schema.core.Str);
var input_schema53947_54600 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker53948_54601 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53947_54600);
}),null));
var output_checker53949_54602 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53946_54599);
}),null));
var ret__52561__auto___54603 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__53950){
var validate__50752__auto__ = cljs.core.deref(ufv___54598);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54605 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53950], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53954_54606 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53955_54607 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__53956_54608 = input_schema53947_54600;
var G__53957_54609 = cljs.core.deref(input_checker53948_54601);
var G__53958_54610 = args__50753__auto___54605;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53954_54606,G__53955_54607,G__53956_54608,G__53957_54609,G__53958_54610) : schema.core.fn_validator.call(null,G__53954_54606,G__53955_54607,G__53956_54608,G__53957_54609,G__53958_54610));
} else {
var temp__5753__auto___54611 = (function (){var fexpr__53960 = cljs.core.deref(input_checker53948_54601);
return (fexpr__53960.cljs$core$IFn$_invoke$arity$1 ? fexpr__53960.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54605) : fexpr__53960.call(null,args__50753__auto___54605));
})();
if(cljs.core.truth_(temp__5753__auto___54611)){
var error__50754__auto___54612 = temp__5753__auto___54611;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54612], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53947_54600,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54605,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54612], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53950;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4695__auto___54615 = len;
var i_54616 = (0);
while(true){
if((i_54616 < n__4695__auto___54615)){
var b_54617 = ((ba[i_54616]) & (255));
var j_54618 = ((2) * i_54616);
(ca[j_54618] = (function (){var G__53961 = (b_54617 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__53961) : hex_chars.call(null,G__53961));
})());

(ca[(j_54618 + (1))] = (function (){var G__53962 = (b_54617 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__53962) : hex_chars.call(null,G__53962));
})());

var G__54621 = (i_54616 + (1));
i_54616 = G__54621;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53963_54622 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53964_54623 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__53965_54624 = output_schema53946_54599;
var G__53966_54625 = cljs.core.deref(output_checker53949_54602);
var G__53967_54626 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53963_54622,G__53964_54623,G__53965_54624,G__53966_54625,G__53967_54626) : schema.core.fn_validator.call(null,G__53963_54622,G__53964_54623,G__53965_54624,G__53966_54625,G__53967_54626));
} else {
var temp__5753__auto___54627 = (function (){var fexpr__53969 = cljs.core.deref(output_checker53949_54602);
return (fexpr__53969.cljs$core$IFn$_invoke$arity$1 ? fexpr__53969.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53969.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54627)){
var error__50754__auto___54628 = temp__5753__auto___54627;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54628], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53946_54599,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54628], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema53946_54599,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53947_54600], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___54642 = schema.utils.use_fn_validation;
var output_schema53970_54643 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema53971_54644 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker53972_54645 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53971_54644);
}),null));
var output_checker53973_54646 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53970_54643);
}),null));
var ret__52561__auto___54658 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__53974){
var validate__50752__auto__ = cljs.core.deref(ufv___54642);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54659 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53974], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53976_54661 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53977_54662 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53978_54663 = input_schema53971_54644;
var G__53979_54664 = cljs.core.deref(input_checker53972_54645);
var G__53980_54665 = args__50753__auto___54659;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53976_54661,G__53977_54662,G__53978_54663,G__53979_54664,G__53980_54665) : schema.core.fn_validator.call(null,G__53976_54661,G__53977_54662,G__53978_54663,G__53979_54664,G__53980_54665));
} else {
var temp__5753__auto___54667 = (function (){var fexpr__53981 = cljs.core.deref(input_checker53972_54645);
return (fexpr__53981.cljs$core$IFn$_invoke$arity$1 ? fexpr__53981.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54659) : fexpr__53981.call(null,args__50753__auto___54659));
})();
if(cljs.core.truth_(temp__5753__auto___54667)){
var error__50754__auto___54668 = temp__5753__auto___54667;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54668], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53971_54644,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54659,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54668], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var s = G__53974;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4695__auto___54669 = ba_len;
var i_54670 = (0);
while(true){
if((i_54670 < n__4695__auto___54669)){
var j_54671 = ((2) * i_54670);
(ba[i_54670] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_54671)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_54671 + (1))))));

var G__54672 = (i_54670 + (1));
i_54670 = G__54672;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53983_54673 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53984_54674 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__53985_54675 = output_schema53970_54643;
var G__53986_54676 = cljs.core.deref(output_checker53973_54646);
var G__53987_54677 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53983_54673,G__53984_54674,G__53985_54675,G__53986_54676,G__53987_54677) : schema.core.fn_validator.call(null,G__53983_54673,G__53984_54674,G__53985_54675,G__53986_54676,G__53987_54677));
} else {
var temp__5753__auto___54678 = (function (){var fexpr__53988 = cljs.core.deref(output_checker53973_54646);
return (fexpr__53988.cljs$core$IFn$_invoke$arity$1 ? fexpr__53988.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__53988.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54678)){
var error__50754__auto___54679 = temp__5753__auto___54678;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54679], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53970_54643,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54679], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema53970_54643,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53971_54644], null)));

var ufv___54684 = schema.utils.use_fn_validation;
var output_schema53990_54685 = deercreeklabs.baracus.ByteArray;
var input_schema53991_54686 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker53992_54687 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53991_54686);
}),null));
var output_checker53993_54688 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53990_54685);
}),null));
var ret__52561__auto___54691 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__53994){
var validate__50752__auto__ = cljs.core.deref(ufv___54684);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54694 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53994], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53996_54695 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53997_54696 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__53998_54697 = input_schema53991_54686;
var G__53999_54698 = cljs.core.deref(input_checker53992_54687);
var G__54000_54699 = args__50753__auto___54694;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53996_54695,G__53997_54696,G__53998_54697,G__53999_54698,G__54000_54699) : schema.core.fn_validator.call(null,G__53996_54695,G__53997_54696,G__53998_54697,G__53999_54698,G__54000_54699));
} else {
var temp__5753__auto___54702 = (function (){var fexpr__54001 = cljs.core.deref(input_checker53992_54687);
return (fexpr__54001.cljs$core$IFn$_invoke$arity$1 ? fexpr__54001.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54694) : fexpr__54001.call(null,args__50753__auto___54694));
})();
if(cljs.core.truth_(temp__5753__auto___54702)){
var error__50754__auto___54703 = temp__5753__auto___54702;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54703], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53991_54686,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54694,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54703], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__53994;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54002_54706 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54003_54707 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__54004_54708 = output_schema53990_54685;
var G__54005_54709 = cljs.core.deref(output_checker53993_54688);
var G__54006_54710 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54002_54706,G__54003_54707,G__54004_54708,G__54005_54709,G__54006_54710) : schema.core.fn_validator.call(null,G__54002_54706,G__54003_54707,G__54004_54708,G__54005_54709,G__54006_54710));
} else {
var temp__5753__auto___54711 = (function (){var fexpr__54007 = cljs.core.deref(output_checker53993_54688);
return (fexpr__54007.cljs$core$IFn$_invoke$arity$1 ? fexpr__54007.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__54007.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54711)){
var error__50754__auto___54712 = temp__5753__auto___54711;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54712], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53990_54685,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54712], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema53990_54685,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53991_54686], null)));

var ufv___54715 = schema.utils.use_fn_validation;
var output_schema54009_54716 = deercreeklabs.baracus.ByteArray;
var input_schema54010_54717 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker54011_54718 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54010_54717);
}),null));
var output_checker54012_54719 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54009_54716);
}),null));
var ret__52561__auto___54728 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__54013){
var validate__50752__auto__ = cljs.core.deref(ufv___54715);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___54729 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54013], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54015_54730 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54016_54731 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__54017_54732 = input_schema54010_54717;
var G__54018_54733 = cljs.core.deref(input_checker54011_54718);
var G__54019_54734 = args__50753__auto___54729;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54015_54730,G__54016_54731,G__54017_54732,G__54018_54733,G__54019_54734) : schema.core.fn_validator.call(null,G__54015_54730,G__54016_54731,G__54017_54732,G__54018_54733,G__54019_54734));
} else {
var temp__5753__auto___54737 = (function (){var fexpr__54020 = cljs.core.deref(input_checker54011_54718);
return (fexpr__54020.cljs$core$IFn$_invoke$arity$1 ? fexpr__54020.cljs$core$IFn$_invoke$arity$1(args__50753__auto___54729) : fexpr__54020.call(null,args__50753__auto___54729));
})();
if(cljs.core.truth_(temp__5753__auto___54737)){
var error__50754__auto___54738 = temp__5753__auto___54737;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54738], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54010_54717,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___54729,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54738], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var ba = G__54013;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54021_54739 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54022_54740 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__54023_54741 = output_schema54009_54716;
var G__54024_54742 = cljs.core.deref(output_checker54012_54719);
var G__54025_54743 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54021_54739,G__54022_54740,G__54023_54741,G__54024_54742,G__54025_54743) : schema.core.fn_validator.call(null,G__54021_54739,G__54022_54740,G__54023_54741,G__54024_54742,G__54025_54743));
} else {
var temp__5753__auto___54744 = (function (){var fexpr__54026 = cljs.core.deref(output_checker54012_54719);
return (fexpr__54026.cljs$core$IFn$_invoke$arity$1 ? fexpr__54026.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__54026.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___54744)){
var error__50754__auto___54745 = temp__5753__auto___54744;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___54745], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54009_54716,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___54745], null));
} else {
}
}
} else {
}

return o__50755__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema54009_54716,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54010_54717], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
