goog.provide('deercreeklabs.tube.client');
deercreeklabs.tube.client.default_keepalive_secs = (25);

/**
 * @interface
 */
deercreeklabs.tube.client.ITubeClient = function(){};

var deercreeklabs$tube$client$ITubeClient$send$dyn_55980 = (function (this$,data){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (deercreeklabs.tube.client.send[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4510__auto__.call(null,this$,data));
} else {
var m__4508__auto__ = (deercreeklabs.tube.client.send["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(this$,data) : m__4508__auto__.call(null,this$,data));
} else {
throw cljs.core.missing_protocol("ITubeClient.send",this$);
}
}
});
/**
 * Send binary bytes over this tube
 */
deercreeklabs.tube.client.send = (function deercreeklabs$tube$client$send(this$,data){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$send$arity$2 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$send$arity$2(this$,data);
} else {
return deercreeklabs$tube$client$ITubeClient$send$dyn_55980(this$,data);
}
});

var deercreeklabs$tube$client$ITubeClient$close$dyn_55981 = (function() {
var G__55982 = null;
var G__55982__1 = (function (this$){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4510__auto__.call(null,this$));
} else {
var m__4508__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4508__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
var G__55982__3 = (function (this$,code,reason){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (deercreeklabs.tube.client.close[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4510__auto__.call(null,this$,code,reason));
} else {
var m__4508__auto__ = (deercreeklabs.tube.client.close["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(this$,code,reason) : m__4508__auto__.call(null,this$,code,reason));
} else {
throw cljs.core.missing_protocol("ITubeClient.close",this$);
}
}
});
G__55982 = function(this$,code,reason){
switch(arguments.length){
case 1:
return G__55982__1.call(this,this$);
case 3:
return G__55982__3.call(this,this$,code,reason);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__55982.cljs$core$IFn$_invoke$arity$1 = G__55982__1;
G__55982.cljs$core$IFn$_invoke$arity$3 = G__55982__3;
return G__55982;
})()
;
/**
 * Close this tube
 */
deercreeklabs.tube.client.close = (function deercreeklabs$tube$client$close(var_args){
var G__55662 = arguments.length;
switch (G__55662) {
case 1:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$1 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$1(this$);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_55981(this$);
}
}));

(deercreeklabs.tube.client.close.cljs$core$IFn$_invoke$arity$3 = (function (this$,code,reason){
if((((!((this$ == null)))) && ((!((this$.deercreeklabs$tube$client$ITubeClient$close$arity$3 == null)))))){
return this$.deercreeklabs$tube$client$ITubeClient$close$arity$3(this$,code,reason);
} else {
return deercreeklabs$tube$client$ITubeClient$close$dyn_55981(this$,code,reason);
}
}));

(deercreeklabs.tube.client.close.cljs$lang$maxFixedArity = 3);



/**
* @constructor
 * @implements {deercreeklabs.tube.client.ITubeClient}
*/
deercreeklabs.tube.client.TubeClient = (function (conn,close_client_BANG_,_STAR_shutdown_QMARK_){
this.conn = conn;
this.close_client_BANG_ = close_client_BANG_;
this._STAR_shutdown_QMARK_ = _STAR_shutdown_QMARK_;
});
(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$ = cljs.core.PROTOCOL_SENTINEL);

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$send$arity$2 = (function (this$,data){
var self__ = this;
var this$__$1 = this;
return deercreeklabs.tube.connection.send(self__.conn,data);
}));

(deercreeklabs.tube.client.TubeClient.prototype.deercreeklabs$tube$client$ITubeClient$close$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var code = (1000);
var reason = "Explicit close";
var ws_already_closed_QMARK_ = false;
return (self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3 ? self__.close_client_BANG_.cljs$core$IFn$_invoke$arity$3(code,reason,ws_already_closed_QMARK_) : self__.close_client_BANG_.call(null,code,reason,ws_already_closed_QMARK_));
}));

(deercreeklabs.tube.client.TubeClient.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"close-client!","close-client!",-332645616,null),new cljs.core.Symbol(null,"*shutdown?","*shutdown?",282019102,null)], null);
}));

(deercreeklabs.tube.client.TubeClient.cljs$lang$type = true);

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorStr = "deercreeklabs.tube.client/TubeClient");

(deercreeklabs.tube.client.TubeClient.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"deercreeklabs.tube.client/TubeClient");
}));

/**
 * Positional factory function for deercreeklabs.tube.client/TubeClient.
 */
deercreeklabs.tube.client.__GT_TubeClient = (function deercreeklabs$tube$client$__GT_TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_){
return (new deercreeklabs.tube.client.TubeClient(conn,close_client_BANG_,_STAR_shutdown_QMARK_));
});

deercreeklabs.tube.client._LT_ws_client_cljs = (function deercreeklabs$tube$client$_LT_ws_client_cljs(logger,url,on_error,on_disconnect,handle_rcv_BANG_,log_conn_failure_QMARK_,_STAR_conn,_STAR_shutdown_QMARK_){
var fragment_size = (31999);
var client = (function (){var G__55665 = deercreeklabs.tube.utils.platform_kw();
var G__55665__$1 = (((G__55665 instanceof cljs.core.Keyword))?G__55665.fqn:null);
switch (G__55665__$1) {
case "node":
var WSC = require("ws");
return (new WSC(url));

break;
case "browser":
return (new WebSocket(url));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55665__$1)].join('')));

}
})();
var _STAR_connected_QMARK_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var msg_handler = (function (msg_obj){
var data = (new Int8Array(msg_obj.data));
return (handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1 ? handle_rcv_BANG_.cljs$core$IFn$_invoke$arity$1(data) : handle_rcv_BANG_.call(null,data));
});
var closer = (function (){
return client.close();
});
var sender = (function (data){
if(cljs.core.truth_(cljs.core.deref(_STAR_shutdown_QMARK_))){
return null;
} else {
return client.send(data.buffer);
}
});
var ret_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
(client.binaryType = "arraybuffer");

(client.onopen = (function (event){
cljs.core.reset_BANG_(_STAR_connected_QMARK_,true);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ret_ch,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"sender","sender",1557303285),sender,new cljs.core.Keyword(null,"closer","closer",10992481),closer,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330),fragment_size], null));
}));

(client.onclose = (function (event){
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__55666 = cljs.core.deref(_STAR_conn);
var G__55667 = event.code;
var G__55668 = event.reason;
return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(G__55666,G__55667,G__55668) : on_disconnect.call(null,G__55666,G__55667,G__55668));
} else {
return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onerror = (function (err){
if(cljs.core.truth_(cljs.core.deref(_STAR_connected_QMARK_))){
var G__55669 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(err);
return (on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(G__55669) : on_error.call(null,G__55669));
} else {
if(cljs.core.truth_(log_conn_failure_QMARK_)){
var G__55670_55985 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__55671_55986 = ["Websocket failed to connect. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(deercreeklabs.tube.utils.ex_msg(err))].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__55670_55985,G__55671_55986) : logger.call(null,G__55670_55985,G__55671_55986));
} else {
}

return cljs.core.async.close_BANG_(ret_ch);
}
}));

(client.onmessage = msg_handler);

return ret_ch;
});
deercreeklabs.tube.client.start_keep_alive_loop = (function deercreeklabs$tube$client$start_keep_alive_loop(conn,keep_alive_secs,_STAR_shutdown_QMARK_){
var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_55703){
var state_val_55704 = (state_55703[(1)]);
if((state_val_55704 === (7))){
var inst_55698 = (state_55703[(2)]);
var _ = (function (){var statearr_55705 = state_55703;
(statearr_55705[(4)] = cljs.core.rest((state_55703[(4)])));

return statearr_55705;
})();
var state_55703__$1 = state_55703;
var statearr_55706_55987 = state_55703__$1;
(statearr_55706_55987[(2)] = inst_55698);

(statearr_55706_55987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (1))){
var state_55703__$1 = state_55703;
var statearr_55707_55988 = state_55703__$1;
(statearr_55707_55988[(2)] = null);

(statearr_55707_55988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (4))){
var inst_55672 = (state_55703[(2)]);
var state_55703__$1 = state_55703;
var statearr_55708_55989 = state_55703__$1;
(statearr_55708_55989[(2)] = inst_55672);

(statearr_55708_55989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (13))){
var inst_55690 = deercreeklabs.tube.connection.send_ping(conn);
var state_55703__$1 = state_55703;
var statearr_55709_55990 = state_55703__$1;
(statearr_55709_55990[(2)] = inst_55690);

(statearr_55709_55990[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (6))){
var inst_55679 = cljs.core.deref(_STAR_shutdown_QMARK_);
var inst_55680 = cljs.core.not(inst_55679);
var state_55703__$1 = state_55703;
if(inst_55680){
var statearr_55710_55991 = state_55703__$1;
(statearr_55710_55991[(1)] = (8));

} else {
var statearr_55711_55992 = state_55703__$1;
(statearr_55711_55992[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (3))){
var inst_55701 = (state_55703[(2)]);
var state_55703__$1 = state_55703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55703__$1,inst_55701);
} else {
if((state_val_55704 === (12))){
var state_55703__$1 = state_55703;
var statearr_55712_55993 = state_55703__$1;
(statearr_55712_55993[(2)] = null);

(statearr_55712_55993[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (2))){
var _ = (function (){var statearr_55713 = state_55703;
(statearr_55713[(4)] = cljs.core.cons((5),(state_55703[(4)])));

return statearr_55713;
})();
var state_55703__$1 = state_55703;
var statearr_55714_55994 = state_55703__$1;
(statearr_55714_55994[(2)] = null);

(statearr_55714_55994[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (11))){
var inst_55686 = (state_55703[(2)]);
var inst_55687 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_55703__$1 = (function (){var statearr_55716 = state_55703;
(statearr_55716[(7)] = inst_55686);

return statearr_55716;
})();
if(cljs.core.truth_(inst_55687)){
var statearr_55717_55995 = state_55703__$1;
(statearr_55717_55995[(1)] = (12));

} else {
var statearr_55718_55996 = state_55703__$1;
(statearr_55718_55996[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (9))){
var state_55703__$1 = state_55703;
var statearr_55719_55997 = state_55703__$1;
(statearr_55719_55997[(2)] = null);

(statearr_55719_55997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (5))){
var _ = (function (){var statearr_55720 = state_55703;
(statearr_55720[(4)] = cljs.core.rest((state_55703[(4)])));

return statearr_55720;
})();
var state_55703__$1 = state_55703;
var ex55715 = (state_55703__$1[(2)]);
var statearr_55721_55998 = state_55703__$1;
(statearr_55721_55998[(5)] = ex55715);


var statearr_55722_55999 = state_55703__$1;
(statearr_55722_55999[(1)] = (4));

(statearr_55722_55999[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (14))){
var inst_55692 = (state_55703[(2)]);
var state_55703__$1 = (function (){var statearr_55723 = state_55703;
(statearr_55723[(8)] = inst_55692);

return statearr_55723;
})();
var statearr_55724_56000 = state_55703__$1;
(statearr_55724_56000[(2)] = null);

(statearr_55724_56000[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (10))){
var inst_55696 = (state_55703[(2)]);
var state_55703__$1 = state_55703;
var statearr_55725_56001 = state_55703__$1;
(statearr_55725_56001[(2)] = inst_55696);

(statearr_55725_56001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55704 === (8))){
var inst_55682 = (keep_alive_secs | (0));
var inst_55683 = ((1000) * inst_55682);
var inst_55684 = cljs.core.async.timeout(inst_55683);
var state_55703__$1 = state_55703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55703__$1,(11),inst_55684);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto__ = null;
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto____0 = (function (){
var statearr_55726 = [null,null,null,null,null,null,null,null,null];
(statearr_55726[(0)] = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto__);

(statearr_55726[(1)] = (1));

return statearr_55726;
});
var deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto____1 = (function (state_55703){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_55703);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e55727){var ex__43226__auto__ = e55727;
var statearr_55728_56002 = state_55703;
(statearr_55728_56002[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_55703[(4)]))){
var statearr_55729_56003 = state_55703;
(statearr_55729_56003[(1)] = cljs.core.first((state_55703[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56004 = state_55703;
state_55703 = G__56004;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto__ = function(state_55703){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto____1.call(this,state_55703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto____0;
deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto____1;
return deercreeklabs$tube$client$start_keep_alive_loop_$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_55730 = f__43958__auto__();
(statearr_55730[(6)] = c__43957__auto__);

return statearr_55730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

return c__43957__auto__;
});
deercreeklabs.tube.client._LT_connect = (function deercreeklabs$tube$client$_LT_connect(wsc,url,logger,options,close_client_BANG_,_STAR_conn,_STAR_shutdown_QMARK_){
var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_55813){
var state_val_55814 = (state_55813[(1)]);
if((state_val_55814 === (7))){
var inst_55808 = (state_55813[(2)]);
var _ = (function (){var statearr_55815 = state_55813;
(statearr_55815[(4)] = cljs.core.rest((state_55813[(4)])));

return statearr_55815;
})();
var state_55813__$1 = state_55813;
var statearr_55816_56005 = state_55813__$1;
(statearr_55816_56005[(2)] = inst_55808);

(statearr_55816_56005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (20))){
var inst_55802 = (state_55813[(2)]);
var state_55813__$1 = state_55813;
var statearr_55817_56006 = state_55813__$1;
(statearr_55817_56006[(2)] = inst_55802);

(statearr_55817_56006[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (1))){
var state_55813__$1 = state_55813;
var statearr_55818_56007 = state_55813__$1;
(statearr_55818_56007[(2)] = null);

(statearr_55818_56007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (4))){
var inst_55731 = (state_55813[(2)]);
var state_55813__$1 = state_55813;
var statearr_55819_56008 = state_55813__$1;
(statearr_55819_56008[(2)] = inst_55731);

(statearr_55819_56008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (15))){
var state_55813__$1 = state_55813;
var statearr_55820_56009 = state_55813__$1;
(statearr_55820_56009[(2)] = null);

(statearr_55820_56009[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (21))){
var state_55813__$1 = state_55813;
var statearr_55821_56010 = state_55813__$1;
(statearr_55821_56010[(2)] = null);

(statearr_55821_56010[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (13))){
var inst_55761 = (state_55813[(7)]);
var inst_55787 = deercreeklabs.tube.utils.current_time_ms();
var inst_55788 = cljs.core.identity(inst_55787);
var inst_55789 = cljs.core.identity(inst_55761);
var inst_55790 = (inst_55788 > inst_55789);
var state_55813__$1 = state_55813;
if(cljs.core.truth_(inst_55790)){
var statearr_55822_56011 = state_55813__$1;
(statearr_55822_56011[(1)] = (18));

} else {
var statearr_55823_56012 = state_55813__$1;
(statearr_55823_56012[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (22))){
var state_55813__$1 = state_55813;
var statearr_55824_56013 = state_55813__$1;
(statearr_55824_56013[(2)] = null);

(statearr_55824_56013[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (6))){
var inst_55763 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_55813__$1 = state_55813;
if(cljs.core.truth_(inst_55763)){
var statearr_55825_56014 = state_55813__$1;
(statearr_55825_56014[(1)] = (8));

} else {
var statearr_55826_56015 = state_55813__$1;
(statearr_55826_56015[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (17))){
var inst_55785 = (state_55813[(2)]);
var state_55813__$1 = state_55813;
var statearr_55827_56016 = state_55813__$1;
(statearr_55827_56016[(2)] = inst_55785);

(statearr_55827_56016[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (3))){
var inst_55811 = (state_55813[(2)]);
var state_55813__$1 = state_55813;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55813__$1,inst_55811);
} else {
if((state_val_55814 === (12))){
var inst_55779 = cljs.core.deref(_STAR_shutdown_QMARK_);
var state_55813__$1 = state_55813;
if(cljs.core.truth_(inst_55779)){
var statearr_55828_56017 = state_55813__$1;
(statearr_55828_56017[(1)] = (15));

} else {
var statearr_55829_56018 = state_55813__$1;
(statearr_55829_56018[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (2))){
var inst_55754 = (state_55813[(8)]);
var inst_55752 = (state_55813[(9)]);
var inst_55747 = (state_55813[(10)]);
var inst_55748 = (state_55813[(11)]);
var _ = (function (){var statearr_55830 = state_55813;
(statearr_55830[(4)] = cljs.core.cons((5),(state_55813[(4)])));

return statearr_55830;
})();
var inst_55739 = wsc;
var inst_55740 = cljs.core.__destructure_map(inst_55739);
var inst_55741 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_55740,new cljs.core.Keyword(null,"sender","sender",1557303285));
var inst_55742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_55740,new cljs.core.Keyword(null,"closer","closer",10992481));
var inst_55743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_55740,new cljs.core.Keyword(null,"fragment-size","fragment-size",-1493888330));
var inst_55744 = options;
var inst_55745 = cljs.core.__destructure_map(inst_55744);
var inst_55746 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55745,new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612),new cljs.core.Keyword(null,"smart","smart",-1065238825));
var inst_55747__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55745,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(5000));
var inst_55748__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55745,new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281),deercreeklabs.tube.client.default_keepalive_secs);
var inst_55749 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55745,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_55750 = cljs.core.constantly(null);
var inst_55751 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55745,new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281),inst_55750);
var inst_55752__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_55753 = (function (){var map__55738 = inst_55745;
var keep_alive_secs = inst_55748__$1;
var connect_timeout_ms = inst_55747__$1;
var closer = inst_55742;
var map__55737 = inst_55740;
var on_rcv = inst_55751;
var compression_type = inst_55746;
var log_conn_failure_QMARK_ = inst_55749;
var ready_ch = inst_55752__$1;
var sender = inst_55741;
var fragment_size = inst_55743;
return (function (conn){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ready_ch,true);
});
})();
var inst_55754__$1 = deercreeklabs.tube.connection.connection.cljs$core$IFn$_invoke$arity$12((0),url,url,inst_55753,null,null,inst_55741,inst_55742,inst_55743,inst_55746,true,inst_55751);
var inst_55755 = cljs.core.reset_BANG_(_STAR_conn,inst_55754__$1);
var inst_55756 = deercreeklabs.baracus.encode_int(inst_55743);
var inst_55757 = (inst_55741.cljs$core$IFn$_invoke$arity$1 ? inst_55741.cljs$core$IFn$_invoke$arity$1(inst_55756) : inst_55741.call(null,inst_55756));
var inst_55758 = deercreeklabs.tube.utils.current_time_ms();
var inst_55759 = cljs.core.identity(inst_55758);
var inst_55760 = cljs.core.identity(inst_55747__$1);
var inst_55761 = (inst_55759 + inst_55760);
var state_55813__$1 = (function (){var statearr_55831 = state_55813;
(statearr_55831[(8)] = inst_55754__$1);

(statearr_55831[(12)] = inst_55755);

(statearr_55831[(13)] = inst_55757);

(statearr_55831[(7)] = inst_55761);

(statearr_55831[(9)] = inst_55752__$1);

(statearr_55831[(10)] = inst_55747__$1);

(statearr_55831[(11)] = inst_55748__$1);

return statearr_55831;
})();
var statearr_55832_56019 = state_55813__$1;
(statearr_55832_56019[(2)] = null);

(statearr_55832_56019[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (23))){
var inst_55800 = (state_55813[(2)]);
var state_55813__$1 = state_55813;
var statearr_55833_56020 = state_55813__$1;
(statearr_55833_56020[(2)] = inst_55800);

(statearr_55833_56020[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (19))){
var state_55813__$1 = state_55813;
var statearr_55834_56021 = state_55813__$1;
(statearr_55834_56021[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (11))){
var inst_55752 = (state_55813[(9)]);
var inst_55774 = (state_55813[(2)]);
var inst_55775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55774,(0),null);
var inst_55776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55774,(1),null);
var inst_55777 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55752,inst_55776);
var state_55813__$1 = (function (){var statearr_55837 = state_55813;
(statearr_55837[(14)] = inst_55775);

return statearr_55837;
})();
if(inst_55777){
var statearr_55838_56022 = state_55813__$1;
(statearr_55838_56022[(1)] = (12));

} else {
var statearr_55839_56023 = state_55813__$1;
(statearr_55839_56023[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (9))){
var inst_55752 = (state_55813[(9)]);
var inst_55769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55770 = cljs.core.async.timeout((100));
var inst_55771 = [inst_55752,inst_55770];
var inst_55772 = (new cljs.core.PersistentVector(null,2,(5),inst_55769,inst_55771,null));
var state_55813__$1 = state_55813;
return cljs.core.async.ioc_alts_BANG_(state_55813__$1,(11),inst_55772);
} else {
if((state_val_55814 === (5))){
var _ = (function (){var statearr_55840 = state_55813;
(statearr_55840[(4)] = cljs.core.rest((state_55813[(4)])));

return statearr_55840;
})();
var state_55813__$1 = state_55813;
var ex55836 = (state_55813__$1[(2)]);
var statearr_55841_56026 = state_55813__$1;
(statearr_55841_56026[(5)] = ex55836);


var statearr_55842_56027 = state_55813__$1;
(statearr_55842_56027[(1)] = (4));

(statearr_55842_56027[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (14))){
var inst_55804 = (state_55813[(2)]);
var state_55813__$1 = state_55813;
var statearr_55843_56028 = state_55813__$1;
(statearr_55843_56028[(2)] = inst_55804);

(statearr_55843_56028[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (16))){
var inst_55754 = (state_55813[(8)]);
var inst_55748 = (state_55813[(11)]);
var inst_55782 = deercreeklabs.tube.client.start_keep_alive_loop(inst_55754,inst_55748,_STAR_shutdown_QMARK_);
var inst_55783 = deercreeklabs.tube.client.__GT_TubeClient(inst_55754,close_client_BANG_,_STAR_shutdown_QMARK_);
var state_55813__$1 = (function (){var statearr_55844 = state_55813;
(statearr_55844[(15)] = inst_55782);

return statearr_55844;
})();
var statearr_55845_56029 = state_55813__$1;
(statearr_55845_56029[(2)] = inst_55783);

(statearr_55845_56029[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (10))){
var inst_55806 = (state_55813[(2)]);
var state_55813__$1 = state_55813;
var statearr_55846_56030 = state_55813__$1;
(statearr_55846_56030[(2)] = inst_55806);

(statearr_55846_56030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (18))){
var inst_55754 = (state_55813[(8)]);
var inst_55747 = (state_55813[(10)]);
var inst_55792 = ["Websocket to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)," connected, but did ","not complete negotiation before timeout (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_55747)," ms)"].join('');
var inst_55793 = (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),inst_55792) : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_55792));
var inst_55794 = deercreeklabs.tube.connection.close(inst_55754,(1002),"Protocol negotiation timed out",false);
var state_55813__$1 = (function (){var statearr_55847 = state_55813;
(statearr_55847[(16)] = inst_55794);

(statearr_55847[(17)] = inst_55793);

return statearr_55847;
})();
var statearr_55848_56031 = state_55813__$1;
(statearr_55848_56031[(2)] = null);

(statearr_55848_56031[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55814 === (8))){
var state_55813__$1 = state_55813;
var statearr_55849_56033 = state_55813__$1;
(statearr_55849_56033[(2)] = null);

(statearr_55849_56033[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto__ = null;
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto____0 = (function (){
var statearr_55850 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55850[(0)] = deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto__);

(statearr_55850[(1)] = (1));

return statearr_55850;
});
var deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto____1 = (function (state_55813){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_55813);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e55851){var ex__43226__auto__ = e55851;
var statearr_55852_56044 = state_55813;
(statearr_55852_56044[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_55813[(4)]))){
var statearr_55853_56049 = state_55813;
(statearr_55853_56049[(1)] = cljs.core.first((state_55813[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56050 = state_55813;
state_55813 = G__56050;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto__ = function(state_55813){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto____1.call(this,state_55813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto____0;
deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto____1;
return deercreeklabs$tube$client$_LT_connect_$_state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_55854 = f__43958__auto__();
(statearr_55854[(6)] = c__43957__auto__);

return statearr_55854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
}));

return c__43957__auto__;
});
var ufv___56051 = schema.utils.use_fn_validation;
var output_schema55856_56052 = schema.core.Any;
var input_schema55857_56053 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_schema55861_56054 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)], 0)),schema.core.optional_key(new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),schema.core.Int,schema.core.optional_key(new cljs.core.Keyword(null,"logger","logger",-220675947)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one(schema.core.Str,new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null)], null)),schema.core.optional_key(new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),schema.core.Bool,schema.core.optional_key(new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null)),schema.core.optional_key(new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),schema.core.make_fn_schema(schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null))]),cljs.core.with_meta(new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 7, [cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"compression-type","compression-type",-1164034612)),cljs.core.list(new cljs.core.Symbol("s","enum","s/enum",-975416934,null),new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"smart","smart",-1065238825),new cljs.core.Keyword(null,"deflate","deflate",412602929)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"keep-alive-secs","keep-alive-secs",-1354697281)),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"logger","logger",-220675947)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069)),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)),cljs.core.list(new cljs.core.Symbol("s","optional-key","s/optional-key",988405874,null),new cljs.core.Keyword(null,"on-rcv","on-rcv",1220794281)),cljs.core.list(new cljs.core.Symbol("s","=>","s/=>",-813269628,null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)], null)))], null);
var input_checker55858_56055 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55857_56053);
}),null));
var output_checker55859_56056 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55856_56052);
}),null));
var input_checker55862_56057 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55861_56054);
}),null));
var output_checker55863_56058 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55856_56052);
}),null));
var ret__52561__auto___56059 = (function (){
/**
 * Inputs: ([url :- s/Str] [url :- s/Str options :- {(s/optional-key :compression-type) (s/enum :none :smart :deflate), (s/optional-key :connect-timeout-ms) s/Int, (s/optional-key :keep-alive-secs) s/Int, (s/optional-key :logger) (s/=> s/Any s/Keyword s/Str), (s/optional-key :log-conn-failure?) s/Bool, (s/optional-key :on-disconnect) (s/=> s/Any), (s/optional-key :on-rcv) (s/=> s/Any)}])
 * 
 *   Will return a connected client or a closed channel (nil) on connection
 * failure or timeout.
 */
deercreeklabs.tube.client._LT_tube_client = (function deercreeklabs$tube$client$_LT_tube_client(var_args){
var G__55867 = arguments.length;
switch (G__55867) {
case 1:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$1 = (function (G__55860){
var validate__50752__auto__ = cljs.core.deref(ufv___56051);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___56061 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55860], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55868_56062 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55869_56063 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__55870_56064 = input_schema55857_56053;
var G__55871_56065 = cljs.core.deref(input_checker55858_56055);
var G__55872_56066 = args__50753__auto___56061;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55868_56062,G__55869_56063,G__55870_56064,G__55871_56065,G__55872_56066) : schema.core.fn_validator.call(null,G__55868_56062,G__55869_56063,G__55870_56064,G__55871_56065,G__55872_56066));
} else {
var temp__5753__auto___56068 = (function (){var fexpr__55873 = cljs.core.deref(input_checker55858_56055);
return (fexpr__55873.cljs$core$IFn$_invoke$arity$1 ? fexpr__55873.cljs$core$IFn$_invoke$arity$1(args__50753__auto___56061) : fexpr__55873.call(null,args__50753__auto___56061));
})();
if(cljs.core.truth_(temp__5753__auto___56068)){
var error__50754__auto___56069 = temp__5753__auto___56068;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___56069], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55857_56053,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___56061,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___56069], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var url = G__55860;
while(true){
return deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2(url,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55874_56082 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55875_56083 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__55876_56084 = output_schema55856_56052;
var G__55877_56085 = cljs.core.deref(output_checker55859_56056);
var G__55878_56086 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55874_56082,G__55875_56083,G__55876_56084,G__55877_56085,G__55878_56086) : schema.core.fn_validator.call(null,G__55874_56082,G__55875_56083,G__55876_56084,G__55877_56085,G__55878_56086));
} else {
var temp__5753__auto___56091 = (function (){var fexpr__55879 = cljs.core.deref(output_checker55859_56056);
return (fexpr__55879.cljs$core$IFn$_invoke$arity$1 ? fexpr__55879.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__55879.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___56091)){
var error__50754__auto___56098 = temp__5753__auto___56091;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___56098], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55856_56052,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___56098], null));
} else {
}
}
} else {
}

return o__50755__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$core$IFn$_invoke$arity$2 = (function (G__55864,G__55865){
var validate__50752__auto__ = cljs.core.deref(ufv___56051);
if(cljs.core.truth_(validate__50752__auto__)){
var args__50753__auto___56119 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55864,G__55865], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55880_56120 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55881_56121 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__55882_56122 = input_schema55861_56054;
var G__55883_56123 = cljs.core.deref(input_checker55862_56057);
var G__55884_56124 = args__50753__auto___56119;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55880_56120,G__55881_56121,G__55882_56122,G__55883_56123,G__55884_56124) : schema.core.fn_validator.call(null,G__55880_56120,G__55881_56121,G__55882_56122,G__55883_56123,G__55884_56124));
} else {
var temp__5753__auto___56137 = (function (){var fexpr__55885 = cljs.core.deref(input_checker55862_56057);
return (fexpr__55885.cljs$core$IFn$_invoke$arity$1 ? fexpr__55885.cljs$core$IFn$_invoke$arity$1(args__50753__auto___56119) : fexpr__55885.call(null,args__50753__auto___56119));
})();
if(cljs.core.truth_(temp__5753__auto___56137)){
var error__50754__auto___56152 = temp__5753__auto___56137;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___56152], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55861_56054,new cljs.core.Keyword(null,"value","value",305978217),args__50753__auto___56119,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___56152], null));
} else {
}
}
} else {
}

var o__50755__auto__ = (function (){var url = G__55864;
var options = G__55865;
while(true){
var c__43957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__43957__auto__,validate__50752__auto__,ufv___56051,output_schema55856_56052,input_schema55857_56053,input_schema55861_56054,input_checker55858_56055,output_checker55859_56056,input_checker55862_56057,output_checker55863_56058){
return (function (){
var f__43958__auto__ = (function (){var switch__43222__auto__ = (function (state_55943){
var state_val_55944 = (state_55943[(1)]);
if((state_val_55944 === (7))){
var inst_55924 = (state_55943[(7)]);
var state_55943__$1 = state_55943;
var statearr_55945_56155 = state_55943__$1;
(statearr_55945_56155[(2)] = inst_55924);

(statearr_55945_56155[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (1))){
var state_55943__$1 = state_55943;
var statearr_55946_56156 = state_55943__$1;
(statearr_55946_56156[(2)] = null);

(statearr_55946_56156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (4))){
var inst_55886 = (state_55943[(2)]);
var state_55943__$1 = state_55943;
var statearr_55947_56157 = state_55943__$1;
(statearr_55947_56157[(2)] = inst_55886);

(statearr_55947_56157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (13))){
var inst_55934 = (state_55943[(2)]);
var inst_55935 = deercreeklabs.async_utils.check(inst_55934);
var state_55943__$1 = state_55943;
var statearr_55948_56159 = state_55943__$1;
(statearr_55948_56159[(2)] = inst_55935);

(statearr_55948_56159[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (6))){
var inst_55926 = (state_55943[(8)]);
var inst_55908 = (state_55943[(9)]);
var inst_55917 = (state_55943[(2)]);
var inst_55918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55917,(0),null);
var inst_55919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55917,(1),null);
var inst_55920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55921 = deercreeklabs.async_utils.check(inst_55918);
var inst_55922 = [inst_55921,inst_55919];
var inst_55923 = (new cljs.core.PersistentVector(null,2,(5),inst_55920,inst_55922,null));
var inst_55924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55923,(0),null);
var inst_55925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55923,(1),null);
var inst_55926__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55908,inst_55925);
var state_55943__$1 = (function (){var statearr_55949 = state_55943;
(statearr_55949[(7)] = inst_55924);

(statearr_55949[(8)] = inst_55926__$1);

return statearr_55949;
})();
if(inst_55926__$1){
var statearr_55950_56162 = state_55943__$1;
(statearr_55950_56162[(1)] = (7));

} else {
var statearr_55951_56164 = state_55943__$1;
(statearr_55951_56164[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (3))){
var inst_55941 = (state_55943[(2)]);
var state_55943__$1 = state_55943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55943__$1,inst_55941);
} else {
if((state_val_55944 === (12))){
var inst_55938 = (state_55943[(2)]);
var _ = (function (){var statearr_55952 = state_55943;
(statearr_55952[(4)] = cljs.core.rest((state_55943[(4)])));

return statearr_55952;
})();
var state_55943__$1 = state_55943;
var statearr_55953_56166 = state_55943__$1;
(statearr_55953_56166[(2)] = inst_55938);

(statearr_55953_56166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (2))){
var inst_55898 = (state_55943[(10)]);
var inst_55904 = (state_55943[(11)]);
var inst_55903 = (state_55943[(12)]);
var inst_55905 = (state_55943[(13)]);
var inst_55908 = (state_55943[(9)]);
var _ = (function (){var statearr_55954 = state_55943;
(statearr_55954[(4)] = cljs.core.cons((5),(state_55943[(4)])));

return statearr_55954;
})();
var inst_55896 = options;
var inst_55897 = cljs.core.__destructure_map(inst_55896);
var inst_55898__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55897,new cljs.core.Keyword(null,"logger","logger",-220675947),deercreeklabs.tube.utils.println_logger);
var inst_55899 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55897,new cljs.core.Keyword(null,"log-conn-failure?","log-conn-failure?",311097069),true);
var inst_55900 = cljs.core.constantly(null);
var inst_55901 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55897,new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814),inst_55900);
var inst_55902 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_55897,new cljs.core.Keyword(null,"connect-timeout-ms","connect-timeout-ms",-86082976),(10000));
var inst_55903__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var inst_55904__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var inst_55905__$1 = (function (){var map__55892 = inst_55897;
var logger = inst_55898__$1;
var log_conn_failure_QMARK_ = inst_55899;
var on_disconnect = inst_55901;
var connect_timeout_ms = inst_55902;
var _STAR_shutdown_QMARK_ = inst_55903__$1;
var _STAR_conn = inst_55904__$1;
return (function (code,reason,ws_already_closed_QMARK_){
var conn = cljs.core.deref(_STAR_conn);
cljs.core.reset_BANG_(_STAR_shutdown_QMARK_,true);

if(cljs.core.truth_(conn)){
deercreeklabs.tube.connection.close(conn,code,reason,ws_already_closed_QMARK_);
} else {
}

return (on_disconnect.cljs$core$IFn$_invoke$arity$3 ? on_disconnect.cljs$core$IFn$_invoke$arity$3(conn,code,reason) : on_disconnect.call(null,conn,code,reason));
});
})();
var inst_55906 = (function (){var map__55892 = inst_55897;
var logger = inst_55898__$1;
var log_conn_failure_QMARK_ = inst_55899;
var on_disconnect = inst_55901;
var connect_timeout_ms = inst_55902;
var _STAR_shutdown_QMARK_ = inst_55903__$1;
var _STAR_conn = inst_55904__$1;
var close_client_BANG_ = inst_55905__$1;
return (function (msg){
try{var G__55958_56170 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__55959_56171 = ["Error in websocket: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('');
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__55958_56170,G__55959_56171) : logger.call(null,G__55958_56170,G__55959_56171));

return close_client_BANG_((1011),msg,true);
}catch (e55955){if((e55955 instanceof Error)){
var e = e55955;
(logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error.") : logger.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Unexpected error in on-error."));

var G__55956 = new cljs.core.Keyword(null,"error","error",-978969032);
var G__55957 = deercreeklabs.tube.utils.ex_msg_and_stacktrace(e);
return (logger.cljs$core$IFn$_invoke$arity$2 ? logger.cljs$core$IFn$_invoke$arity$2(G__55956,G__55957) : logger.call(null,G__55956,G__55957));
} else {
throw e55955;

}
}});
})();
var inst_55907 = (function (){var on_error = inst_55906;
var connect_timeout_ms = inst_55902;
var map__55892 = inst_55897;
var close_client_BANG_ = inst_55905__$1;
var on_disconnect = inst_55901;
var _STAR_conn = inst_55904__$1;
var log_conn_failure_QMARK_ = inst_55899;
var logger = inst_55898__$1;
var _STAR_shutdown_QMARK_ = inst_55903__$1;
return (function (p1__55855_SHARP_){
var temp__5753__auto__ = cljs.core.deref(_STAR_conn);
if(cljs.core.truth_(temp__5753__auto__)){
var conn = temp__5753__auto__;
return deercreeklabs.tube.connection.handle_data(conn,p1__55855_SHARP_);
} else {
return null;
}
});
})();
var inst_55908__$1 = deercreeklabs.tube.client._LT_ws_client_cljs(inst_55898__$1,url,inst_55906,inst_55901,inst_55907,inst_55899,inst_55904__$1,inst_55903__$1);
var inst_55912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55913 = cljs.core.async.timeout(inst_55902);
var inst_55914 = [inst_55908__$1,inst_55913];
var inst_55915 = (new cljs.core.PersistentVector(null,2,(5),inst_55912,inst_55914,null));
var state_55943__$1 = (function (){var statearr_55960 = state_55943;
(statearr_55960[(10)] = inst_55898__$1);

(statearr_55960[(11)] = inst_55904__$1);

(statearr_55960[(12)] = inst_55903__$1);

(statearr_55960[(13)] = inst_55905__$1);

(statearr_55960[(9)] = inst_55908__$1);

return statearr_55960;
})();
return cljs.core.async.ioc_alts_BANG_(state_55943__$1,(6),inst_55915);
} else {
if((state_val_55944 === (11))){
var state_55943__$1 = state_55943;
var statearr_55962_56177 = state_55943__$1;
(statearr_55962_56177[(2)] = null);

(statearr_55962_56177[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (9))){
var inst_55930 = (state_55943[(2)]);
var state_55943__$1 = state_55943;
if(cljs.core.truth_(inst_55930)){
var statearr_55963_56178 = state_55943__$1;
(statearr_55963_56178[(1)] = (10));

} else {
var statearr_55964_56179 = state_55943__$1;
(statearr_55964_56179[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (5))){
var _ = (function (){var statearr_55965 = state_55943;
(statearr_55965[(4)] = cljs.core.rest((state_55943[(4)])));

return statearr_55965;
})();
var state_55943__$1 = state_55943;
var ex55961 = (state_55943__$1[(2)]);
var statearr_55966_56181 = state_55943__$1;
(statearr_55966_56181[(5)] = ex55961);


var statearr_55967_56183 = state_55943__$1;
(statearr_55967_56183[(1)] = (4));

(statearr_55967_56183[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55944 === (10))){
var inst_55898 = (state_55943[(10)]);
var inst_55904 = (state_55943[(11)]);
var inst_55924 = (state_55943[(7)]);
var inst_55903 = (state_55943[(12)]);
var inst_55905 = (state_55943[(13)]);
var inst_55932 = deercreeklabs.tube.client._LT_connect(inst_55924,url,inst_55898,options,inst_55905,inst_55904,inst_55903);
var state_55943__$1 = state_55943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55943__$1,(13),inst_55932);
} else {
if((state_val_55944 === (8))){
var inst_55926 = (state_55943[(8)]);
var state_55943__$1 = state_55943;
var statearr_55968_56185 = state_55943__$1;
(statearr_55968_56185[(2)] = inst_55926);

(statearr_55968_56185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var deercreeklabs$tube$client$state_machine__43223__auto__ = null;
var deercreeklabs$tube$client$state_machine__43223__auto____0 = (function (){
var statearr_55969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55969[(0)] = deercreeklabs$tube$client$state_machine__43223__auto__);

(statearr_55969[(1)] = (1));

return statearr_55969;
});
var deercreeklabs$tube$client$state_machine__43223__auto____1 = (function (state_55943){
while(true){
var ret_value__43224__auto__ = (function (){try{while(true){
var result__43225__auto__ = switch__43222__auto__(state_55943);
if(cljs.core.keyword_identical_QMARK_(result__43225__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43225__auto__;
}
break;
}
}catch (e55970){var ex__43226__auto__ = e55970;
var statearr_55971_56186 = state_55943;
(statearr_55971_56186[(2)] = ex__43226__auto__);


if(cljs.core.seq((state_55943[(4)]))){
var statearr_55972_56187 = state_55943;
(statearr_55972_56187[(1)] = cljs.core.first((state_55943[(4)])));

} else {
throw ex__43226__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43224__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56188 = state_55943;
state_55943 = G__56188;
continue;
} else {
return ret_value__43224__auto__;
}
break;
}
});
deercreeklabs$tube$client$state_machine__43223__auto__ = function(state_55943){
switch(arguments.length){
case 0:
return deercreeklabs$tube$client$state_machine__43223__auto____0.call(this);
case 1:
return deercreeklabs$tube$client$state_machine__43223__auto____1.call(this,state_55943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
deercreeklabs$tube$client$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$0 = deercreeklabs$tube$client$state_machine__43223__auto____0;
deercreeklabs$tube$client$state_machine__43223__auto__.cljs$core$IFn$_invoke$arity$1 = deercreeklabs$tube$client$state_machine__43223__auto____1;
return deercreeklabs$tube$client$state_machine__43223__auto__;
})()
})();
var state__43959__auto__ = (function (){var statearr_55973 = f__43958__auto__();
(statearr_55973[(6)] = c__43957__auto__);

return statearr_55973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43959__auto__);
});})(c__43957__auto__,validate__50752__auto__,ufv___56051,output_schema55856_56052,input_schema55857_56053,input_schema55861_56054,input_checker55858_56055,output_checker55859_56056,input_checker55862_56057,output_checker55863_56058))
);

return c__43957__auto__;
break;
}
})();
if(cljs.core.truth_(validate__50752__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55974_56189 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55975_56190 = cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null));
var G__55976_56191 = output_schema55856_56052;
var G__55977_56192 = cljs.core.deref(output_checker55863_56058);
var G__55978_56193 = o__50755__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55974_56189,G__55975_56190,G__55976_56191,G__55977_56192,G__55978_56193) : schema.core.fn_validator.call(null,G__55974_56189,G__55975_56190,G__55976_56191,G__55977_56192,G__55978_56193));
} else {
var temp__5753__auto___56194 = (function (){var fexpr__55979 = cljs.core.deref(output_checker55863_56058);
return (fexpr__55979.cljs$core$IFn$_invoke$arity$1 ? fexpr__55979.cljs$core$IFn$_invoke$arity$1(o__50755__auto__) : fexpr__55979.call(null,o__50755__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___56194)){
var error__50754__auto___56196 = temp__5753__auto___56194;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"<tube-client","<tube-client",-1898003947,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Will return a connected client or a closed channel (nil) on connection\n   failure or timeout."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__50754__auto___56196], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55856_56052,new cljs.core.Keyword(null,"value","value",305978217),o__50755__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__50754__auto___56196], null));
} else {
}
}
} else {
}

return o__50755__auto__;
}));

(deercreeklabs.tube.client._LT_tube_client.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.tube.client._LT_tube_client),schema.core.make_fn_schema(output_schema55856_56052,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55857_56053,input_schema55861_56054], null)));


//# sourceMappingURL=deercreeklabs.tube.client.js.map
