# clj-mock

A Clojure library designed to mock clojure vars.


## Usage

Add clj-mock dependence:

[![Clojars Project](https://img.shields.io/clojars/v/clj-mock.svg)](https://clojars.org/defclass/clj-mock)

Examples:

```clojure

(defn inner [a]
    "I'am not been replaced.")

  (mock {#'inner {["params1"] :value1
                  ["params2"] :value2
                  :default :value3}}
        [(inner "params1")
         (inner "params2")
         (inner "params3")])

  ;; => [:value1 :value2 :value3]

  (mock {#'inner {["params1"] :value1
                  ["params2"] :value2
                  :default-fn (fn [x] (prn x))}}
        [(inner "params1")
         (inner "params2")
         (inner "params3")])

  ;; ["params3"]
  ;=> [:value1 :value2 nil]
  )

```

## License

Copyright © 2019 Michael Wong

Distributed under the Eclipse Public License .
