(ns clj-mock.core)

(defn search-value
  [args cond-map]
  (loop [[[k v :as h] & t] (seq cond-map)]
    (if (nil? t)
      (do (assert (or (= :default k)
                      (= :default-fn k))
                  (format "Last items is expected :default or :default-fn, meet: %s"
                          (pr-str h)))
          (if (= :default k)
            v
            (apply v args)))
      (cond
        (vector? k)
        (if (= args k) v (recur t))

        (or (= :default k) (= :default-fn k))
        (recur (concat t [h]))

        :else
        (throw (IllegalArgumentException.
                 (format "Expect vector, passed: %s" k)))))))

(defn construct-map
  [fdecls]
  (reduce
    (fn [acc [var-k value-m]]
      (let [f (fn [& args]
                (do (assert (or (contains? value-m :default)
                                (contains? value-m :default-fn))
                            "Should have :default or :default-fn key.")
                    (search-value (vec args) value-m)))]
        (assoc acc var-k f)))
    {}
    fdecls))

(defmacro mock
  [fdecls & body]
  `(with-redefs-fn (construct-map ~fdecls)
     (fn [] ~@body)))

(comment

  (defn inner [a]
    "I'am not been replaced.")

  (mock {#'inner {["params1"] :value1
                  ["params2"] :value2
                  :default :value3}}
        [(inner "params1")
         (inner "params2")
         (inner "params3")])

  ;; => [:value1 :value2 :value3]

  (mock {#'inner {["params1"] :value1
                  ["params2"] :value2
                  :default-fn (fn [x] (prn x))}}
        [(inner "params1")
         (inner "params2")
         (inner "params3")])

  ;; ["params3"]
  ;=> [:value1 :value2 nil]
  )