(ns spectator.generators
  (:require [clojure.test.check.generators :as check-gen])
  (:import (java.time LocalDate)))

(def string-1
  (->> (check-gen/vector check-gen/char 1 999)
       (check-gen/fmap clojure.string/join)))

(def local-date
  (->> check-gen/large-integer
       (check-gen/fmap (fn [^long days] (LocalDate/ofEpochDay days)))))

(def future-local-date
  (->> (check-gen/large-integer* {:min 0})
       (check-gen/fmap (fn [^long days] (.plusDays (LocalDate/now) days)))))

