/*
 * Decompiled with CFR 0.152.
 */
package pl.defunkt.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.EventDSL;
import com.aphyr.riemann.client.RiemannClient;
import com.aphyr.riemann.client.SimpleUdpTransport;
import com.aphyr.riemann.client.SynchronousTransport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class RiemannAppender<E>
extends AppenderBase<E> {
    private final String className = ((Object)((Object)this)).getClass().getSimpleName();
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 5555;
    private String serviceName = "*no-service-name*";
    private String hostName = this.determineHostname();
    private String riemannHostName = this.determineRiemannHostname();
    private Level riemannLogLevel = Level.ERROR;
    private int riemannPort = 5555;
    private Map<String, String> customAttributes = new HashMap<String, String>();
    private RiemannClient riemannClient = null;
    private boolean tcp = false;

    private String determineRiemannHostname() {
        return System.getProperty("riemann.hostname", DEFAULT_HOST);
    }

    private String determineHostname() {
        String string = System.getProperty("hostname");
        if (string != null) {
            return string;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    public void start() {
        try {
            this.riemannClient = this.tcp ? RiemannClient.tcp((String)this.riemannHostName, (int)this.riemannPort) : new RiemannClient((SynchronousTransport)new SimpleUdpTransport(this.riemannHostName, this.riemannPort));
            this.riemannClient.connect();
            this.printError("%s.start: connected to %s, using hostname of %s", this.className, this.riemannHostName, this.hostName);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        super.start();
    }

    public void stop() {
        if (this.riemannClient != null) {
            this.riemannClient.close();
        }
        super.stop();
    }

    public String toString() {
        return String.format("RiemannAppender{hashCode=%s;serviceName=%s;transport=%s;riemannHostname=%s;riemannPort=%d;hostname=%s}", ((Object)((Object)this)).hashCode(), this.serviceName, this.tcp ? "tcp" : "udp", this.riemannHostName, this.riemannPort, this.hostName);
    }

    private void getStackTraceFromEvent(ILoggingEvent iLoggingEvent, EventDSL eventDSL) {
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy != null) {
            StringBuilder stringBuilder = new StringBuilder(iThrowableProxy.getMessage()).append("\n");
            if (iThrowableProxy.getStackTraceElementProxyArray() != null) {
                for (StackTraceElementProxy stackTraceElementProxy : iThrowableProxy.getStackTraceElementProxyArray()) {
                    stringBuilder.append("\t").append(stackTraceElementProxy.toString()).append("\n");
                }
            }
            eventDSL.attribute("log/cause", iThrowableProxy.getCause().getMessage());
            eventDSL.attribute("log/stacktrace", stringBuilder.toString());
            Level level = iLoggingEvent.getLevel();
            if (level == Level.ERROR) {
                eventDSL.attribute("state", "error");
            } else if (level == Level.WARN) {
                eventDSL.attribute("state", "warning");
            }
        }
    }

    boolean isMinimumLevel(ILoggingEvent iLoggingEvent) {
        return iLoggingEvent.getLevel().isGreaterOrEqual(this.riemannLogLevel);
    }

    private final String send(EventDSL eventDSL) {
        try {
            Proto.Msg msg = (Proto.Msg)eventDSL.send().deref();
            return msg.getOk() ? null : msg.getError();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    private String asString(ILoggingEvent iLoggingEvent) {
        Map map = iLoggingEvent.getMDCPropertyMap();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            stringBuilder.append(String.format(", %s:%s", string, map.get(string)));
        }
        return String.format("{level:%s, message:%s, logger:%s, thread:%s%s}", iLoggingEvent.getLevel().toString(), iLoggingEvent.getMessage(), iLoggingEvent.getLoggerName(), iLoggingEvent.getThreadName(), stringBuilder.toString());
    }

    protected void append(E e) {
        ILoggingEvent iLoggingEvent = (ILoggingEvent)e;
        if (this.isMinimumLevel(iLoggingEvent)) {
            EventDSL eventDSL = this.createRiemannEvent(iLoggingEvent);
            String string = null;
            if (this.send(eventDSL) != null) {
                try {
                    this.riemannClient.reconnect();
                    string = ((Proto.Msg)eventDSL.send().deref()).getError();
                }
                catch (IOException iOException) {
                    string = iOException.getMessage();
                }
            }
            if (string != null) {
                this.printError("%s.append: Error during append(): %s", this.className, string);
            }
        }
    }

    private EventDSL createRiemannEvent(ILoggingEvent iLoggingEvent) {
        EventDSL eventDSL = this.riemannClient.event().host(this.hostName).time(iLoggingEvent.getTimeStamp() / 1000L).description(iLoggingEvent.getMessage()).attribute("log/level", iLoggingEvent.getLevel().levelStr).attribute("log/logger", iLoggingEvent.getLoggerName()).attribute("log/thread", iLoggingEvent.getThreadName()).attribute("log/message", iLoggingEvent.getMessage()).attribute("service", this.serviceName);
        if (iLoggingEvent.getThrowableProxy() != null) {
            this.getStackTraceFromEvent(iLoggingEvent, eventDSL);
        }
        if (iLoggingEvent.getMarker() != null) {
            eventDSL.tag("log/" + iLoggingEvent.getMarker().getName());
        }
        this.copyAttributes(eventDSL, iLoggingEvent.getMDCPropertyMap());
        this.copyAttributes(eventDSL, this.customAttributes);
        return eventDSL;
    }

    private void copyAttributes(EventDSL eventDSL, Map<String, String> map) {
        for (String string : map.keySet()) {
            eventDSL.attribute("log/" + string, map.get(string));
        }
    }

    private void printError(String string, Object ... objectArray) {
        System.err.println(String.format(string, objectArray));
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setRiemannHostName(String string) {
        this.riemannHostName = string;
    }

    public void setRiemannPort(int n) {
        this.riemannPort = n;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public void setRiemannLogLevel(String string) {
        this.riemannLogLevel = Level.toLevel((String)string);
    }

    public void setCustomAttributes(String string) {
        this.customAttributes.putAll(this.parseCustomAttributes(string));
    }

    Map<String, String> parseCustomAttributes(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            for (String string2 : string.split(",")) {
                String[] stringArray = string2.split(":");
                hashMap.put(stringArray[0], stringArray[1]);
            }
        }
        catch (Throwable throwable) {
            this.printError("Encountered error while parsing attribute string: %s", string);
        }
        return hashMap;
    }

    public void setTcp(boolean bl) {
        this.tcp = bl;
    }
}

