(ns revolt.catapulte.gpg
  (:require [digest :as sec]
            [revolt.shell]
            [clojure.tools.logging :as log]
            [clojure.java.io :as io]))

(defmacro gpg
  [& args]
  `(revolt.shell/sh "gpg" ~@args))

(defn digest-sha1
  [asc-file]
  (when-let [digest (sec/sha1 (io/as-file asc-file))]
    (let [checksum-file (str asc-file ".sha1")]
      (spit checksum-file digest)
      checksum-file)))

(defn sign!
  [sign-key files]
  (if sign-key
    (do
      (log/infof "signing %s with key %s" files sign-key)
      (let [signed (for [f files]
                     (let [asc-file (str f ".asc")]
                       (gpg --yes --armour --sign -u sign-key f)
                       [asc-file (digest-sha1 asc-file)]))]
        (into files (apply concat signed))))
    files))
