(ns revolt.catapulte.gpg
  (:require [revolt.shell]
            [clojure.tools.logging :as log]
            [clojure.string :as str]))

(defmacro gpg
  [& args]
  `(revolt.shell/sh "gpg" ~@args))

(defn gpg-detach-sign
  [sign-key input-file output-file]
  (gpg --yes --armour --detach-sign -o output-file -u sign-key input-file)
  output-file)

(defn sign!
  [sign-key jar-file pom-file]
  (if sign-key
    (do
      (log/info "signing files with key" sign-key)
      [jar-file
       pom-file
       (gpg-detach-sign sign-key jar-file (str jar-file ".asc"))
       (gpg-detach-sign sign-key pom-file (str/replace jar-file #"(\.jar|\.war)$" ".pom.asc"))])

    [jar-file pom-file]))
