(ns skalar.image
  (:require [failjure.core :as f]
            [skalar.mogrify :as mogrify]))

(defn verify [req available-sizes]
  (let [sizes  (:sizes req)
        mapped (map #(or (and (get available-sizes %) %)
                         (f/fail (str "Unknown '" % "' size.")))
                    sizes)]
    (or (first (filter f/failed? mapped))
        (assoc req :sizes sizes))))

(defn rescale [req available-sizes pool]
  (let [{:keys [file sizes]} req]
    (assoc req :images (map #(mogrify/mogrify-resize file % available-sizes pool) sizes))))
