(ns skalar.mogrify
  (:require [skalar.pool :as pool]))

(defn- with-extension [extension filename]
  (str (.substring filename 0 (.lastIndexOf filename ".")) extension))

(defn mogrify [file args size pool]
  (let [path (.getAbsolutePath file)
        cmd  (str "mogrify -auto-orient -create-directories -format png -output-directory " size " " args " " path "\n")]
    (pool/send-cmd pool cmd {:size size
                             :file file
                             :output (with-extension ".png" path)})))

(defn mogrify-resize [file size available-sizes pool]
  (when-let [res (available-sizes size)]
    (mogrify file (str "-resize " res) (name size) pool)))

(defn mogrify-thumbnail [file size pool]
  (mogrify file (str "+profile \"*\" -thumbnail " (name size)) "thumbnail" pool))
