(ns degree9.remote
  "Provides methods for connecting via microservices pattern."
  (:require
    [meta.server :as server]
    [meta.client :as client]))

(defn connection
  "Create a connection to a remote server."
  [uri]
  (-> (client/app)
    (client/with-socketio uri)
    (client/with-authentication nil)))

(defn api
  "Mount a remote service to a local endpoint."
  [app path uri service hooks]
  (server/api app path (client/service (connection uri) service) hooks))

(defn service
  "Create a service which will proxy requests to a remote service."
  [collection & [opts]]
  (let []
    (reify
      Object
      (id [this] "id")
      (setup [this app] app)
      (find [this params]
        (find* store database collection (js->clj params)))
      (get [this id params]
        (get* store database collection id (js->clj params)))
      (create [this data params]
        (create* store database collection data (js->clj params)))
      (update [this id data params]
        (update* store database collection id data (js->clj params)))
      ;(patch [this id data params]
      ;  ())
      (remove [this id params]
        (remove* store database collection id (js->clj params))))))
